/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.context;

import java.util.Stack;

public class StackedContext<T> {
    private final Stack<T> contexts;

    public static <T> StackedContext<T> context(T initial) {
        return StackedContext.emptyContext().start(initial);
    }

    public static <T> StackedContext<T> emptyContext() {
        return new StackedContext(new Stack());
    }

    public StackedContext(Stack<T> contexts) {
        this.contexts = contexts;
    }

    public T getCurrent() {
        return this.contexts.peek();
    }

    public boolean hasCurrent() {
        return !this.contexts.isEmpty();
    }

    public StackedContext<T> end() {
        this.contexts.pop();
        return this;
    }

    public StackedContext<T> start(T context) {
        this.contexts.add(context);
        return this;
    }

    public void set(T context) {
        this.end();
        this.start(context);
    }
}

