/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.config;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.lang3.builder.Builder;
import org.jtwig.model.expression.Expression;
import org.jtwig.model.expression.test.TestExpression;
import org.jtwig.model.tree.Node;
import org.jtwig.render.config.RenderConfiguration;
import org.jtwig.render.expression.calculator.ExpressionCalculator;
import org.jtwig.render.expression.calculator.operation.binary.BinaryOperator;
import org.jtwig.render.expression.calculator.operation.binary.calculators.BinaryOperationCalculator;
import org.jtwig.render.expression.calculator.operation.unary.UnaryOperator;
import org.jtwig.render.expression.calculator.operation.unary.calculators.UnaryOperationCalculator;
import org.jtwig.render.expression.test.calculator.TestExpressionCalculator;
import org.jtwig.render.node.renderer.NodeRender;
import org.jtwig.util.builder.MapBuilder;

public class RenderConfigurationBuilder<B extends RenderConfigurationBuilder>
implements Builder<RenderConfiguration> {
    private boolean strictMode;
    private Charset outputCharset;
    private final MapBuilder<B, Class<? extends Node>, NodeRender> nodeRenders;
    private final MapBuilder<B, Class<? extends Expression>, ExpressionCalculator> expressionCalculators;
    private final MapBuilder<B, Class<? extends BinaryOperator>, BinaryOperationCalculator> binaryExpressionCalculators;
    private final MapBuilder<B, Class<? extends UnaryOperator>, UnaryOperationCalculator> unaryExpressionCalculators;
    private final MapBuilder<B, Class<? extends TestExpression>, TestExpressionCalculator> testExpressionCalculators;

    public RenderConfigurationBuilder() {
        this.nodeRenders = new MapBuilder(this.self());
        this.expressionCalculators = new MapBuilder(this.self());
        this.binaryExpressionCalculators = new MapBuilder(this.self());
        this.unaryExpressionCalculators = new MapBuilder(this.self());
        this.testExpressionCalculators = new MapBuilder(this.self());
    }

    public RenderConfigurationBuilder(RenderConfiguration prototype) {
        this.strictMode = prototype.getStrictMode();
        this.outputCharset = prototype.getDefaultOutputCharset();
        this.nodeRenders = new MapBuilder<B, Class<Node>, NodeRender>(this.self(), prototype.getNodeRenders());
        this.expressionCalculators = new MapBuilder<B, Class<Expression>, ExpressionCalculator>(this.self(), prototype.getExpressionCalculators());
        this.binaryExpressionCalculators = new MapBuilder<B, Class<BinaryOperator>, BinaryOperationCalculator>(this.self(), prototype.getBinaryExpressionCalculators());
        this.unaryExpressionCalculators = new MapBuilder<B, Class<UnaryOperator>, UnaryOperationCalculator>(this.self(), prototype.getUnaryExpressionCalculators());
        this.testExpressionCalculators = new MapBuilder<B, Class<TestExpression>, TestExpressionCalculator>(this.self(), prototype.getTestExpressionCalculators());
    }

    public B withStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
        return this.self();
    }

    public B withOutputCharset(Charset outputCharset) {
        this.outputCharset = outputCharset;
        return this.self();
    }

    public MapBuilder<B, Class<? extends Node>, NodeRender> nodeRenders() {
        return this.nodeRenders;
    }

    public MapBuilder<B, Class<? extends Expression>, ExpressionCalculator> expressionCalculators() {
        return this.expressionCalculators;
    }

    public MapBuilder<B, Class<? extends BinaryOperator>, BinaryOperationCalculator> binaryExpressionCalculators() {
        return this.binaryExpressionCalculators;
    }

    public MapBuilder<B, Class<? extends UnaryOperator>, UnaryOperationCalculator> unaryExpressionCalculators() {
        return this.unaryExpressionCalculators;
    }

    public MapBuilder<B, Class<? extends TestExpression>, TestExpressionCalculator> testExpressionCalculators() {
        return this.testExpressionCalculators;
    }

    protected B self() {
        return (B)this;
    }

    public RenderConfiguration build() {
        return new RenderConfiguration(this.strictMode, this.outputCharset, (Map<Class<? extends Node>, NodeRender>)this.nodeRenders.build(), (Map<Class<? extends Expression>, ExpressionCalculator>)this.expressionCalculators.build(), (Map<Class<? extends BinaryOperator>, BinaryOperationCalculator>)this.binaryExpressionCalculators.build(), (Map<Class<? extends UnaryOperator>, UnaryOperationCalculator>)this.unaryExpressionCalculators.build(), (Map<Class<? extends TestExpression>, TestExpressionCalculator>)this.testExpressionCalculators.build());
    }
}

