/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property.method;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jtwig.property.method.argument.ArgumentConverter;
import org.jtwig.property.method.argument.AssignableTypes;
import org.jtwig.property.method.argument.IsNativeType;
import org.jtwig.reflection.model.Value;
import org.jtwig.reflection.model.java.JavaMethodArgument;

public class RetrieveArgumentsService {
    private static final RetrieveArgumentsService INSTANCE = new RetrieveArgumentsService(new ArgumentConverter(IsNativeType.instance(), new AssignableTypes(IsNativeType.instance())));
    private final ArgumentConverter argumentConverter;

    public static RetrieveArgumentsService instance() {
        return INSTANCE;
    }

    public RetrieveArgumentsService(ArgumentConverter argumentConverter) {
        this.argumentConverter = argumentConverter;
    }

    public Optional<List<Object>> retrieveArguments(List<Object> arguments, List<JavaMethodArgument> classes) {
        Iterator<Object> argumentsIterator = arguments.iterator();
        Iterator<JavaMethodArgument> methodArgumentIterator = classes.iterator();
        ArrayList<Object> result = new ArrayList<Object>();
        while (argumentsIterator.hasNext()) {
            Object next = argumentsIterator.next();
            JavaMethodArgument argument = methodArgumentIterator.next();
            Optional<Value> value = this.argumentConverter.convert(argument, next);
            if (!value.isPresent()) {
                return Optional.absent();
            }
            result.add(((Value)value.get()).getValue());
        }
        return Optional.of(result);
    }
}

