/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property.method;

import com.google.common.base.Optional;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jtwig.property.PropertyResolveRequest;
import org.jtwig.property.method.MethodPropertyExtractor;
import org.jtwig.property.method.RetrieveArgumentsService;
import org.jtwig.reflection.model.Value;
import org.jtwig.reflection.model.java.JavaMethod;
import org.jtwig.util.ErrorMessageFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodNameMethodPropertyExtractor
implements MethodPropertyExtractor {
    private static Logger log = LoggerFactory.getLogger(MethodNameMethodPropertyExtractor.class);
    private final RetrieveArgumentsService retrieveArgumentsService;
    private final Comparator<String> methodNameComparator;

    public static Comparator<String> exactlyEqual() {
        return new Comparator<String>(){

            @Override
            public int compare(String methodName, String searchingName) {
                return methodName.compareTo(searchingName);
            }
        };
    }

    public static Comparator<String> prefixedEqual(final String prefix) {
        return new Comparator<String>(){

            @Override
            public int compare(String methodName, String searchingName) {
                return methodName.compareTo(prefix + StringUtils.capitalize((String)searchingName));
            }
        };
    }

    public MethodNameMethodPropertyExtractor(RetrieveArgumentsService retrieveArgumentsService, Comparator<String> methodNameComparator) {
        this.retrieveArgumentsService = retrieveArgumentsService;
        this.methodNameComparator = methodNameComparator;
    }

    @Override
    public Optional<Value> extract(PropertyResolveRequest request, JavaMethod method) {
        if (this.methodNameComparator.compare(method.name(), request.getPropertyName()) == 0) {
            Optional<List<Object>> arguments;
            List methodArguments = method.arguments();
            if (request.getArguments().size() == methodArguments.size() && (arguments = this.retrieveArgumentsService.retrieveArguments(request.getArguments(), methodArguments)).isPresent()) {
                try {
                    return Optional.of((Object)new Value(method.invoke(request.getEntity().getValue(), ((List)arguments.get()).toArray())));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.debug(ErrorMessageFormatter.errorMessage(request.getPosition(), String.format("Unable to execute method '%s' on '%s'", request.getPropertyName(), request.getEntity())), (Throwable)e);
                }
            }
        }
        return Optional.absent();
    }
}

