/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property;

import com.google.common.base.Optional;
import java.util.Collection;
import org.jtwig.property.PropertyResolveRequest;
import org.jtwig.property.PropertyResolver;
import org.jtwig.property.method.MethodPropertyExtractor;
import org.jtwig.reflection.model.Value;
import org.jtwig.reflection.model.java.JavaMethod;

public class MethodPropertyResolver
implements PropertyResolver {
    private final MethodPropertyExtractor methodPropertyExtractor;

    public MethodPropertyResolver(MethodPropertyExtractor methodPropertyExtractor) {
        this.methodPropertyExtractor = methodPropertyExtractor;
    }

    @Override
    public Optional<Value> resolve(PropertyResolveRequest request) {
        if (request.getEntity() == null) {
            return Optional.absent();
        }
        if (request.getEntity().getValue() == null) {
            return Optional.absent();
        }
        Collection declaredMethods = request.getEntity().type().methods();
        for (JavaMethod declaredMethod : declaredMethods) {
            Optional<Value> result = this.methodPropertyExtractor.extract(request, declaredMethod);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.absent();
    }
}

