/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.property;

import com.google.common.base.Optional;
import org.jtwig.property.PropertyResolveRequest;
import org.jtwig.property.PropertyResolver;
import org.jtwig.reflection.model.Value;
import org.jtwig.reflection.model.java.JavaField;
import org.jtwig.util.ErrorMessageFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldPropertyResolver
implements PropertyResolver {
    private final Logger logger = LoggerFactory.getLogger(FieldPropertyResolver.class);
    private final boolean tryPrivateField;

    public FieldPropertyResolver(boolean tryPrivateField) {
        this.tryPrivateField = tryPrivateField;
    }

    @Override
    public Optional<Value> resolve(PropertyResolveRequest request) {
        if (request.getArguments().isEmpty()) {
            if (request.getEntity() == null) {
                return Optional.absent();
            }
            if (request.getEntity().getValue() == null) {
                return Optional.absent();
            }
            Optional field = request.getEntity().type().field(request.getPropertyName());
            if (field.isPresent()) {
                return this.value(request, (JavaField)field.get());
            }
            return Optional.absent();
        }
        return Optional.absent();
    }

    private Optional<Value> value(PropertyResolveRequest request, JavaField field) {
        try {
            return Optional.of((Object)new Value(field.value(request.getEntity().getValue(), this.tryPrivateField)));
        }
        catch (IllegalAccessException e) {
            this.logger.debug(ErrorMessageFormatter.errorMessage(request.getPosition(), String.format("Unable to get property '%s' value", field.name())), (Throwable)e);
            return Optional.absent();
        }
    }
}

