/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.parser.parboiled.expression;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jtwig.model.expression.BinaryOperationExpression;
import org.jtwig.model.expression.Expression;
import org.jtwig.model.position.Position;
import org.jtwig.parser.parboiled.ParserContext;
import org.jtwig.parser.parboiled.base.PositionTrackerParser;
import org.jtwig.parser.parboiled.base.SpacingParser;
import org.jtwig.parser.parboiled.expression.ExpressionParser;
import org.jtwig.parser.parboiled.expression.PrimaryExpressionParser;
import org.jtwig.parser.parboiled.expression.operator.BinaryOperatorParser;
import org.jtwig.render.expression.calculator.operation.binary.BinaryOperator;
import org.parboiled.Rule;

public class BinaryOperationExpressionParser
extends ExpressionParser<BinaryOperationExpression> {
    final Collection<BinaryOperator> operators;

    public BinaryOperationExpressionParser(ParserContext context, Collection<BinaryOperator> operators) {
        super(BinaryOperationExpressionParser.class, context);
        this.operators = operators;
    }

    @Override
    public Rule ExpressionRule() {
        Rule initialExpression = this.parserContext().parser(PrimaryExpressionParser.class).ExpressionRule();
        ImmutableListMultimap index = Multimaps.index(this.operators, this.precedence());
        ArrayList integers = new ArrayList(index.keySet());
        Collections.sort(integers);
        for (Integer integer : integers) {
            initialExpression = this.BinaryOperation(initialExpression, (List<BinaryOperator>)index.get((Object)integer));
        }
        return initialExpression;
    }

    Function<BinaryOperator, Integer> precedence() {
        return new Function<BinaryOperator, Integer>(){

            public Integer apply(BinaryOperator input) {
                return input.precedence();
            }
        };
    }

    Rule BinaryOperation(Rule expressionRule, List<BinaryOperator> operator) {
        return this.Sequence(expressionRule, this.parserContext().parser(SpacingParser.class).Spacing(), new Object[]{this.ZeroOrMore(this.parserContext().parser(PositionTrackerParser.class).PushPosition(), this.parserContext().parser(BinaryOperatorParser.class).BinaryOperator(operator), new Object[]{this.parserContext().parser(SpacingParser.class).Spacing(), expressionRule, this.push(new BinaryOperationExpression((Position)this.parserContext().parser(PositionTrackerParser.class).pop(2), (Expression)this.pop(2), (BinaryOperator)this.parserContext().parser(BinaryOperatorParser.class).pop(1), (Expression)this.pop()))})});
    }
}

