/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.model.tree;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.jtwig.model.expression.VariableExpression;
import org.jtwig.model.position.Position;
import org.jtwig.model.tree.Node;

public class MacroNode
extends Node {
    private final VariableExpression macroName;
    private final Collection<String> macroArgumentNames;
    private final Node content;

    public MacroNode(Position position, VariableExpression macroName, Collection<VariableExpression> macroArgumentNames, Node content) {
        super(position);
        this.macroName = macroName;
        this.macroArgumentNames = Collections2.transform(macroArgumentNames, (Function)new Function<VariableExpression, String>(){

            public String apply(VariableExpression input) {
                return input.getIdentifier();
            }
        });
        this.content = content;
    }

    public VariableExpression getMacroName() {
        return this.macroName;
    }

    public Collection<String> getMacroArgumentNames() {
        return this.macroArgumentNames;
    }

    public Node getContent() {
        return this.content;
    }
}

