/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.functions.impl.math;

import java.math.BigDecimal;
import org.jtwig.functions.FunctionRequest;
import org.jtwig.functions.SimpleJtwigFunction;

public class RoundFunction
extends SimpleJtwigFunction {
    @Override
    public String name() {
        return "round";
    }

    @Override
    public Object execute(FunctionRequest request) {
        request.maximumNumberOfArguments(2).minimumNumberOfArguments(1);
        if (request.getNumberOfArguments() == 2) {
            String strategy = this.getString(request, 1);
            switch (RoundStrategy.valueOf(strategy.toUpperCase())) {
                case CEIL: {
                    return this.round(request, 2);
                }
                case FLOOR: {
                    return this.round(request, 3);
                }
            }
            return this.round(request, 5);
        }
        return this.round(request, 5);
    }

    private String getString(FunctionRequest request, int index) {
        return request.getEnvironment().getValueEnvironment().getStringConverter().convert(request.get(index));
    }

    private Object round(FunctionRequest request, int mode) {
        BigDecimal conversionResult = request.getEnvironment().getValueEnvironment().getNumberConverter().convert(request.get(0)).orThrow(request.getPosition(), String.format("Cannot convert %s to number", request.get(0)));
        return conversionResult.setScale(0, mode);
    }

    public static enum RoundStrategy {
        COMMON,
        CEIL,
        FLOOR;

    }
}

