/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.functions.impl.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jtwig.functions.FunctionRequest;
import org.jtwig.functions.SimpleJtwigFunction;
import org.jtwig.value.WrappedCollection;

public class BatchFunction
extends SimpleJtwigFunction {
    @Override
    public String name() {
        return "batch";
    }

    @Override
    public Object execute(FunctionRequest request) {
        request.minimumNumberOfArguments(2).maximumNumberOfArguments(3);
        int groupSize = this.getNumber(request, 1).intValue();
        if (request.getNumberOfArguments() == 3) {
            return this.batch(request, request.get(0), groupSize, request.get(2));
        }
        return this.batch(request, request.get(0), groupSize);
    }

    private List<List<Object>> batch(FunctionRequest request, Object input, int groupSize) {
        Iterator<Object> iterator = this.getCollection(request, input).iterator();
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        while (iterator.hasNext()) {
            ArrayList<Object> batch = new ArrayList<Object>();
            for (int i = 0; i < groupSize; ++i) {
                if (!iterator.hasNext()) continue;
                batch.add(iterator.next());
            }
            result.add(batch);
        }
        return result;
    }

    public List<List<Object>> batch(FunctionRequest request, Object input, int groupSize, Object padding) {
        Iterator<Object> iterator = this.getCollection(request, input).iterator();
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        while (iterator.hasNext()) {
            ArrayList<Object> batch = new ArrayList<Object>();
            for (int i = 0; i < groupSize; ++i) {
                if (iterator.hasNext()) {
                    batch.add(iterator.next());
                    continue;
                }
                batch.add(padding);
            }
            result.add(batch);
        }
        return result;
    }

    private Iterable<Object> getCollection(FunctionRequest request, Object input) {
        return request.getEnvironment().getValueEnvironment().getCollectionConverter().convert(input).or(WrappedCollection.singleton(input)).values();
    }

    private BigDecimal getNumber(FunctionRequest request, int index) {
        return request.getEnvironment().getValueEnvironment().getNumberConverter().convert(request.get(index)).orThrow(request.getPosition(), String.format("Cannot convert argument %d of number_format to number", index + 1));
    }
}

