/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.escape;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jtwig.escape.EscapeEngine;

public class EscapeEngineSelector {
    private final Map<String, EscapeEngine> escapeEngineMap;

    public static EscapeEngineSelector newInstance(Map<String, EscapeEngine> escapeEngineMap) {
        HashMap<String, EscapeEngine> map = new HashMap<String, EscapeEngine>();
        for (Map.Entry<String, EscapeEngine> entry : escapeEngineMap.entrySet()) {
            map.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return new EscapeEngineSelector(map);
    }

    private EscapeEngineSelector(Map<String, EscapeEngine> escapeEngineMap) {
        this.escapeEngineMap = escapeEngineMap;
    }

    public Optional<EscapeEngine> escapeEngineFor(String name) {
        return Optional.fromNullable((Object)this.escapeEngineMap.get(StringUtils.lowerCase((String)name)));
    }

    public Collection<String> availableEscapeEngines() {
        return this.escapeEngineMap.keySet();
    }
}

