/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig;

import java.io.File;
import java.io.OutputStream;
import org.jtwig.JtwigModel;
import org.jtwig.environment.DefaultEnvironmentConfiguration;
import org.jtwig.environment.Environment;
import org.jtwig.environment.EnvironmentConfiguration;
import org.jtwig.environment.EnvironmentFactory;
import org.jtwig.environment.EnvironmentHolder;
import org.jtwig.escape.EscapeEngine;
import org.jtwig.model.tree.Node;
import org.jtwig.render.RenderRequest;
import org.jtwig.render.context.RenderContextHolder;
import org.jtwig.render.context.StackedContext;
import org.jtwig.render.context.model.BlockContext;
import org.jtwig.render.context.model.MacroAliasesContext;
import org.jtwig.render.context.model.MacroDefinitionContext;
import org.jtwig.render.context.model.PropertiesContext;
import org.jtwig.render.context.model.RenderContext;
import org.jtwig.renderable.RenderResult;
import org.jtwig.renderable.StreamRenderResult;
import org.jtwig.renderable.StringBuilderRenderResult;
import org.jtwig.resource.reference.ResourceReference;
import org.jtwig.value.context.IsolateParentValueContext;
import org.jtwig.value.context.JtwigModelValueContext;
import org.jtwig.value.context.MapValueContext;
import org.jtwig.value.context.ValueContext;

public class JtwigTemplate {
    public static final EnvironmentFactory ENVIRONMENT_FACTORY = new EnvironmentFactory();
    private final ResourceReference resource;
    private final Environment environment;

    public static JtwigTemplate inlineTemplate(String template) {
        return JtwigTemplate.inlineTemplate(template, new DefaultEnvironmentConfiguration());
    }

    public static JtwigTemplate inlineTemplate(String template, EnvironmentConfiguration configuration) {
        return new JtwigTemplate(ENVIRONMENT_FACTORY.create(configuration), new ResourceReference("string", template));
    }

    public static JtwigTemplate classpathTemplate(String location) {
        return JtwigTemplate.classpathTemplate(location, new DefaultEnvironmentConfiguration());
    }

    public static JtwigTemplate classpathTemplate(String location, EnvironmentConfiguration environmentConfiguration) {
        ResourceReference resourceReference = new ResourceReference("classpath", location);
        Environment environment = ENVIRONMENT_FACTORY.create(environmentConfiguration);
        return new JtwigTemplate(environment, resourceReference);
    }

    public static JtwigTemplate fileTemplate(String filename, EnvironmentConfiguration environmentConfiguration) {
        Environment environment = ENVIRONMENT_FACTORY.create(environmentConfiguration);
        ResourceReference resourceReference = new ResourceReference("file", filename);
        return new JtwigTemplate(environment, resourceReference);
    }

    public static JtwigTemplate fileTemplate(String filename) {
        return JtwigTemplate.fileTemplate(filename, (EnvironmentConfiguration)new DefaultEnvironmentConfiguration());
    }

    public static JtwigTemplate fileTemplate(File path, EnvironmentConfiguration environmentConfiguration) {
        return JtwigTemplate.fileTemplate(path.getAbsolutePath(), environmentConfiguration);
    }

    public static JtwigTemplate fileTemplate(File path) {
        return JtwigTemplate.fileTemplate(path, (EnvironmentConfiguration)new DefaultEnvironmentConfiguration());
    }

    public JtwigTemplate(Environment environment, ResourceReference resource) {
        this.resource = resource;
        this.environment = environment;
    }

    public String render(JtwigModel model) {
        StringBuilderRenderResult result = new StringBuilderRenderResult();
        this.render(model, result);
        return result.content();
    }

    public void render(JtwigModel model, OutputStream outputStream) {
        StreamRenderResult result = new StreamRenderResult(outputStream, this.environment.getRenderEnvironment().getDefaultOutputCharset());
        this.render(model, result);
    }

    private void render(JtwigModel model, RenderResult renderResult) {
        StackedContext<ValueContext> valueContextContext = StackedContext.context(new IsolateParentValueContext(new JtwigModelValueContext(model), MapValueContext.newContext()));
        StackedContext<EscapeEngine> escapeEngineContext = StackedContext.context(this.environment.getEscapeEnvironment().getInitialEscapeEngine());
        StackedContext<ResourceReference> resourceContext = StackedContext.context(this.resource);
        StackedContext<BlockContext> blockContext = StackedContext.context(BlockContext.newContext());
        StackedContext<MacroDefinitionContext> macroDefinitionContext = StackedContext.emptyContext();
        StackedContext<MacroAliasesContext> macroContext = StackedContext.emptyContext();
        StackedContext<PropertiesContext> propertiesContext = StackedContext.emptyContext();
        RenderContext renderContext = new RenderContext(valueContextContext, escapeEngineContext, resourceContext, blockContext, macroDefinitionContext, macroContext, propertiesContext);
        EnvironmentHolder.set(this.environment);
        RenderContextHolder.set(renderContext);
        Node node = this.environment.getParser().parse(this.environment, this.resource);
        this.environment.getRenderEnvironment().getRenderNodeService().render(new RenderRequest(renderContext, this.environment), node).appendTo(renderResult);
    }
}

