/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.util.DirectedGraph;

public class Util {
    private static final Logger logger = Logger.getLogger(Util.class);
    private static long id = 121L;
    private static final Pattern REGEX_CHARS = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");

    private Util() {
    }

    public static long getId() {
        return id++;
    }

    public static boolean isSourceElement(Element element) {
        if (element == null || element instanceof Symbol.PackageSymbol) {
            return false;
        }
        if (element instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)element;
            if (clazz.sourcefile != null && clazz.sourcefile.getClass().getName().equals("com.sun.tools.javac.file.RegularFileObject")) {
                return true;
            }
        }
        return Util.isSourceElement(element.getEnclosingElement());
    }

    public static String getSourceFilePath(Element element) {
        if (element == null || element instanceof Symbol.PackageSymbol) {
            return null;
        }
        if (element instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)element;
            if (clazz.sourcefile != null && clazz.sourcefile.getClass().getName().equals("com.sun.tools.javac.file.RegularFileObject")) {
                return clazz.sourcefile.getName();
            }
        }
        return null;
    }

    public static JCTree lookupTree(JSweetContext context, final Element element) {
        if (element == null || element instanceof Symbol.PackageSymbol) {
            return null;
        }
        Element rootClass = Util.getRootClassElement(element);
        if (rootClass instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)rootClass;
            if (clazz.sourcefile != null && clazz.sourcefile.getClass().getName().equals("com.sun.tools.javac.file.RegularFileObject")) {
                final JCTree[] result = new JCTree[]{null};
                for (int i = 0; i < context.sourceFiles.length; ++i) {
                    if (!new File(clazz.sourcefile.getName()).equals(context.sourceFiles[i].getJavaFile())) continue;
                    JCTree.JCCompilationUnit cu = context.compilationUnits[i];
                    new TreeScanner(){

                        @Override
                        public void visitClassDef(JCTree.JCClassDecl tree) {
                            if (tree.sym == element) {
                                result[0] = tree;
                            } else {
                                super.visitClassDef(tree);
                            }
                        }

                        @Override
                        public void visitMethodDef(JCTree.JCMethodDecl tree) {
                            if (tree.sym == element) {
                                result[0] = tree;
                            }
                        }

                        @Override
                        public void visitVarDef(JCTree.JCVariableDecl tree) {
                            if (tree.sym == element) {
                                result[0] = tree;
                            } else {
                                super.visitVarDef(tree);
                            }
                        }
                    }.scan(cu);
                    return result[0];
                }
            }
        }
        return null;
    }

    private static Element getRootClassElement(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Symbol.ClassSymbol && (element.getEnclosingElement() == null || element.getEnclosingElement() instanceof PackageElement)) {
            return element;
        }
        return Util.getRootClassElement(element.getEnclosingElement());
    }

    public static void addFiles(String extension, File file, Collection<File> files) {
        Util.addFiles((File f) -> f.getName().endsWith(extension), file, files);
    }

    public static void addFiles(Predicate<File> filter, File file, Collection<File> files) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                Util.addFiles(filter, f, files);
            }
        } else if (filter.test(file)) {
            files.add(file);
        }
    }

    public static String getFullMethodSignature(Symbol.MethodSymbol method) {
        return ((Symbol)method.getEnclosingElement()).getQualifiedName() + "." + method.toString();
    }

    public static boolean containsMethods(JCTree.JCClassDecl classDeclaration) {
        for (JCTree member : classDeclaration.getMembers()) {
            if (member instanceof JCTree.JCMethodDecl) {
                JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)member;
                if (method.pos == classDeclaration.pos) continue;
                return true;
            }
            if (!(member instanceof JCTree.JCVariableDecl) || !((JCTree.JCVariableDecl)member).mods.getFlags().contains((Object)Modifier.STATIC)) continue;
            return true;
        }
        return false;
    }

    private static void putVar(Map<String, Symbol.VarSymbol> vars, Symbol.VarSymbol varSymbol) {
        vars.put(((Name)varSymbol.getSimpleName()).toString(), varSymbol);
    }

    public static void fillAllVariablesInScope(Map<String, Symbol.VarSymbol> vars, Stack<JCTree> scanningStack, JCTree from, JCTree to) {
        if (from == to) {
            return;
        }
        int i = scanningStack.indexOf(from);
        if (i == -1 || i == 0) {
            return;
        }
        JCTree parent = (JCTree)scanningStack.get(i - 1);
        List<JCTree.JCStatement> statements = null;
        switch (parent.getKind()) {
            case BLOCK: {
                statements = ((JCTree.JCBlock)parent).stats;
                break;
            }
            case CASE: {
                statements = ((JCTree.JCCase)parent).stats;
                break;
            }
            case CATCH: {
                Util.putVar(vars, ((JCTree.JCCatch)parent).param.sym);
                break;
            }
            case FOR_LOOP: {
                if (((JCTree.JCForLoop)parent).init == null) break;
                for (JCTree.JCStatement s : ((JCTree.JCForLoop)parent).init) {
                    if (!(s instanceof JCTree.JCVariableDecl)) continue;
                    Util.putVar(vars, ((JCTree.JCVariableDecl)s).sym);
                }
                break;
            }
            case ENHANCED_FOR_LOOP: {
                Util.putVar(vars, ((JCTree.JCEnhancedForLoop)parent).var.sym);
                break;
            }
            case METHOD: {
                for (JCTree.JCVariableDecl var : ((JCTree.JCMethodDecl)parent).params) {
                    Util.putVar(vars, var.sym);
                }
                break;
            }
        }
        if (statements != null) {
            for (JCTree.JCStatement s : statements) {
                if (s == from) break;
                if (!(s instanceof JCTree.JCVariableDecl)) continue;
                Util.putVar(vars, ((JCTree.JCVariableDecl)s).sym);
            }
        }
        Util.fillAllVariablesInScope(vars, scanningStack, parent, to);
    }

    public static java.util.List<JCTree.JCClassDecl> findTypeDeclarationsInCompilationUnits(java.util.List<JCTree.JCCompilationUnit> compilationUnits) {
        LinkedList<JCTree.JCClassDecl> symbols = new LinkedList<JCTree.JCClassDecl>();
        for (JCTree.JCCompilationUnit compilationUnit : compilationUnits) {
            for (JCTree definition : compilationUnit.defs) {
                if (!(definition instanceof JCTree.JCClassDecl)) continue;
                symbols.add((JCTree.JCClassDecl)definition);
            }
        }
        return symbols;
    }

    public static java.util.List<JCTree.JCMethodDecl> findMethodDeclarations(JCTree.JCClassDecl typeDeclaration) {
        LinkedList<JCTree.JCMethodDecl> methods = new LinkedList<JCTree.JCMethodDecl>();
        for (JCTree definition : typeDeclaration.defs) {
            if (!(definition instanceof JCTree.JCMethodDecl)) continue;
            methods.add((JCTree.JCMethodDecl)definition);
        }
        return methods;
    }

    public static JCTree.JCMethodDecl findFirstMethodDeclaration(JCTree.JCClassDecl typeDeclaration, String methodName) {
        return Util.findMethodDeclarations(typeDeclaration).stream().filter(methodDecl -> methodDecl.getName().toString().equals(methodName)).findFirst().orElse(null);
    }

    public static void fillAllVariableAccesses(final Map<String, Symbol.VarSymbol> vars, final JCTree tree) {
        new TreeScanner(){

            @Override
            public void visitIdent(JCTree.JCIdent ident) {
                if (ident.sym.getKind() == ElementKind.LOCAL_VARIABLE) {
                    Util.putVar(vars, (Symbol.VarSymbol)ident.sym);
                }
            }

            @Override
            public void visitLambda(JCTree.JCLambda lambda) {
                if (lambda == tree) {
                    super.visitLambda(lambda);
                }
            }
        }.scan(tree);
    }

    @Deprecated
    public static Symbol.MethodSymbol findMethodDeclarationInType(com.sun.tools.javac.code.Types types, Symbol.TypeSymbol typeSymbol, JCTree.JCMethodInvocation invocation) {
        String meth = invocation.meth.toString();
        String methName = meth.substring(meth.lastIndexOf(46) + 1);
        return Util.findMethodDeclarationInType(types, typeSymbol, methName, (Type.MethodType)invocation.meth.type);
    }

    @Deprecated
    public static Symbol.MethodSymbol findMethodDeclarationInType(com.sun.tools.javac.code.Types types, Symbol.TypeSymbol typeSymbol, String methodName, Type.MethodType methodType) {
        return Util.findMethodDeclarationInType(types, typeSymbol, methodName, methodType, false);
    }

    public static Symbol.MethodSymbol findMethodDeclarationInType2(com.sun.tools.javac.code.Types types, Symbol.TypeSymbol typeSymbol, String methodName, Type.MethodType methodType) {
        LinkedList<Symbol.MethodSymbol> candidates = new LinkedList<Symbol.MethodSymbol>();
        Util.collectMatchingMethodDeclarationsInType(types, typeSymbol, methodName, methodType, false, candidates);
        for (Symbol.MethodSymbol candidate : candidates) {
            if (!types.isSubSignature(candidate.type, methodType)) continue;
            return candidate;
        }
        return null;
    }

    @Deprecated
    public static Symbol.MethodSymbol findMethodDeclarationInType(com.sun.tools.javac.code.Types types, Symbol.TypeSymbol typeSymbol, String methodName, Type.MethodType methodType, boolean overrides) {
        LinkedList<Symbol.MethodSymbol> candidates = new LinkedList<Symbol.MethodSymbol>();
        Util.collectMatchingMethodDeclarationsInType(types, typeSymbol, methodName, methodType, overrides, candidates);
        Symbol.MethodSymbol bestMatch = null;
        int lastScore = Integer.MIN_VALUE;
        for (Symbol.MethodSymbol candidate : candidates) {
            int currentScore = Util.getCandidateMethodMatchScore(candidate, methodType, types);
            if (bestMatch != null && currentScore <= lastScore) continue;
            bestMatch = candidate;
            lastScore = currentScore;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("method declaration match for " + typeSymbol + "." + methodName + " - " + methodType + " : " + (bestMatch == null ? "" : bestMatch.getEnclosingElement() + ".") + bestMatch + " score=" + lastScore));
        }
        return bestMatch;
    }

    @Deprecated
    private static int getCandidateMethodMatchScore(Symbol.MethodSymbol candidate, Type.MethodType methodType, com.sun.tools.javac.code.Types types) {
        boolean isAbstract;
        if (methodType == null || ((List)candidate.getParameters()).size() != methodType.argtypes.size()) {
            return -50;
        }
        int score = 0;
        boolean bl = isAbstract = (candidate.flags() & 0x400L) != 0L && !candidate.isDefault();
        if (isAbstract) {
            score -= 30;
        }
        for (int i = 0; i < ((List)candidate.getParameters()).size(); ++i) {
            Type candidateParamType = ((Symbol.VarSymbol)((List)candidate.getParameters()).get((int)i)).type;
            Type paramType = methodType.argtypes.get(i);
            if (candidateParamType.equals(paramType)) continue;
            --score;
        }
        return score;
    }

    private static void collectMatchingMethodDeclarationsInType(com.sun.tools.javac.code.Types types, Symbol.TypeSymbol typeSymbol, String methodName, Type.MethodType methodType, boolean overrides, java.util.List<Symbol.MethodSymbol> collector) {
        if (typeSymbol == null) {
            return;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (!(element instanceof Symbol.MethodSymbol) || !methodName.equals(element.getSimpleName().toString()) && (((Symbol.MethodSymbol)element).getKind() != ElementKind.CONSTRUCTOR || !"this".equals(methodName))) continue;
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)element;
                if (methodType == null) {
                    collector.add(methodSymbol);
                    continue;
                }
                if (!(overrides ? Util.isInvocable(types, methodSymbol.type.asMethodType(), methodType) : Util.isInvocable(types, methodType, methodSymbol.type.asMethodType()))) continue;
                collector.add(methodSymbol);
            }
        }
        if (!(!(typeSymbol instanceof Symbol.ClassSymbol) || ((Symbol.ClassSymbol)typeSymbol).getSuperclass() == null || overrides && Object.class.getName().equals(((Symbol.ClassSymbol)typeSymbol).getSuperclass().toString()))) {
            Util.collectMatchingMethodDeclarationsInType(types, ((Symbol.ClassSymbol)typeSymbol).getSuperclass().tsym, methodName, methodType, overrides, collector);
        }
        if (typeSymbol instanceof Symbol.ClassSymbol && ((Symbol.ClassSymbol)typeSymbol).getInterfaces() != null) {
            for (Type t : ((Symbol.ClassSymbol)typeSymbol).getInterfaces()) {
                Util.collectMatchingMethodDeclarationsInType(types, t.tsym, methodName, methodType, overrides, collector);
            }
        }
    }

    public static void findMethodDeclarationsInType(Symbol.TypeSymbol typeSymbol, Collection<String> methodNames, Set<String> ignoredTypeNames, java.util.List<Symbol.MethodSymbol> result) {
        if (typeSymbol == null) {
            return;
        }
        if (ignoredTypeNames.contains(typeSymbol.getQualifiedName().toString())) {
            return;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (!(element instanceof Symbol.MethodSymbol) || !methodNames.contains(element.getSimpleName().toString())) continue;
                result.add((Symbol.MethodSymbol)element);
            }
        }
        if (typeSymbol instanceof Symbol.ClassSymbol && ((Symbol.ClassSymbol)typeSymbol).getSuperclass() != null) {
            Util.findMethodDeclarationsInType(((Symbol.ClassSymbol)typeSymbol).getSuperclass().tsym, methodNames, ignoredTypeNames, result);
        }
        if (result == null && typeSymbol instanceof Symbol.ClassSymbol && ((Symbol.ClassSymbol)typeSymbol).getInterfaces() != null) {
            for (Type t : ((Symbol.ClassSymbol)typeSymbol).getInterfaces()) {
                Util.findMethodDeclarationsInType(t.tsym, methodNames, ignoredTypeNames, result);
            }
        }
    }

    public static Symbol.MethodSymbol findFirstMethodDeclarationInType(Element typeSymbol, String methodName) {
        if (typeSymbol == null) {
            return null;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (!(element instanceof Symbol.MethodSymbol) || !methodName.equals(element.getSimpleName().toString())) continue;
                return (Symbol.MethodSymbol)element;
            }
        }
        return null;
    }

    public static boolean isDeprecated(Element element) {
        return ((Symbol)element).isDeprecated();
    }

    public static Symbol findFirstDeclarationInType(Element typeSymbol, String name) {
        if (typeSymbol == null) {
            return null;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (!name.equals(element.getSimpleName().toString())) continue;
                return (Symbol)element;
            }
        }
        return null;
    }

    public static Symbol findFirstDeclarationInClassAndSuperClasses(Symbol.TypeSymbol typeSymbol, String name, ElementKind kind) {
        return Util.findFirstDeclarationInClassAndSuperClasses(typeSymbol, name, kind, null);
    }

    public static Symbol findFirstDeclarationInClassAndSuperClasses(Symbol.TypeSymbol typeSymbol, String name, ElementKind kind, Integer methodArgsCount) {
        if (typeSymbol == null) {
            return null;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (!name.equals(element.getSimpleName().toString()) || element.getKind() != kind || methodArgsCount != null && !methodArgsCount.equals(((ExecutableElement)element).getParameters().size())) continue;
                return (Symbol)element;
            }
        }
        if (typeSymbol instanceof Symbol.ClassSymbol) {
            Symbol s = Util.findFirstDeclarationInClassAndSuperClasses(((Symbol.ClassSymbol)typeSymbol).getSuperclass().tsym, name, kind, methodArgsCount);
            if (s == null && kind == ElementKind.METHOD) {
                for (Type type : ((Symbol.ClassSymbol)typeSymbol).getInterfaces()) {
                    s = Util.findFirstDeclarationInClassAndSuperClasses(type.tsym, name, kind, methodArgsCount);
                    if (s == null) continue;
                    break;
                }
            }
            return s;
        }
        return null;
    }

    public static boolean scanMemberDeclarationsInType(Symbol.TypeSymbol typeSymbol, Set<String> ignoredTypeNames, Function<Element, Boolean> scanner) {
        if (typeSymbol == null) {
            return true;
        }
        if (ignoredTypeNames.contains(typeSymbol.getQualifiedName().toString())) {
            return true;
        }
        if (typeSymbol.getEnclosedElements() != null) {
            for (Element element : typeSymbol.getEnclosedElements()) {
                if (scanner.apply(element).booleanValue()) continue;
                return false;
            }
        }
        if (typeSymbol instanceof Symbol.ClassSymbol && ((Symbol.ClassSymbol)typeSymbol).getSuperclass() != null && !Util.scanMemberDeclarationsInType(((Symbol.ClassSymbol)typeSymbol).getSuperclass().tsym, ignoredTypeNames, scanner)) {
            return false;
        }
        if (typeSymbol instanceof Symbol.ClassSymbol && ((Symbol.ClassSymbol)typeSymbol).getInterfaces() != null) {
            for (Type t : ((Symbol.ClassSymbol)typeSymbol).getInterfaces()) {
                if (Util.scanMemberDeclarationsInType(t.tsym, ignoredTypeNames, scanner)) continue;
                return false;
            }
        }
        return true;
    }

    public static JCTree.JCVariableDecl findParameter(JCTree.JCMethodDecl method, String name) {
        for (JCTree.JCVariableDecl parameter : method.getParameters()) {
            if (!name.equals(parameter.name.toString())) continue;
            return parameter;
        }
        return null;
    }

    public static boolean isInvocable(com.sun.tools.javac.code.Types types, Type.MethodType from, Type.MethodType target) {
        if (((List)from.getParameterTypes()).length() != ((List)target.getParameterTypes()).length()) {
            return false;
        }
        for (int i = 0; i < ((List)from.getParameterTypes()).length(); ++i) {
            if (types.isAssignable(types.erasure((Type)((List)from.getParameterTypes()).get(i)), types.erasure((Type)((List)target.getParameterTypes()).get(i)))) continue;
            return false;
        }
        return true;
    }

    public String getTypeInitalValue(String typeName) {
        if (typeName == null) {
            return "null";
        }
        switch (typeName) {
            case "void": {
                return null;
            }
            case "boolean": {
                return "false";
            }
            case "number": {
                return "0";
            }
        }
        return "null";
    }

    public static void findDefaultMethodsInType(Set<Map.Entry<JCTree.JCClassDecl, JCTree.JCMethodDecl>> defaultMethods, JSweetContext context, Symbol.ClassSymbol classSymbol) {
        if (context.getDefaultMethods(classSymbol) != null) {
            defaultMethods.addAll(context.getDefaultMethods(classSymbol));
        }
        for (Type t : classSymbol.getInterfaces()) {
            Util.findDefaultMethodsInType(defaultMethods, context, (Symbol.ClassSymbol)t.tsym);
        }
    }

    public static Symbol.VarSymbol findFieldDeclaration(Symbol.ClassSymbol classSymbol, Name name) {
        if (classSymbol == null) {
            return null;
        }
        Iterator it = classSymbol.members_field.getElementsByName(name, symbol -> symbol instanceof Symbol.VarSymbol).iterator();
        if (it.hasNext()) {
            return (Symbol.VarSymbol)it.next();
        }
        if (classSymbol.getSuperclass().tsym instanceof Symbol.ClassSymbol) {
            return Util.findFieldDeclaration((Symbol.ClassSymbol)classSymbol.getSuperclass().tsym, name);
        }
        return null;
    }

    public static boolean isGlobalsClassName(String qualifiedName) {
        return qualifiedName != null && ("Globals".equals(qualifiedName) || qualifiedName.endsWith(".Globals"));
    }

    public static boolean isVarargs(JCTree.JCVariableDecl varDecl) {
        return (varDecl.mods.flags & 0x400000000L) == 0x400000000L;
    }

    public static boolean isVarargs(Symbol.VarSymbol varSym) {
        return (varSym.flags_field & 0x400000000L) == 0x400000000L;
    }

    public static File toFile(JavaFileObject javaFileObject) {
        return new File(javaFileObject.getName());
    }

    public static <T> List<T> toJCList(Iterable<T> collection) {
        return List.from(collection);
    }

    public static List<JavaFileObject> toJavaFileObjects(JavaFileManager fileManager, Collection<File> sourceFiles) throws IOException {
        List<JavaFileObject> fileObjects = List.nil();
        JavacFileManager javacFileManager = (JavacFileManager)fileManager;
        for (JavaFileObject javaFileObject : javacFileManager.getJavaFileObjectsFromFiles(sourceFiles)) {
            fileObjects = fileObjects.append(javaFileObject);
        }
        if (fileObjects.length() != sourceFiles.size()) {
            throw new IOException("invalid file list");
        }
        return fileObjects;
    }

    public static JavaFileObject toJavaFileObject(JavaFileManager fileManager, File sourceFile) throws IOException {
        List<JavaFileObject> javaFileObjects = Util.toJavaFileObjects(fileManager, Arrays.asList(sourceFile));
        return javaFileObjects.isEmpty() ? null : (JavaFileObject)javaFileObjects.get(0);
    }

    public static String escapeRegex(String regex) {
        Matcher match = REGEX_CHARS.matcher(regex);
        return match.replaceAll("\\\\$1");
    }

    @SafeVarargs
    public static final <T> java.util.List<T> list(T ... items) {
        ArrayList<T> list = new ArrayList<T>(items.length);
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    public static boolean isAssignable(com.sun.tools.javac.code.Types types, Symbol.TypeSymbol to, Symbol.TypeSymbol from) {
        if (to.equals(from)) {
            return true;
        }
        return types.isAssignable((Type)from.asType(), (Type)to.asType());
    }

    public static boolean containsAssignableType(com.sun.tools.javac.code.Types types, java.util.List<Type> list, Type type) {
        for (Type t : list) {
            if (!types.isAssignable(t, type)) continue;
            return true;
        }
        return false;
    }

    public static String getRelativePath(Symbol fromSymbol, Symbol toSymbol) {
        return Util.getRelativePath("/" + fromSymbol.getQualifiedName().toString().replace('.', '/'), "/" + toSymbol.getQualifiedName().toString().replace('.', '/'));
    }

    public static String getRelativePath(String fromPath, String toPath) {
        StringBuilder relativePath = null;
        if (!(fromPath = fromPath.replaceAll("\\\\", "/")).equals(toPath = toPath.replaceAll("\\\\", "/"))) {
            String[] toSegments;
            String[] fromSegments = fromPath.split("/");
            int length = fromSegments.length < (toSegments = toPath.split("/")).length ? fromSegments.length : toSegments.length;
            int lastCommonRoot = -1;
            int index = 0;
            while (index < length && fromSegments[index].equals(toSegments[index])) {
                lastCommonRoot = index++;
            }
            if (lastCommonRoot != -1) {
                relativePath = new StringBuilder();
                for (index = lastCommonRoot + 1; index < fromSegments.length; ++index) {
                    if (fromSegments[index].length() <= 0) continue;
                    relativePath.append("../");
                }
                for (index = lastCommonRoot + 1; index < toSegments.length - 1; ++index) {
                    relativePath.append(toSegments[index] + "/");
                }
                if (!fromPath.startsWith(toPath)) {
                    relativePath.append(toSegments[toSegments.length - 1]);
                } else if (relativePath.length() > 0) {
                    relativePath.deleteCharAt(relativePath.length() - 1);
                }
            }
        }
        return relativePath == null ? null : relativePath.toString();
    }

    public static String removeExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static boolean containsFile(File dir, File[] files) {
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                if (!Util.containsFile(child, files)) continue;
                return true;
            }
            for (File file : files) {
                if (!child.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isIntegral(Type type) {
        if (type == null) {
            return false;
        }
        switch (type.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumber(TypeMirror type) {
        if (type == null) {
            return false;
        }
        switch (type.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DOUBLE: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCoreType(TypeMirror type) {
        if (type == null) {
            return false;
        }
        if (String.class.getName().equals(type.toString())) {
            return true;
        }
        switch (type.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DOUBLE: 
            case FLOAT: 
            case BOOLEAN: 
            case CHAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isArithmeticOrLogicalOperator(Tree.Kind kind) {
        switch (kind) {
            case MINUS: 
            case PLUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case AND: 
            case AND_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case OR: 
            case XOR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isArithmeticOperator(Tree.Kind kind) {
        switch (kind) {
            case MINUS: 
            case PLUS: 
            case MULTIPLY: 
            case DIVIDE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isComparisonOperator(Tree.Kind kind) {
        switch (kind) {
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                return true;
            }
        }
        return false;
    }

    public static boolean isParent(Symbol.TypeSymbol type, Symbol.TypeSymbol toFind) {
        if (!(type instanceof Symbol.ClassSymbol)) {
            return false;
        }
        Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)type;
        if (clazz.equals(toFind)) {
            return true;
        }
        if (Util.isParent((Symbol.ClassSymbol)clazz.getSuperclass().tsym, toFind)) {
            return true;
        }
        for (Type t : clazz.getInterfaces()) {
            if (!Util.isParent((Symbol.ClassSymbol)t.tsym, toFind)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParent(Symbol.ClassSymbol clazz, String ... qualifiedNamesToFind) {
        if (clazz == null) {
            return false;
        }
        if (ArrayUtils.contains((Object[])qualifiedNamesToFind, (Object)clazz.getQualifiedName().toString())) {
            return true;
        }
        if (Util.hasParent((Symbol.ClassSymbol)clazz.getSuperclass().tsym, qualifiedNamesToFind)) {
            return true;
        }
        for (Type t : clazz.getInterfaces()) {
            if (!Util.hasParent((Symbol.ClassSymbol)t.tsym, qualifiedNamesToFind)) continue;
            return true;
        }
        return false;
    }

    public static Symbol.PackageSymbol getPackageByName(JSweetContext context, String qualifiedName) {
        return (Symbol.PackageSymbol)((Object)context.symtab.packages.get(context.names.fromString(qualifiedName)));
    }

    public static Symbol.ClassSymbol getTypeByName(JSweetContext context, String qualifiedName) {
        return (Symbol.ClassSymbol)((Object)context.symtab.classes.get(context.names.fromString(qualifiedName)));
    }

    public static boolean hasVarargs(Symbol.MethodSymbol methodSymbol) {
        return methodSymbol != null && ((List)methodSymbol.getParameters()).length() > 0 && (methodSymbol.flags() & 0x400000000L) != 0L;
    }

    public static boolean hasTypeParameters(Symbol.MethodSymbol methodSymbol) {
        if (methodSymbol != null && ((List)methodSymbol.getParameters()).length() > 0) {
            for (Symbol.VarSymbol p : methodSymbol.getParameters()) {
                if (!(p.type instanceof Type.TypeVar)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isImported(JCTree.JCCompilationUnit compilationUnit, Symbol.TypeSymbol type) {
        for (JCTree.JCImport i : compilationUnit.getImports()) {
            if (i.isStatic() || i.qualid.type == null || i.qualid.type.tsym != type) continue;
            return true;
        }
        return false;
    }

    public static Symbol.TypeSymbol getStaticImportTarget(JCTree.JCCompilationUnit compilationUnit, String name) {
        if (compilationUnit == null) {
            return null;
        }
        for (JCTree.JCImport i : compilationUnit.getImports()) {
            if (!i.isStatic() || !i.qualid.toString().endsWith("." + name)) continue;
            if (i.qualid instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess qualified = i.qualid;
                if (qualified.selected instanceof JCTree.JCFieldAccess) {
                    qualified = (JCTree.JCFieldAccess)qualified.selected;
                }
                if (qualified.sym instanceof Symbol.TypeSymbol) {
                    return (Symbol.TypeSymbol)qualified.sym;
                }
            }
            return null;
        }
        return null;
    }

    public static Symbol.TypeSymbol getImportedType(JCTree.JCImport i) {
        if (!i.isStatic()) {
            return i.qualid.type == null ? null : i.qualid.type.tsym;
        }
        if (i.qualid instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess qualified = i.qualid;
            if (qualified.selected instanceof JCTree.JCFieldAccess) {
                qualified = (JCTree.JCFieldAccess)qualified.selected;
            }
            if (qualified.sym instanceof Symbol.TypeSymbol) {
                return (Symbol.TypeSymbol)qualified.sym;
            }
        }
        return null;
    }

    public static boolean isConstant(JCTree.JCExpression expr) {
        boolean constant = false;
        if (expr instanceof JCTree.JCLiteral) {
            constant = true;
        } else if (expr instanceof JCTree.JCFieldAccess) {
            if (((JCTree.JCFieldAccess)expr).sym.isStatic() && ((JCTree.JCFieldAccess)expr).sym.getModifiers().contains((Object)Modifier.FINAL)) {
                constant = true;
            }
        } else if (expr instanceof JCTree.JCIdent && ((JCTree.JCIdent)expr).sym.isStatic() && ((JCTree.JCIdent)expr).sym.getModifiers().contains((Object)Modifier.FINAL)) {
            constant = true;
        }
        return constant;
    }

    public static boolean isNullLiteral(JCTree tree) {
        return tree instanceof JCTree.JCLiteral && ((JCTree.JCLiteral)tree).getValue() == null;
    }

    public static boolean isConstantOrNullField(JCTree.JCVariableDecl var) {
        return !var.getModifiers().getFlags().contains((Object)Modifier.STATIC) && (var.init == null || var.getModifiers().getFlags().contains((Object)Modifier.FINAL) && var.init instanceof JCTree.JCLiteral);
    }

    public static String getTypeInitialValue(TypeMirror type) {
        if (type == null) {
            return "null";
        }
        if (Util.isNumber(type)) {
            return "0";
        }
        if (type.getKind() == TypeKind.BOOLEAN) {
            return "false";
        }
        if (type.getKind() == TypeKind.VOID) {
            return null;
        }
        return "null";
    }

    public static Symbol getAccessedSymbol(JCTree tree) {
        if (tree instanceof JCTree.JCFieldAccess) {
            return ((JCTree.JCFieldAccess)tree).sym;
        }
        if (tree instanceof JCTree.JCIdent) {
            return ((JCTree.JCIdent)tree).sym;
        }
        return null;
    }

    public static boolean hasAbstractMethod(Symbol.ClassSymbol classSymbol) {
        for (Element member : classSymbol.getEnclosedElements()) {
            if (!(member instanceof Symbol.MethodSymbol) || !((Symbol.MethodSymbol)member).getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverridingBuiltInJavaObjectMethod(Symbol.MethodSymbol method) {
        switch (method.toString()) {
            case "toString()": 
            case "hashCode()": 
            case "equals(java.lang.Object)": {
                return true;
            }
        }
        return false;
    }

    public static java.util.List<JCTree.JCClassDecl> getSortedClassDeclarations(java.util.List<JCTree> decls) {
        java.util.List<JCTree.JCClassDecl> classDecls = decls.stream().filter(d -> d instanceof JCTree.JCClassDecl).map(d -> (JCTree.JCClassDecl)d).collect(Collectors.toList());
        DirectedGraph<JCTree.JCClassDecl> defs = new DirectedGraph<JCTree.JCClassDecl>();
        java.util.List<Symbol.ClassSymbol> symbols = classDecls.stream().map(d -> d.sym).collect(Collectors.toList());
        defs.add((T[])classDecls.toArray(new JCTree.JCClassDecl[0]));
        for (int i = 0; i < symbols.size(); ++i) {
            int superClassIndex = Util.indexOfSuperclass(symbols, (Symbol.ClassSymbol)symbols.get(i));
            if (superClassIndex < 0) continue;
            defs.addEdge((JCTree.JCClassDecl)classDecls.get(superClassIndex), (JCTree.JCClassDecl)classDecls.get(i));
        }
        return defs.topologicalSort(null);
    }

    private static int indexOfSuperclass(java.util.List<Symbol.ClassSymbol> symbols, Symbol.ClassSymbol clazz) {
        int superClassIndex = symbols.indexOf(clazz.getSuperclass().tsym);
        if (superClassIndex < 0) {
            for (Symbol s : clazz.getEnclosedElements()) {
                if (!(s instanceof Symbol.ClassSymbol)) continue;
                return Util.indexOfSuperclass(symbols, (Symbol.ClassSymbol)s);
            }
        }
        return superClassIndex;
    }

    public static Symbol.ClassSymbol findInnerClassDeclaration(Symbol.ClassSymbol clazz, String name) {
        if (clazz == null) {
            return null;
        }
        for (Symbol s : clazz.getEnclosedElements()) {
            if (!(s instanceof Symbol.ClassSymbol) || !s.getSimpleName().toString().equals(name)) continue;
            return (Symbol.ClassSymbol)s;
        }
        if (clazz.getSuperclass() != null) {
            return Util.findInnerClassDeclaration((Symbol.ClassSymbol)clazz.getSuperclass().tsym, name);
        }
        return null;
    }

    public static boolean isLiteralExpression(JCTree.JCExpression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof JCTree.JCLiteral) {
            return true;
        }
        if (expression instanceof JCTree.JCBinary) {
            return Util.isLiteralExpression(((JCTree.JCBinary)expression).lhs) && Util.isLiteralExpression(((JCTree.JCBinary)expression).rhs);
        }
        if (expression instanceof JCTree.JCUnary) {
            return Util.isLiteralExpression(((JCTree.JCUnary)expression).arg);
        }
        return false;
    }

    public static java.util.List<java.util.List<JCTree>> getExecutionPaths(JCTree.JCMethodDecl methodDeclaration) {
        LinkedList<java.util.List<JCTree>> executionPaths = new LinkedList<java.util.List<JCTree>>();
        executionPaths.add(new LinkedList());
        LinkedList<java.util.List<JCTree>> currentPaths = new LinkedList<java.util.List<JCTree>>(executionPaths);
        LinkedList<JCTree.JCBreak> activeBreaks = new LinkedList<JCTree.JCBreak>();
        for (JCTree.JCStatement statement : methodDeclaration.body.stats) {
            Util.collectExecutionPaths(statement, executionPaths, currentPaths, activeBreaks);
        }
        return executionPaths;
    }

    private static void collectExecutionPaths(JCTree.JCStatement currentNode, java.util.List<java.util.List<JCTree>> allExecutionPaths, java.util.List<java.util.List<JCTree>> currentPaths, java.util.List<JCTree.JCBreak> activeBreaks) {
        for (java.util.List<JCTree> currentPath : new ArrayList<java.util.List<JCTree>>(currentPaths)) {
            JCTree lastStatement = currentPath.isEmpty() ? null : currentPath.get(currentPath.size() - 1);
            if (lastStatement instanceof JCTree.JCReturn || lastStatement instanceof JCTree.JCBreak && activeBreaks.contains(lastStatement)) continue;
            if (allExecutionPaths.size() > 20000) {
                throw new RuntimeException("too many execution paths, aborting");
            }
            currentPath.add(currentNode);
            java.util.List<java.util.List<JCTree>> currentPathForksList = Util.pathsList(currentPath);
            if (currentNode instanceof JCTree.JCIf) {
                JCTree.JCIf ifNode = (JCTree.JCIf)currentNode;
                boolean lastIsCurrentPath = true;
                JCTree.JCStatement[] forks = new JCTree.JCStatement[]{ifNode.thenpart, ifNode.elsepart};
                Util.evaluateForksExecutionPaths(allExecutionPaths, currentPathForksList, currentPath, lastIsCurrentPath, activeBreaks, forks);
            } else if (currentNode instanceof JCTree.JCBlock) {
                for (JCTree.JCStatement statement : ((JCTree.JCBlock)currentNode).stats) {
                    Util.collectExecutionPaths(statement, allExecutionPaths, currentPathForksList, activeBreaks);
                }
            } else if (currentNode instanceof JCTree.JCLabeledStatement) {
                Util.collectExecutionPaths(((JCTree.JCLabeledStatement)currentNode).body, allExecutionPaths, currentPaths, activeBreaks);
            } else if (currentNode instanceof JCTree.JCForLoop) {
                Util.collectExecutionPaths(((JCTree.JCForLoop)currentNode).body, allExecutionPaths, currentPaths, activeBreaks);
                activeBreaks.clear();
            } else if (currentNode instanceof JCTree.JCEnhancedForLoop) {
                Util.collectExecutionPaths(((JCTree.JCEnhancedForLoop)currentNode).body, allExecutionPaths, currentPaths, activeBreaks);
                activeBreaks.clear();
            } else if (currentNode instanceof JCTree.JCWhileLoop) {
                Util.collectExecutionPaths(((JCTree.JCWhileLoop)currentNode).body, allExecutionPaths, currentPaths, activeBreaks);
                activeBreaks.clear();
            } else if (currentNode instanceof JCTree.JCDoWhileLoop) {
                Util.collectExecutionPaths(((JCTree.JCDoWhileLoop)currentNode).body, allExecutionPaths, currentPaths, activeBreaks);
                activeBreaks.clear();
            } else if (currentNode instanceof JCTree.JCSynchronized) {
                Util.collectExecutionPaths(((JCTree.JCSynchronized)currentNode).body, allExecutionPaths, currentPaths, activeBreaks);
            } else if (currentNode instanceof JCTree.JCTry) {
                JCTree.JCTry tryNode = (JCTree.JCTry)currentNode;
                Util.collectExecutionPaths(tryNode.getBlock(), allExecutionPaths, currentPaths, activeBreaks);
                JCTree.JCStatement[] catchForks = tryNode.getCatches().stream().map(catchExp -> catchExp.body).collect(Collectors.toList()).toArray(new JCTree.JCStatement[0]);
                Util.evaluateForksExecutionPaths(allExecutionPaths, currentPathForksList, currentPath, false, activeBreaks, catchForks);
                if (tryNode.getFinallyBlock() != null) {
                    Util.collectExecutionPaths(tryNode.getFinallyBlock(), allExecutionPaths, currentPathForksList, activeBreaks);
                }
            } else if (currentNode instanceof JCTree.JCSwitch) {
                JCTree.JCSwitch switchNode = (JCTree.JCSwitch)currentNode;
                Util.evaluateForksExecutionPaths(allExecutionPaths, currentPathForksList, currentPath, true, activeBreaks, switchNode.cases.toArray(new JCTree.JCCase[0]));
                activeBreaks.clear();
            } else if (currentNode instanceof JCTree.JCCase) {
                for (JCTree.JCStatement statement : ((JCTree.JCCase)currentNode).stats) {
                    Util.collectExecutionPaths(statement, allExecutionPaths, currentPathForksList, activeBreaks);
                }
            }
            Util.addAllWithoutDuplicates(currentPaths, currentPathForksList);
        }
    }

    private static void evaluateForksExecutionPaths(java.util.List<java.util.List<JCTree>> allExecutionPaths, java.util.List<java.util.List<JCTree>> currentPaths, java.util.List<JCTree> currentPath, boolean lastIsCurrentPath, java.util.List<JCTree.JCBreak> activeBreaks, JCTree.JCStatement[] forks) {
        int i = 0;
        LinkedList<java.util.List<JCTree>> generatedExecutionPaths = new LinkedList<java.util.List<JCTree>>();
        for (JCTree.JCStatement fork : forks) {
            java.util.List<java.util.List<JCTree>> currentPathsForFork;
            if (fork == null) continue;
            if (lastIsCurrentPath && ++i == forks.length) {
                currentPathsForFork = Util.pathsList(currentPath);
            } else {
                LinkedList<JCTree> forkedPath = new LinkedList<JCTree>(currentPath);
                allExecutionPaths.add(forkedPath);
                currentPathsForFork = Util.pathsList(forkedPath);
            }
            Util.collectExecutionPaths(fork, allExecutionPaths, currentPathsForFork, activeBreaks);
            generatedExecutionPaths.addAll(currentPathsForFork);
        }
        Util.addAllWithoutDuplicates(currentPaths, generatedExecutionPaths);
    }

    private static java.util.List<java.util.List<JCTree>> addAllWithoutDuplicates(java.util.List<java.util.List<JCTree>> pathsListUnique, java.util.List<java.util.List<JCTree>> listToBeAdded) {
        for (java.util.List<JCTree> path : listToBeAdded) {
            boolean pathAlreadyAdded = false;
            for (java.util.List<JCTree> pathFromUnique : pathsListUnique) {
                if (path != pathFromUnique) continue;
                pathAlreadyAdded = true;
            }
            if (pathAlreadyAdded) continue;
            pathsListUnique.add(path);
        }
        return pathsListUnique;
    }

    @SafeVarargs
    private static java.util.List<java.util.List<JCTree>> pathsList(java.util.List<JCTree> ... executionPaths) {
        LinkedList<java.util.List<JCTree>> pathsList = new LinkedList<java.util.List<JCTree>>();
        for (java.util.List<JCTree> path : executionPaths) {
            pathsList.add(path);
        }
        return pathsList;
    }

    public static boolean isDeclarationOrSubClassDeclaration(Types types, Type.ClassType classType, String searchedClassName) {
        while (classType != null) {
            if (classType.tsym.getQualifiedName().toString().equals(searchedClassName)) {
                return true;
            }
            java.util.List<? extends TypeMirror> superTypes = types.directSupertypes(classType);
            classType = superTypes == null || superTypes.isEmpty() ? null : (Type.ClassType)superTypes.get(0);
        }
        return false;
    }

    public static boolean isDeclarationOrSubClassDeclarationBySimpleName(Types types, Type.ClassType classType, String searchedClassSimpleName) {
        while (classType != null) {
            if (((Name)classType.tsym.getSimpleName()).toString().equals(searchedClassSimpleName)) {
                return true;
            }
            java.util.List<? extends TypeMirror> superTypes = types.directSupertypes(classType);
            classType = superTypes == null || superTypes.isEmpty() ? null : (Type.ClassType)superTypes.get(0);
        }
        return false;
    }
}

