/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ProcessUtil {
    private static final Logger logger = Logger.getLogger(ProcessUtil.class);
    public static final String NODE_MINIMUM_VERSION = "4.4.0";
    private static boolean initialized = false;
    public static File USER_HOME_DIR = new File(System.getProperty("user.home"));
    public static File NPM_DIR = new File(USER_HOME_DIR, ".jsweet-node_modules");
    private static List<String> nodeCommandsBaseNames = Arrays.asList("tsc", "browserify", "phantomjs");
    public static String NODE_COMMAND = "node";
    public static String NPM_COMMAND = "npm";
    private static String EXTRA_PATH = "";
    private static final Map<String, String> globalExecutableCache = new HashMap<String, String>();

    public static void initNode() {
        if (!initialized) {
            if (!System.getenv("PATH").contains("/usr/local/bin") && new File("/usr/local/bin/node").exists()) {
                ProcessUtil.addExtraPath("/usr/local/bin");
                NODE_COMMAND = "/usr/local/bin/node";
                NPM_COMMAND = "/usr/local/bin/npm";
            }
            initialized = true;
        }
        logger.debug((Object)("extra path: " + EXTRA_PATH));
    }

    public static void addExtraPath(String extraPath) {
        EXTRA_PATH = EXTRA_PATH + extraPath + File.pathSeparator;
    }

    public static String getGlobalNpmPackageNodeMainFilePath(String nodeModule, String mainFileName) {
        return NPM_DIR.getPath() + File.separator + "node_modules" + File.separator + nodeModule + File.separator + "bin" + File.separator + mainFileName;
    }

    public static String getGlobalNpmPackageExecutablePath(String command) {
        File commandFile = new File(command);
        if (commandFile.isFile() && commandFile.isAbsolute()) {
            return command;
        }
        if (ProcessUtil.isWindows()) {
            return NPM_DIR.getPath() + File.separator + command + ".cmd";
        }
        String unixPath = NPM_DIR.getPath() + File.separator + "bin" + File.separator + command;
        if (new File(unixPath).isFile()) {
            return unixPath;
        }
        logger.info((Object)("cannot find " + command + " - searching in node_modules files"));
        unixPath = ProcessUtil.lookupGlobalNpmPackageExecutablePath(NPM_DIR, command);
        return unixPath;
    }

    private static String lookupGlobalNpmPackageExecutablePath(File directory, String executableName) {
        File[] children;
        if (directory != null && (children = directory.listFiles()) != null) {
            for (File child : children) {
                if (!child.isDirectory()) continue;
                if (child.getName().equals("bin")) {
                    for (File binFile : child.listFiles()) {
                        if (!binFile.getName().equals(executableName)) continue;
                        return binFile.getAbsolutePath();
                    }
                    continue;
                }
                String foundPath = ProcessUtil.lookupGlobalNpmPackageExecutablePath(child, executableName);
                if (foundPath == null) continue;
                return foundPath;
            }
        }
        return null;
    }

    public static String getLocalNpmPackageExecutablePath(String command, File projectDirectory) {
        File commandFile = new File(command);
        if (commandFile.isFile() && commandFile.isAbsolute()) {
            return command;
        }
        return projectDirectory.getAbsolutePath() + File.separator + "node_modules" + File.separator + ".bin" + File.separator + command + (ProcessUtil.isWindows() ? ".cmd" : "");
    }

    public static String getGlobalNpmPackagePath(String packageName) {
        return NPM_DIR.getPath() + File.separator + "node_modules" + File.separator + packageName;
    }

    public static boolean isExecutableInstalledGloballyWithNpm(String command) {
        String executablePath = ProcessUtil.getGlobalNpmPackageExecutablePath(command);
        return executablePath != null && new File(executablePath).exists();
    }

    public static boolean isExecutableInstalledLocallyWithNpm(String command, File projectDirectory) {
        String executablePath = ProcessUtil.getLocalNpmPackageExecutablePath(command, projectDirectory);
        return executablePath != null && new File(executablePath).exists();
    }

    public static boolean isPackageInstalledGloballyWithNpm(String packageName) {
        return new File(ProcessUtil.getGlobalNpmPackagePath(packageName)).exists();
    }

    public static boolean isPackageInstalledLocallyWithNpm(String packageName, File projectDirectory) {
        return new File(ProcessUtil.getLocalNpmPackagePath(packageName, projectDirectory)).exists();
    }

    public static String getLocalNpmPackagePath(String packageName, File projectDirectory) {
        return projectDirectory.getAbsolutePath() + File.separator + "node_modules" + File.separator + packageName;
    }

    public static Process runCommand(String command, Consumer<String> stdoutConsumer, Runnable errorHandler, String ... args) {
        return ProcessUtil.runCommand(command, null, false, stdoutConsumer, null, errorHandler, args);
    }

    public static Process runAsyncCommand(String command, Consumer<String> stdoutConsumer, Consumer<Process> endConsumer, Runnable errorHandler, String ... args) {
        return ProcessUtil.runCommand(command, null, true, stdoutConsumer, endConsumer, errorHandler, args);
    }

    public static Process runCommand(final String command, File directory, boolean async, final Consumer<String> stdoutConsumer, final Consumer<Process> endConsumer, final Runnable errorHandler, String ... args) {
        Object[] cmd;
        if (ProcessUtil.isWindows()) {
            String commandExecutableName = FilenameUtils.getBaseName((String)command);
            cmd = nodeCommandsBaseNames.contains(commandExecutableName) ? new String[]{ProcessUtil.getGlobalNpmPackageExecutablePath(command)} : new String[]{"cmd", "/c", command};
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])args);
        } else if (nodeCommandsBaseNames.contains(command)) {
            cmd = new String[]{ProcessUtil.getGlobalNpmPackageExecutablePath(command)};
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])args);
        } else {
            String cmdAndArgs = StringUtils.join((Object[])ArrayUtils.insert((int)0, (Object[])args, (Object[])new String[]{command}), (String)" ");
            cmd = new String[]{"/bin/sh", "-c", cmdAndArgs};
        }
        logger.debug((Object)("run command: " + StringUtils.join((Object[])cmd, (String)" ")));
        Process[] processReference = new Process[]{null};
        try {
            Process process;
            ProcessBuilder processBuilder = new ProcessBuilder((String[])cmd);
            processBuilder.redirectErrorStream(true);
            if (directory != null) {
                processBuilder.directory(directory);
            }
            if (!StringUtils.isBlank((CharSequence)EXTRA_PATH)) {
                processBuilder.environment().put("PATH", processBuilder.environment().get("PATH") + File.pathSeparator + EXTRA_PATH);
            }
            processReference[0] = process = processBuilder.start();
            logger.debug((Object)("started " + processBuilder.command()));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> process.destroyForcibly()));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block19: {
                        try {
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));){
                                String line;
                                while ((line = in.readLine()) != null) {
                                    if (stdoutConsumer != null) {
                                        stdoutConsumer.accept(line);
                                        continue;
                                    }
                                    logger.info((Object)(command + " - " + line));
                                }
                            }
                            process.waitFor();
                            if (endConsumer != null) {
                                endConsumer.accept(process);
                            }
                            if (process.exitValue() != 0 && errorHandler != null) {
                                errorHandler.run();
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            if (errorHandler == null) break block19;
                            errorHandler.run();
                        }
                    }
                }
            };
            if (async) {
                new Thread(runnable).start();
            } else {
                runnable.run();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (errorHandler != null) {
                errorHandler.run();
            }
            return null;
        }
        return processReference[0];
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static void installGlobalNodePackage(String nodePackageName, String version) {
        logger.debug((Object)("installing " + nodePackageName + " with npm"));
        ProcessUtil.initNode();
        ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, null, null, null, "install", "--prefix", NPM_DIR.getPath(), version == null ? nodePackageName : nodePackageName + "@" + version);
    }

    public static void installLocalNodePackage(String nodePackageName, String version, File projectDirectory) {
        logger.debug((Object)("installing " + nodePackageName + " local with npm"));
        ProcessUtil.initNode();
        ProcessUtil.checkNpmProjectInitialization(projectDirectory);
        ProcessUtil.runCommand(NPM_COMMAND, projectDirectory, false, null, null, null, "install", version == null ? nodePackageName : nodePackageName + "@" + version, "--save");
    }

    private static void checkNpmProjectInitialization(File projectDirectory) {
        if (!new File(projectDirectory, "package.json").isFile()) {
            ProcessUtil.runCommand(NPM_COMMAND, projectDirectory, false, null, null, null, "init", "-y");
        }
    }

    public static boolean isNodePackageInstalled(String nodePackageName) {
        logger.debug((Object)("checking installation of " + nodePackageName + " with npm"));
        ProcessUtil.initNode();
        boolean[] installed = new boolean[]{false};
        ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, (String line) -> {
            if (!installed[0]) {
                installed[0] = line.endsWith("/" + nodePackageName);
            }
        }, null, null, "ls", "--parseable", nodePackageName);
        return installed[0];
    }

    public static void uninstallGlobalNodePackage(String nodePackageName) {
        logger.debug((Object)("uninstalling " + nodePackageName + " with npm"));
        ProcessUtil.initNode();
        ProcessUtil.runCommand(NPM_COMMAND, USER_HOME_DIR, false, null, null, null, "uninstall", "--prefix", NPM_DIR.getPath(), nodePackageName, "-g");
    }

    public static boolean isVersionHighEnough(String currentVersion, String minimumVersion) {
        currentVersion = currentVersion.replace("v", "");
        minimumVersion = minimumVersion.replace("v", "");
        String[] currentVersionParts = currentVersion.split("[.]");
        String[] minimumVersionParts = minimumVersion.split("[.]");
        for (int i = 0; i < currentVersionParts.length && minimumVersionParts.length > i; ++i) {
            try {
                int currentVersionPart = Integer.parseInt(currentVersionParts[i]);
                int minimumVersionPart = Integer.parseInt(minimumVersionParts[i]);
                if (currentVersionPart > minimumVersionPart) {
                    return true;
                }
                if (currentVersionPart >= minimumVersionPart) continue;
                return false;
            }
            catch (NumberFormatException e) {
                logger.error((Object)("unexpected version token " + currentVersion + " / " + minimumVersion), (Throwable)e);
            }
        }
        return true;
    }

    public static String findGlobalExecutable(String fileName, String packageName) {
        String path = globalExecutableCache.get(fileName);
        if (path == null) {
            try {
                File programFilesPath;
                String globalPackagesDir = NPM_DIR.getAbsolutePath();
                Stream<Path> searchPaths = Files.walk(Paths.get(globalPackagesDir, new String[0]), new FileVisitOption[0]);
                if (ProcessUtil.isWindows() && (programFilesPath = new File(System.getenv("ProgramFiles") + "/nodejs/node_modules/" + packageName)).isDirectory()) {
                    searchPaths = Stream.concat(searchPaths, Files.walk(Paths.get(programFilesPath.getAbsolutePath(), new String[0]), FileVisitOption.FOLLOW_LINKS));
                }
                path = searchPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> {
                    String file = f.toFile().getName();
                    return file.equals(fileName);
                }).map(f -> f.toFile().getAbsolutePath()).findFirst().orElse(null);
                globalExecutableCache.put(fileName, path);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot find global executable", e);
            }
        }
        return path;
    }
}

