/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.ModuleKind;
import org.jsweet.transpiler.extension.Java2TypeScriptAdapter;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.model.BinaryOperatorElement;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ExtendedElementFactory;
import org.jsweet.transpiler.model.ForeachLoopElement;
import org.jsweet.transpiler.model.ImportElement;
import org.jsweet.transpiler.model.LiteralElement;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.NewArrayElement;
import org.jsweet.transpiler.model.NewClassElement;
import org.jsweet.transpiler.model.VariableAccessElement;
import org.jsweet.transpiler.model.support.ForeachLoopElementSupport;
import org.jsweet.transpiler.util.Util;

public class RemoveJavaDependenciesAdapter
extends Java2TypeScriptAdapter {
    protected Map<String, String> extTypesMapping = new HashMap<String, String>();
    private final String ERASED_CLASS_HIERARCHY_FIELD = "__classes";
    private Set<String> excludedJavaSuperTypes = new HashSet<String>();

    public RemoveJavaDependenciesAdapter(JSweetContext context) {
        super(context);
        this.init();
    }

    public RemoveJavaDependenciesAdapter(PrinterAdapter parentAdapter) {
        super(parentAdapter);
        this.init();
    }

    protected void init() {
        this.initTypesMapping();
        this.addTypeMappings(this.extTypesMapping);
    }

    protected void initTypesMapping() {
        this.addTypeMapping(Class.class.getName(), "any");
        this.context.getLangTypeMappings().put(RuntimeException.class.getName(), "Error");
        this.context.getBaseThrowables().add(RuntimeException.class.getName());
        this.extTypesMapping.put(List.class.getName(), "Array");
        this.extTypesMapping.put(AbstractList.class.getName(), "Array");
        this.extTypesMapping.put(ArrayList.class.getName(), "Array");
        this.extTypesMapping.put(Iterable.class.getName(), "Array");
        this.extTypesMapping.put(LinkedList.class.getName(), "Array");
        this.extTypesMapping.put(Collection.class.getName(), "Array");
        this.extTypesMapping.put(Set.class.getName(), "Array");
        this.extTypesMapping.put(EnumSet.class.getName(), "Array");
        this.extTypesMapping.put(Deque.class.getName(), "Array");
        this.extTypesMapping.put(Queue.class.getName(), "Array");
        this.extTypesMapping.put(Stack.class.getName(), "Array");
        this.extTypesMapping.put(HashSet.class.getName(), "Array");
        this.extTypesMapping.put(TreeSet.class.getName(), "Array");
        this.extTypesMapping.put(Vector.class.getName(), "Array");
        this.extTypesMapping.put(Enumeration.class.getName(), "any");
        this.extTypesMapping.put(Iterator.class.getName(), "any");
        this.extTypesMapping.put(ListIterator.class.getName(), "any");
        this.extTypesMapping.put(Map.class.getName(), "any");
        this.extTypesMapping.put(Properties.class.getName(), "any");
        this.extTypesMapping.put(AbstractMap.class.getName(), "any");
        this.extTypesMapping.put(HashMap.class.getName(), "any");
        this.extTypesMapping.put(TreeMap.class.getName(), "any");
        this.extTypesMapping.put(WeakHashMap.class.getName(), "any");
        this.extTypesMapping.put(LinkedHashMap.class.getName(), "any");
        this.extTypesMapping.put(Hashtable.class.getName(), "any");
        this.extTypesMapping.put(Comparator.class.getName(), "any");
        this.extTypesMapping.put(Exception.class.getName(), "Error");
        this.extTypesMapping.put(RuntimeException.class.getName(), "Error");
        this.extTypesMapping.put(Throwable.class.getName(), "Error");
        this.extTypesMapping.put(Error.class.getName(), "Error");
        this.extTypesMapping.put(StringBuffer.class.getName(), "{ str: string, toString: Function }");
        this.extTypesMapping.put(StringBuilder.class.getName(), "{ str: string, toString: Function }");
        this.extTypesMapping.put(Collator.class.getName(), "any");
        this.extTypesMapping.put(Calendar.class.getName(), "Date");
        this.extTypesMapping.put(GregorianCalendar.class.getName(), "Date");
        this.extTypesMapping.put(TimeZone.class.getName(), "string");
        this.extTypesMapping.put(Locale.class.getName(), "string");
        this.extTypesMapping.put(Charset.class.getName(), "string");
        this.extTypesMapping.put(Reader.class.getName(), "{ str: string, cursor: number }");
        this.extTypesMapping.put(StringReader.class.getName(), "{ str: string, cursor: number }");
        this.extTypesMapping.put(InputStream.class.getName(), "{ str: string, cursor: number }");
        this.extTypesMapping.put(InputStreamReader.class.getName(), "{ str: string, cursor: number }");
        this.extTypesMapping.put(BufferedReader.class.getName(), "{ str: string, cursor: number }");
        this.extTypesMapping.put(Method.class.getName(), "{ owner: any, name: string, fn : Function }");
        this.addTypeMapping((typeTree, name) -> name.startsWith("java.") && this.types().isSubtype(typeTree.getType(), this.util().getType(Throwable.class)) ? "Error" : null);
        this.addTypeMapping((typeTree, name) -> ExtendedElementFactory.toTree(typeTree) instanceof JCTree.JCTypeApply && WeakReference.class.getName().equals(((JCTree)ExtendedElementFactory.toTree((ExtendedElement)typeTree)).type.tsym.getQualifiedName().toString()) ? ((JCTree.JCTypeApply)ExtendedElementFactory.toTree((ExtendedElement)typeTree)).arguments.head : null);
        this.excludedJavaSuperTypes.add(EventObject.class.getName());
    }

    @Override
    public String needsImport(ImportElement importElement, String qualifiedName) {
        if (JSweetConfig.isJDKPath(qualifiedName)) {
            return null;
        }
        return super.needsImport(importElement, qualifiedName);
    }

    protected RemoveJavaDependenciesAdapter print(ExtendedElement expression, boolean delegate) {
        if (delegate) {
            this.print("(<any>").print(expression).print(").__delegate");
        } else {
            this.print(expression);
        }
        delegate = false;
        return this;
    }

    protected RemoveJavaDependenciesAdapter printTargetForParameter(ExtendedElement expression, boolean delegate) {
        if (expression != null && expression.toString().equals("super")) {
            this.getPrinter().print("this");
            return this;
        }
        return this.print(expression, delegate);
    }

    @Override
    public boolean substituteMethodInvocation(MethodInvocationElement invocation) {
        TypeMirror jdkSuperclass;
        boolean delegate;
        String targetMethodName = invocation.getMethodName();
        String targetClassName = invocation.getMethod().getEnclosingElement().toString();
        ExtendedElement targetExpression = invocation.getTargetExpression();
        if (targetExpression != null) {
            targetClassName = targetExpression.getTypeAsElement().toString();
        }
        boolean bl = delegate = (jdkSuperclass = this.context.getJdkSuperclass(targetClassName, this.excludedJavaSuperTypes)) != null;
        if (delegate) {
            targetClassName = jdkSuperclass.toString();
        }
        if (targetClassName != null && (targetExpression != null || invocation.getMethod().getModifiers().contains((Object)Modifier.STATIC))) {
            switch (targetClassName) {
                case "java.lang.Float": 
                case "java.lang.Double": 
                case "java.lang.Integer": 
                case "java.lang.Byte": 
                case "java.lang.Long": 
                case "java.lang.Short": {
                    if (!this.substituteMethodInvocationOnNumber(invocation, targetMethodName)) break;
                    return true;
                }
                case "java.lang.Character": {
                    if (!this.substituteMethodInvocationOnCharacter(invocation, targetMethodName)) break;
                    return true;
                }
                case "java.util.Collection": 
                case "java.util.List": 
                case "java.util.AbstractList": 
                case "java.util.AbstractSet": 
                case "java.util.AbstractCollection": 
                case "java.util.Queue": 
                case "java.util.Deque": 
                case "java.util.LinkedList": 
                case "java.util.ArrayList": 
                case "java.util.Stack": 
                case "java.util.Vector": 
                case "java.util.Set": 
                case "java.util.EnumSet": 
                case "java.util.HashSet": 
                case "java.util.TreeSet": {
                    if (!this.substituteMethodInvocationOnArray(invocation, targetMethodName, targetClassName, delegate)) break;
                    return true;
                }
                case "java.util.Properties": 
                case "java.util.Dictionary": 
                case "java.util.Map": 
                case "java.util.AbstractMap": 
                case "java.util.HashMap": 
                case "java.util.TreeMap": 
                case "java.util.Hashtable": 
                case "java.util.WeakHashMap": 
                case "java.util.LinkedHashMap": {
                    if (!this.substituteMethodInvocationOnMap(invocation, targetMethodName, targetExpression, delegate)) break;
                    return true;
                }
                case "java.util.Collections": {
                    if (!this.substituteMethodInvocationOnCollections(invocation, targetMethodName, targetExpression, delegate)) break;
                    return true;
                }
                case "java.util.Arrays": {
                    if (!this.substituteMethodInvocationOnArrays(invocation, targetMethodName, targetExpression, delegate)) break;
                    return true;
                }
                case "java.lang.System": {
                    switch (targetMethodName) {
                        case "arraycopy": {
                            this.printMacroName(targetMethodName);
                            this.print("((srcPts, srcOff, dstPts, dstOff, size) => { if(srcPts !== dstPts || dstOff >= srcOff + size) { while (--size >= 0) dstPts[dstOff++] = srcPts[srcOff++];} else { let tmp = srcPts.slice(srcOff, srcOff + size); for (let i = 0; i < size; i++) dstPts[dstOff++] = tmp[i]; }})(").printArgList(invocation.getArguments()).print(")");
                            return true;
                        }
                        case "currentTimeMillis": {
                            this.printMacroName(targetMethodName);
                            this.print("Date.now()");
                            return true;
                        }
                        case "nanoTime": {
                            this.printMacroName(targetMethodName);
                            this.print("(Date.now() * 1000000)");
                            return true;
                        }
                    }
                    break;
                }
                case "java.util.Objects": {
                    if (!this.substituteMethodInvocationOnObjects(invocation, targetMethodName, delegate)) break;
                    return true;
                }
                case "java.lang.StringBuffer": 
                case "java.lang.StringBuilder": {
                    if (!this.substituteMethodInvocationOnStringBuilder(invocation, targetMethodName, delegate)) break;
                    return true;
                }
                case "java.lang.ref.WeakReference": {
                    switch (targetMethodName) {
                        case "get": {
                            this.printMacroName(targetMethodName);
                            this.print(invocation.getTargetExpression(), delegate);
                            return true;
                        }
                    }
                    break;
                }
                case "java.text.Collator": {
                    switch (targetMethodName) {
                        case "getInstance": {
                            this.printMacroName(targetMethodName);
                            this.print("((o1, o2) => o1.toString().localeCompare(o2.toString()))");
                            return true;
                        }
                    }
                    break;
                }
                case "java.nio.charset.Charset": {
                    switch (targetMethodName) {
                        case "forName": {
                            this.print(invocation.getArgument(0));
                            return true;
                        }
                    }
                    break;
                }
                case "java.util.Locale": {
                    switch (targetMethodName) {
                        case "getDefault": {
                            this.printMacroName(targetMethodName);
                            this.getPrinter().print("(window.navigator['userLanguage'] || window.navigator.language)");
                            return true;
                        }
                    }
                    break;
                }
                case "java.util.TimeZone": {
                    switch (targetMethodName) {
                        case "getTimeZone": {
                            if (invocation.getArgumentCount() != 1) break;
                            this.printMacroName(targetMethodName);
                            this.print(invocation.getArgument(0));
                            return true;
                        }
                        case "getDefault": {
                            this.printMacroName(targetMethodName);
                            this.getPrinter().print("\"UTC\"");
                            return true;
                        }
                        case "getID": {
                            this.printMacroName(targetMethodName);
                            this.print(invocation.getTargetExpression(), delegate);
                            return true;
                        }
                    }
                    break;
                }
                case "java.util.Calendar": 
                case "java.util.GregorianCalendar": {
                    if (!this.substituteMethodInvocationOnCalendar(invocation, targetMethodName, delegate)) break;
                    return true;
                }
                case "java.io.Reader": 
                case "java.io.StringReader": 
                case "java.io.InputStream": 
                case "java.io.InputStreamReader": 
                case "java.io.BufferedReader": {
                    switch (targetMethodName) {
                        case "read": {
                            this.printMacroName(targetMethodName);
                            this.print("(r => r.str.charCodeAt(r.cursor++))(");
                            this.print(invocation.getTargetExpression(), delegate).print(")");
                            return true;
                        }
                        case "skip": {
                            this.printMacroName(targetMethodName);
                            this.print(invocation.getTargetExpression(), delegate).print(".cursor+=").print(invocation.getArgument(0));
                            return true;
                        }
                        case "reset": {
                            this.printMacroName(targetMethodName);
                            this.print(invocation.getTargetExpression(), delegate).print(".cursor=0");
                            return true;
                        }
                        case "close": {
                            this.printMacroName(targetMethodName);
                            return true;
                        }
                    }
                    break;
                }
                case "java.lang.ThreadLocal": {
                    switch (targetMethodName) {
                        case "get": {
                            this.printMacroName(targetMethodName);
                            this.print("((tlObj: any) => {    if (tlObj.___value) { return tlObj.___value }     else { return tlObj.___value = tlObj.initialValue() }   })(");
                            this.print(invocation.getTargetExpression());
                            this.print(")");
                            return true;
                        }
                    }
                    break;
                }
                case "java.lang.Class": {
                    if (!this.substituteMethodInvocationOnClass(invocation, targetMethodName, delegate)) break;
                    return true;
                }
                case "java.lang.reflect.Method": {
                    if (!this.substituteMethodInvocationOnMethod(invocation, targetMethodName, delegate)) break;
                    return true;
                }
                case "java.lang.reflect.Field": {
                    if (!this.substituteMethodInvocationOnField(invocation, targetMethodName, delegate)) break;
                    return true;
                }
                case "java.lang.reflect.Array": {
                    switch (targetMethodName) {
                        case "newInstance": {
                            this.printMacroName(targetMethodName);
                            if (invocation.getArgumentCount() == 2) {
                                this.print("new Array<any>(").print(invocation.getArgument(1)).print(")");
                                return true;
                            }
                        }
                        case "getLength": {
                            this.printMacroName(targetMethodName);
                            this.print(invocation.getArgument(0)).print(".length");
                            return true;
                        }
                        case "get": {
                            this.printMacroName(targetMethodName);
                            this.print(invocation.getArgument(0)).print("[").print(invocation.getArgument(1)).print("]");
                            return true;
                        }
                        case "set": {
                            this.printMacroName(targetMethodName);
                            this.print("(").print(invocation.getArgument(0)).print("[").print(invocation.getArgument(1)).print("]=").print(invocation.getArgument(1)).print(")");
                            return true;
                        }
                    }
                    break;
                }
                case "java.lang.Math": 
                case "java.lang.StrictMath": {
                    switch (targetMethodName) {
                        case "ulp": {
                            this.printMacroName(targetMethodName);
                            this.print("((x) => { let buffer = new ArrayBuffer(8); let dataView = new DataView(buffer); dataView.setFloat64(0, x); let first = dataView.getUint32(0); let second = dataView.getUint32(4); let rawExponent = first & 0x7ff00000; if (rawExponent == 0x7ff00000) { dataView.setUint32(0,first & 0x7fffffff); } else if (rawExponent == 0) { dataView.setUint32(4,1); dataView.setUint32(0,0); } else if (rawExponent >= (52 << 20) + 0x00100000) { dataView.setUint32(0,rawExponent - (52 << 20)); dataView.setUint32(4,0); } else if (rawExponent >= (33 << 20)) { dataView.setUint32(0,1 << ((rawExponent - (33 << 20))  >>> 20 )); dataView.setUint32(4,0); } else { dataView.setUint32(4,1 << ((rawExponent - 0x00100000)  >>> 20)); dataView.setUint32(0,0); } return dataView.getFloat64(0); })(").printArgList(invocation.getArguments()).print(")");
                            return true;
                        }
                        case "IEEEremainder": {
                            this.printMacroName(targetMethodName);
                            this.print("((f1, f2) => { let r = Math.abs(f1 % f2); if (isNaN(r) || r == f2 || r <= Math.abs(f2) / 2.0) { return r; } else { return (f1 > 0 ? 1 : -1) * (r - f2); } })(").printArgList(invocation.getArguments()).print(")");
                            return true;
                        }
                    }
                }
            }
            switch (targetMethodName) {
                case "clone": {
                    this.printMacroName(targetMethodName);
                    if (targetExpression == null || !(invocation.getTargetExpression().getType() instanceof ArrayType)) break;
                    this.print(invocation.getTargetExpression(), delegate).print(".slice(0)");
                    return true;
                }
            }
        }
        return super.substituteMethodInvocation(invocation);
    }

    protected boolean substituteMethodInvocationOnObjects(MethodInvocationElement invocation, String targetMethodName, boolean delegate) {
        switch (targetMethodName) {
            case "hash": {
                this.printMacroName(targetMethodName);
                this.print("0");
                return true;
            }
            case "requireNonNull": {
                this.printMacroName(targetMethodName);
                this.print("if(").print(invocation.getArgument(0)).print("==null){throw new Error('cannot be null')}");
                return true;
            }
        }
        return false;
    }

    protected boolean substituteMethodInvocationOnField(MethodInvocationElement invocation, String targetMethodName, boolean delegate) {
        switch (targetMethodName) {
            case "getName": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression()).print(".name");
                return true;
            }
            case "get": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getArgument(0)).print("[").print(invocation.getTargetExpression()).print(".name").print("]");
                return true;
            }
            case "set": {
                this.printMacroName(targetMethodName);
                this.print("(").print(invocation.getArgument(0)).print("[").print(invocation.getTargetExpression()).print(".name").print("]=").print(invocation.getArgument(1)).print(")");
                return true;
            }
            case "getDeclaringClass": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression()).print(".owner");
                return true;
            }
            case "setAccessible": {
                return true;
            }
        }
        return false;
    }

    protected boolean substituteMethodInvocationOnMethod(MethodInvocationElement invocation, String targetMethodName, boolean delegate) {
        switch (targetMethodName) {
            case "getName": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression()).print(".name");
                return true;
            }
            case "invoke": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression()).print(".fn.apply(").print(invocation.getArgument(0));
                if (invocation.getArgumentCount() > 1) {
                    this.print(", [").printArgList(invocation.getArgumentTail()).print("]");
                }
                this.print(")");
                return true;
            }
            case "getDeclaringClass": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression()).print(".owner");
                return true;
            }
            case "setAccessible": {
                return true;
            }
        }
        return false;
    }

    protected boolean substituteMethodInvocationOnClass(MethodInvocationElement invocation, String targetMethodName, boolean delegate) {
        switch (targetMethodName) {
            case "forName": {
                this.printMacroName(targetMethodName);
                if (this.getContext().options.getModuleKind() != ModuleKind.none) {
                    this.print("eval(").print(invocation.getArgument(0)).print(".split('.').slice(-1)[0])");
                } else {
                    this.print("eval(").print(invocation.getArgument(0)).print(")");
                }
                return true;
            }
            case "newInstance": {
                this.printMacroName(targetMethodName);
                this.print("new (");
                this.print(invocation.getTargetExpression(), delegate).print(")(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "isInstance": {
                this.printMacroName(targetMethodName);
                this.print("((c:any,o:any) => { if(typeof c === 'string') return (o.constructor && o.constructor").print("[\"__interfaces\"] && o.constructor").print("[\"__interfaces\"].indexOf(c) >= 0) || (o").print("[\"__interfaces\"] && o").print("[\"__interfaces\"].indexOf(c) >= 0); else if(typeof c === 'function') return (o instanceof c) || (o.constructor && o.constructor === c); })(");
                this.print(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "isPrimitive": {
                this.printMacroName(targetMethodName);
                this.print("(").print(invocation.getTargetExpression()).print(" === <any>'__erasedPrimitiveType__'").print(")");
                return true;
            }
            case "getMethods": 
            case "getDeclaredMethods": {
                this.printMacroName(targetMethodName);
                this.print("(c => Object.getOwnPropertyNames(c.prototype).filter(n => typeof c.prototype[n] == 'function').map(n => ({owner:c,name:n,fn:c.prototype[n]}) ) )(").print(invocation.getTargetExpression()).print(")");
                return true;
            }
            case "getMethod": 
            case "getDeclaredMethod": {
                this.printMacroName(targetMethodName);
                this.print("((c,p) => { if(c.prototype.hasOwnProperty(p) && typeof c.prototype[p] == 'function') return {owner:c,name:p,fn:c.prototype[p]}; else return null; })(").print(invocation.getTargetExpression()).print(",").print(invocation.getArgument(0)).print(")");
                return true;
            }
            case "getField": 
            case "getDeclaredField": {
                this.printMacroName(targetMethodName);
                this.print("((c,p) => { return {owner:c,name:p}; })(").print(invocation.getTargetExpression()).print(",").print(invocation.getArgument(0)).print(")");
                return true;
            }
        }
        return false;
    }

    protected boolean substituteMethodInvocationOnArrays(MethodInvocationElement invocation, String targetMethodName, ExtendedElement targetExpression, boolean delegate) {
        switch (targetMethodName) {
            case "asList": {
                this.printMacroName(targetMethodName);
                if (invocation.getArgumentCount() == 1 && invocation.getArgument(0).getType() instanceof ArrayType) {
                    this.printArgList(invocation.getArguments()).print(".slice(0)");
                } else {
                    this.print("[").printArgList(invocation.getArguments()).print("]");
                }
                return true;
            }
            case "copyOf": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getArgument(0)).print(".slice(0,").print(invocation.getArgument(1)).print(")");
                return true;
            }
            case "fill": {
                this.printMacroName(targetMethodName);
                if (invocation.getArgumentCount() == 4) {
                    this.print("((a, start, end, v) => { for(let i=start;i<end;i++) a[i]=v; })(").printArgList(invocation.getArguments()).print(")");
                } else {
                    this.print("((a, v) => { for(let i=0;i<a.length;i++) a[i]=v; })(").printArgList(invocation.getArguments()).print(")");
                }
                return true;
            }
            case "equals": {
                this.printMacroName(targetMethodName);
                this.print("((a1, a2) => { if(a1==null && a2==null) return true; if(a1==null || a2==null) return false; if(a1.length != a2.length) return false; for(let i = 0; i < a1.length; i++) { if(<any>a1[i] != <any>a2[i]) return false; } return true; })(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "deepEquals": {
                this.printMacroName(targetMethodName);
                this.print("(JSON.stringify(").print(invocation.getArgument(0)).print(") === JSON.stringify(").print(invocation.getArgument(1)).print("))");
                return true;
            }
            case "sort": {
                this.printMacroName(targetMethodName);
                if (invocation.getArgumentCount() > 2) {
                    this.print("((arr, start, end, f?) => ((arr1, arr2) => arr1.splice.apply(arr1, (<any[]>[start, arr2.length]).concat(arr2)))(").print(invocation.getArgument(0)).print(", ").print(invocation.getArgument(0)).print(".slice(start, end).sort(f)))(").printArgList(invocation.getArguments()).print(")");
                } else if (invocation.getArgumentCount() == 2) {
                    this.print("((l,c) => { if((<any>c).compare) l.sort((e1,e2)=>(<any>c).compare(e1,e2)); else l.sort(<any>c); })(").print(invocation.getArgument(0)).print(",").print(invocation.getArgument(1)).print(")");
                } else {
                    this.print("((l) => {l.sort(); })(").print(invocation.getArgument(0)).print(")");
                }
                return true;
            }
        }
        return false;
    }

    protected boolean substituteMethodInvocationOnCollections(MethodInvocationElement invocation, String targetMethodName, ExtendedElement targetExpression, boolean delegate) {
        switch (targetMethodName) {
            case "emptyList": {
                this.printMacroName(targetMethodName);
                this.print("[]");
                return true;
            }
            case "emptySet": {
                this.printMacroName(targetMethodName);
                this.print("[]");
                return true;
            }
            case "emptyMap": {
                this.printMacroName(targetMethodName);
                this.print("{}");
                return true;
            }
            case "unmodifiableList": 
            case "unmodifiableCollection": 
            case "unmodifiableSet": 
            case "unmodifiableSortedSet": {
                this.printMacroName(targetMethodName);
                this.printArgList(invocation.getArguments()).print(".slice(0)");
                return true;
            }
            case "singleton": {
                this.printMacroName(targetMethodName);
                this.print("[").print(invocation.getArgument(0)).print("]");
                return true;
            }
            case "singletonList": {
                this.printMacroName(targetMethodName);
                this.print("[").print(invocation.getArgument(0)).print("]");
                return true;
            }
            case "nCopies": {
                this.printMacroName(targetMethodName);
                this.print("((n,v)=>{let c=[];for(let i=0;i<n;i++)c.push(v);return c;})(");
                this.print(invocation.getArgument(0));
                this.print(",");
                this.print(invocation.getArgument(1));
                this.print(")");
                return true;
            }
            case "singletonMap": {
                this.printMacroName(targetMethodName);
                if (this.types().isSameType(invocation.getArgument(0).getType(), this.util().getType(String.class))) {
                    if (invocation.getArgument(0) instanceof JCTree.JCLiteral) {
                        this.print("{ ").print(invocation.getArgument(0)).print(": ").print(invocation.getArgument(1)).print(" }");
                    } else {
                        this.print("(k => { let o = {}; o[k] = ").print(invocation.getArgument(1)).print("; return o; })(").print(invocation.getArgument(0)).print(")");
                    }
                } else {
                    this.print("(k => { let o = {entries: [{getKey: function() { return this.key }, getValue: function() { return this.value },key:k, value:").print(invocation.getArgument(1)).print("}]}; return o; })(").print(invocation.getArgument(0)).print(")");
                }
                return true;
            }
            case "binarySearch": {
                this.printMacroName(targetMethodName);
                if (invocation.getArgumentCount() == 3) {
                    this.print("((l, key, c) => { let comp : any = c; if(typeof c != 'function') { comp = (a,b)=>c.compare(a,b); } let low = 0; let high = l.length-1; while (low <= high) { let mid = (low + high) >>> 1; let midVal = l[mid]; let cmp = comp(midVal, key); if (cmp < 0) low = mid + 1; else if (cmp > 0) high = mid - 1; else return mid; } return -(low + 1); })(").printArgList(invocation.getArguments()).print(")");
                    return true;
                }
                if (invocation.getArgumentCount() == 2) {
                    if (this.util().isNumber(invocation.getArgument(1).getType())) {
                        this.print("((l, key) => { let comp = (a,b)=>a-b; let low = 0; let high = l.length-1; while (low <= high) { let mid = (low + high) >>> 1; let midVal = l[mid]; let cmp = comp(midVal, key); if (cmp < 0) low = mid + 1; else if (cmp > 0) high = mid - 1; else return mid; } return -(low + 1); })(").printArgList(invocation.getArguments()).print(")");
                        return true;
                    }
                    this.print("((l, key) => { let comp = (a,b)=>a.localeCompare(b); let low = 0; let high = l.length-1; while (low <= high) { let mid = (low + high) >>> 1; let midVal = l[mid]; let cmp = comp(midVal, key); if (cmp < 0) low = mid + 1; else if (cmp > 0) high = mid - 1; else return mid; } return -(low + 1); })(").printArgList(invocation.getArguments()).print(")");
                    return true;
                }
            }
            case "sort": {
                this.printMacroName(targetMethodName);
                if (invocation.getArgumentCount() == 2) {
                    this.print("((l,c) => { if((<any>c).compare) l.sort((e1,e2)=>(<any>c).compare(e1,e2)); else l.sort(<any>c); })(").print(invocation.getArgument(0)).print(",").print(invocation.getArgument(1)).print(")");
                } else {
                    this.print(invocation.getArgument(0)).print(".sort(").printArgList(invocation.getArgumentTail()).print(")");
                }
                return true;
            }
            case "reverse": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getArgument(0)).print(".reverse()");
                return true;
            }
            case "disjoint": {
                this.printMacroName(targetMethodName);
                this.print("((c1, c2) => { for(let i=0;i<c1.length;i++) { if(c2.indexOf(<any>c1[i])>=0) return false; } return true; } )(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
        }
        return false;
    }

    private boolean substituteMethodInvocationOnStringBuilder(MethodInvocationElement invocation, String targetMethodName, boolean delegate) {
        switch (targetMethodName) {
            case "append": {
                this.printMacroName(targetMethodName);
                if (invocation.getArgumentCount() == 1) {
                    this.print("(sb => { sb.str = sb.str.concat(<any>").printArgList(invocation.getArguments()).print("); return sb; })(");
                    this.print(invocation.getTargetExpression(), delegate).print(")");
                } else {
                    this.print("(sb => { sb.str = sb.str.concat((<any>").print(invocation.getArgument(0)).print(").substr(").printArgList(invocation.getArgumentTail()).print(")); return sb; })(");
                    this.print(invocation.getTargetExpression(), delegate).print(")");
                }
                return true;
            }
            case "insert": {
                this.printMacroName(targetMethodName);
                this.print("((sb, index, c) => { sb.str = sb.str.substr(0, index) + c + sb.str.substr(index); return sb; })(");
                this.print(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "setCharAt": {
                this.printMacroName(targetMethodName);
                this.print("((sb, index, c) => sb.str = sb.str.substr(0, index) + c + sb.str.substr(index + 1))(");
                this.print(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "deleteCharAt": {
                this.printMacroName(targetMethodName);
                this.print("((sb, index) => { sb.str = sb.str.substr(0, index) + sb.str.substr(index + 1); return sb; })(");
                this.print(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "delete": {
                this.printMacroName(targetMethodName);
                this.print("((sb, i1, i2) => { sb.str = sb.str.substr(0, i1) + sb.str.substr(i2); return sb; })(");
                this.print(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "length": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".str.length");
                return true;
            }
            case "charAt": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".str.charAt(").print(invocation.getArgument(0)).print(")");
                return true;
            }
            case "setLength": {
                this.printMacroName(targetMethodName);
                this.print("((sb, length) => sb.str = sb.str.substring(0, length))(");
                this.print(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "toString": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".str");
                return true;
            }
            case "lastIndexOf": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".str.lastIndexOf(").print(invocation.getArgument(0)).print(")");
                return true;
            }
            case "substring": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".str.substring(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
        }
        return false;
    }

    protected boolean substituteMethodInvocationOnCalendar(MethodInvocationElement invocation, String targetMethodName, boolean delegate) {
        switch (targetMethodName) {
            case "set": {
                if (invocation.getArgumentCount() != 2) break;
                String first = invocation.getArgument(0).toString();
                if (first.endsWith("YEAR")) {
                    this.printMacroName(targetMethodName);
                    this.print("((d, p) => d[\"UTC\"]?d.setUTCFullYear(p):d.setFullYear(p))(");
                    this.print(invocation.getTargetExpression(), delegate).print(", ").print(invocation.getArgument(1)).print(")");
                    return true;
                }
                if (first.endsWith("DAY_OF_MONTH")) {
                    this.printMacroName(targetMethodName);
                    this.print("((d, p) => d[\"UTC\"]?d.setUTCDate(p):d.setDate(p))(");
                    this.print(invocation.getTargetExpression(), delegate).print(", ").print(invocation.getArgument(1)).print(")");
                    return true;
                }
                if (first.endsWith("DAY_OF_WEEK")) {
                    this.printMacroName(targetMethodName);
                    this.print("((d, p) => d[\"UTC\"]?d.setUTCDay(p):d.setDay(p))(");
                    this.print(invocation.getTargetExpression(), delegate).print(", ").print(invocation.getArgument(1)).print(")");
                    return true;
                }
                if (first.endsWith("MONTH")) {
                    this.printMacroName(targetMethodName);
                    this.print("((d, p) => d[\"UTC\"]?d.setUTCMonth(p):d.setMonth(p))(");
                    this.print(invocation.getTargetExpression(), delegate).print(", ").print(invocation.getArgument(1)).print(")");
                    return true;
                }
                if (first.endsWith("HOUR_OF_DAY")) {
                    this.printMacroName(targetMethodName);
                    this.print("((d, p) => d[\"UTC\"]?d.setUTCHours(p):d.setHours(p))(");
                    this.print(invocation.getTargetExpression(), delegate).print(", ").print(invocation.getArgument(1)).print(")");
                    return true;
                }
                if (first.endsWith("MINUTE")) {
                    this.printMacroName(targetMethodName);
                    this.print("((d, p) => d[\"UTC\"]?d.setUTCMinutes(p):d.setMinutes(p))(");
                    this.print(invocation.getTargetExpression(), delegate).print(", ").print(invocation.getArgument(1)).print(")");
                    return true;
                }
                if (first.endsWith("MILLISECOND")) {
                    this.printMacroName(targetMethodName);
                    this.print("((d, p) => d[\"UTC\"]?d.setUTCMilliseconds(p):d.setMilliseconds(p))(");
                    this.print(invocation.getTargetExpression(), delegate).print(", ").print(invocation.getArgument(1)).print(")");
                    return true;
                }
                if (!first.endsWith("SECOND")) break;
                this.printMacroName(targetMethodName);
                this.print("((d, p) => d[\"UTC\"]?d.setUTCSeconds(p):d.setSeconds(p))(");
                this.print(invocation.getTargetExpression(), delegate).print(", ").print(invocation.getArgument(1)).print(")");
                return true;
            }
            case "get": {
                if (invocation.getArgumentCount() != 1) break;
                String first = invocation.getArgument(0).toString();
                if (first.endsWith("YEAR")) {
                    this.printMacroName(targetMethodName);
                    this.print("(d => d[\"UTC\"]?d.getUTCFullYear():d.getFullYear())(");
                    this.print(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                if (first.endsWith("DAY_OF_MONTH")) {
                    this.printMacroName(targetMethodName);
                    this.print("(d => d[\"UTC\"]?d.getUTCDate():d.getDate())(");
                    this.print(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                if (first.endsWith("DAY_OF_WEEK")) {
                    this.printMacroName(targetMethodName);
                    this.print("(d => d[\"UTC\"]?d.getUTCDay():d.getDay())(");
                    this.print(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                if (first.endsWith("MONTH")) {
                    this.printMacroName(targetMethodName);
                    this.print("(d => d[\"UTC\"]?d.getUTCMonth():d.getMonth())(");
                    this.print(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                if (first.endsWith("HOUR_OF_DAY")) {
                    this.printMacroName(targetMethodName);
                    this.print("(d => d[\"UTC\"]?d.getUTCHours():d.getHours())(");
                    this.print(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                if (first.endsWith("MINUTE")) {
                    this.printMacroName(targetMethodName);
                    this.print("(d => d[\"UTC\"]?d.getUTCMinutes():d.getMinutes())(");
                    this.print(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                if (first.endsWith("MILLISECOND")) {
                    this.printMacroName(targetMethodName);
                    this.print("(d => d[\"UTC\"]?d.getUTCMilliseconds():d.getMilliseconds())(");
                    this.print(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                if (!first.endsWith("SECOND")) break;
                this.printMacroName(targetMethodName);
                this.print("(d => d[\"UTC\"]?d.getUTCSeconds():d.getSeconds())(");
                this.print(invocation.getTargetExpression(), delegate).print(")");
                return true;
            }
            case "setTimeInMillis": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".setTime(").print(invocation.getArgument(0)).print(")");
                return true;
            }
            case "getTimeInMillis": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".getTime()");
                return true;
            }
            case "setTime": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".setTime(").print(invocation.getArgument(0)).print(".getTime())");
                return true;
            }
            case "getTime": {
                this.printMacroName(targetMethodName);
                this.print("(new Date(");
                this.print(invocation.getTargetExpression(), delegate).print(".getTime()))");
                return true;
            }
        }
        return false;
    }

    protected boolean substituteMethodInvocationOnMap(MethodInvocationElement invocation, String targetMethodName, ExtendedElement targetExpression, boolean delegate) {
        if (targetExpression == null) {
            return false;
        }
        if (((DeclaredType)targetExpression.getType()).getTypeArguments().size() == 2 && this.types().isSameType(((DeclaredType)targetExpression.getType()).getTypeArguments().get(0), this.util().getType(String.class))) {
            switch (targetMethodName) {
                case "put": {
                    this.printMacroName(targetMethodName);
                    this.print("(");
                    this.print(invocation.getTargetExpression(), delegate).print("[").print(invocation.getArgument(0)).print("] = ").print(invocation.getArgument(1)).print(")");
                    return true;
                }
                case "get": {
                    this.printMacroName(targetMethodName);
                    this.print("((m,k) => m[k]===undefined?null:m[k])(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(", ").print(invocation.getArgument(0)).print(")");
                    return true;
                }
                case "containsKey": {
                    this.printMacroName(targetMethodName);
                    this.print(invocation.getTargetExpression(), delegate).print(".hasOwnProperty(").print(invocation.getArgument(0)).print(")");
                    return true;
                }
                case "keySet": {
                    this.printMacroName(targetMethodName);
                    this.print("Object.keys(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                case "values": {
                    this.printMacroName(targetMethodName);
                    this.print("(obj => Object.keys(obj).map(key => obj[key]))(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                case "size": {
                    this.printMacroName(targetMethodName);
                    this.print("Object.keys(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(").length");
                    return true;
                }
                case "isEmpty": {
                    this.printMacroName(targetMethodName);
                    this.print("(Object.keys(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(").length == 0)");
                    return true;
                }
                case "remove": {
                    this.printMacroName(targetMethodName);
                    this.print("(map => { let deleted = ");
                    this.print(invocation.getTargetExpression(), delegate).print("[").print(invocation.getArgument(0)).print("];");
                    this.print("delete ");
                    this.print(invocation.getTargetExpression(), delegate).print("[").print(invocation.getArgument(0)).print("];");
                    this.print("return deleted;})").print("(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                case "clear": {
                    this.printMacroName(targetMethodName);
                    this.print("(obj => { for (let member in obj) delete obj[member]; })(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                case "entrySet": {
                    this.printMacroName(targetMethodName);
                    this.print("(o => { let s = []; for (let e in o) s.push({ k: e, v: o[e], getKey: function() { return this.k }, getValue: function() { return this.v } }); return s; })(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                case "clone": {
                    this.printMacroName(targetMethodName);
                    this.print("(o => { let c = {}; for (let k in Object.keys(o)){ c[k] = o[k] } return c; })(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
            }
        } else {
            String newEntry = "{key:k,value:v,getKey: function() { return this.key }, getValue: function() { return this.value }}";
            switch (targetMethodName) {
                case "put": 
                case "setProperty": {
                    this.printMacroName(targetMethodName);
                    this.print("((m,k,v) => { if(m.entries==null) m.entries=[]; for(let i=0;i<m.entries.length;i++) if(m.entries[i].key.equals!=null && m.entries[i].key.equals(k) || m.entries[i].key===k) { m.entries[i].value=v; return; } m.entries.push(" + newEntry + "); })(").print("<any>");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                    return true;
                }
                case "get": 
                case "getProperty": {
                    this.printMacroName(targetMethodName);
                    this.print("((m,k) => { if(m.entries==null) m.entries=[]; for(let i=0;i<m.entries.length;i++) if(m.entries[i].key.equals!=null && m.entries[i].key.equals(k) || m.entries[i].key===k) { return m.entries[i].value; } return null; })(").print("<any>");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                    return true;
                }
                case "containsKey": {
                    this.printMacroName(targetMethodName);
                    this.print("((m,k) => { if(m.entries==null) m.entries=[]; for(let i=0;i<m.entries.length;i++) if(m.entries[i].key.equals!=null && m.entries[i].key.equals(k) || m.entries[i].key===k) { return true; } return false; })(").print("<any>");
                    this.print(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                    return true;
                }
                case "keySet": 
                case "stringPropertyNames": {
                    this.printMacroName(targetMethodName);
                    this.print("((m) => { let r=[]; if(m.entries==null) m.entries=[]; for(let i=0;i<m.entries.length;i++) r.push(m.entries[i].key); return r; })(").print("<any>");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                case "values": {
                    this.printMacroName(targetMethodName);
                    this.print("((m) => { let r=[]; if(m.entries==null) m.entries=[]; for(let i=0;i<m.entries.length;i++) r.push(m.entries[i].value); return r; })(").print("<any>");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                case "size": {
                    this.printMacroName(targetMethodName);
                    this.print("((m) => { if(m.entries==null) m.entries=[]; return m.entries.length; })(").print("<any>");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                case "isEmpty": {
                    this.printMacroName(targetMethodName);
                    this.print("((m) => { if(m.entries==null) m.entries=[]; return m.entries.length == 0; })(").print("<any>");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                case "remove": {
                    this.printMacroName(targetMethodName);
                    this.print("((m,k) => { if(m.entries==null) m.entries=[]; for(let i=0;i<m.entries.length;i++) if(m.entries[i].key.equals!=null && m.entries[i].key.equals(k) || m.entries[i].key===k) { return m.entries.splice(i,1)[0]; } })(").print("<any>");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                    return true;
                }
                case "clear": {
                    this.printMacroName(targetMethodName);
                    this.print("(<any>");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(").entries=[]");
                    return true;
                }
                case "entrySet": {
                    this.printMacroName(targetMethodName);
                    this.print("((m) => { if(m.entries==null) m.entries=[]; return m.entries; })(").print("<any>");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                case "clone": {
                    this.printMacroName(targetMethodName);
                    this.print("(m => { if(m.entries==null) m.entries=[]; let c = {entries: []}; for(let i=0;i<m.entries.length;i++) { let k = m.entries[i].key, v = m.entries[i].value; c.entries[i] = " + newEntry + "; } return c; })(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean substituteMethodInvocationOnArray(MethodInvocationElement invocation, String targetMethodName, String targetClassName, boolean delegate) {
        switch (targetMethodName) {
            case "add": 
            case "addLast": 
            case "push": 
            case "addElement": {
                this.printMacroName(targetMethodName);
                switch (targetClassName) {
                    case "java.util.Set": 
                    case "java.util.HashSet": 
                    case "java.util.TreeSet": {
                        this.print("((s, e) => { if(s.indexOf(e)==-1) { s.push(e); return true; } else { return false; } })(");
                        this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(", ").print(invocation.getArgument(0)).print(")");
                        break;
                    }
                    default: {
                        if (invocation.getArgumentCount() == 2) {
                            this.print(invocation.getTargetExpression(), delegate).print(".splice(").print(invocation.getArgument(0)).print(", 0, ").print(invocation.getArgument(1)).print(")");
                            break;
                        }
                        this.print("(");
                        this.print(invocation.getTargetExpression(), delegate).print(".push(").printArgList(invocation.getArguments()).print(")>0)");
                    }
                }
                return true;
            }
            case "addAll": {
                this.printMacroName(targetMethodName);
                if (invocation.getArgumentCount() == 2) {
                    this.print("((l1, ndx, l2) => { for(let i=l2.length-1;i>=0;i--) l1.splice(ndx,0,l2[i]); })(");
                    this.print(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                } else {
                    this.print("((l1, l2) => l1.push.apply(l1, l2))(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                }
                return true;
            }
            case "pop": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".pop(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "peek": 
            case "lastElement": {
                this.printMacroName(targetMethodName);
                this.print("((s) => { return s[s.length-1]; })(");
                this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                return true;
            }
            case "remove": 
            case "removeFirst": 
            case "removeElement": {
                this.printMacroName(targetMethodName);
                if (invocation.getArgumentCount() == 0) {
                    this.print(invocation.getTargetExpression(), delegate).print(".splice(0, 1)[0]");
                } else if (Util.isNumber(invocation.getArgument(0).getType()) && this.types().isSubtype(this.types().erasure(invocation.getTargetExpression().getType()), this.types().erasure(this.util().getType(List.class)))) {
                    this.print(invocation.getTargetExpression(), delegate).print(".splice(").printArgList(invocation.getArguments()).print(", 1)[0]");
                } else {
                    this.print("(a => { let index = a.indexOf(").print(invocation.getArgument(0)).print("); if(index>=0) { a.splice(index").print(invocation.getArgumentCount() == 1 ? "" : ", ").printArgList(invocation.getArgumentTail()).print(", 1); return true; } else { return false; }})(");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                }
                return true;
            }
            case "removeAll": {
                this.printMacroName(targetMethodName);
                this.print("((a, r) => { let b=false; for(let i=0;i<r.length;i++) { let ndx=a.indexOf(r[i]); if(ndx>=0) { a.splice(ndx, 1); b=true; } } return b; })(");
                this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(",").print(invocation.getArgument(0)).print(")");
                return true;
            }
            case "containsAll": {
                this.printMacroName(targetMethodName);
                this.print("((a, r) => { for(let i=0;i<r.length;i++) { if(a.indexOf(<any>r[i])<0) return false; } return true; } )(");
                this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(",").print(invocation.getArgument(0)).print(")");
                return true;
            }
            case "retainAll": {
                this.printMacroName(targetMethodName);
                this.print("((a, r) => { let b=false; for(let i=0;i<a.length;i++) { let ndx=r.indexOf(a[i]); if(ndx<0) { a.splice(i, 1); i--; b=true; } } return b; })(");
                this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(",").print(invocation.getArgument(0)).print(")");
                return true;
            }
            case "addFirst": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".unshift(").print(invocation.getArgument(0)).print(")");
                return true;
            }
            case "poll": 
            case "pollFirst": {
                this.printMacroName(targetMethodName);
                this.print("(a => a.length==0?null:a.shift())(");
                this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                return true;
            }
            case "pollLast": {
                this.printMacroName(targetMethodName);
                this.print("(a => a.length==0?null:a.pop())(");
                this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                return true;
            }
            case "removeElementAt": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".splice(").printArgList(invocation.getArguments()).print(", 1)");
                return true;
            }
            case "subList": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print(".slice(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "size": {
                this.printMacroName(targetMethodName);
                this.print("(<number>");
                this.print(invocation.getTargetExpression(), delegate).print(".length)");
                return true;
            }
            case "get": 
            case "elementAt": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression(), delegate).print("[").printArgList(invocation.getArguments()).print("]");
                return true;
            }
            case "set": {
                this.printMacroName(targetMethodName);
                this.print("(");
                this.print(invocation.getTargetExpression(), delegate).print("[").print(invocation.getArgument(0)).print("] = ").print(invocation.getArgument(1)).print(")");
                return true;
            }
            case "clear": {
                this.printMacroName(targetMethodName);
                this.print("(");
                this.print(invocation.getTargetExpression(), delegate).print(".length = 0)");
                return true;
            }
            case "isEmpty": {
                this.printMacroName(targetMethodName);
                this.print("(");
                this.print(invocation.getTargetExpression(), delegate).print(".length == 0)");
                return true;
            }
            case "contains": {
                this.printMacroName(targetMethodName);
                this.print("(");
                this.print(invocation.getTargetExpression(), delegate).print(".indexOf(<any>(").print(invocation.getArgument(0)).print(")) >= 0)");
                return true;
            }
            case "toArray": {
                this.printMacroName(targetMethodName);
                if (invocation.getArgumentCount() == 1) {
                    ExtendedElement e = invocation.getArgument(0);
                    if (invocation.getTargetExpression() instanceof VariableAccessElement && e instanceof NewArrayElement) {
                        NewArrayElement newArray = (NewArrayElement)e;
                        boolean simplified = false;
                        if (newArray.getDimensionCount() == 1) {
                            ExtendedElement d = newArray.getDimension(0);
                            if (d.isConstant() && d.toString().equals("0")) {
                                simplified = true;
                            } else if (d instanceof MethodInvocationElement && ((MethodInvocationElement)d).getMethodName().equals("size") && ((MethodInvocationElement)d).getTargetExpression().toString().equals(invocation.getTargetExpression().toString())) {
                                simplified = true;
                            }
                        }
                        if (simplified) {
                            this.print(invocation.getTargetExpression(), delegate).print(".slice(0)");
                            return true;
                        }
                    }
                    this.print("((a1, a2) => { if(a1.length >= a2.length) { a1.length=0; a1.push.apply(a1, a2); return a1; } else { return a2.slice(0); } })(").print(invocation.getArgument(0)).print(", ");
                    this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                    return true;
                }
                this.print(invocation.getTargetExpression(), delegate).print(".slice(0)");
                return true;
            }
            case "elements": {
                this.printMacroName(targetMethodName);
                this.print("((a) => { var i = 0; return { nextElement: function() { return i<a.length?a[i++]:null; }, hasMoreElements: function() { return i<a.length; }}})(");
                this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                return true;
            }
            case "iterator": {
                this.printMacroName(targetMethodName);
                this.print("((a) => { var i = 0; return { next: function() { return i<a.length?a[i++]:null; }, hasNext: function() { return i<a.length; }}})(");
                this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                return true;
            }
            case "listIterator": {
                this.printMacroName(targetMethodName);
                this.print("((a) => { var i = 0; return { next: function() { return i<a.length?a[i++]:null; }, hasNext: function() { return i<a.length; }}})(");
                this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(")");
                return true;
            }
            case "ensureCapacity": {
                this.printMacroName(targetMethodName);
                return true;
            }
            case "toString": {
                this.printMacroName(targetMethodName);
                this.print("('['+");
                this.print(invocation.getTargetExpression(), delegate).print(".join(', ')+']')");
                return true;
            }
            case "allOf": {
                this.print("function() { let result: number[] = []; for(let val in ").print(invocation.getArgument(0)).print(") { if(!isNaN(<any>val)) { result.push(parseInt(val,10)); } } return result; }()");
                return true;
            }
            case "equals": {
                this.printMacroName(targetMethodName);
                this.print("((a1, a2) => { if(a1==null && a2==null) return true; if(a1==null || a2==null) return false; if(a1.length != a2.length) return false; for(let i = 0; i < a1.length; i++) { if(<any>a1[i] != <any>a2[i]) return false; } return true; })(");
                this.printTargetForParameter(invocation.getTargetExpression(), delegate).print(", ").printArgList(invocation.getArguments()).print(")");
                return true;
            }
        }
        return false;
    }

    protected boolean substituteMethodInvocationOnNumber(MethodInvocationElement invocation, String targetMethodName) {
        switch (targetMethodName) {
            case "parseInt": 
            case "parseLong": 
            case "parseShort": 
            case "parseByte": {
                this.printMacroName(targetMethodName);
                this.print("parseInt").print("(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "parseFloat": 
            case "parseDouble": {
                this.printMacroName(targetMethodName);
                this.print("parseFloat").print("(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "floatToIntBits": 
            case "floatToRawIntBits": {
                this.printMacroName(targetMethodName);
                this.print("((f) => { let buf = new ArrayBuffer(4); (new Float32Array(buf))[0]=f; return (new Uint32Array(buf))[0]; })(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "intBitsToFloat": {
                this.print("((v) => { let buf = new ArrayBuffer(4); (new Uint32Array(buf))[0]=v; return (new Float32Array(buf))[0]; })(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "doubleToLongBits": 
            case "doubleToRawLongBits": {
                this.printMacroName(targetMethodName);
                this.print("((f) => { let buf = new ArrayBuffer(4); (new Float32Array(buf))[0]=f; return (new Uint32Array(buf))[0]; })((<any>Math).fround(").printArgList(invocation.getArguments()).print("))");
                return true;
            }
            case "longBitsToDouble": {
                this.print("((v) => { let buf = new ArrayBuffer(4); (new Uint32Array(buf))[0]=v; return (new Float32Array(buf))[0]; })(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
            case "valueOf": {
                if (this.util().isNumber(invocation.getArgument(0).getType())) {
                    this.print(invocation.getArgument(0));
                    return true;
                }
                this.print("parseFloat").print("(").printArgList(invocation.getArguments()).print(")");
                return true;
            }
        }
        return false;
    }

    protected boolean substituteMethodInvocationOnCharacter(MethodInvocationElement invocation, String targetMethodName) {
        switch (targetMethodName) {
            case "isDigit": {
                this.printMacroName(targetMethodName);
                this.print("/\\d/.test(").printArgList(invocation.getArguments()).print("[0])");
                return true;
            }
            case "isLetter": {
                this.printMacroName(targetMethodName);
                this.print("/[a-zA-Z]/.test(").printArgList(invocation.getArguments()).print("[0])");
                return true;
            }
            case "isAlphabetic": {
                this.printMacroName(targetMethodName);
                this.print("/[a-zA-Z]/.test(").printArgList(invocation.getArguments()).print("[0])");
                return true;
            }
            case "isLetterOrDigit": {
                this.printMacroName(targetMethodName);
                this.print("/[a-zA-Z\\d]/.test(").printArgList(invocation.getArguments()).print("[0])");
                return true;
            }
            case "toLowerCase": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getArgument(0)).print(".toLowerCase()");
                return true;
            }
            case "toUpperCase": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getArgument(0)).print(".toUpperCase()");
                return true;
            }
            case "isLowerCase": {
                this.printMacroName(targetMethodName);
                this.print("(s => s.toLowerCase() === s)(").print(invocation.getArgument(0)).print(")");
                return true;
            }
            case "isUpperCase": {
                this.printMacroName(targetMethodName);
                this.print("(s => s.toUpperCase() === s)(").print(invocation.getArgument(0)).print(")");
                return true;
            }
            case "charValue": {
                this.printMacroName(targetMethodName);
                this.print(invocation.getTargetExpression());
                return true;
            }
            case "valueOf": {
                this.print(invocation.getArgument(0));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean substituteVariableAccess(VariableAccessElement variableAccess) {
        String targetClassName = variableAccess.getTargetElement().toString();
        String variableName = variableAccess.getVariableName();
        if (variableAccess.getVariable().getModifiers().contains((Object)Modifier.STATIC) && this.isMappedType(targetClassName) && targetClassName.startsWith("java.lang.") && !"class".equals(variableName)) {
            switch (targetClassName) {
                case "java.lang.Float": 
                case "java.lang.Double": 
                case "java.lang.Integer": 
                case "java.lang.Byte": 
                case "java.lang.Long": 
                case "java.lang.Short": {
                    switch (variableName) {
                        case "MIN_VALUE": 
                        case "MAX_VALUE": 
                        case "POSITIVE_INFINITY": 
                        case "NEGATIVE_INFINITY": {
                            try {
                                Field constantField = Class.forName(targetClassName).getDeclaredField(variableName);
                                this.print("" + constantField.get(null));
                            }
                            catch (Exception e) {
                                this.logger.warn((Object)("unable to read Java constant value " + targetClassName + "." + variableName), (Throwable)e);
                                this.print("Number." + variableName);
                            }
                            return true;
                        }
                        case "NaN": {
                            this.print("NaN");
                            return true;
                        }
                    }
                    break;
                }
                case "java.lang.Boolean": {
                    switch (variableName) {
                        case "TRUE": {
                            this.print("true");
                            return true;
                        }
                        case "FALSE": {
                            this.print("false");
                            return true;
                        }
                    }
                }
            }
        }
        return super.substituteVariableAccess(variableAccess);
    }

    @Override
    public boolean substituteNewClass(NewClassElement newClass) {
        boolean extendsJava;
        String className = newClass.getTypeAsElement().toString();
        TypeMirror jdkSuperclass = this.context.getJdkSuperclass(className, this.excludedJavaSuperTypes);
        boolean bl = extendsJava = jdkSuperclass != null;
        if (extendsJava) {
            className = jdkSuperclass.toString();
            this.print("(() => { let __o : any = new ").print(newClass.getConstructorAccess()).print("(").printArgList(newClass.getArguments()).print("); __o.__delegate = ");
        }
        boolean substitute = false;
        switch (className) {
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Double": 
            case "java.lang.Float": 
            case "java.long.Short": 
            case "java.util.Byte": {
                boolean isCharArgument;
                String argType = newClass.getArgument(0).getType().toString();
                boolean bl2 = isCharArgument = Character.class.getName().equals(argType) || "char".equals(argType);
                if (isCharArgument) {
                    this.print("new Number(").print(newClass.getArgument(0)).print(".charCodeAt(0)).valueOf()");
                } else {
                    this.print("new Number(").print(newClass.getArgument(0)).print(").valueOf()");
                }
                substitute = true;
                break;
            }
            case "java.util.ArrayList": 
            case "java.util.LinkedList": 
            case "java.util.Vector": 
            case "java.util.Stack": 
            case "java.util.TreeSet": 
            case "java.util.HashSet": 
            case "java.util.AbstractSet": 
            case "java.util.AbstractCollection": 
            case "java.util.AbstractList": 
            case "java.util.AbstractQueue": {
                if (newClass.getArgumentCount() == 0) {
                    this.print("[]");
                } else if (Util.isNumber(newClass.getArgument(0).getType()) || newClass.getArgument(0) instanceof LiteralElement) {
                    this.print("[]");
                } else {
                    this.print(newClass.getArgument(0)).print(".slice(0)");
                }
                substitute = true;
                break;
            }
            case "java.util.HashMap": 
            case "java.util.TreeMap": 
            case "java.util.Hashtable": 
            case "java.util.WeakHashMap": 
            case "java.util.LinkedHashMap": {
                if (newClass.getArgumentCount() == 0 || !(newClass.getArgument(0).getType() instanceof Type.ClassType) || !Util.isDeclarationOrSubClassDeclaration(this.types(), (Type.ClassType)newClass.getArgument(0).getType(), Map.class.getName())) {
                    this.print("{}");
                } else if (((DeclaredType)newClass.getType()).getTypeArguments().size() == 2 && this.types().isSameType(((DeclaredType)newClass.getType()).getTypeArguments().get(0), this.util().getType(String.class))) {
                    this.print("((o) => { let r = {}; for(let p in o) r[p]=o[p]; return r; })(").print(newClass.getArgument(0)).print(")");
                } else {
                    this.print("((o) => { let r = {}; r['entries'] = o.entries!=null?o.entries.slice():null; return r; })(").print(newClass.getArgument(0)).print(")");
                }
                substitute = true;
                break;
            }
            case "java.lang.String": {
                if (newClass.getArgumentCount() == 0) {
                    this.print("\"\"");
                    return true;
                }
                ExtendedElement firstArgument = newClass.getArgument(0);
                if (firstArgument.getType() instanceof ArrayType) {
                    if (this.util().isIntegral(((ArrayType)firstArgument.getType()).getComponentType())) {
                        this.print("String.fromCharCode.apply(null, ").print(firstArgument).print(")");
                        if (newClass.getArgumentCount() >= 3 && this.util().isIntegral(newClass.getArgument(1).getType()) && this.util().isIntegral(newClass.getArgument(2).getType())) {
                            this.print(".substr(").print(newClass.getArgument(1)).print(", ").print(newClass.getArgument(2)).print(")");
                        }
                        return true;
                    }
                    this.print(firstArgument).print(".join('')");
                    if (newClass.getArgumentCount() >= 3 && this.util().isIntegral(newClass.getArgument(1).getType()) && this.util().isIntegral(newClass.getArgument(2).getType())) {
                        this.print(".substr(").print(newClass.getArgument(1)).print(", ").print(newClass.getArgument(2)).print(")");
                    }
                    return true;
                }
                if (!StringBuffer.class.getName().equals(firstArgument.getTypeAsElement().toString()) && !StringBuilder.class.getName().equals(firstArgument.getTypeAsElement().toString())) break;
                this.print(firstArgument).print(".str");
                return true;
            }
            case "java.lang.StringBuffer": 
            case "java.lang.StringBuilder": {
                if (newClass.getArgumentCount() == 0 || Util.isNumber(newClass.getArgument(0).getType())) {
                    this.print("{ str: \"\", toString: function() { return this.str; } }");
                } else {
                    this.print("{ str: ").print(newClass.getArgument(0)).print(", toString: function() { return this.str; } }");
                }
                substitute = true;
                break;
            }
            case "java.lang.ref.WeakReference": {
                this.print(newClass.getArgument(0));
                substitute = true;
                break;
            }
            case "java.io.StringReader": {
                this.print("{ str: ").print(newClass.getArgument(0)).print(", cursor: 0 }");
                substitute = true;
                break;
            }
            case "java.io.InputStreamReader": 
            case "java.io.BufferedReader": {
                this.print(newClass.getArgument(0));
                substitute = true;
                break;
            }
            case "java.util.GregorianCalendar": {
                MethodInvocationElement inv;
                if (newClass.getArgumentCount() == 0) {
                    this.getPrinter().print("new Date()");
                    substitute = true;
                    break;
                }
                if (newClass.getArgumentCount() != 1 || !TimeZone.class.getName().equals(newClass.getArgument(0).getType().toString()) || !(newClass.getArgument(0) instanceof MethodInvocationElement) || !(inv = (MethodInvocationElement)newClass.getArgument(0)).getMethodName().equals("getTimeZone") || !(inv.getArgument(0) instanceof LiteralElement) || !((LiteralElement)inv.getArgument(0)).getValue().equals("UTC")) break;
                this.getPrinter().print("(d => { d[\"UTC\"]=true; return d; })(new Date())");
                substitute = true;
                break;
            }
        }
        if (!extendsJava && className.startsWith("java.") && this.types().isSubtype(newClass.getType(), this.context.symtab.throwableType)) {
            this.print("Object.defineProperty(");
            this.print("new Error(");
            if (newClass.getArgumentCount() > 0) {
                if (String.class.getName().equals(newClass.getArgument(0).getType().toString())) {
                    this.print(newClass.getArgument(0));
                } else if (this.types().isSubtype(newClass.getArgument(0).getType(), this.context.symtab.throwableType)) {
                    this.print(newClass.getArgument(0)).print(".message");
                }
            }
            this.print(")");
            HashSet<String> classes = new HashSet<String>();
            this.context.grabSuperClassNames(classes, newClass.getTypeAsElement());
            this.print(", '__classes', { configurable: true, value: [");
            for (String c : classes) {
                this.print("'" + c + "',");
            }
            if (!classes.isEmpty()) {
                this.removeLastChar();
            }
            this.print("] })");
            return true;
        }
        if (!substitute) {
            substitute = super.substituteNewClass(newClass);
        }
        if (extendsJava) {
            this.print("; return __o; })()");
        }
        return substitute;
    }

    @Override
    public boolean substituteForEachLoop(ForeachLoopElement foreachLoop, boolean targetHasLength, String indexVarName) {
        JCTree.JCEnhancedForLoop loop = (JCTree.JCEnhancedForLoop)((ForeachLoopElementSupport)foreachLoop).getTree();
        if (!targetHasLength && !JSweetConfig.isJDKPath(loop.expr.type.toString()) && this.types().isSubtype(loop.expr.type, this.types().erasure(this.util().getType(Iterable.class)))) {
            this.printForEachLoop(loop, indexVarName);
            return true;
        }
        return false;
    }

    @Override
    public boolean eraseSuperClass(TypeElement classdecl, TypeElement superClass) {
        return superClass.getQualifiedName().toString().startsWith("java.") && !superClass.asType().equals(this.context.symtab.throwableType) && !superClass.asType().equals(this.context.symtab.exceptionType) && !superClass.asType().equals(this.context.symtab.runtimeExceptionType) && !superClass.asType().equals(this.context.symtab.errorType) && !Util.isSourceElement(superClass);
    }

    @Override
    public boolean eraseSuperInterface(TypeElement classdecl, TypeElement superInterface) {
        return superInterface.getQualifiedName().toString().startsWith("java.") && !Util.isSourceElement(superInterface);
    }

    @Override
    public boolean isSubstituteSuperTypes() {
        return true;
    }

    @Override
    public boolean substituteInstanceof(String exprStr, ExtendedElement expr, TypeMirror typeMirror) {
        Type type = (Type)typeMirror;
        String typeName = type.tsym.getQualifiedName().toString();
        if (typeName.startsWith("java.") && this.context.types.isSubtype(type, this.context.symtab.throwableType)) {
            this.print(exprStr, expr);
            this.print(" != null && ");
            this.print("(");
            this.print(exprStr, expr);
            this.print("[\"__classes\"] && ");
            this.print(exprStr, expr);
            this.print("[\"__classes\"].indexOf(\"" + type.tsym.getQualifiedName().toString() + "\") >= 0");
            this.print(")");
            if (this.context.getBaseThrowables().contains(typeName)) {
                this.print(" || ");
                return false;
            }
            return true;
        }
        String mappedType = this.extTypesMapping.get(typeName);
        if ("string".equals(mappedType)) {
            mappedType = "String";
        }
        if ("boolean".equals(mappedType)) {
            mappedType = "Boolean";
        }
        if ("any".equals(mappedType) || mappedType != null && mappedType.startsWith("{")) {
            mappedType = "Object";
        }
        if (mappedType != null) {
            if ("String".equals(mappedType)) {
                this.print("typeof ");
                this.print(exprStr, expr);
                this.print(" === ").print("'string'");
                return true;
            }
            this.print(exprStr, expr);
            this.print(" != null && ");
            this.print("(");
            this.print(exprStr, expr);
            this.print(" instanceof " + mappedType);
            this.print(")");
            return true;
        }
        return super.substituteInstanceof(exprStr, expr, type);
    }

    @Override
    public boolean substituteBinaryOperator(BinaryOperatorElement binaryOperator) {
        if ("+".equals(binaryOperator.getOperator()) && this.types().isSameType(this.util().getType(String.class), binaryOperator.getOperatorType().getReturnType())) {
            if ("Array".equals(this.extTypesMapping.get(this.types().erasure(binaryOperator.getLeftHandSide().getType()).toString()))) {
                this.print("/* implicit toString */ (a => a?'['+a.join(', ')+']':'null')(").print(binaryOperator.getLeftHandSide()).print(") + ").print(binaryOperator.getRightHandSide());
                return true;
            }
            if ("Array".equals(this.extTypesMapping.get(this.types().erasure(binaryOperator.getRightHandSide().getType()).toString()))) {
                this.print(binaryOperator.getLeftHandSide()).print(" + /* implicit toString */ (a => a?'['+a.join(', ')+']':'null')(").print(binaryOperator.getRightHandSide()).print(")");
                return true;
            }
        }
        return super.substituteBinaryOperator(binaryOperator);
    }
}

