/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler.extension;

import java.math.BigDecimal;
import javax.lang.model.element.Element;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.NewClassElement;
import org.jsweet.transpiler.model.VariableAccessElement;

public class BigDecimalAdapter
extends PrinterAdapter {
    public BigDecimalAdapter(PrinterAdapter parent) {
        super(parent);
        this.addTypeMapping(BigDecimal.class.getName(), "Big");
    }

    @Override
    public boolean substituteNewClass(NewClassElement newClass) {
        String className = newClass.getTypeAsElement().toString();
        if (BigDecimal.class.getName().equals(className)) {
            this.print("new Big(").printArgList(newClass.getArguments()).print(")");
            return true;
        }
        return super.substituteNewClass(newClass);
    }

    @Override
    public boolean substituteVariableAccess(VariableAccessElement variableAccess) {
        if (variableAccess.getTargetExpression() != null) {
            Element targetType = variableAccess.getTargetExpression().getTypeAsElement();
            if (BigDecimal.class.getName().equals(targetType.toString())) {
                switch (variableAccess.getVariableName()) {
                    case "ZERO": {
                        this.printMacroName(variableAccess.getVariableName());
                        this.print("new Big(0)");
                        return true;
                    }
                    case "ONE": {
                        this.printMacroName(variableAccess.getVariableName());
                        this.print("new Big(1)");
                        return true;
                    }
                    case "TEN": {
                        this.printMacroName(variableAccess.getVariableName());
                        this.print("new Big(10)");
                        return true;
                    }
                }
            }
        }
        return super.substituteVariableAccess(variableAccess);
    }

    @Override
    public boolean substituteMethodInvocation(MethodInvocationElement invocation) {
        if (invocation.getTargetExpression() != null) {
            Element targetType = invocation.getTargetExpression().getTypeAsElement();
            if (BigDecimal.class.getName().equals(targetType.toString())) {
                switch (invocation.getMethodName()) {
                    case "multiply": {
                        this.printMacroName(invocation.getMethodName());
                        this.print(invocation.getTargetExpression()).print(".times(").printArgList(invocation.getArguments()).print(")");
                        return true;
                    }
                    case "add": {
                        this.printMacroName(invocation.getMethodName());
                        this.print(invocation.getTargetExpression()).print(".plus(").printArgList(invocation.getArguments()).print(")");
                        return true;
                    }
                    case "subtract": {
                        this.printMacroName(invocation.getMethodName());
                        this.print(invocation.getTargetExpression()).print(".minus(").printArgList(invocation.getArguments()).print(")");
                        return true;
                    }
                    case "scale": {
                        this.printMacroName(invocation.getMethodName());
                        this.print("2");
                        return true;
                    }
                    case "setScale": {
                        this.printMacroName(invocation.getMethodName());
                        this.print(invocation.getTargetExpression()).print(".round(").print(invocation.getArguments().get(0)).print(")");
                        return true;
                    }
                    case "compareTo": {
                        this.printMacroName(invocation.getMethodName());
                        this.print(invocation.getTargetExpression()).print(".cmp(").print(invocation.getArguments().get(0)).print(")");
                        return true;
                    }
                    case "equals": {
                        this.printMacroName(invocation.getMethodName());
                        this.print(invocation.getTargetExpression()).print(".eq(").print(invocation.getArguments().get(0)).print(")");
                        return true;
                    }
                    case "valueOf": {
                        this.printMacroName(invocation.getMethodName());
                        this.print("new Big(").print(invocation.getArguments().get(0)).print(")");
                        return true;
                    }
                    case "signum": {
                        this.printMacroName(invocation.getMethodName());
                        this.print(invocation.getTargetExpression()).print(".cmp(0)");
                        return true;
                    }
                }
            }
        }
        return super.substituteMethodInvocation(invocation);
    }
}

