/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.EcmaScriptComplianceLevel;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.ModuleImportDescriptor;
import org.jsweet.transpiler.OverloadScanner;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.model.ExtendedElement;
import org.jsweet.transpiler.model.ExtendedElementFactory;
import org.jsweet.transpiler.model.MethodInvocationElement;
import org.jsweet.transpiler.model.support.ArrayAccessElementSupport;
import org.jsweet.transpiler.model.support.AssignmentElementSupport;
import org.jsweet.transpiler.model.support.AssignmentWithOperatorElementSupport;
import org.jsweet.transpiler.model.support.BinaryOperatorElementSupport;
import org.jsweet.transpiler.model.support.CaseElementSupport;
import org.jsweet.transpiler.model.support.CompilationUnitElementSupport;
import org.jsweet.transpiler.model.support.ExtendedElementSupport;
import org.jsweet.transpiler.model.support.ForeachLoopElementSupport;
import org.jsweet.transpiler.model.support.ImportElementSupport;
import org.jsweet.transpiler.model.support.MethodInvocationElementSupport;
import org.jsweet.transpiler.model.support.NewClassElementSupport;
import org.jsweet.transpiler.model.support.UnaryOperatorElementSupport;
import org.jsweet.transpiler.util.AbstractTreePrinter;
import org.jsweet.transpiler.util.AbstractTreeScanner;
import org.jsweet.transpiler.util.ConsoleTranspilationHandler;
import org.jsweet.transpiler.util.JSDoc;
import org.jsweet.transpiler.util.RollbackException;
import org.jsweet.transpiler.util.Util;

public class Java2TypeScriptTranslator
extends AbstractTreePrinter {
    public static final String PARENT_CLASS_FIELD_NAME = "__parent";
    public static final String INTERFACES_FIELD_NAME = "__interfaces";
    public static final String STATIC_INITIALIZATION_SUFFIX = "_$LI$";
    public static final String CLASS_NAME_IN_CONSTRUCTOR = "__class";
    public static final String ANONYMOUS_PREFIX = "$";
    public static final String ENUM_WRAPPER_CLASS_SUFFIX = "_$WRAPPER";
    public static final String ENUM_WRAPPER_CLASS_WRAPPERS = "_$wrappers";
    public static final String ENUM_WRAPPER_CLASS_NAME = "_$name";
    public static final String ENUM_WRAPPER_CLASS_ORDINAL = "_$ordinal";
    public static final String VAR_DECL_KEYWORD = "let";
    public static final Pattern BODY_MARKER = Pattern.compile("\\{\\{\\s*body\\s*\\}\\}");
    public static final Pattern BASE_INDENT_MARKER = Pattern.compile("\\{\\{\\s*baseIndent\\s*\\}\\}");
    public static final Pattern INDENT_MARKER = Pattern.compile("\\{\\{\\s*indent\\s*\\}\\}");
    public static final Pattern METHOD_NAME_MARKER = Pattern.compile("\\{\\{\\s*methodName\\s*\\}\\}");
    public static final Pattern CLASS_NAME_MARKER = Pattern.compile("\\{\\{\\s*className\\s*\\}\\}");
    public static final String GENERATOR_PREFIX = "__generator_";
    protected static Logger logger = Logger.getLogger(Java2TypeScriptTranslator.class);
    private final Stack<ComparisonMode> comparisonModeStack = new Stack();
    private Stack<ClassScope> scope = new Stack();
    private boolean isAnnotationScope = false;
    private boolean isDefinitionScope = false;
    private static java.util.List<Class<?>> statementsWithNoSemis = Arrays.asList(JCTree.JCIf.class, JCTree.JCForLoop.class, JCTree.JCEnhancedForLoop.class, JCTree.JCSwitch.class);
    public static final Map<String, String> TYPE_MAPPING;
    private static final Map<String, String> CONSTRUCTOR_TYPE_MAPPING;
    private Symbol.PackageSymbol topLevelPackage;
    private boolean inTypeParameters = false;
    private boolean disableTypeSubstitution = false;
    private boolean printCoreMethodDelegate = false;
    private boolean staticInitializedAssignment = false;
    protected boolean inRollback = false;
    Stack<Type> rootConditionalAssignedTypes = new Stack();
    Stack<Type> rootArrayAssignedTypes = new Stack();

    public void enterComparisonMode(ComparisonMode comparisonMode) {
        this.comparisonModeStack.push(comparisonMode);
    }

    public void exitComparisonMode() {
        this.comparisonModeStack.pop();
    }

    private ComparisonMode getComparisonMode() {
        if (this.comparisonModeStack.isEmpty()) {
            return ComparisonMode.STRICT;
        }
        if (this.comparisonModeStack.peek() == ComparisonMode.STRICT) {
            return ComparisonMode.FORCE_STRICT;
        }
        return ComparisonMode.LOOSE;
    }

    protected final boolean isTopLevelScope() {
        return this.getIndent() == 0;
    }

    protected final ClassScope getScope() {
        return this.scope.peek();
    }

    protected final ClassScope getScope(int i) {
        return (ClassScope)this.scope.get(this.scope.size() - 1 - i);
    }

    public void enterScope() {
        this.scope.push(new ClassScope());
    }

    public void exitScope() {
        this.scope.pop();
    }

    public Java2TypeScriptTranslator(PrinterAdapter adapter, TranspilationHandler logHandler, JSweetContext context, JCTree.JCCompilationUnit compilationUnit, boolean fillSourceMap) {
        super(logHandler, context, compilationUnit, adapter, fillSourceMap);
    }

    private static String mapConstructorType(String typeName) {
        if (CONSTRUCTOR_TYPE_MAPPING.containsKey(typeName)) {
            return CONSTRUCTOR_TYPE_MAPPING.get(typeName);
        }
        return typeName;
    }

    public void useModule(ModuleImportDescriptor moduleImport) {
        this.useModule(false, moduleImport.isDirect(), moduleImport.getTargetPackage(), null, moduleImport.getImportedName(), moduleImport.getPathToImportedClass(), null);
    }

    private void useModule(boolean require, boolean direct, PackageElement targetPackage, JCTree sourceTree, String targetName, String moduleName, Symbol sourceElement) {
        if (this.context.useModules) {
            this.context.packageDependencies.add((Symbol.PackageSymbol)targetPackage);
            this.context.packageDependencies.add(this.compilationUnit.packge);
            this.context.packageDependencies.addEdge(this.compilationUnit.packge, (Symbol.PackageSymbol)targetPackage);
        }
        this.context.registerUsedModule(moduleName);
        Set<String> importedNames = this.context.getImportedNames(this.compilationUnit.getSourceFile().getName());
        if (!importedNames.contains(targetName)) {
            if (this.context.useModules) {
                if (this.context.isExcludedSourcePath(Util.getSourceFilePath(sourceElement))) {
                    return;
                }
                if (sourceElement instanceof Symbol.ClassSymbol && this.context.hasAnnotationType((Symbol.ClassSymbol)sourceElement, "jsweet.lang.Decorator")) {
                    this.context.forceTopImports();
                }
                if (!(this.context.moduleBundleMode || !(sourceElement instanceof Symbol.ClassSymbol) || !Util.isSourceElement(sourceElement) || sourceElement instanceof Symbol.TypeSymbol && this.context.referenceAnalyzer != null && this.context.referenceAnalyzer.isDependent(this.compilationUnit, (Symbol.TypeSymbol)sourceElement))) {
                    this.context.addTopFooterStatement("import." + targetName, "import { " + targetName + " } from '" + moduleName + "';\n");
                } else if (direct) {
                    this.context.addHeader("import." + targetName, "import " + targetName + " = " + moduleName + ";\n");
                } else {
                    boolean fullImport;
                    boolean bl = fullImport = require || "Globals".equals(targetName);
                    if (fullImport) {
                        if (this.context.useRequireForModules) {
                            this.context.addHeader("import." + targetName, "import " + targetName + " = require(\"" + moduleName + "\");\n");
                        } else {
                            this.context.addHeader("import." + targetName, "import * as " + targetName + " from '" + moduleName + "';\n");
                        }
                    } else {
                        this.context.addHeader("import." + targetName, "import { " + targetName + " } from '" + moduleName + "';\n");
                    }
                }
            }
            this.context.registerImportedName(this.compilationUnit.getSourceFile().getName(), sourceElement, targetName);
        }
    }

    private boolean checkRootPackageParent(JCTree.JCCompilationUnit topLevel, Symbol.PackageSymbol rootPackage, Symbol.PackageSymbol parentPackage) {
        if (parentPackage == null) {
            return true;
        }
        if (!this.context.options.isNoRootDirectories() || this.context.options.isBundle()) {
            return true;
        }
        if (this.context.isRootPackage(parentPackage)) {
            this.report((JCTree)((Object)topLevel.getPackageName()), JSweetProblem.ENCLOSED_ROOT_PACKAGES, rootPackage.getQualifiedName().toString(), parentPackage.getQualifiedName().toString());
            return false;
        }
        for (Symbol s : parentPackage.getEnclosedElements()) {
            if (!(s instanceof Symbol.ClassSymbol) || !Util.isSourceElement(s)) continue;
            this.report((JCTree)((Object)topLevel.getPackageName()), JSweetProblem.CLASS_OUT_OF_ROOT_PACKAGE_SCOPE, s.getQualifiedName().toString(), rootPackage.getQualifiedName().toString());
            return false;
        }
        return this.checkRootPackageParent(topLevel, rootPackage, (Symbol.PackageSymbol)parentPackage.owner);
    }

    private ModuleImportDescriptor getModuleImportDescriptor(String importedName, TypeElement importedClass) {
        return this.getAdapter().getModuleImportDescriptor(new CompilationUnitElementSupport(this.compilationUnit), importedName, importedClass);
    }

    private boolean isMappedOrErasedType(Symbol symbol) {
        return this.context.isMappedType(symbol.type.tsym.toString()) || this.context.hasAnnotationType(symbol, "jsweet.lang.Erased");
    }

    public void ensureModuleIsUsed(Element element) {
        ModuleImportDescriptor moduleImport;
        if (this.context.useModules && element instanceof TypeElement && (moduleImport = this.getAdapter().getModuleImportDescriptor(new CompilationUnitElementSupport(this.compilationUnit), element.getSimpleName().toString(), (TypeElement)element)) != null) {
            this.useModule(moduleImport);
        }
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit topLevel) {
        Symbol.PackageSymbol rootPackage;
        if (this.context.isPackageErased(topLevel.packge)) {
            return;
        }
        this.isDefinitionScope = topLevel.packge.getQualifiedName().toString().startsWith("def.");
        if (this.context.hasAnnotationType(topLevel.packge, "jsweet.lang.Module")) {
            this.context.addExportedElement(this.context.getAnnotationValue(topLevel.packge, "jsweet.lang.Module", String.class, null), topLevel.packge, this.getCompilationUnit());
        }
        if ((rootPackage = this.context.getFirstEnclosingRootPackage(topLevel.packge)) != null && !this.checkRootPackageParent(topLevel, rootPackage, (Symbol.PackageSymbol)rootPackage.owner)) {
            return;
        }
        this.context.importedTopPackages.clear();
        this.context.rootPackages.add(rootPackage);
        this.topLevelPackage = this.context.getTopLevelPackage(topLevel.packge);
        if (this.topLevelPackage != null) {
            this.context.topLevelPackageNames.add(this.topLevelPackage.getQualifiedName().toString());
        }
        this.footer.delete(0, this.footer.length());
        this.setCompilationUnit(topLevel);
        String packge = topLevel.packge.toString();
        boolean globalModule = "globals".equals(packge) || packge.endsWith(".globals");
        String rootRelativePackageName = "";
        if (!globalModule && (rootRelativePackageName = this.getRootRelativeName(topLevel.packge)).length() == 0) {
            globalModule = true;
        }
        ArrayList<String> packageSegments = new ArrayList<String>(Arrays.asList(rootRelativePackageName.split("\\.")));
        packageSegments.retainAll(JSweetConfig.TS_TOP_LEVEL_KEYWORDS);
        if (!packageSegments.isEmpty()) {
            this.report((JCTree)((Object)topLevel.getPackageName()), JSweetProblem.PACKAGE_NAME_CONTAINS_KEYWORD, packageSegments);
        }
        for (final JCTree.JCImport jCImport : topLevel.getImports()) {
            TreeScanner importedModulesScanner = new TreeScanner(){

                @Override
                public void scan(JCTree tree) {
                    if (tree instanceof JCTree.JCFieldAccess) {
                        JCTree.JCFieldAccess qualified = (JCTree.JCFieldAccess)tree;
                        if (qualified.sym != null) {
                            if (Java2TypeScriptTranslator.this.context.hasAnnotationType(qualified.sym, "jsweet.lang.Module")) {
                                String targetName = Java2TypeScriptTranslator.this.createImportAliasFromFieldAccess(qualified);
                                String actualName = Java2TypeScriptTranslator.this.context.getAnnotationValue(qualified.sym, "jsweet.lang.Module", String.class, null);
                                Java2TypeScriptTranslator.this.useModule(true, false, null, jCImport, targetName, actualName, qualified.sym);
                            }
                        } else if (qualified.selected instanceof JCTree.JCFieldAccess) {
                            JCTree.JCFieldAccess qualifier = (JCTree.JCFieldAccess)qualified.selected;
                            if (qualifier.sym != null) {
                                try {
                                    for (Symbol importedMember : qualifier.sym.getEnclosedElements()) {
                                        if (!qualified.name.equals(importedMember.getSimpleName()) || !Java2TypeScriptTranslator.this.context.hasAnnotationType(importedMember, "jsweet.lang.Module")) continue;
                                        String targetName = Java2TypeScriptTranslator.this.createImportAliasFromSymbol(importedMember);
                                        String actualName = Java2TypeScriptTranslator.this.context.getAnnotationValue(importedMember, "jsweet.lang.Module", String.class, null);
                                        Java2TypeScriptTranslator.this.useModule(true, false, null, jCImport, targetName, actualName, importedMember);
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    super.scan(tree);
                }
            };
            importedModulesScanner.scan(jCImport.qualid);
        }
        for (JCTree.JCImport jCImport : topLevel.getImports()) {
            ModuleImportDescriptor moduleImport;
            if (!(jCImport.qualid instanceof JCTree.JCFieldAccess)) continue;
            JCTree.JCFieldAccess qualified = jCImport.qualid;
            String importedName = qualified.name.toString();
            if (jCImport.isStatic() && qualified.selected instanceof JCTree.JCFieldAccess) {
                qualified = (JCTree.JCFieldAccess)qualified.selected;
            }
            if (!(qualified.sym instanceof Symbol.ClassSymbol)) continue;
            boolean globals = "Globals".equals(qualified.sym.getSimpleName().toString());
            if (!globals) {
                importedName = qualified.name.toString();
            }
            Symbol.ClassSymbol importedClass = (Symbol.ClassSymbol)qualified.sym;
            String qualId = ((JCTree)jCImport.getQualifiedIdentifier()).toString();
            String adaptedQualId = this.getAdapter().needsImport(new ImportElementSupport(jCImport), qualId);
            if (!globals && adaptedQualId == null || (moduleImport = this.getModuleImportDescriptor(importedName, importedClass)) == null) continue;
            this.useModule(false, moduleImport.isDirect(), moduleImport.getTargetPackage(), jCImport, moduleImport.getImportedName(), moduleImport.getPathToImportedClass(), null);
        }
        if (this.context.useModules) {
            new UsedTypesScanner().scan(this.compilationUnit);
        }
        new TreeScanner(){
            Stack<JCTree> stack = new Stack();

            @Override
            public void scan(JCTree t) {
                if (t != null) {
                    this.stack.push(t);
                    try {
                        super.scan(t);
                    }
                    finally {
                        this.stack.pop();
                    }
                }
            }

            public <T extends JCTree> T getParent(Class<T> type) {
                for (int i = this.stack.size() - 2; i >= 0; --i) {
                    if (!type.isAssignableFrom(((JCTree)this.stack.get(i)).getClass())) continue;
                    return (T)((JCTree)this.stack.get(i));
                }
                return null;
            }

            @Override
            public void visitIdent(JCTree.JCIdent identifier) {
                if (identifier.sym instanceof Symbol.PackageSymbol) {
                    JCTree tree;
                    if (this.getParent(JCTree.JCImport.class) != null) {
                        return;
                    }
                    boolean isSourceType = false;
                    for (int i = this.stack.size() - 2; i >= 0 && (tree = (JCTree)this.stack.get(i)) instanceof JCTree.JCFieldAccess; --i) {
                        JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)tree;
                        if (!(fa.sym instanceof Symbol.ClassSymbol) || !Util.isSourceElement(fa.sym)) continue;
                        isSourceType = true;
                        break;
                    }
                    if (!isSourceType) {
                        return;
                    }
                    Symbol.PackageSymbol identifierPackage = (Symbol.PackageSymbol)identifier.sym;
                    String pathToModulePackage = Util.getRelativePath(((Java2TypeScriptTranslator)Java2TypeScriptTranslator.this).compilationUnit.packge, identifierPackage);
                    if (pathToModulePackage == null) {
                        return;
                    }
                    File moduleFile = new File(new File(pathToModulePackage), "module");
                    if (!((Name)identifierPackage.getSimpleName()).toString().equals(((Name)((Java2TypeScriptTranslator)Java2TypeScriptTranslator.this).compilationUnit.packge.getSimpleName()).toString())) {
                        Java2TypeScriptTranslator.this.useModule(false, false, identifierPackage, identifier, ((Name)identifierPackage.getSimpleName()).toString(), moduleFile.getPath().replace('\\', '/'), null);
                    }
                } else if (identifier.sym instanceof Symbol.ClassSymbol && "globals".equals(identifier.sym.getEnclosingElement().getSimpleName().toString())) {
                    String pathToModulePackage = Util.getRelativePath(((Java2TypeScriptTranslator)Java2TypeScriptTranslator.this).compilationUnit.packge, identifier.sym.getEnclosingElement());
                    if (pathToModulePackage == null) {
                        return;
                    }
                    File moduleFile = new File(new File(pathToModulePackage), "module");
                    if (!identifier.sym.getEnclosingElement().equals(((Name)((Java2TypeScriptTranslator)Java2TypeScriptTranslator.this).compilationUnit.packge.getSimpleName()).toString())) {
                        Java2TypeScriptTranslator.this.useModule(false, false, (Symbol.PackageSymbol)identifier.sym.getEnclosingElement(), identifier, "globals", moduleFile.getPath().replace('\\', '/'), null);
                    }
                }
            }

            @Override
            public void visitApply(JCTree.JCMethodInvocation invocation) {
                if (invocation.meth instanceof JCTree.JCIdent && JSweetConfig.TS_STRICT_MODE_KEYWORDS.contains(invocation.meth.toString().toLowerCase())) {
                    Symbol.PackageSymbol invocationPackage = (Symbol.PackageSymbol)((JCTree.JCIdent)invocation.meth).sym.getEnclosingElement().getEnclosingElement();
                    String rootRelativeInvocationPackageName = Java2TypeScriptTranslator.this.getRootRelativeName(invocationPackage);
                    if (rootRelativeInvocationPackageName.indexOf(46) == -1) {
                        super.visitApply(invocation);
                        return;
                    }
                    String targetRootPackageName = rootRelativeInvocationPackageName.substring(0, rootRelativeInvocationPackageName.indexOf(46));
                    String pathToReachRootPackage = Util.getRelativePath("/" + ((Java2TypeScriptTranslator)Java2TypeScriptTranslator.this).compilationUnit.packge.getQualifiedName().toString().replace('.', '/'), "/" + targetRootPackageName);
                    if (pathToReachRootPackage == null) {
                        super.visitApply(invocation);
                        return;
                    }
                    File moduleFile = new File(new File(pathToReachRootPackage), "module");
                    if (!invocationPackage.toString().equals(((Name)((Java2TypeScriptTranslator)Java2TypeScriptTranslator.this).compilationUnit.packge.getSimpleName()).toString())) {
                        Java2TypeScriptTranslator.this.useModule(false, false, invocationPackage, invocation, targetRootPackageName, moduleFile.getPath().replace('\\', '/'), null);
                    }
                }
                super.visitApply(invocation);
            }
        };
        if (!globalModule && !this.context.useModules) {
            this.printIndent();
            if (this.isDefinitionScope) {
                this.print("declare ");
            } else if (this.context.moduleBundleMode) {
                this.print("export ");
            }
            this.print("namespace ").print(rootRelativePackageName).print(" {").startIndent().println();
        }
        for (JCTree jCTree : topLevel.defs) {
            if (jCTree instanceof JCTree.JCClassDecl) continue;
            this.print(jCTree);
        }
        for (JCTree jCTree : Util.getSortedClassDeclarations(topLevel.defs)) {
            this.printIndent();
            int pos = this.getCurrentPosition();
            this.print(jCTree);
            if (this.getCurrentPosition() == pos) {
                this.removeLastIndent();
                continue;
            }
            this.println().println();
        }
        if (!globalModule && !this.context.useModules) {
            this.removeLastChar().endIndent().printIndent().print("}").println();
        }
        if (this.footer.length() > 0) {
            this.println().print(this.footer.toString());
        }
        globalModule = false;
    }

    private String createImportAliasFromFieldAccess(JCTree.JCFieldAccess access) {
        String name = this.extractNameFromAnnotatedSymbol(access.sym);
        if (name != null) {
            return name;
        }
        return access.name.toString();
    }

    private String createImportAliasFromSymbol(Symbol symbol) {
        String name = this.extractNameFromAnnotatedSymbol(symbol);
        if (name != null) {
            return name;
        }
        return symbol.getSimpleName().toString();
    }

    private String extractNameFromAnnotatedSymbol(Symbol symbol) {
        if (this.context.hasAnnotationType(symbol, "jsweet.lang.Name")) {
            return this.context.getAnnotationValue(symbol, "jsweet.lang.Name", String.class, null);
        }
        return null;
    }

    private void printDocComment(JCTree element) {
        this.printDocComment(element, false);
    }

    private void printDocComment(JCTree element, boolean newline) {
        if (this.compilationUnit != null && this.compilationUnit.docComments != null) {
            Tokens.Comment comment = this.compilationUnit.docComments.getComment(element);
            String commentText = JSDoc.adaptDocComment(this.context, this.getCompilationUnit(), element, comment == null ? null : comment.getText());
            Symbol elt = null;
            if (element instanceof JCTree.JCVariableDecl) {
                elt = ((JCTree.JCVariableDecl)element).sym;
            } else if (element instanceof JCTree.JCMethodDecl) {
                elt = ((JCTree.JCMethodDecl)element).sym;
            } else if (element instanceof JCTree.JCClassDecl) {
                elt = ((JCTree.JCClassDecl)element).sym;
            }
            if (elt != null) {
                commentText = this.getAdapter().adaptDocComment(elt, commentText);
            }
            ArrayList<String> lines = new ArrayList<String>();
            if (commentText != null) {
                lines.addAll(Arrays.asList(commentText.split("\n")));
            }
            if (!lines.isEmpty()) {
                if (newline) {
                    this.println().printIndent();
                }
                this.print("/**").println();
                for (String line : lines) {
                    this.printIndent().print(" * ").print(line.trim()).println();
                }
                this.removeLastChar();
                this.println().printIndent().print(" ").print("*/").println();
                this.printIndent();
            }
        }
    }

    private void printAnonymousClassTypeArgs(JCTree.JCNewClass newClass) {
        JCTree.JCTypeApply tapply;
        if (newClass.clazz instanceof JCTree.JCTypeApply && (tapply = (JCTree.JCTypeApply)newClass.clazz).getTypeArguments() != null && !((List)tapply.getTypeArguments()).isEmpty()) {
            boolean printed = false;
            this.print("<");
            for (JCTree.JCExpression targ : tapply.getTypeArguments()) {
                if (!(targ.type.tsym instanceof Symbol.TypeVariableSymbol)) continue;
                printed = true;
                this.print(targ).print(", ");
            }
            if (printed) {
                this.removeLastChars(2);
                this.print(">");
            } else {
                this.removeLastChar();
            }
        }
    }

    protected boolean isAnonymousClass() {
        return this.scope.size() > 1 && this.getScope(1).isAnonymousClass;
    }

    private boolean isInnerClass() {
        return this.scope.size() > 1 && this.getScope(1).isInnerClass;
    }

    private boolean isLocalClass() {
        return this.scope.size() > 1 && this.getScope(1).isLocalClass;
    }

    @Override
    public final AbstractTreePrinter substituteAndPrintType(JCTree typeTree) {
        return this.substituteAndPrintType(typeTree, false, this.inTypeParameters, true, this.disableTypeSubstitution);
    }

    private AbstractTreePrinter printArguments(java.util.List<JCTree.JCExpression> arguments) {
        int i = 1;
        for (JCTree.JCExpression argument : arguments) {
            this.printArgument(argument, i++).print(", ");
        }
        if (arguments.size() > 0) {
            this.removeLastChars(2);
        }
        return this;
    }

    private AbstractTreePrinter printArgument(JCTree.JCExpression argument, int i) {
        this.print("p" + i + ": ");
        this.substituteAndPrintType(argument, false, false, true, false);
        return this;
    }

    private AbstractTreePrinter substituteAndPrintType(JCTree typeTree, boolean arrayComponent, boolean inTypeParameters, boolean completeRawTypes, boolean disableSubstitution) {
        if (typeTree instanceof JCTree.JCTypeIntersection) {
            for (JCTree jCTree : ((JCTree.JCTypeIntersection)typeTree).bounds) {
                this.substituteAndPrintType(jCTree, arrayComponent, inTypeParameters, completeRawTypes, disableSubstitution);
                this.print(" & ");
            }
            this.removeLastChars(3);
            return this;
        }
        if (typeTree.type.tsym instanceof Symbol.TypeVariableSymbol && this.getAdapter().typeVariablesToErase.contains(typeTree.type.tsym)) {
            return this.print("any");
        }
        if (!disableSubstitution) {
            if (this.context.hasAnnotationType(typeTree.type.tsym, "jsweet.lang.Erased")) {
                return this.print("any");
            }
            if (this.context.hasAnnotationType(typeTree.type.tsym, "jsweet.lang.ObjectType")) {
                return this.print("any");
            }
            String typeFullName = typeTree.type.getModelType().toString();
            if (Runnable.class.getName().equals(typeFullName)) {
                if (arrayComponent) {
                    this.print("(");
                }
                this.print("() => void");
                if (arrayComponent) {
                    this.print(")");
                }
                return this;
            }
            if (typeTree instanceof JCTree.JCTypeApply) {
                JCTree.JCTypeApply jCTypeApply = (JCTree.JCTypeApply)typeTree;
                String typeName = jCTypeApply.clazz.toString();
                String mappedTypeName = this.context.getTypeMappingTarget(typeName);
                if (mappedTypeName != null && mappedTypeName.endsWith("<>")) {
                    this.print(typeName.substring(0, mappedTypeName.length() - 2));
                    return this;
                }
                if (typeFullName.startsWith("jsweet.util.tuple.")) {
                    this.print("[");
                    for (JCTree.JCExpression argument : jCTypeApply.arguments) {
                        this.substituteAndPrintType(argument, arrayComponent, inTypeParameters, completeRawTypes, false).print(",");
                    }
                    if (jCTypeApply.arguments.length() > 0) {
                        this.removeLastChar();
                    }
                    this.print("]");
                    return this;
                }
                if (typeFullName.startsWith("jsweet.util.union.Union")) {
                    this.print("(");
                    for (JCTree.JCExpression argument : jCTypeApply.arguments) {
                        this.print("(");
                        this.substituteAndPrintType(argument, arrayComponent, inTypeParameters, completeRawTypes, false);
                        this.print(")");
                        this.print("|");
                    }
                    if (jCTypeApply.arguments.length() > 0) {
                        this.removeLastChar();
                    }
                    this.print(")");
                    return this;
                }
                if (typeFullName.startsWith("jsweet.util.") || typeFullName.startsWith("java.util.function.")) {
                    if (typeName.endsWith("Consumer") || typeName.startsWith("Consumer")) {
                        if (arrayComponent) {
                            this.print("(");
                        }
                        this.print("(");
                        if (typeName.startsWith("Int") || typeName.startsWith("Long") || typeName.startsWith("Double")) {
                            this.print("p0 : number");
                        } else {
                            this.printArguments(jCTypeApply.arguments);
                        }
                        this.print(") => void");
                        if (arrayComponent) {
                            this.print(")");
                        }
                        return this;
                    }
                    if (typeName.endsWith("Function") || typeName.startsWith("Function")) {
                        if (arrayComponent) {
                            this.print("(");
                        }
                        this.print("(");
                        if (typeName.startsWith("Int") || typeName.startsWith("Long") || typeName.startsWith("Double")) {
                            this.print("p0 : number");
                        } else {
                            this.printArguments(jCTypeApply.arguments.subList(0, jCTypeApply.arguments.length() - 1));
                        }
                        this.print(") => ");
                        this.substituteAndPrintType(jCTypeApply.arguments.get(jCTypeApply.arguments.length() - 1), arrayComponent, inTypeParameters, completeRawTypes, false);
                        if (arrayComponent) {
                            this.print(")");
                        }
                        return this;
                    }
                    if (typeName.endsWith("Supplier") || typeName.startsWith("Supplier")) {
                        if (arrayComponent) {
                            this.print("(");
                        }
                        this.print("(");
                        this.print(") => ");
                        if (typeName.startsWith("Int") || typeName.startsWith("Long") || typeName.startsWith("Double")) {
                            this.print("number");
                        } else {
                            this.substituteAndPrintType(jCTypeApply.arguments.get(0), arrayComponent, inTypeParameters, completeRawTypes, false);
                        }
                        if (arrayComponent) {
                            this.print(")");
                        }
                        return this;
                    }
                    if (typeName.endsWith("Predicate")) {
                        if (arrayComponent) {
                            this.print("(");
                        }
                        this.print("(");
                        if (typeName.startsWith("Int") || typeName.startsWith("Long") || typeName.startsWith("Double")) {
                            this.print("p0 : number");
                        } else {
                            this.printArguments(jCTypeApply.arguments);
                        }
                        this.print(") => boolean");
                        if (arrayComponent) {
                            this.print(")");
                        }
                        return this;
                    }
                    if (typeName.endsWith("Operator")) {
                        if (arrayComponent) {
                            this.print("(");
                        }
                        this.print("(");
                        this.printArgument((JCTree.JCExpression)jCTypeApply.arguments.head, 1);
                        if (typeName.startsWith("Binary")) {
                            this.print(", ");
                            this.printArgument((JCTree.JCExpression)jCTypeApply.arguments.head, 2);
                        }
                        this.print(") => ");
                        this.substituteAndPrintType((JCTree)jCTypeApply.arguments.head, arrayComponent, inTypeParameters, completeRawTypes, false);
                        if (arrayComponent) {
                            this.print(")");
                        }
                        return this;
                    }
                }
                if (typeFullName.startsWith(Class.class.getName() + "<")) {
                    return this.print("any");
                }
            } else {
                if (!(typeTree instanceof JCTree.JCArrayTypeTree) && typeFullName.startsWith("java.util.function.")) {
                    return this.print("any");
                }
                String string = this.context.getTypeMappingTarget(typeFullName);
                if (string != null) {
                    if (string.endsWith("<>")) {
                        this.print(string.substring(0, string.length() - 2));
                    } else {
                        this.print(string);
                        if (completeRawTypes && !typeTree.type.tsym.getTypeParameters().isEmpty() && !this.context.getTypeMappingTarget(typeFullName).equals("any")) {
                            this.printAnyTypeArguments(typeTree.type.tsym.getTypeParameters().size());
                        }
                    }
                    return this;
                }
            }
            for (BiFunction<ExtendedElement, String, Object> mapping : this.context.getFunctionalTypeMappings()) {
                Object mapped = mapping.apply(new ExtendedElementSupport<JCTree>(typeTree), typeFullName);
                if (mapped instanceof String) {
                    this.print((String)mapped);
                    return this;
                }
                if (mapped instanceof JCTree) {
                    this.substituteAndPrintType((JCTree)mapped);
                    return this;
                }
                if (!(mapped instanceof TypeMirror)) continue;
                this.print(this.getAdapter().getMappedType((TypeMirror)mapped));
                return this;
            }
        }
        if (typeTree instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply typeApply = (JCTree.JCTypeApply)typeTree;
            this.substituteAndPrintType(typeApply.clazz, arrayComponent, inTypeParameters, false, disableSubstitution);
            if (!(typeApply.arguments.isEmpty() || "any".equals(this.getLastPrintedString(3)) || "Object".equals(this.getLastPrintedString(6)))) {
                this.print("<");
                for (JCTree.JCExpression argument : typeApply.arguments) {
                    this.substituteAndPrintType(argument, arrayComponent, false, completeRawTypes, false).print(", ");
                }
                if (typeApply.arguments.length() > 0) {
                    this.removeLastChars(2);
                }
                this.print(">");
            }
            return this;
        }
        if (typeTree instanceof JCTree.JCWildcard) {
            JCTree.JCWildcard wildcard = (JCTree.JCWildcard)typeTree;
            String string = this.context.getWildcardName(wildcard);
            if (string == null) {
                return this.print("any");
            }
            this.print(string);
            if (inTypeParameters) {
                this.print(" extends ");
                return this.substituteAndPrintType(wildcard.getBound(), arrayComponent, false, completeRawTypes, disableSubstitution);
            }
            return this;
        }
        if (typeTree instanceof JCTree.JCArrayTypeTree) {
            return this.substituteAndPrintType(((JCTree.JCArrayTypeTree)typeTree).elemtype, true, inTypeParameters, completeRawTypes, disableSubstitution).print("[]");
        }
        if (completeRawTypes && typeTree.type.tsym.getTypeParameters() != null && !typeTree.type.tsym.getTypeParameters().isEmpty()) {
            this.print(typeTree);
            this.print("<");
            for (int i = 0; i < typeTree.type.tsym.getTypeParameters().length(); ++i) {
                this.print("any, ");
            }
            this.removeLastChars(2);
            this.print(">");
            return this;
        }
        return this.print(typeTree);
    }

    private String getClassName(Symbol clazz) {
        String name = this.context.hasClassNameMapping(clazz) ? this.context.getClassNameMapping(clazz) : clazz.getSimpleName().toString();
        if (clazz.isEnum()) {
            name = name + ENUM_WRAPPER_CLASS_SUFFIX;
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClassDef(JCTree.JCClassDecl classdecl) {
        boolean bl;
        Symbol s;
        JCTree testParent;
        if (this.getAdapter().substituteType(classdecl.sym)) {
            this.getAdapter().afterType(classdecl.sym);
            return;
        }
        if (this.context.isIgnored(classdecl)) {
            this.getAdapter().afterType(classdecl.sym);
            return;
        }
        String name = classdecl.getSimpleName().toString();
        if (this.context.hasClassNameMapping(classdecl.sym)) {
            name = this.context.getClassNameMapping(classdecl.sym);
        }
        if (!this.scope.isEmpty() && this.getScope().anonymousClasses.contains(classdecl)) {
            name = this.getScope().name + ANONYMOUS_PREFIX + this.getScope().anonymousClasses.indexOf(classdecl);
        }
        if ((testParent = this.getFirstParent(JCTree.JCClassDecl.class, JCTree.JCMethodDecl.class)) != null && testParent instanceof JCTree.JCMethodDecl && !this.isLocalClass()) {
            this.getScope().localClasses.add(classdecl);
            return;
        }
        this.enterScope();
        this.getScope().name = name;
        JCTree.JCClassDecl parent = this.getParent(JCTree.JCClassDecl.class);
        ArrayList parentTypeVars = new ArrayList();
        if (parent != null) {
            this.getScope().innerClass = true;
            if (!classdecl.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                this.getScope().innerClassNotStatic = true;
                if (parent.getTypeParameters() != null) {
                    parentTypeVars.addAll(parent.getTypeParameters().stream().map(t -> (Symbol.TypeVariableSymbol)t.type.tsym).collect(Collectors.toList()));
                    this.getAdapter().typeVariablesToErase.addAll(parentTypeVars);
                }
            }
        }
        this.getScope().declareClassScope = this.context.hasAnnotationType(classdecl.sym, "jsweet.lang.Ambient") || this.isDefinitionScope;
        this.getScope().interfaceScope = false;
        this.getScope().removedSuperclass = false;
        this.getScope().enumScope = false;
        this.getScope().enumWrapperClassScope = false;
        if (this.getScope().declareClassScope) {
            if (this.context.hasAnnotationType(classdecl.sym, "jsweet.lang.Decorator")) {
                this.print("declare function ").print(name).print("(...args: any[]);").println();
                this.exitScope();
                return;
            }
        } else if (this.context.lookupDecoratorAnnotation(classdecl.sym.getQualifiedName().toString()) != null) {
            JCTree[] globalDecoratorFunction = this.context.lookupGlobalMethod(classdecl.sym.getQualifiedName().toString());
            if (globalDecoratorFunction == null) {
                this.report((JCTree)classdecl, JSweetProblem.CANNOT_FIND_GLOBAL_DECORATOR_FUNCTION, classdecl.sym.getQualifiedName());
            } else {
                this.getScope().decoratorScope = true;
                this.enter(globalDecoratorFunction[0]);
                this.print(globalDecoratorFunction[1]);
                this.exit();
                this.getScope().decoratorScope = false;
            }
            this.exitScope();
            return;
        }
        HashSet<Map.Entry<JCTree.JCClassDecl, JCTree.JCMethodDecl>> defaultMethods = null;
        boolean globals = "Globals".equals(classdecl.name.toString());
        if (globals && classdecl.extending != null) {
            this.report((JCTree)classdecl, JSweetProblem.GLOBALS_CLASS_CANNOT_HAVE_SUPERCLASS, new Object[0]);
        }
        ArrayList<Type> implementedInterfaces = new ArrayList<Type>();
        if (!globals) {
            boolean bl2;
            if (classdecl.extending != null && "Globals".equals(((Name)classdecl.extending.type.tsym.getSimpleName()).toString())) {
                this.report((JCTree)classdecl, JSweetProblem.GLOBALS_CLASS_CANNOT_BE_SUBCLASSED, new Object[0]);
                return;
            }
            if (classdecl.getKind() != Tree.Kind.ENUM || this.scope.size() <= 1 || !this.getScope(1).isComplexEnum) {
                this.printDocComment(classdecl);
            } else {
                this.print("/** @ignore */").println().printIndent();
            }
            this.print(classdecl.mods);
            if (!this.isTopLevelScope() || this.context.useModules || this.context.moduleBundleMode || this.isAnonymousClass() || this.isInnerClass() || this.isLocalClass()) {
                this.print("export ");
            }
            if (this.context.isInterface(classdecl.sym)) {
                this.print("interface ");
                this.getScope().interfaceScope = true;
            } else if (classdecl.getKind() == Tree.Kind.ENUM) {
                if (this.getScope().declareClassScope && (this.getIndent() == 0 || !this.isDefinitionScope)) {
                    this.print("declare ");
                }
                if (this.scope.size() > 1 && this.getScope(1).isComplexEnum) {
                    if (Util.hasAbstractMethod(classdecl.sym)) {
                        this.print("abstract ");
                    }
                    this.print("class ");
                    this.getScope().enumWrapperClassScope = true;
                } else {
                    this.print("enum ");
                    this.getScope().enumScope = true;
                }
            } else {
                if (this.getScope().declareClassScope && (this.getIndent() == 0 || !this.isDefinitionScope)) {
                    this.print("declare ");
                }
                defaultMethods = new HashSet<Map.Entry<JCTree.JCClassDecl, JCTree.JCMethodDecl>>();
                Util.findDefaultMethodsInType(defaultMethods, this.context, classdecl.sym);
                if (classdecl.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) {
                    this.print("abstract ");
                }
                this.print("class ");
            }
            this.print(name + (this.getScope().enumWrapperClassScope ? ENUM_WRAPPER_CLASS_SUFFIX : ""));
            if (classdecl.typarams != null && classdecl.typarams.size() > 0) {
                this.print("<").printArgList(null, classdecl.typarams).print(">");
            } else if (this.isAnonymousClass() && classdecl.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                JCTree.JCNewClass newClass = (JCTree.JCNewClass)this.getScope(1).anonymousClassesConstructors.get(this.getScope(1).anonymousClasses.indexOf(classdecl));
                this.printAnonymousClassTypeArgs(newClass);
            }
            Object mixin = null;
            if (this.context.hasAnnotationType(classdecl.sym, "jsweet.lang.Mixin")) {
                mixin = this.context.getAnnotationValue(classdecl.sym, "jsweet.lang.Mixin", Type.class, null);
                for (Attribute.Compound c : classdecl.sym.getAnnotationMirrors()) {
                    if (!"jsweet.lang.Mixin".equals(c.type.toString())) continue;
                    String string = this.getRootRelativeName(((Attribute.Class)((Pair)c.values.head).snd).classType.tsym);
                    String mixinName = this.getRootRelativeName(classdecl.sym);
                    if (!mixinName.equals(string)) {
                        this.report((JCTree)classdecl, JSweetProblem.WRONG_MIXIN_NAME, mixinName, string);
                        continue;
                    }
                    if (!((Attribute.Class)((Pair)c.values.head).snd).classType.tsym.equals(classdecl.sym)) continue;
                    this.report((JCTree)classdecl, JSweetProblem.SELF_MIXIN_TARGET, mixinName);
                }
            }
            boolean bl3 = false;
            if (classdecl.extending != null) {
                boolean removeIterable = false;
                if (this.context.hasAnnotationType(classdecl.sym, "jsweet.lang.SyntacticIterable") && classdecl.extending.type.tsym.getQualifiedName().toString().equals(Iterable.class.getName())) {
                    removeIterable = true;
                }
                if (!this.getAdapter().substituteExtends(classdecl.sym)) {
                    if (!(removeIterable || JSweetConfig.isJDKReplacementMode() || "def.js.Object".equals(classdecl.extending.type.toString()) || Object.class.getName().equals(classdecl.extending.type.toString()) || mixin != null && this.context.types.isSameType((Type)mixin, classdecl.extending.type) || this.getAdapter().eraseSuperClass(classdecl.sym, (Symbol.ClassSymbol)classdecl.extending.type.tsym))) {
                        if (!this.getScope().interfaceScope && this.context.isInterface(classdecl.extending.type.tsym)) {
                            bl2 = true;
                            this.print(" implements ");
                            implementedInterfaces.add(classdecl.extending.type);
                        } else {
                            this.print(" extends ");
                        }
                        if (this.getScope().enumWrapperClassScope && this.getScope(1).anonymousClasses.contains(classdecl)) {
                            this.print(classdecl.extending.toString() + ENUM_WRAPPER_CLASS_SUFFIX);
                        } else {
                            this.disableTypeSubstitution = !this.getAdapter().isSubstituteSuperTypes();
                            this.substituteAndPrintType(classdecl.extending);
                            this.disableTypeSubstitution = false;
                        }
                        if (this.context.classesWithWrongConstructorOverload.contains(classdecl.sym)) {
                            this.getScope().hasConstructorOverloadWithSuperClass = true;
                        }
                    } else {
                        this.getScope().removedSuperclass = true;
                    }
                }
            }
            if (!(this.getAdapter().substituteImplements(classdecl.sym) || classdecl.implementing == null || classdecl.implementing.isEmpty() || this.getScope().enumScope)) {
                ArrayList<JCTree.JCExpression> implementing = new ArrayList<JCTree.JCExpression>(classdecl.implementing);
                if (this.context.hasAnnotationType(classdecl.sym, "jsweet.lang.SyntacticIterable")) {
                    for (JCTree.JCExpression itf : classdecl.implementing) {
                        if (!itf.type.tsym.getQualifiedName().toString().equals(Iterable.class.getName())) continue;
                        implementing.remove(itf);
                    }
                }
                for (JCTree.JCExpression itf : classdecl.implementing) {
                    if (!this.context.isFunctionalType(itf.type.tsym) && !this.getAdapter().eraseSuperInterface(classdecl.sym, (Symbol.ClassSymbol)itf.type.tsym)) continue;
                    implementing.remove(itf);
                }
                if (!implementing.isEmpty()) {
                    if (!bl2) {
                        if (this.getScope().interfaceScope) {
                            this.print(" extends ");
                        } else {
                            this.print(" implements ");
                        }
                    } else {
                        this.print(", ");
                    }
                    for (JCTree.JCExpression itf : implementing) {
                        this.disableTypeSubstitution = !this.getAdapter().isSubstituteSuperTypes();
                        this.substituteAndPrintType(itf);
                        this.disableTypeSubstitution = false;
                        implementedInterfaces.add(itf.type);
                        this.print(", ");
                    }
                    this.removeLastChars(2);
                }
            }
            this.print(" {").println().startIndent();
        }
        this.getAdapter().beforeTypeBody(classdecl.sym);
        if (this.getScope().innerClassNotStatic && !this.getScope().interfaceScope && !this.getScope().enumScope && !this.getScope().enumWrapperClassScope) {
            this.printIndent().print("public __parent: any;").println();
        }
        if (defaultMethods != null && !defaultMethods.isEmpty()) {
            this.getScope().defaultMethodScope = true;
            for (Map.Entry entry : defaultMethods) {
                Symbol.MethodSymbol s2;
                if (!(((JCTree.JCMethodDecl)entry.getValue()).type instanceof Type.MethodType) || (s2 = Util.findMethodDeclarationInType2(this.context.types, classdecl.sym, ((JCTree.JCMethodDecl)entry.getValue()).getName().toString(), (Type.MethodType)((JCTree.JCMethodDecl)entry.getValue()).type)) != null && s2 != ((JCTree.JCMethodDecl)entry.getValue()).sym) continue;
                this.getAdapter().typeVariablesToErase.addAll(((Symbol.ClassSymbol)s2.getEnclosingElement()).getTypeParameters());
                if (this.context.useModules) {
                    UsedTypesScanner usedTypesScanner = new UsedTypesScanner();
                    JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)entry.getValue();
                    if (!this.context.hasAnnotationType(method.sym, "jsweet.lang.Erased")) {
                        if (this.context.hasAnnotationType(method.sym, "jsweet.lang.Replace")) {
                            usedTypesScanner.scan(method.params);
                            usedTypesScanner.scan(method.restype);
                            usedTypesScanner.scan(method.thrown);
                            usedTypesScanner.scan(method.typarams);
                            usedTypesScanner.scan(method.recvparam);
                        } else {
                            usedTypesScanner.scan(method);
                        }
                    }
                }
                if (!this.context.hasAnnotationType(((JCTree.JCMethodDecl)entry.getValue()).sym, "jsweet.lang.Erased")) {
                    this.printIndent().print("/* Default method injected from " + ((JCTree.JCClassDecl)entry.getKey()).sym.getQualifiedName() + " */").println();
                }
                this.printIndent().print((JCTree)entry.getValue()).println();
                this.getAdapter().typeVariablesToErase.removeAll(((Symbol.ClassSymbol)s2.getEnclosingElement()).getTypeParameters());
            }
            this.getScope().defaultMethodScope = false;
        }
        if (this.getScope().enumScope) {
            this.printIndent();
        }
        if (globals) {
            this.removeLastIndent();
        }
        for (JCTree jCTree : classdecl.defs) {
            if (jCTree instanceof JCTree.JCClassDecl) {
                this.getScope().hasInnerClass = true;
            }
            if (!(jCTree instanceof JCTree.JCVariableDecl)) continue;
            JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)jCTree;
            if (var.sym.isStatic() || var.init == null) continue;
            this.getScope().fieldsWithInitializers.add((JCTree.JCVariableDecl)jCTree);
        }
        if (!(globals || this.getScope().enumScope || this.context.isInterface(classdecl.sym) || this.context.getStaticInitializerCount(classdecl.sym) <= 0)) {
            this.printIndent().print("static __static_initialized : boolean = false;").println();
            int liCount = this.context.getStaticInitializerCount(classdecl.sym);
            String string = this.getClassName(classdecl.sym) + ".";
            this.printIndent().print("static __static_initialize() { ");
            this.print("if(!" + string + "__static_initialized) { ");
            this.print(string + "__static_initialized = true; ");
            for (int i = 0; i < liCount; ++i) {
                this.print(string + "__static_initializer_" + i + "(); ");
            }
            this.print("} }").println().println();
            String qualifiedClassName = this.getQualifiedTypeName(classdecl.sym, globals, true);
            this.context.addTopFooterStatement(StringUtils.isBlank((CharSequence)qualifiedClassName) ? "" : qualifiedClassName + ".__static_initialize();");
        }
        boolean hasUninitializedFields = false;
        for (JCTree def : classdecl.defs) {
            if (this.getScope().interfaceScope && (def instanceof JCTree.JCMethodDecl && ((JCTree.JCMethodDecl)def).sym.isStatic() || def instanceof JCTree.JCVariableDecl && ((JCTree.JCVariableDecl)def).sym.isStatic()) || this.getScope().interfaceScope && def instanceof JCTree.JCMethodDecl && Util.isOverridingBuiltInJavaObjectMethod(((JCTree.JCMethodDecl)def).sym) || def instanceof JCTree.JCClassDecl) continue;
            if (def instanceof JCTree.JCVariableDecl) {
                if (this.getScope().enumScope && ((JCTree.JCVariableDecl)def).sym.getKind() != ElementKind.ENUM_CONSTANT) {
                    this.getScope().isComplexEnum = true;
                    continue;
                }
                if (this.shouldPrintFieldInitializationInConstructor((JCTree.JCVariableDecl)def)) {
                    hasUninitializedFields = true;
                }
            }
            if (def instanceof JCTree.JCBlock && !((JCTree.JCBlock)def).isStatic()) {
                hasUninitializedFields = true;
            }
            if (!this.getScope().enumScope) {
                this.printIndent();
            }
            int n = this.getCurrentPosition();
            this.print(def);
            if (this.getCurrentPosition() == n) {
                if (this.getScope().enumScope) continue;
                this.removeLastIndent();
                continue;
            }
            if (def instanceof JCTree.JCVariableDecl) {
                if (this.getScope().enumScope) {
                    this.print(", ");
                    continue;
                }
                this.print(";").println().println();
                continue;
            }
            this.println().println();
        }
        if (!this.getScope().interfaceScope && classdecl.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) {
            ArrayList<Symbol.MethodSymbol> arrayList = new ArrayList<Symbol.MethodSymbol>();
            for (Type type : implementedInterfaces) {
                this.context.grabMethodsToBeImplemented(arrayList, type.tsym);
            }
            arrayList.sort((m1, m2) -> ((Name)m1.getSimpleName()).compareTo((Name)m2.getSimpleName()));
            HashMap<Name, String> signatures = new HashMap<Name, String>();
            for (Symbol.MethodSymbol meth : arrayList) {
                OverloadScanner.Overload o;
                if (!(meth.type instanceof Type.MethodType) || this.context.hasAnnotationType(meth, "jsweet.lang.Erased") || this.isMappedOrErasedType(meth.owner) || this.getScope().generatedMethodNames.contains(meth.name.toString())) continue;
                s = Util.findMethodDeclarationInType(this.getContext().types, classdecl.sym, ((Name)meth.getSimpleName()).toString(), (Type.MethodType)meth.type, true);
                if (Object.class.getName().equals(((Symbol)((Symbol.MethodSymbol)s).getEnclosingElement()).toString())) {
                    s = null;
                }
                boolean printAbstractDeclaration = false;
                if (s != null && !((Object)((Symbol.MethodSymbol)s).getEnclosingElement()).equals(classdecl.sym) && !((Symbol.MethodSymbol)s).isDefault() && (this.context.isInterface((Symbol.TypeSymbol)((Symbol.MethodSymbol)s).getEnclosingElement()) || ((Symbol.MethodSymbol)s).getModifiers().contains((Object)Modifier.ABSTRACT))) {
                    printAbstractDeclaration = true;
                }
                if (printAbstractDeclaration && (o = this.context.getOverload(classdecl.sym, meth)) != null && o.methods.size() > 1 && !o.isValid && !meth.type.equals(o.coreMethod.type)) {
                    printAbstractDeclaration = false;
                }
                if (s != null && !printAbstractDeclaration) continue;
                String signature = this.getContext().types.erasure(meth.type).toString();
                if (signatures.containsKey(meth.name) && ((String)signatures.get(meth.name)).equals(signature)) continue;
                this.printAbstractMethodDeclaration(meth);
                signatures.put(meth.name, signature);
            }
        }
        if (!(this.getScope().hasDeclaredConstructor || this.getScope().interfaceScope || this.getScope().enumScope || this.getScope().declareClassScope)) {
            HashSet<String> hashSet = new HashSet<String>();
            this.context.grabSupportedInterfaceNames(hashSet, classdecl.sym);
            if (!hashSet.isEmpty() || this.getScope().innerClass || this.getScope().innerClassNotStatic || hasUninitializedFields) {
                int n;
                this.printIndent().print("constructor(");
                boolean hasArgs = false;
                if (this.getScope().innerClassNotStatic) {
                    this.print("__parent: any");
                    hasArgs = true;
                }
                int n2 = n = this.scope.size() > 1 ? this.getScope(1).anonymousClasses.indexOf(classdecl) : -1;
                if (n != -1) {
                    for (int i = 0; i < ((JCTree.JCNewClass)((ClassScope)this.getScope((int)1)).anonymousClassesConstructors.get((int)n)).args.length(); ++i) {
                        if (!hasArgs) {
                            hasArgs = true;
                        } else {
                            this.print(", ");
                        }
                        this.print("__arg" + i + ": any");
                    }
                    for (Symbol.VarSymbol v : (LinkedHashSet)this.getScope(1).finalVariables.get(n)) {
                        if (!hasArgs) {
                            hasArgs = true;
                        } else {
                            this.print(", ");
                        }
                        this.print("private " + v.getSimpleName() + ": any");
                    }
                }
                this.print(") {").startIndent().println();
                if (classdecl.extending != null && !this.getScope().removedSuperclass && !this.context.isInterface(classdecl.extending.type.tsym)) {
                    this.printIndent().print("super(");
                    boolean hasArg = false;
                    if (this.getScope().innerClassNotStatic && ((Symbol.TypeSymbol)(s = classdecl.extending.type.tsym)).getEnclosingElement() instanceof Symbol.ClassSymbol && !s.isStatic()) {
                        this.print(PARENT_CLASS_FIELD_NAME);
                        hasArg = true;
                    }
                    if (n != -1) {
                        for (int i = 0; i < ((JCTree.JCNewClass)((ClassScope)this.getScope((int)1)).anonymousClassesConstructors.get((int)n)).args.length(); ++i) {
                            if (hasArg) {
                                this.print(", ");
                            } else {
                                hasArg = true;
                            }
                            this.print("__arg" + i);
                        }
                    }
                    this.print(");").println();
                }
                this.printInstanceInitialization(classdecl, null);
                this.endIndent().printIndent().print("}").println().println();
            }
        }
        this.removeLastChar();
        if (this.getScope().enumWrapperClassScope && !this.getScope(1).anonymousClasses.contains(classdecl)) {
            this.printIndent().print("public name() : string { return this._$name; }").println();
            this.printIndent().print("public ordinal() : number { return this._$ordinal; }").println();
            this.printIndent().print("public compareTo(other : any) : number { return this._$ordinal - (isNaN(other)?other._$ordinal:other); }").println();
        }
        if (this.getScope().enumScope) {
            this.removeLastChar().println();
        }
        if (!globals) {
            this.endIndent().printIndent().print("}");
            if (!(this.getScope().interfaceScope || this.getScope().declareClassScope || this.getScope().enumScope || this.getScope().enumWrapperClassScope && classdecl.sym.isAnonymous())) {
                if (!classdecl.sym.isAnonymous()) {
                    this.println().printIndent().print(this.getScope().enumWrapperClassScope ? classdecl.sym.getSimpleName().toString() : name).print("[\"__class\"] = ").print("\"" + classdecl.sym.getQualifiedName().toString() + "\";");
                }
                HashSet<String> hashSet = new HashSet<String>();
                this.context.grabSupportedInterfaceNames(hashSet, classdecl.sym);
                if (!hashSet.isEmpty()) {
                    this.println().printIndent().print(this.getScope().enumWrapperClassScope ? classdecl.sym.getSimpleName().toString() : name).print("[\"__interfaces\"] = ");
                    this.print("[");
                    for (String string : hashSet) {
                        this.print("\"").print(string).print("\",");
                    }
                    this.removeLastChar();
                    this.print("];").println();
                }
                if (!this.getScope().enumWrapperClassScope) {
                    this.println();
                }
            }
        }
        if (this.getScope().isComplexEnum) {
            this.println().println().printIndent();
            this.visitClassDef(classdecl);
        }
        boolean bl4 = false;
        if (this.getScope().interfaceScope) {
            boolean bl5;
            for (JCTree jCTree : classdecl.defs) {
                if ((!(jCTree instanceof JCTree.JCMethodDecl) || !((JCTree.JCMethodDecl)jCTree).sym.isStatic()) && (!(jCTree instanceof JCTree.JCVariableDecl) || !((JCTree.JCVariableDecl)jCTree).sym.isStatic()) || jCTree instanceof JCTree.JCVariableDecl && this.context.hasAnnotationType(((JCTree.JCVariableDecl)jCTree).sym, "jsweet.lang.StringType", "jsweet.lang.Erased")) continue;
                if (!bl5) {
                    bl5 = true;
                    this.println().println().printIndent();
                    if (this.getIndent() != 0 || this.context.useModules || this.context.moduleBundleMode) {
                        this.print("export ");
                    } else if (this.isDefinitionScope) {
                        this.print("declare ");
                    }
                    this.print("namespace ").print(classdecl.getSimpleName().toString()).print(" {").startIndent();
                }
                this.println().println().printIndent().print(jCTree);
                if (!(jCTree instanceof JCTree.JCVariableDecl)) continue;
                this.print(";");
            }
            if (bl5) {
                this.println().endIndent().printIndent().print("}").println();
            }
        }
        boolean bl6 = false;
        for (JCTree jCTree : Util.getSortedClassDeclarations(classdecl.defs)) {
            boolean bl7;
            JCTree.JCClassDecl cdef;
            if (!(jCTree instanceof JCTree.JCClassDecl) || this.context.isIgnored(cdef = (JCTree.JCClassDecl)jCTree)) continue;
            if (!bl7) {
                bl7 = true;
                this.println().println().printIndent();
                if (!this.isTopLevelScope() || this.context.useModules || this.context.moduleBundleMode) {
                    this.print("export ");
                } else if (this.isDefinitionScope) {
                    this.print("declare ");
                }
                this.print("namespace ").print(name).print(" {").startIndent();
            }
            this.getScope().isInnerClass = true;
            this.println().println().printIndent().print(cdef);
            this.getScope().isInnerClass = false;
        }
        for (JCTree.JCClassDecl jCClassDecl : this.getScope().anonymousClasses) {
            boolean bl8;
            if (!bl8) {
                bl8 = true;
                this.println().println().printIndent();
                if (!this.isTopLevelScope() || this.context.useModules || this.context.moduleBundleMode) {
                    this.print("export ");
                }
                this.print("namespace ").print(name).print(" {").startIndent();
            }
            this.getScope().isAnonymousClass = true;
            this.println().println().printIndent().print(jCClassDecl);
            this.getScope().isAnonymousClass = false;
        }
        for (JCTree.JCClassDecl jCClassDecl : this.getScope().localClasses) {
            if (!bl) {
                bl = true;
                this.println().println().printIndent();
                if (!this.isTopLevelScope() || this.context.useModules || this.context.moduleBundleMode) {
                    this.print("export ");
                }
                this.print("namespace ").print(name).print(" {").startIndent();
            }
            this.getScope().isLocalClass = true;
            this.println().println().printIndent().print(jCClassDecl);
            this.getScope().isLocalClass = false;
        }
        if (bl) {
            this.println().endIndent().printIndent().print("}").println();
        }
        if (this.getScope().enumScope && this.getScope().isComplexEnum && !this.getScope().anonymousClasses.contains(classdecl)) {
            this.println().printIndent().print(classdecl.sym.getSimpleName().toString()).print("[\"_$wrappers\"] = [");
            int index = 0;
            for (JCTree tree : classdecl.defs) {
                if (!(tree instanceof JCTree.JCVariableDecl) || ((JCTree.JCVariableDecl)tree).sym.getKind() != ElementKind.ENUM_CONSTANT) continue;
                JCTree.JCVariableDecl varDecl = (JCTree.JCVariableDecl)tree;
                JCTree.JCNewClass newClass = (JCTree.JCNewClass)varDecl.init;
                JCTree.JCClassDecl clazz = classdecl;
                try {
                    int anonymousClassIndex = this.getScope().anonymousClasses.indexOf(newClass.def);
                    if (anonymousClassIndex >= 0) {
                        this.print("new ").print(clazz.getSimpleName().toString() + "." + clazz.getSimpleName().toString() + ANONYMOUS_PREFIX + anonymousClassIndex + ENUM_WRAPPER_CLASS_SUFFIX).print("(");
                    } else {
                        this.print("new ").print(clazz.getSimpleName().toString() + ENUM_WRAPPER_CLASS_SUFFIX).print("(");
                    }
                    this.print("" + index++ + ", ");
                    this.print("\"" + varDecl.sym.name.toString() + "\"");
                    if (!newClass.args.isEmpty()) {
                        this.print(", ");
                    }
                    this.printArgList(null, newClass.args).print(")");
                    this.print(", ");
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.removeLastChars(2);
            this.print("];").println();
        }
        if (this.getScope().mainMethod != null && ((List)this.getScope().mainMethod.getParameters()).size() < 2 && ((Object)((ClassScope)this.getScope()).mainMethod.sym.getEnclosingElement()).equals(classdecl.sym)) {
            void var12_67;
            String mainClassName;
            String string = mainClassName = this.getQualifiedTypeName(classdecl.sym, globals, true);
            if (!StringUtils.isBlank((CharSequence)mainClassName)) {
                String string2 = mainClassName + ".";
            }
            this.context.entryFiles.add(new File(this.compilationUnit.sourcefile.getName()));
            this.context.addFooterStatement((String)var12_67 + "main" + "(" + (((List)this.getScope().mainMethod.getParameters()).isEmpty() ? "" : "null") + ");");
        }
        this.getAdapter().typeVariablesToErase.removeAll(parentTypeVars);
        this.exitScope();
        this.getAdapter().afterType(classdecl.sym);
    }

    private void printAbstractMethodDeclaration(Symbol.MethodSymbol method) {
        this.printIndent().print("public abstract ").print(((Name)method.getSimpleName()).toString());
        this.print("(");
        if (method.getParameters() != null && !((List)method.getParameters()).isEmpty()) {
            for (Symbol.VarSymbol var : method.getParameters()) {
                this.print(var.name.toString()).print("?: any");
                this.print(", ");
            }
            this.removeLastChars(2);
        }
        this.print(")");
        this.print(": any;").println();
    }

    private String getTSMethodName(JCTree.JCMethodDecl methodDecl) {
        String name;
        switch (name = this.context.getActualName(methodDecl.sym)) {
            case "<init>": {
                return "constructor";
            }
            case "$apply": 
            case "$applyStatic": {
                return "";
            }
            case "apply": 
            case "applyStatic": {
                if (this.context.deprecatedApply) {
                    return "";
                }
                return name;
            }
            case "$new": {
                return "new";
            }
        }
        return name;
    }

    protected boolean isDebugMode(JCTree.JCMethodDecl methodDecl) {
        return methodDecl != null && !this.getScope().constructor && this.context.options.isDebugMode() && !this.context.hasAnnotationType(methodDecl.sym, "jsweet.lang.NoDebug") && !this.context.hasAnnotationType((Symbol)methodDecl.sym.getEnclosingElement(), "jsweet.lang.NoDebug");
    }

    private boolean isInterfaceMethod(JCTree.JCClassDecl parent, JCTree.JCMethodDecl method) {
        return this.context.isInterface(parent.sym) && !method.sym.isStatic();
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl methodDecl) {
        Symbol.VarSymbol v;
        if (this.getAdapter().substituteExecutable(methodDecl.sym)) {
            return;
        }
        if (this.context.hasAnnotationType(methodDecl.sym, "jsweet.lang.Erased")) {
            return;
        }
        JCTree.JCClassDecl parent = (JCTree.JCClassDecl)this.getParent();
        if (parent != null && methodDecl.pos == parent.pos && !this.getScope().enumWrapperClassScope) {
            return;
        }
        if ("$get".equals(methodDecl.getName().toString()) && ((List)methodDecl.getParameters()).size() == 1) {
            this.print("[").print((JCTree)((List)methodDecl.getParameters()).head).print("]: ");
            this.substituteAndPrintType(methodDecl.restype).print(";");
            return;
        }
        this.getScope().constructor = methodDecl.sym.isConstructor();
        if (this.getScope().enumScope) {
            if (this.getScope().constructor) {
                if (parent != null && parent.pos != methodDecl.pos) {
                    this.getScope().isComplexEnum = true;
                }
            } else {
                this.getScope().isComplexEnum = true;
            }
            return;
        }
        if (this.getScope().isDeclareClassScope() && parent.getExtendsClause() != null && parent.getExtendsClause().type instanceof Type.ClassType) {
            Type.ClassType superClassType = (Type.ClassType)parent.getExtendsClause().type;
            Symbol.MethodSymbol superMethod = Util.findMethodDeclarationInType(this.context.types, superClassType.tsym, methodDecl.getName().toString(), (Type.MethodType)methodDecl.type);
            if (superMethod != null && Util.isSourceElement(superMethod)) {
                return;
            }
        }
        OverloadScanner.Overload overload = null;
        boolean inOverload = false;
        boolean inCoreWrongOverload = false;
        if (parent != null) {
            overload = this.context.getOverload(parent.sym, methodDecl.sym);
            boolean bl = inOverload = overload != null && overload.methods.size() > 1;
            if (inOverload) {
                if (!overload.isValid) {
                    if (!this.printCoreMethodDelegate) {
                        if (overload.coreMethod.equals(methodDecl)) {
                            inCoreWrongOverload = true;
                            if (!this.isInterfaceMethod(parent, methodDecl) && !methodDecl.sym.isConstructor() && parent.sym.equals(overload.coreMethod.sym.getEnclosingElement())) {
                                this.printCoreMethodDelegate = true;
                                this.visitMethodDef(overload.coreMethod);
                                this.println().println().printIndent();
                                this.printCoreMethodDelegate = false;
                            }
                        } else {
                            if (methodDecl.sym.isConstructor()) {
                                return;
                            }
                            boolean addCoreMethod = false;
                            boolean bl2 = addCoreMethod = !overload.printed && overload.coreMethod.sym.getEnclosingElement() != parent.sym && !overload.coreMethod.sym.getModifiers().contains((Object)Modifier.DEFAULT) && (!overload.coreMethod.sym.getModifiers().contains((Object)Modifier.ABSTRACT) || this.isInterfaceMethod(parent, methodDecl) || !this.context.types.isSubtype(parent.sym.type, ((Symbol)overload.coreMethod.sym.getEnclosingElement()).type));
                            if (!overload.printed && !addCoreMethod && overload.coreMethod.type instanceof Type.MethodType) {
                                boolean bl3 = addCoreMethod = Util.findMethodDeclarationInType(this.context.types, parent.sym, methodDecl.getName().toString(), (Type.MethodType)overload.coreMethod.type) == null;
                            }
                            if (addCoreMethod) {
                                this.visitMethodDef(overload.coreMethod);
                                overload.printed = true;
                                if (!this.isInterfaceMethod(parent, methodDecl)) {
                                    this.println().println().printIndent();
                                }
                            }
                            if (this.isInterfaceMethod(parent, methodDecl)) {
                                return;
                            }
                        }
                    }
                } else if (!overload.coreMethod.equals(methodDecl)) {
                    return;
                }
            }
        }
        boolean ambient = this.context.hasAnnotationType(methodDecl.sym, "jsweet.lang.Ambient");
        if (inOverload && !inCoreWrongOverload && (ambient || this.isDefinitionScope)) {
            return;
        }
        if (this.isDebugMode(methodDecl)) {
            this.printMethodModifiers(methodDecl, parent, this.getScope().constructor, inOverload, overload);
            this.print(this.getTSMethodName(methodDecl)).print("(");
            this.printArgList(null, methodDecl.params);
            this.print(") : ");
            this.substituteAndPrintType(methodDecl.getReturnType());
            this.print(" {").println();
            this.startIndent().printIndent();
            if (!this.context.types.isSameType(this.context.symtab.voidType, methodDecl.sym.getReturnType())) {
                this.print("return ");
            }
            this.print("__debug_exec('" + parent.sym.getQualifiedName() + "', '" + methodDecl.getName() + "', ");
            if (!methodDecl.params.isEmpty()) {
                this.print("[");
                for (JCTree.JCVariableDecl param : methodDecl.params) {
                    this.print("'" + param.getName() + "', ");
                }
                this.removeLastChars(2);
                this.print("]");
            } else {
                this.print("undefined");
            }
            this.print(", this, arguments, ");
            if (methodDecl.sym.isStatic()) {
                this.print(((Symbol)methodDecl.sym.getEnclosingElement()).getSimpleName().toString());
            } else {
                this.print("this");
            }
            this.print(".__generator_" + this.getTSMethodName(methodDecl) + "(");
            for (JCTree.JCVariableDecl param : methodDecl.params) {
                this.print(this.context.getActualName(param.sym) + ", ");
            }
            if (!methodDecl.params.isEmpty()) {
                this.removeLastChars(2);
            }
            this.print("));");
            this.println().endIndent().printIndent();
            this.print("}").println().println().printIndent();
        }
        if (inOverload && !overload.isValid) {
            for (JCTree.JCMethodDecl m : overload.methods) {
                if (m == methodDecl) continue;
                for (JCTree.JCAnnotation anno : m.mods.annotations) {
                    if (methodDecl.mods.annotations.stream().anyMatch(a -> a.getAnnotationType().toString().equals(anno.getAnnotationType().toString()))) continue;
                    methodDecl.mods.annotations = methodDecl.mods.annotations.append(anno);
                }
            }
        }
        this.print(methodDecl.mods);
        if (methodDecl.mods.getFlags().contains((Object)Modifier.NATIVE)) {
            if (!(this.getScope().declareClassScope || ambient || this.getScope().interfaceScope)) {
                this.report((JCTree)methodDecl, methodDecl.name, JSweetProblem.NATIVE_MODIFIER_IS_NOT_ALLOWED, methodDecl.name);
            }
        } else if (this.getScope().declareClassScope && !this.getScope().constructor && !this.getScope().interfaceScope && !methodDecl.mods.getFlags().contains((Object)Modifier.DEFAULT)) {
            this.report((JCTree)methodDecl, methodDecl.name, JSweetProblem.INVALID_METHOD_BODY_IN_INTERFACE, methodDecl.name, parent == null ? "<no class>" : parent.name);
        }
        if (methodDecl.name.toString().equals("constructor")) {
            this.report((JCTree)methodDecl, methodDecl.name, JSweetProblem.CONSTRUCTOR_MEMBER, new Object[0]);
        }
        if (parent != null && (v = Util.findFieldDeclaration(parent.sym, methodDecl.name)) != null && this.context.getFieldNameMapping(v) == null) {
            if (this.isDefinitionScope) {
                return;
            }
            if (methodDecl.name.toString().equals(this.context.getActualName(v))) {
                this.report((JCTree)methodDecl, methodDecl.name, JSweetProblem.METHOD_CONFLICTS_FIELD, methodDecl.name, v.owner);
            }
        }
        if ("main".equals(methodDecl.name.toString()) && methodDecl.mods.getFlags().contains((Object)Modifier.STATIC) && !this.context.hasAnnotationType(methodDecl.sym, "jsweet.lang.Disabled") && (this.scope.size() == 1 || this.scope.size() == 2 && this.getScope().enumWrapperClassScope)) {
            this.getScope().mainMethod = methodDecl;
        }
        boolean globals = parent == null ? false : "Globals".equals(parent.name.toString());
        boolean bl = globals = globals || this.getScope().interfaceScope && methodDecl.mods.getFlags().contains((Object)Modifier.STATIC);
        if (!inOverload || inCoreWrongOverload) {
            this.printDocComment(methodDecl);
        }
        if (parent == null) {
            this.printAsyncKeyword(methodDecl);
            this.print("function ");
        } else if (globals) {
            if (this.getScope().constructor && methodDecl.sym.isPrivate() && ((List)methodDecl.getParameters()).isEmpty()) {
                return;
            }
            if (this.getScope().constructor) {
                this.report((JCTree)methodDecl, methodDecl.name, JSweetProblem.GLOBAL_CONSTRUCTOR_DEF, new Object[0]);
                return;
            }
            if (this.context.lookupDecoratorAnnotation((parent.sym.getQualifiedName() + "." + methodDecl.name).replace("Globals.", "")) != null && !this.getScope().decoratorScope) {
                return;
            }
            if (!methodDecl.mods.getFlags().contains((Object)Modifier.STATIC)) {
                this.report((JCTree)methodDecl, methodDecl.name, JSweetProblem.GLOBALS_CAN_ONLY_HAVE_STATIC_MEMBERS, new Object[0]);
                return;
            }
            if (this.context.hasAnnotationType(methodDecl.sym, "jsweet.lang.Module")) {
                this.getContext().addExportedElement(this.context.getAnnotationValue(methodDecl.sym, "jsweet.lang.Module", String.class, null), methodDecl.sym, this.getCompilationUnit());
            }
            if (this.context.useModules || this.context.moduleBundleMode) {
                if (!methodDecl.mods.getFlags().contains((Object)Modifier.PRIVATE)) {
                    this.print("export ");
                }
            } else if (!this.isTopLevelScope()) {
                this.print("export ");
            }
            if (ambient || this.getIndent() == 0 && this.isDefinitionScope) {
                this.print("declare ");
            }
            this.printAsyncKeyword(methodDecl);
            this.print("function ");
        } else {
            this.printMethodModifiers(methodDecl, parent, this.getScope().constructor, inOverload, overload);
            this.printAsyncKeyword(methodDecl);
            if (ambient) {
                this.report((JCTree)methodDecl, methodDecl.name, JSweetProblem.WRONG_USE_OF_AMBIENT, methodDecl.name);
            }
        }
        if (parent == null || !this.context.isFunctionalType(parent.sym)) {
            if (this.isDebugMode(methodDecl)) {
                this.print("*").print(GENERATOR_PREFIX);
            }
            if (inOverload && !overload.isValid && !inCoreWrongOverload) {
                this.print(this.getOverloadMethodName(methodDecl.sym));
            } else {
                String tsMethodName = this.getTSMethodName(methodDecl);
                this.getScope().generatedMethodNames.add(tsMethodName);
                if (this.doesMemberNameRequireQuotes(tsMethodName)) {
                    this.print("'" + tsMethodName + "'");
                } else {
                    this.print(tsMethodName);
                }
            }
        }
        if (methodDecl.typarams != null && !methodDecl.typarams.isEmpty() || this.getContext().getWildcards(methodDecl.sym) != null) {
            this.inTypeParameters = true;
            this.print("<");
            if (methodDecl.typarams != null && !methodDecl.typarams.isEmpty()) {
                this.printArgList(null, methodDecl.typarams);
                if (this.getContext().getWildcards(methodDecl.sym) != null) {
                    this.print(", ");
                }
            }
            if (this.getContext().getWildcards(methodDecl.sym) != null) {
                this.printArgList(null, this.getContext().getWildcards(methodDecl.sym), this::substituteAndPrintType);
            }
            this.print(">");
            this.inTypeParameters = false;
        }
        this.print("(");
        this.printMethodArgs(methodDecl, overload, inOverload, inCoreWrongOverload, this.getScope());
        this.print(")");
        this.printMethodReturnDeclaration(methodDecl, inCoreWrongOverload);
        if (inCoreWrongOverload && this.isInterfaceMethod(parent, methodDecl)) {
            this.print(";");
            return;
        }
        if (methodDecl.getBody() == null && (!inCoreWrongOverload || this.getScope().declareClassScope) || methodDecl.mods.getFlags().contains((Object)Modifier.DEFAULT) && !this.getScope().defaultMethodScope) {
            if (!this.getScope().interfaceScope && methodDecl.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) && inOverload && !overload.isValid) {
                this.print(" {");
                this.print(" throw new Error('cannot invoke abstract overloaded method... check your argument(s) type(s)'); ");
                this.print("}");
            } else {
                this.print(";");
            }
        } else {
            if (!this.getScope().declareClassScope && this.getScope().interfaceScope && !methodDecl.mods.getFlags().contains((Object)Modifier.STATIC)) {
                this.report((JCTree)methodDecl, methodDecl.name, JSweetProblem.INVALID_METHOD_BODY_IN_INTERFACE, methodDecl.name, parent == null ? "<no class>" : parent.name);
            }
            if (this.getScope().declareClassScope) {
                if (!this.getScope().constructor || methodDecl.getBody() != null && ((List)methodDecl.getBody().getStatements()).isEmpty()) {
                    this.report((JCTree)methodDecl, methodDecl.name, JSweetProblem.INVALID_METHOD_BODY_IN_INTERFACE, methodDecl.name, parent == null ? "<no class>" : parent.name);
                }
                this.print(";");
            } else if (inCoreWrongOverload) {
                this.print(" {").println().startIndent().printIndent();
                this.printCoreOverloadMethod(methodDecl, parent, overload);
                this.print(" else throw new Error('invalid overload');");
                this.endIndent().println().printIndent().print("}");
            } else {
                this.print(" ").print("{").println().startIndent();
                String replacedBody = null;
                if (this.context.hasAnnotationType(methodDecl.sym, "jsweet.lang.Replace")) {
                    replacedBody = this.context.getAnnotationValue(methodDecl.sym, "jsweet.lang.Replace", String.class, null);
                }
                boolean fieldsInitPrinted = false;
                int position = this.getCurrentPosition();
                if (replacedBody == null || BODY_MARKER.matcher(replacedBody).find()) {
                    this.enter(methodDecl.getBody());
                    if (!methodDecl.getBody().stats.isEmpty() && ((JCTree.JCStatement)methodDecl.getBody().stats.head).toString().startsWith("super(")) {
                        this.printBlockStatement((JCTree.JCStatement)methodDecl.getBody().stats.head);
                        if (parent != null) {
                            this.printInstanceInitialization(parent, methodDecl.sym);
                            fieldsInitPrinted = true;
                        }
                        this.printBlockStatements(methodDecl.getBody().stats.tail);
                    } else {
                        if (parent != null) {
                            this.printInstanceInitialization(parent, methodDecl.sym);
                            fieldsInitPrinted = true;
                        }
                        this.printBlockStatements(methodDecl.getBody().stats);
                    }
                    this.exit();
                    if (replacedBody != null) {
                        String orgBody = this.getOutput().substring(position);
                        this.removeLastChars(this.getCurrentPosition() - position);
                        replacedBody = BODY_MARKER.matcher(replacedBody).replaceAll(orgBody);
                        replacedBody = BASE_INDENT_MARKER.matcher(replacedBody).replaceAll(this.getIndentString());
                        replacedBody = INDENT_MARKER.matcher(replacedBody).replaceAll("    ");
                        replacedBody = METHOD_NAME_MARKER.matcher(replacedBody).replaceAll(methodDecl.getName().toString());
                        replacedBody = CLASS_NAME_MARKER.matcher(replacedBody).replaceAll(parent.sym.getQualifiedName().toString());
                    }
                }
                if (replacedBody != null && replacedBody.trim().startsWith("super(")) {
                    String superCall = replacedBody.substring(0, replacedBody.indexOf(59) + 1);
                    replacedBody = replacedBody.substring(replacedBody.indexOf(59) + 1);
                    this.println(superCall);
                }
                if (!fieldsInitPrinted && parent != null) {
                    this.printInstanceInitialization(parent, methodDecl.sym);
                    fieldsInitPrinted = true;
                }
                if (replacedBody != null) {
                    if (methodDecl.sym.isConstructor()) {
                        this.getScope().hasDeclaredConstructor = true;
                    }
                    this.printIndent().print(replacedBody).println();
                }
                this.endIndent().printIndent().print("}");
            }
        }
    }

    private void printCoreOverloadMethod(JCTree.JCMethodDecl methodDecl, JCTree.JCClassDecl parent, OverloadScanner.Overload overload) {
        boolean wasPrinted = false;
        for (int i = 0; i < overload.methods.size(); ++i) {
            JCTree.JCMethodDecl method = overload.methods.get(i);
            if (this.context.isInterface((Symbol.ClassSymbol)method.sym.getEnclosingElement()) && !method.getModifiers().getFlags().contains((Object)Modifier.DEFAULT) && !method.getModifiers().getFlags().contains((Object)Modifier.STATIC) || !Util.isParent(parent.sym, (Symbol.ClassSymbol)method.sym.getEnclosingElement())) continue;
            if (wasPrinted) {
                this.print(" else ");
            }
            wasPrinted = true;
            this.print("if(");
            this.printMethodParamsTest(overload, method);
            this.print(") ");
            if (method.sym.isConstructor() || method.sym.getModifiers().contains((Object)Modifier.DEFAULT) && method.equals(overload.coreMethod)) {
                this.printInlinedMethod(overload, method, methodDecl.getParameters());
                continue;
            }
            if (parent.sym != method.sym.getEnclosingElement() && this.context.getOverload((TypeElement)((Symbol.ClassSymbol)method.sym.getEnclosingElement()), (ExecutableElement)method.sym).coreMethod == method) {
                this.print("{").println().startIndent().printIndent();
                if ((method.getBody() == null || method.mods.getFlags().contains((Object)Modifier.DEFAULT) && !this.getScope().defaultMethodScope) && !this.getScope().interfaceScope && method.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) {
                    this.print(" throw new Error('cannot invoke abstract overloaded method... check your argument(s) type(s)'); ");
                } else {
                    String tsMethodAccess = this.getTSMemberAccess(this.getTSMethodName(methodDecl), true);
                    this.print("super" + tsMethodAccess);
                    this.print("(");
                    for (int j = 0; j < ((List)method.getParameters()).size(); ++j) {
                        this.print(this.avoidJSKeyword(((JCTree.JCVariableDecl)((List)overload.coreMethod.getParameters()).get((int)j)).name.toString())).print(", ");
                    }
                    if (!((List)method.getParameters()).isEmpty()) {
                        this.removeLastChars(2);
                    }
                    this.print(");");
                }
                this.println().endIndent().printIndent().print("}");
                continue;
            }
            this.print("{").println().startIndent().printIndent();
            this.print("return <any>");
            if (!Util.isGlobalsClassName(parent.name.toString())) {
                if (method.sym.isStatic()) {
                    this.print(this.getQualifiedTypeName(parent.sym, false, false).toString());
                } else {
                    this.print("this");
                }
                this.print(".");
            }
            this.print(this.getOverloadMethodName(method.sym)).print("(");
            for (int j = 0; j < ((List)method.getParameters()).size(); ++j) {
                if (j == ((List)method.getParameters()).size() - 1 && Util.hasVarargs(overload.coreMethod.sym)) {
                    this.print("<any>");
                }
                this.print(this.avoidJSKeyword(((JCTree.JCVariableDecl)((List)overload.coreMethod.getParameters()).get((int)j)).name.toString())).print(", ");
            }
            if (!((List)method.getParameters()).isEmpty()) {
                this.removeLastChars(2);
            }
            this.print(");");
            this.println().endIndent().printIndent().print("}");
        }
    }

    protected void printMethodReturnDeclaration(JCTree.JCMethodDecl methodDecl, boolean inCoreWrongOverload) {
        if (inCoreWrongOverload && !methodDecl.sym.isConstructor()) {
            this.print(" : any");
        } else if (methodDecl.restype != null && methodDecl.restype.type.getTag() != TypeTag.VOID) {
            boolean promisify;
            this.print(" : ");
            boolean bl = promisify = this.isAsyncMethod(methodDecl) && !methodDecl.restype.type.tsym.getQualifiedName().toString().endsWith(".Promise");
            if (promisify) {
                this.print(" Promise< ");
            }
            this.substituteAndPrintType(methodDecl.restype);
            if (promisify) {
                this.print(" > ");
            }
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers modifiers) {
        if (this.getScope().isDeclareClassScope() && modifiers.getFlags().contains((Object)Modifier.ABSTRACT)) {
            modifiers.flags ^= 0x400L;
        }
        super.visitModifiers(modifiers);
    }

    protected void printAsyncKeyword(JCTree.JCMethodDecl methodDecl) {
        if (this.getScope().declareClassScope || this.getScope().interfaceScope) {
            return;
        }
        if (this.isAsyncMethod(methodDecl)) {
            this.print(" async ");
        }
    }

    protected boolean isAsyncMethod(JCTree.JCMethodDecl methodDecl) {
        return this.context.hasAnnotationType(methodDecl.sym, "jsweet.lang.Async");
    }

    protected void printMethodArgs(JCTree.JCMethodDecl methodDecl, OverloadScanner.Overload overload, boolean inOverload, boolean inCoreWrongOverload, ClassScope scope) {
        boolean isWrapped = false;
        if (this.context.hasAnnotationType(methodDecl.sym, "jsweet.lang.WrapParameters")) {
            isWrapped = true;
        }
        if (isWrapped) {
            this.print("{");
        }
        if (inCoreWrongOverload) {
            scope.setEraseVariableTypes(true);
        }
        boolean paramPrinted = false;
        if (scope.isInnerClassNotStatic() && methodDecl.sym.isConstructor() && !scope.isEnumWrapperClassScope()) {
            this.print("__parent: any, ");
            paramPrinted = true;
        }
        if (scope.isConstructor() && scope.isEnumWrapperClassScope()) {
            this.print((this.isAnonymousClass() ? "" : "protected ") + ENUM_WRAPPER_CLASS_ORDINAL + " : number, ");
            this.print((this.isAnonymousClass() ? "" : "protected ") + ENUM_WRAPPER_CLASS_NAME + " : string, ");
            paramPrinted = true;
        }
        int i = 0;
        for (JCTree.JCVariableDecl param : methodDecl.getParameters()) {
            if (isWrapped) {
                this.print(param.getName().toString());
            } else {
                this.print(param);
            }
            if (inOverload && overload.isValid && overload.defaultValues.get(i) != null) {
                this.print(" = ").print(overload.defaultValues.get(i));
            }
            this.print(", ");
            ++i;
            paramPrinted = true;
        }
        if (inCoreWrongOverload) {
            scope.setEraseVariableTypes(false);
        }
        if (paramPrinted) {
            this.removeLastChars(2);
        }
        if (isWrapped) {
            this.print("}: {");
            for (JCTree.JCVariableDecl param : methodDecl.getParameters()) {
                this.print(param).println(";");
            }
            this.print("}");
        }
    }

    protected void printMethodModifiers(JCTree.JCMethodDecl methodDecl, JCTree.JCClassDecl parent, boolean constructor, boolean inOverload, OverloadScanner.Overload overload) {
        if ((methodDecl.mods.getFlags().contains((Object)Modifier.PUBLIC) || inOverload && overload.coreMethod.equals(methodDecl)) && !this.getScope().interfaceScope) {
            this.print("public ");
        }
        if (methodDecl.mods.getFlags().contains((Object)Modifier.PRIVATE) && !constructor && !this.getScope().innerClass) {
            if (!this.getScope().interfaceScope) {
                if (!(inOverload && overload.coreMethod.equals(methodDecl) || this.getScope().hasInnerClass)) {
                    this.print("/*private*/ ");
                }
            } else if (!inOverload || !overload.coreMethod.equals(methodDecl)) {
                this.report((JCTree)methodDecl, methodDecl.name, JSweetProblem.INVALID_PRIVATE_IN_INTERFACE, methodDecl.name, parent == null ? "<no class>" : parent.name);
            }
        }
        if (methodDecl.mods.getFlags().contains((Object)Modifier.STATIC) && !this.getScope().interfaceScope) {
            this.print("static ");
        }
        if (methodDecl.mods.getFlags().contains((Object)Modifier.ABSTRACT) && !this.getScope().interfaceScope && !inOverload) {
            this.print("abstract ");
        }
    }

    private boolean shouldPrintFieldInitializationInConstructor(JCTree.JCVariableDecl var) {
        if (var.sym.isStatic()) {
            return false;
        }
        return var.init == null || !this.getScope().hasConstructorOverloadWithSuperClass && this.getScope().getFieldsWithInitializers().contains(var);
    }

    protected void printVariableInitialization(JCTree.JCClassDecl clazz, JCTree.JCVariableDecl var) {
        String name = var.getName().toString();
        name = this.context.getFieldNameMapping(var.sym) != null ? this.context.getFieldNameMapping(var.sym) : this.getIdentifier(var.sym);
        if (this.getScope().innerClassNotStatic && !Util.isConstantOrNullField(var) || var.init != null && this.shouldPrintFieldInitializationInConstructor(var)) {
            if (this.doesMemberNameRequireQuotes(name)) {
                this.printIndent().print("this['").print(name).print("'] = ");
            } else {
                this.printIndent().print("this.").print(name).print(" = ");
            }
            this.substituteAndPrintAssignedExpression(var.type, var.init);
            this.print(";").println();
        } else if (var.init == null) {
            if (this.doesMemberNameRequireQuotes(name)) {
                this.printIndent().print("if(").print("this['").print(name).print("']").print("===undefined) ").print("this['").print(name).print("'] = ").print(this.getAdapter().getVariableInitialValue(var.sym)).print(";").println();
            } else {
                this.printIndent().print("if(").print("this.").print(name).print("===undefined) this.").print(name).print(" = ").print(this.getAdapter().getVariableInitialValue(var.sym)).print(";").println();
            }
        }
    }

    protected void printInstanceInitialization(JCTree.JCClassDecl clazz, Symbol.MethodSymbol method) {
        if (method == null || method.isConstructor()) {
            this.getScope().hasDeclaredConstructor = true;
            if (this.context.types.isAssignable(clazz.sym.type, this.context.symtab.throwableType)) {
                this.printIndent().print("(<any>Object).setPrototypeOf(this, " + this.getClassName(clazz.sym) + ".prototype);").println();
            }
            if (this.getScope().innerClassNotStatic && !this.getScope().enumWrapperClassScope) {
                this.printIndent().print("this.__parent = __parent;").println();
            }
            for (JCTree member : clazz.defs) {
                JCTree.JCBlock block;
                if (member instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)member;
                    if (var.sym.isStatic() || this.context.hasAnnotationType(var.sym, "jsweet.lang.Erased")) continue;
                    this.printVariableInitialization(clazz, var);
                    continue;
                }
                if (!(member instanceof JCTree.JCBlock) || (block = (JCTree.JCBlock)member).isStatic()) continue;
                this.printIndent().print("(() => {").startIndent().println();
                this.stack.push(block);
                this.printBlockStatements(block.stats);
                this.stack.pop();
                this.endIndent().printIndent().print("})();").println();
            }
        }
    }

    private void printInlinedMethod(OverloadScanner.Overload overload, JCTree.JCMethodDecl method, java.util.List<? extends JCTree> args) {
        this.print("{").println().startIndent();
        if (this.getScope().innerClassNotStatic && this.getScope().constructor) {
            this.printIndent().print("let __args = Array.prototype.slice.call(arguments, [1]);").println();
        } else {
            this.printIndent().print("let __args = arguments;").println();
        }
        for (int j = 0; j < ((List)method.getParameters()).size(); ++j) {
            if (args.get(j) instanceof JCTree.JCVariableDecl) {
                if (((JCTree.JCVariableDecl)((List)method.getParameters()).get((int)j)).name.equals(((JCTree.JCVariableDecl)args.get((int)j)).name)) continue;
                this.printIndent().print("let ").print(this.avoidJSKeyword(((JCTree.JCVariableDecl)((List)method.getParameters()).get((int)j)).name.toString())).print(" : ").print("any").print(Util.isVarargs((JCTree.JCVariableDecl)((List)method.getParameters()).get(j)) ? "[]" : "").print(" = ").print("__args[" + j + "]").print(";").println();
                continue;
            }
            if (((JCTree.JCVariableDecl)((List)method.getParameters()).get((int)j)).name.toString().equals(args.get(j).toString())) continue;
            this.getScope().inlinedConstructorArgs = method.getParameters().stream().map(p -> p.sym.name.toString()).collect(Collectors.toList());
            this.printIndent().print("let ").print(this.avoidJSKeyword(((JCTree.JCVariableDecl)((List)method.getParameters()).get((int)j)).name.toString())).print(" : ").print("any").print(Util.isVarargs((JCTree.JCVariableDecl)((List)method.getParameters()).get(j)) ? "[]" : "").print(" = ").print(args.get(j)).print(";").println();
            this.getScope().inlinedConstructorArgs = null;
        }
        if (method.getBody() != null) {
            boolean skipFirst = false;
            boolean initialized = false;
            if (!method.getBody().stats.isEmpty() && method.getBody().stats.get(0).toString().startsWith("this(")) {
                skipFirst = true;
                JCTree.JCMethodInvocation inv = (JCTree.JCMethodInvocation)((JCTree.JCExpressionStatement)method.getBody().stats.get((int)0)).expr;
                Symbol.MethodSymbol ms = Util.findMethodDeclarationInType(this.context.types, (Symbol.TypeSymbol)overload.coreMethod.sym.getEnclosingElement(), inv);
                for (JCTree.JCMethodDecl md : overload.methods) {
                    if (!md.sym.equals(ms)) continue;
                    this.printIndent();
                    initialized = true;
                    this.printInlinedMethod(overload, md, inv.args);
                    this.println();
                }
            }
            String replacedBody = null;
            if (this.context.hasAnnotationType(method.sym, "jsweet.lang.Replace")) {
                replacedBody = this.context.getAnnotationValue(method.sym, "jsweet.lang.Replace", String.class, null);
            }
            int position = this.getCurrentPosition();
            if (replacedBody == null || BODY_MARKER.matcher(replacedBody).find()) {
                List<JCTree.JCStatement> stats;
                this.enter(method.getBody());
                List<JCTree.JCStatement> list = stats = skipFirst ? method.getBody().stats.tail : method.getBody().stats;
                if (!stats.isEmpty() && ((JCTree.JCStatement)stats.head).toString().startsWith("super(")) {
                    this.printBlockStatement((JCTree.JCStatement)stats.head);
                    this.printFieldInitializations();
                    if (!initialized) {
                        this.printInstanceInitialization(this.getParent(JCTree.JCClassDecl.class), method.sym);
                    }
                    if (!stats.tail.isEmpty()) {
                        this.printIndent().print("((").print(") => {").startIndent().println();
                        this.printBlockStatements(stats.tail);
                        this.endIndent().printIndent().print("})(").print(");").println();
                    }
                } else {
                    if (!initialized) {
                        this.printInstanceInitialization(this.getParent(JCTree.JCClassDecl.class), method.sym);
                    }
                    if (!stats.isEmpty() || !method.sym.isConstructor()) {
                        this.printIndent();
                    }
                    if (!method.sym.isConstructor()) {
                        this.print("return <any>");
                    }
                    if (!stats.isEmpty() || !method.sym.isConstructor()) {
                        this.print("((").print(") => {").startIndent().println();
                        this.printBlockStatements(stats);
                        this.endIndent().printIndent().print("})(").print(");").println();
                    }
                }
                this.exit();
                if (replacedBody != null) {
                    this.getIndent();
                    this.printIndent();
                    String orgBody = this.getOutput().substring(position);
                    this.removeLastChars(this.getCurrentPosition() - position);
                    replacedBody = BODY_MARKER.matcher(replacedBody).replaceAll(orgBody);
                    replacedBody = BASE_INDENT_MARKER.matcher(replacedBody).replaceAll(this.getIndentString());
                    replacedBody = INDENT_MARKER.matcher(replacedBody).replaceAll("    ");
                    replacedBody = METHOD_NAME_MARKER.matcher(replacedBody).replaceAll(method.getName().toString());
                    replacedBody = CLASS_NAME_MARKER.matcher(replacedBody).replaceAll(((Symbol)method.sym.getEnclosingElement()).getQualifiedName().toString());
                }
            }
            if (replacedBody != null) {
                if (method.sym.isConstructor()) {
                    this.getScope().hasDeclaredConstructor = true;
                }
                this.printIndent().print(replacedBody).println();
            }
        } else {
            String returnValue = Util.getTypeInitialValue(method.sym.getReturnType());
            if (returnValue != null) {
                this.print(" return ").print(returnValue).print("; ");
            }
        }
        this.endIndent().printIndent().print("}");
    }

    private void printFieldInitializations() {
        JCTree.JCClassDecl clazz = this.getParent(JCTree.JCClassDecl.class);
        for (JCTree t : clazz.getMembers()) {
            if (!(t instanceof JCTree.JCVariableDecl) || this.getScope().fieldsWithInitializers.contains(t)) continue;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)t;
            if (field.sym.isStatic() || this.context.hasAnnotationType(field.sym, "jsweet.lang.Erased")) continue;
            String name = this.getIdentifier(field.sym);
            if (this.context.getFieldNameMapping(field.sym) != null) {
                name = this.context.getFieldNameMapping(field.sym);
            }
            this.printIndent().print("if(").print("this.").print(name).print("===undefined) ").print("this.").print(name).print(" = ").print(this.getAdapter().getVariableInitialValue(field.sym)).print(";").println();
        }
        for (JCTree.JCVariableDecl field : this.getScope().fieldsWithInitializers) {
            if (this.context.hasAnnotationType(field.sym, "jsweet.lang.Erased")) continue;
            String name = this.getIdentifier(field.sym);
            if (this.context.getFieldNameMapping(field.sym) != null) {
                name = this.context.getFieldNameMapping(field.sym);
            }
            this.printIndent().print("this.").print(name).print(" = ");
            if (!this.substituteAssignedExpression(field.type, field.init)) {
                this.print(field.init);
            }
            this.print(";").println();
        }
    }

    protected void printBlockStatements(java.util.List<JCTree.JCStatement> statements) {
        for (final JCTree.JCStatement statement : statements) {
            JCTree.JCMethodDecl methodDecl;
            if (this.context.options.isDebugMode() && this.isDebugMode(methodDecl = this.getParent(JCTree.JCMethodDecl.class))) {
                int s = statement.getStartPosition();
                int e = statement.getEndPosition(this.diagnosticSource.getEndPosTable());
                if (e == -1) {
                    e = s;
                }
                this.printIndent().print("yield { row: ").print("" + this.diagnosticSource.getLineNumber(s)).print(", column: " + this.diagnosticSource.getColumnNumber(s, false)).print(", statement: \"");
                this.print(StringEscapeUtils.escapeJson((String)statement.toString())).print("\"");
                final Stack locals = new Stack();
                try {
                    new TreeScanner(){

                        @Override
                        public void scan(JCTree tree) {
                            if (tree == statement) {
                                throw new RuntimeException();
                            }
                            boolean contextChange = false;
                            if (tree instanceof JCTree.JCBlock || tree instanceof JCTree.JCEnhancedForLoop || tree instanceof JCTree.JCLambda || tree instanceof JCTree.JCForLoop || tree instanceof JCTree.JCDoWhileLoop) {
                                locals.push(new ArrayList());
                                contextChange = true;
                            }
                            if (tree instanceof JCTree.JCVariableDecl) {
                                ((java.util.List)locals.peek()).add(((JCTree.JCVariableDecl)tree).name.toString());
                            }
                            super.scan(tree);
                            if (contextChange) {
                                locals.pop();
                            }
                        }
                    }.scan(methodDecl.body);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList accessibleLocals = new ArrayList();
                for (java.util.List l : locals) {
                    accessibleLocals.addAll(l);
                }
                if (!accessibleLocals.isEmpty()) {
                    this.print(", locals: ");
                    this.print("{");
                    for (String local : accessibleLocals) {
                        this.print("" + local + ": " + local + ", ");
                    }
                    this.removeLastChars(2);
                    this.print("}");
                }
                this.print(" };").println();
            }
            this.printBlockStatement(statement);
        }
    }

    private void printBlockStatement(JCTree.JCStatement statement) {
        this.printIndent();
        int pos = this.getCurrentPosition();
        this.print(statement);
        if (this.getCurrentPosition() == pos) {
            this.removeLastIndent();
            return;
        }
        if (!statementsWithNoSemis.contains(statement.getClass())) {
            if (statement instanceof JCTree.JCLabeledStatement) {
                if (!statementsWithNoSemis.contains(((JCTree.JCLabeledStatement)statement).body.getClass())) {
                    this.print(";");
                }
            } else {
                this.print(";");
            }
        }
        this.println();
    }

    private String getOverloadMethodName(Symbol.MethodSymbol method) {
        if (method.isConstructor()) {
            return "constructor";
        }
        StringBuilder sb = new StringBuilder(((Name)method.getSimpleName()).toString());
        sb.append(ANONYMOUS_PREFIX);
        for (Symbol.VarSymbol p : method.getParameters()) {
            sb.append(this.context.types.erasure(p.type).toString().replace('.', '_').replace("[]", "_A"));
            sb.append(ANONYMOUS_PREFIX);
        }
        if (!((List)method.getParameters()).isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private void checkType(Symbol.TypeSymbol type) {
        String name;
        ModuleImportDescriptor moduleImport;
        if (type instanceof Symbol.ClassSymbol && !this.isMappedOrErasedType(type) && (moduleImport = this.getModuleImportDescriptor(name = ((Name)type.getSimpleName()).toString(), (Symbol.ClassSymbol)type)) != null) {
            this.useModule(false, moduleImport.isDirect(), moduleImport.getTargetPackage(), null, moduleImport.getImportedName(), moduleImport.getPathToImportedClass(), null);
        }
    }

    private void printMethodParamsTest(OverloadScanner.Overload overload, JCTree.JCMethodDecl m) {
        int i;
        for (i = 0; i < ((List)m.getParameters()).size(); ++i) {
            this.print("(");
            this.printInstanceOf(this.avoidJSKeyword(((JCTree.JCVariableDecl)((List)overload.coreMethod.getParameters()).get((int)i)).name.toString()), null, ((JCTree.JCVariableDecl)((List)m.getParameters()).get((int)i)).type);
            this.checkType(((JCTree.JCVariableDecl)((List)m.getParameters()).get((int)i)).type.tsym);
            this.print(" || ").print(this.avoidJSKeyword(((JCTree.JCVariableDecl)((List)overload.coreMethod.getParameters()).get((int)i)).name.toString()) + " === null").print(")");
            this.print(" && ");
        }
        while (i < ((List)overload.coreMethod.getParameters()).size()) {
            this.print(this.avoidJSKeyword(((JCTree.JCVariableDecl)((List)overload.coreMethod.getParameters()).get((int)i)).name.toString())).print(" === undefined");
            this.print(" && ");
            ++i;
        }
        this.removeLastChars(4);
    }

    @Override
    public void visitBlock(JCTree.JCBlock block) {
        boolean initializer;
        JCTree parent = this.getParent();
        boolean globals = parent instanceof JCTree.JCClassDecl && "Globals".equals(((JCTree.JCClassDecl)parent).name.toString());
        boolean bl = initializer = parent instanceof JCTree.JCClassDecl && !globals;
        if (initializer) {
            if (this.getScope().interfaceScope) {
                this.report((JCTree)block, JSweetProblem.INVALID_INITIALIZER_IN_INTERFACE, ((JCTree.JCClassDecl)parent).name);
            }
            if (!block.isStatic()) {
                return;
            }
            this.printStaticInitializer(block);
            return;
        }
        if (!globals) {
            this.print("{").println().startIndent();
        }
        this.printBlockStatements(block.stats);
        if (!globals) {
            this.endIndent().printIndent().print("}");
        }
    }

    private void printStaticInitializer(JCTree.JCBlock block) {
        if (this.getScope().isEnumScope()) {
            return;
        }
        if (this.getScope().isDeclareClassScope()) {
            return;
        }
        int static_i = 0;
        for (JCTree m : ((JCTree.JCClassDecl)this.getParent()).getMembers()) {
            if (!(m instanceof JCTree.JCBlock) || !((JCTree.JCBlock)m).isStatic()) continue;
            if (block == m) {
                String asyncKeyword = this.isAsyncStaticInitializer(block) ? "async" : "";
                this.print("static " + asyncKeyword + " __static_initializer_" + static_i + "() ");
                this.print("{");
                this.println().startIndent();
                this.printBlockStatements(block.stats);
                this.endIndent().printIndent();
                this.print("}");
                break;
            }
            ++static_i;
        }
    }

    protected boolean isAsyncStaticInitializer(JCTree.JCBlock initializerBlock) {
        AsyncCallsFinder finder = new AsyncCallsFinder(new ConsoleTranspilationHandler(), this.context, this.compilationUnit);
        initializerBlock.accept(finder);
        return finder.found;
    }

    private String avoidJSKeyword(String name) {
        if (JSweetConfig.JS_KEYWORDS.contains(name)) {
            name = "__" + name;
        }
        return name;
    }

    private boolean isLazyInitialized(Symbol.VarSymbol var) {
        return var.isStatic() && this.context.lazyInitializedStatics.contains(var) && (!var.isEnum() || !((Object)var.getEnclosingElement()).equals(var.type.tsym));
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl varDecl) {
        if (this.getAdapter().substituteVariable(varDecl.sym)) {
            return;
        }
        if (this.context.hasAnnotationType(varDecl.sym, "jsweet.lang.Erased")) {
            return;
        }
        if (this.context.hasAnnotationType(varDecl.sym, "jsweet.lang.StringType")) {
            return;
        }
        if (this.getScope().enumScope) {
            this.printDocComment(varDecl, true);
            this.print(varDecl.name.toString());
            if (varDecl.init instanceof JCTree.JCNewClass) {
                JCTree.JCNewClass newClass = (JCTree.JCNewClass)varDecl.init;
                if (newClass.def != null) {
                    this.initAnonymousClass(newClass);
                }
            }
        } else {
            boolean globals;
            JCTree parent = this.getParent();
            if (this.getScope().enumWrapperClassScope && varDecl.sym.getKind() == ElementKind.ENUM_CONSTANT) {
                return;
            }
            String name = this.getIdentifier(varDecl.sym);
            if (this.context.getFieldNameMapping(varDecl.sym) != null) {
                name = this.context.getFieldNameMapping(varDecl.sym);
            }
            boolean confictInDefinitionScope = false;
            if (parent instanceof JCTree.JCClassDecl) {
                Symbol.MethodSymbol m = Util.findMethodDeclarationInType(this.context.types, ((JCTree.JCClassDecl)parent).sym, name, null);
                if (m != null) {
                    if (!this.isDefinitionScope) {
                        this.report((JCTree)varDecl, varDecl.name, JSweetProblem.FIELD_CONFLICTS_METHOD, name, m.owner);
                    } else {
                        confictInDefinitionScope = true;
                    }
                }
                if (!this.getScope().interfaceScope && name.equals("constructor")) {
                    this.report((JCTree)varDecl, varDecl.name, JSweetProblem.CONSTRUCTOR_MEMBER, new Object[0]);
                }
            } else {
                if (!this.context.useModules && this.context.importedTopPackages.contains(name)) {
                    name = "__var_" + name;
                }
                if (JSweetConfig.JS_KEYWORDS.contains(name)) {
                    this.report((JCTree)varDecl, varDecl.name, JSweetProblem.JS_KEYWORD_CONFLICT, name, name);
                    name = "__" + name;
                }
            }
            boolean bl = globals = parent instanceof JCTree.JCClassDecl && "Globals".equals(((JCTree.JCClassDecl)parent).name.toString());
            if (globals && !varDecl.mods.getFlags().contains((Object)Modifier.STATIC)) {
                this.report((JCTree)varDecl, varDecl.name, JSweetProblem.GLOBALS_CAN_ONLY_HAVE_STATIC_MEMBERS, new Object[0]);
                return;
            }
            boolean bl2 = globals = globals || parent instanceof JCTree.JCClassDecl && (((JCTree.JCClassDecl)parent).sym.isInterface() || this.getScope().interfaceScope && varDecl.sym.isStatic());
            if (parent instanceof JCTree.JCClassDecl) {
                this.printDocComment(varDecl);
            }
            this.print(varDecl.mods);
            if (!globals && parent instanceof JCTree.JCClassDecl) {
                if (varDecl.mods.getFlags().contains((Object)Modifier.PUBLIC) && !this.getScope().interfaceScope) {
                    this.print("public ");
                }
                if (varDecl.mods.getFlags().contains((Object)Modifier.PRIVATE)) {
                    if (!this.getScope().interfaceScope) {
                        if (!this.getScope().innerClass && !varDecl.mods.getFlags().contains((Object)Modifier.STATIC)) {
                            this.print("/*private*/ ");
                        }
                    } else {
                        this.report((JCTree)varDecl, varDecl.name, JSweetProblem.INVALID_PRIVATE_IN_INTERFACE, varDecl.name, ((JCTree.JCClassDecl)parent).name);
                    }
                }
                if (varDecl.mods.getFlags().contains((Object)Modifier.STATIC) && !this.getScope().interfaceScope) {
                    this.print("static ");
                }
            }
            if (!this.getScope().interfaceScope && parent instanceof JCTree.JCClassDecl && this.context.hasAnnotationType(varDecl.sym, "jsweet.lang.Optional")) {
                this.report((JCTree)varDecl, varDecl.name, JSweetProblem.USELESS_OPTIONAL_ANNOTATION, varDecl.name, ((JCTree.JCClassDecl)parent).name);
            }
            boolean ambient = this.context.hasAnnotationType(varDecl.sym, "jsweet.lang.Ambient");
            if (globals || !(parent instanceof JCTree.JCClassDecl) && !(parent instanceof JCTree.JCMethodDecl) && !(parent instanceof JCTree.JCLambda)) {
                if (globals) {
                    if (this.context.hasAnnotationType(varDecl.sym, "jsweet.lang.Module")) {
                        this.getContext().addExportedElement(this.context.getAnnotationValue(varDecl.sym, "jsweet.lang.Module", String.class, null), varDecl.sym, this.getCompilationUnit());
                    }
                    if (this.context.useModules || this.context.moduleBundleMode) {
                        if (!varDecl.mods.getFlags().contains((Object)Modifier.PRIVATE)) {
                            this.print("export ");
                        }
                    } else if (!this.isTopLevelScope()) {
                        this.print("export ");
                    }
                    if (ambient || this.isTopLevelScope() && this.isDefinitionScope) {
                        this.print("declare ");
                    }
                }
                if (!this.inArgListTail || !(parent instanceof JCTree.JCForLoop)) {
                    if (this.isDefinitionScope) {
                        this.print("var ");
                    } else {
                        this.print("let ");
                    }
                }
            } else if (ambient) {
                this.report((JCTree)varDecl, varDecl.name, JSweetProblem.WRONG_USE_OF_AMBIENT, varDecl.name);
            }
            if (Util.isVarargs(varDecl)) {
                this.print("...");
            }
            if (this.doesMemberNameRequireQuotes(name)) {
                this.print("'" + name + "'");
            } else {
                this.print(name);
            }
            if (!Util.isVarargs(varDecl) && (this.getScope().isEraseVariableTypes() || this.getScope().interfaceScope && this.context.hasAnnotationType(varDecl.sym, "jsweet.lang.Optional"))) {
                this.print("?");
            }
            if (!this.getScope().skipTypeAnnotations && !this.getScope().enumWrapperClassScope && this.typeChecker.checkType(varDecl, varDecl.name, varDecl.vartype)) {
                this.print(" : ");
                if (confictInDefinitionScope) {
                    this.print("any");
                } else if (this.getScope().isEraseVariableTypes()) {
                    this.print("any");
                    if (Util.isVarargs(varDecl)) {
                        this.print("[]");
                    }
                } else if (this.context.hasAnnotationType(varDecl.vartype.type.tsym, "jsweet.lang.StringType") && !varDecl.vartype.type.tsym.isEnum()) {
                    this.print("\"");
                    this.print(this.context.getAnnotationValue(varDecl.vartype.type.tsym, "jsweet.lang.StringType", String.class, varDecl.vartype.type.tsym.name.toString()).toString());
                    this.print("\"");
                } else {
                    this.substituteAndPrintType(varDecl.vartype);
                }
            }
            if (this.isLazyInitialized(varDecl.sym)) {
                JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)parent;
                String prefix = this.getClassName(clazz.sym);
                prefix = "Globals".equals(prefix) ? "" : prefix + ".";
                this.print("; ");
                if (globals) {
                    if (!this.isTopLevelScope()) {
                        this.print("export ");
                    }
                    this.print("function ");
                } else {
                    this.print("public static ");
                }
                this.print(name).print("_$LI$() : ");
                this.substituteAndPrintType(varDecl.vartype);
                this.print(" { ");
                int liCount = this.context.getStaticInitializerCount(clazz.sym);
                if (liCount > 0 && !globals) {
                    this.print(prefix + "__static_initialize(); ");
                }
                if (varDecl.init != null && !this.isDefinitionScope) {
                    this.print("if(" + prefix).print(name).print(" == null) ").print(prefix).print(name).print(" = ");
                    if (!this.substituteAssignedExpression(varDecl.type, varDecl.init)) {
                        this.print(varDecl.init);
                    }
                    this.print("; ");
                }
                this.print("return ").print(prefix).print(name).print("; }");
                if (!globals && this.context.bundleMode) {
                    String qualifiedClassName = this.getQualifiedTypeName(clazz.sym, globals, true);
                    this.context.addTopFooterStatement((StringUtils.isBlank((CharSequence)qualifiedClassName) ? "" : qualifiedClassName + ".") + name + STATIC_INITIALIZATION_SUFFIX + "();");
                }
            } else {
                if (!(varDecl.init == null || this.isDefinitionScope || parent instanceof JCTree.JCClassDecl && this.getScope().innerClassNotStatic && !varDecl.sym.isStatic() && !Util.isConstantOrNullField(varDecl))) {
                    if (!globals && parent instanceof JCTree.JCClassDecl && this.getScope().interfaceScope) {
                        this.report((JCTree)varDecl, varDecl.name, JSweetProblem.INVALID_FIELD_INITIALIZER_IN_INTERFACE, varDecl.name, ((JCTree.JCClassDecl)parent).name);
                    } else if (!this.getScope().fieldsWithInitializers.contains(varDecl)) {
                        this.print(" = ");
                        if (!this.substituteAssignedExpression(varDecl.type, varDecl.init)) {
                            this.print(varDecl.init);
                        }
                    }
                }
                if (!(this.isDefinitionScope || ambient || this.isTopLevelScope() && this.isDefinitionScope || !varDecl.sym.isStatic() || varDecl.init != null)) {
                    this.print(" = ").print(this.getAdapter().getVariableInitialValue(varDecl.sym));
                }
            }
        }
    }

    private String getTSMemberAccess(String memberName, boolean hasSelector) {
        if (this.doesMemberNameRequireQuotes(memberName)) {
            return (hasSelector ? "" : "window") + "['" + memberName + "']";
        }
        return (hasSelector ? "." : "") + memberName;
    }

    private boolean doesMemberNameRequireQuotes(String name) {
        for (char c : name.toCharArray()) {
            if (!JSweetConfig.TS_IDENTIFIER_FORBIDDEN_CHARS.contains(Character.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitParens(JCTree.JCParens parens) {
        this.print("(");
        super.visitParens(parens);
        this.print(")");
    }

    @Override
    public void visitImport(JCTree.JCImport importDecl) {
        String qualId = ((JCTree)importDecl.getQualifiedIdentifier()).toString();
        if (this.context.useModules && qualId.endsWith("*") && !qualId.endsWith(".Globals.*") && !qualId.equals("jsweet.util.Lang.*")) {
            this.report((JCTree)importDecl, JSweetProblem.WILDCARD_IMPORT, new Object[0]);
            return;
        }
        String adaptedQualId = this.getAdapter().needsImport(new ImportElementSupport(importDecl), qualId);
        if (adaptedQualId != null && adaptedQualId.contains(".") && (!importDecl.isStatic() || qualId.contains(".Globals.") || qualId.contains(".StringTypes."))) {
            String[] namePath = this.context.useModules && importDecl.isStatic() ? qualId.split("\\.") : adaptedQualId.split("\\.");
            String name = namePath[namePath.length - 1];
            if (this.context.useModules) {
                if (!adaptedQualId.startsWith("globals") && !this.context.getImportedNames(this.compilationUnit.getSourceFile().getName()).contains(name)) {
                    this.print("import ").print(name).print(" = ").print(adaptedQualId).print(";").println();
                    this.context.registerImportedName(this.compilationUnit.getSourceFile().getName(), null, name);
                }
            } else {
                if (this.topLevelPackage == null) {
                    if (this.context.globalImports.contains(name)) {
                        return;
                    }
                    this.context.globalImports.add(name);
                }
                if (!this.context.useModules) {
                    this.context.importedTopPackages.add(namePath[0]);
                } else if (!this.context.getImportedNames(this.compilationUnit.getSourceFile().getName()).contains(name)) {
                    this.print("import ").print(name).print(" = ").print(adaptedQualId).print(";").println();
                    this.context.registerImportedName(this.compilationUnit.getSourceFile().getName(), null, name);
                }
            }
        }
    }

    private void printInnerClassAccess(String accessedElementName, ElementKind kind) {
        this.printInnerClassAccess(accessedElementName, kind, null);
    }

    private void printInnerClassAccess(String accessedElementName, ElementKind kind, Integer methodArgsCount) {
        boolean foundInParent;
        this.print("this.");
        JCTree.JCClassDecl parent = this.getParent(JCTree.JCClassDecl.class);
        int level = 0;
        boolean bl = foundInParent = Util.findFirstDeclarationInClassAndSuperClasses(parent.sym, accessedElementName, kind, methodArgsCount) != null;
        if (!foundInParent) {
            while (this.getScope(level++).innerClassNotStatic) {
                if ((parent = this.getParent(JCTree.JCClassDecl.class, parent)) == null || Util.findFirstDeclarationInClassAndSuperClasses(parent.sym, accessedElementName, kind, methodArgsCount) == null) continue;
                foundInParent = true;
                break;
            }
        }
        if (foundInParent && level > 0) {
            if (this.getScope().constructor) {
                this.removeLastChars(5);
            }
            for (int i = 0; i < level; ++i) {
                this.print("__parent.");
            }
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess fieldAccess) {
        if (!this.getAdapter().substitute(ExtendedElementFactory.INSTANCE.create(fieldAccess))) {
            if (fieldAccess.selected.type.tsym instanceof Symbol.PackageSymbol && this.context.isRootPackage(fieldAccess.selected.type.tsym)) {
                if (fieldAccess.type != null && fieldAccess.type.tsym != null) {
                    this.printIdentifier(fieldAccess.type.tsym);
                } else {
                    this.print(fieldAccess.name.toString());
                }
                return;
            }
            if ("class".equals(fieldAccess.name.toString())) {
                if (fieldAccess.type instanceof Type.ClassType && this.context.isInterface(((Type)((Type.ClassType)fieldAccess.type).typarams_field.head).tsym)) {
                    this.print("\"").print(this.context.getRootRelativeJavaName(((Type)((Type.ClassType)fieldAccess.type).typarams_field.head).tsym)).print("\"");
                } else {
                    String name = fieldAccess.selected.type.tsym.toString();
                    if (this.context.isMappedType(name)) {
                        String target = this.context.getTypeMappingTarget(name);
                        if (CONSTRUCTOR_TYPE_MAPPING.containsKey(target)) {
                            this.print(Java2TypeScriptTranslator.mapConstructorType(target));
                        } else {
                            this.print("\"").print(this.context.getRootRelativeJavaName(((Type)((Type.ClassType)fieldAccess.type).typarams_field.head).tsym)).print("\"");
                        }
                    } else if (CONSTRUCTOR_TYPE_MAPPING.containsKey(name)) {
                        this.print(Java2TypeScriptTranslator.mapConstructorType(name));
                    } else {
                        this.print(fieldAccess.selected);
                    }
                }
            } else if ("this".equals(fieldAccess.name.toString())) {
                this.print("this");
                if (this.getScope().innerClassNotStatic) {
                    JCTree.JCClassDecl parent = this.getParent(JCTree.JCClassDecl.class);
                    int level = 0;
                    boolean foundInParent = false;
                    while (this.getScope(level++).innerClassNotStatic) {
                        if ((parent = this.getParent(JCTree.JCClassDecl.class, parent)) == null || !parent.sym.equals(fieldAccess.selected.type.tsym)) continue;
                        foundInParent = true;
                        break;
                    }
                    if (foundInParent && level > 0) {
                        this.print(".");
                        if (this.getScope().constructor) {
                            this.removeLastChars(5);
                        }
                        for (int i = 0; i < level; ++i) {
                            this.print("__parent.");
                        }
                        this.removeLastChar();
                    }
                }
            } else {
                String selected = fieldAccess.selected.toString();
                if (!selected.equals("Globals")) {
                    if (selected.equals("super") && fieldAccess.sym instanceof Symbol.VarSymbol) {
                        this.print("this.");
                    } else if (this.getScope().innerClassNotStatic && ("this".equals(selected) || selected.endsWith(".this"))) {
                        this.printInnerClassAccess(fieldAccess.name.toString(), ElementKind.FIELD);
                    } else {
                        boolean accessSubstituted = false;
                        if (fieldAccess.sym instanceof Symbol.VarSymbol) {
                            Symbol.VarSymbol varSym = (Symbol.VarSymbol)fieldAccess.sym;
                            if (varSym.isStatic() && varSym.owner != Util.getAccessedSymbol(fieldAccess.selected)) {
                                accessSubstituted = true;
                                this.print(this.getRootRelativeName(varSym.owner)).print(".");
                                this.ensureModuleIsUsed(varSym.owner);
                            }
                        } else if (fieldAccess.selected.type.tsym instanceof Symbol.PackageSymbol && this.context.useModules && !this.context.moduleBundleMode && fieldAccess.sym instanceof TypeElement && Util.isSourceElement(fieldAccess.sym)) {
                            accessSubstituted = true;
                            ModuleImportDescriptor moduleImport = this.getAdapter().getModuleImportDescriptor(new CompilationUnitElementSupport(this.compilationUnit), fieldAccess.sym.getSimpleName().toString(), (TypeElement)((Object)fieldAccess.sym));
                            if (moduleImport != null) {
                                this.useModule(moduleImport);
                            }
                        }
                        if (!accessSubstituted) {
                            this.print(fieldAccess.selected).print(".");
                        }
                    }
                }
                String fieldName = null;
                fieldName = fieldAccess.sym instanceof Symbol.VarSymbol && this.context.getFieldNameMapping(fieldAccess.sym) != null ? this.context.getFieldNameMapping(fieldAccess.sym) : this.getIdentifier(fieldAccess.sym);
                if (fieldAccess.sym instanceof Symbol.ClassSymbol && this.context.hasClassNameMapping(fieldAccess.sym)) {
                    fieldName = this.context.getClassNameMapping(fieldAccess.sym);
                }
                if (this.doesMemberNameRequireQuotes(fieldName)) {
                    if (this.getLastPrintedChar() == '.') {
                        this.removeLastChar();
                        this.print("['").print(fieldName).print("']");
                    } else {
                        this.print("this['").print(fieldName).print("']");
                    }
                } else {
                    this.print(fieldName);
                }
                if (fieldAccess.sym instanceof Symbol.VarSymbol && this.isLazyInitialized((Symbol.VarSymbol)fieldAccess.sym) && !this.staticInitializedAssignment) {
                    this.print("_$LI$()");
                }
            }
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation inv) {
        Symbol.MethodSymbol methodSymbol;
        boolean debugMode = false;
        if (this.context.options.isDebugMode() && Util.getAccessedSymbol(inv.meth) instanceof Symbol.MethodSymbol && !(methodSymbol = (Symbol.MethodSymbol)Util.getAccessedSymbol(inv.meth)).isConstructor() && Util.isSourceElement(methodSymbol)) {
            debugMode = true;
        }
        if (debugMode) {
            this.print("__debug_result(yield ");
        }
        this.getAdapter().substituteMethodInvocation(new MethodInvocationElementSupport(inv));
        if (debugMode) {
            this.print(")");
        }
    }

    public void printDefaultMethodInvocation(JCTree.JCMethodInvocation inv) {
        Symbol.TypeSymbol s;
        int argsLength;
        Symbol.ClassSymbol target;
        Object selected;
        boolean isStatic;
        HashMap<String, Symbol.VarSymbol> vars;
        String meth = inv.meth.toString();
        String methName = meth.substring(meth.lastIndexOf(46) + 1);
        if (methName.equals("super") && this.getScope().removedSuperclass) {
            return;
        }
        boolean applyVarargs = true;
        if ("$new".equals(methName)) {
            this.print("new ");
            applyVarargs = false;
        }
        boolean anonymous = this.isAnonymousMethod(methName);
        boolean targetIsThisOrStaticImported = meth.equals(methName) || meth.equals("this." + methName);
        Type.MethodType type = inv.meth.type instanceof Type.MethodType ? (Type.MethodType)inv.meth.type : null;
        Symbol methSym = null;
        String methodName = null;
        boolean keywordHandled = false;
        if (targetIsThisOrStaticImported) {
            JCTree.JCImport staticImport = this.getStaticGlobalImport(methName);
            if (staticImport == null) {
                JCTree.JCClassDecl p = this.getParent(JCTree.JCClassDecl.class);
                Symbol symbol = methSym = p == null ? null : Util.findMethodDeclarationInType(this.context.types, p.sym, methName, type);
                if (methSym != null) {
                    this.typeChecker.checkApply(inv, (Symbol.MethodSymbol)methSym);
                    if (!methSym.isStatic()) {
                        if (!meth.startsWith("this.")) {
                            this.print("this");
                            if (!anonymous) {
                                this.print(".");
                            }
                        }
                    } else {
                        if (meth.startsWith("this.") && methSym.isStatic()) {
                            this.report((JCTree)inv, JSweetProblem.CANNOT_ACCESS_STATIC_MEMBER_ON_THIS, ((Symbol.MethodSymbol)methSym).getSimpleName());
                        }
                        if (!"Globals".equals(((Symbol.MethodSymbol)methSym).owner.getSimpleName().toString())) {
                            this.print("" + ((Symbol.MethodSymbol)methSym).owner.getSimpleName());
                            if (((Symbol.MethodSymbol)methSym).owner.isEnum()) {
                                this.print(ENUM_WRAPPER_CLASS_SUFFIX);
                            }
                            if (!anonymous) {
                                this.print(".");
                            }
                        }
                    }
                } else {
                    Symbol.TypeSymbol target2;
                    if (this.getScope().defaultMethodScope) {
                        target2 = Util.getStaticImportTarget(this.getContext().getDefaultMethodCompilationUnit(this.getParent(JCTree.JCMethodDecl.class)), methName);
                        if (target2 != null) {
                            this.print(this.getRootRelativeName(target2) + ".");
                        }
                    } else {
                        target2 = Util.getStaticImportTarget(this.getCompilationUnit(), methName);
                        if (target2 != null) {
                            this.print(this.getRootRelativeName(target2) + ".");
                        }
                    }
                    if (this.getScope().innerClass) {
                        JCTree.JCClassDecl parent = this.getParent(JCTree.JCClassDecl.class);
                        int level = 0;
                        Symbol method = null;
                        if (parent != null) {
                            while (this.getScope(level++).innerClass) {
                                parent = this.getParent(JCTree.JCClassDecl.class, parent);
                                method = Util.findMethodDeclarationInType(this.context.types, parent.sym, methName, type);
                                if (method == null) continue;
                            }
                        }
                        if (method != null) {
                            if (method.isStatic()) {
                                this.print(((Symbol)((Symbol.MethodSymbol)method).getEnclosingElement()).getSimpleName().toString() + ".");
                            } else {
                                if (level == 0 || !this.getScope().constructor) {
                                    this.print("this.");
                                }
                                for (int i = 0; i < level; ++i) {
                                    this.print("__parent.");
                                }
                                if (anonymous) {
                                    this.removeLastChar();
                                }
                            }
                        }
                    }
                }
            } else {
                JCTree.JCFieldAccess staticFieldAccess = staticImport.qualid;
                methSym = Util.findMethodDeclarationInType(this.context.types, staticFieldAccess.selected.type.tsym, methName, type);
                if (methSym != null) {
                    String prefix;
                    vars = new HashMap<String, Symbol.VarSymbol>();
                    Util.fillAllVariablesInScope(vars, this.getStack(), inv, this.getParent(JCTree.JCMethodDecl.class));
                    if (vars.containsKey(((Name)((Symbol.MethodSymbol)methSym).getSimpleName()).toString())) {
                        this.report((JCTree)inv, JSweetProblem.HIDDEN_INVOCATION, ((Symbol.MethodSymbol)methSym).getSimpleName());
                    }
                    if (!this.context.useModules && ((Symbol.MethodSymbol)methSym).owner.getSimpleName().toString().equals("Globals") && ((Symbol.MethodSymbol)methSym).owner.owner != null && !((Symbol.MethodSymbol)methSym).owner.owner.getSimpleName().toString().equals("globals") && !StringUtils.isEmpty((CharSequence)(prefix = this.getRootRelativeName(((Symbol.MethodSymbol)methSym).owner.owner)))) {
                        this.print(this.getRootRelativeName(((Symbol.MethodSymbol)methSym).owner.owner) + ".");
                    }
                }
                if (JSweetConfig.TS_STRICT_MODE_KEYWORDS.contains(this.context.getActualName(methSym))) {
                    String targetClass = this.getStaticContainerFullName(staticImport);
                    if (!StringUtils.isBlank((CharSequence)targetClass)) {
                        this.print(targetClass);
                        this.print(".");
                        keywordHandled = true;
                    }
                    if (JSweetConfig.isLibPath(((Symbol)((Symbol.MethodSymbol)methSym).getEnclosingElement()).getQualifiedName().toString())) {
                        methodName = methName.toLowerCase();
                    }
                }
            }
        } else if (inv.meth instanceof JCTree.JCFieldAccess) {
            JCTree.JCExpression selected2 = ((JCTree.JCFieldAccess)inv.meth).selected;
            if (this.context.isFunctionalType(selected2.type.tsym)) {
                anonymous = true;
            }
            if ((methSym = Util.findMethodDeclarationInType(this.context.types, selected2.type.tsym, methName, type)) != null) {
                this.typeChecker.checkApply(inv, (Symbol.MethodSymbol)methSym);
            }
        }
        boolean bl = isStatic = methSym == null || methSym.isStatic();
        if (!(Util.hasVarargs((Symbol.MethodSymbol)methSym) && (inv.args.isEmpty() || inv.args.last().type.getKind() == TypeKind.ARRAY && this.context.types.erasure(((Type.ArrayType)inv.args.last().type).elemtype).equals(this.context.types.erasure(((Type.ArrayType)((Symbol.VarSymbol)((List)((Symbol.MethodSymbol)methSym).getParameters()).last()).type).elemtype))))) {
            applyVarargs = false;
        }
        if (anonymous) {
            applyVarargs = false;
            if (inv.meth instanceof JCTree.JCFieldAccess) {
                selected = ((JCTree.JCFieldAccess)inv.meth).selected;
                this.print((JCTree)selected);
            }
        } else if (inv.meth instanceof JCTree.JCFieldAccess && applyVarargs && !targetIsThisOrStaticImported && !isStatic) {
            String accessedMemberName;
            this.print("(o => o");
            if (keywordHandled) {
                accessedMemberName = ((JCTree.JCFieldAccess)inv.meth).name.toString();
            } else {
                if (methSym == null) {
                    methSym = (Symbol.MethodSymbol)((JCTree.JCFieldAccess)inv.meth).sym;
                }
                accessedMemberName = methSym != null ? this.context.getActualName(methSym) : ((JCTree.JCFieldAccess)inv.meth).name.toString();
            }
            this.print(this.getTSMemberAccess(accessedMemberName, true));
        } else if (methodName != null) {
            this.print(this.getTSMemberAccess(methodName, this.removeLastChar('.')));
        } else if (keywordHandled) {
            this.print(inv.meth);
        } else {
            if (methSym == null && inv.meth instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)inv.meth).sym instanceof Symbol.MethodSymbol) {
                methSym = (Symbol.MethodSymbol)((JCTree.JCFieldAccess)inv.meth).sym;
            }
            if (methSym != null && inv.meth instanceof JCTree.JCFieldAccess) {
                selected = ((JCTree.JCFieldAccess)inv.meth).selected;
                if (!"Globals".equals(((Name)((JCTree.JCExpression)selected).type.tsym.getSimpleName()).toString())) {
                    if (this.getScope().innerClassNotStatic && ("this".equals(((JCTree)selected).toString()) || ((JCTree)selected).toString().endsWith(".this"))) {
                        this.printInnerClassAccess(((Symbol.MethodSymbol)methSym).name.toString(), ((Symbol.MethodSymbol)methSym).getKind(), ((List)((Symbol.MethodSymbol)methSym).getParameters()).size());
                    } else {
                        if (methSym != null && methSym.isStatic() && selected instanceof JCTree.JCIdent && ((JCTree.JCIdent)selected).sym instanceof Symbol.VarSymbol) {
                            if (this.context.useModules && !this.context.moduleBundleMode) {
                                this.print(this.getClassName(((JCTree.JCExpression)selected).type.tsym));
                                ModuleImportDescriptor moduleImport = this.getAdapter().getModuleImportDescriptor(new CompilationUnitElementSupport(this.compilationUnit), ((Name)((JCTree.JCExpression)selected).type.tsym.getSimpleName()).toString(), (TypeElement)((Object)((JCTree.JCExpression)selected).type.tsym));
                                if (moduleImport != null) {
                                    this.useModule(moduleImport);
                                }
                            } else {
                                this.print(this.getRootRelativeName(((JCTree.JCExpression)selected).type.tsym));
                            }
                        } else {
                            this.print((JCTree)selected);
                        }
                        this.print(".");
                    }
                } else {
                    if (this.context.useModules && !((Symbol.ClassSymbol)((JCTree.JCExpression)selected).type.tsym).sourcefile.getName().equals(this.getCompilationUnit().sourcefile.getName())) {
                        this.print("Globals").print(".");
                    }
                    vars = new HashMap();
                    Util.fillAllVariablesInScope(vars, this.getStack(), inv, this.getParent(JCTree.JCMethodDecl.class));
                    if (vars.containsKey(methName)) {
                        this.report((JCTree)inv, JSweetProblem.HIDDEN_INVOCATION, methName);
                    }
                }
            }
            if (methSym != null) {
                if (this.context.isInvalidOverload((ExecutableElement)((Object)methSym)) && !Util.hasTypeParameters((Symbol.MethodSymbol)methSym) && !((Symbol.MethodSymbol)methSym).isDefault() && this.getParent(JCTree.JCMethodDecl.class) != null && !this.getParent(JCTree.JCMethodDecl.class).sym.isDefault()) {
                    if (this.context.isInterface((Symbol.TypeSymbol)((Symbol.MethodSymbol)methSym).getEnclosingElement())) {
                        this.removeLastChar('.');
                        this.print("['" + this.getOverloadMethodName((Symbol.MethodSymbol)methSym) + "']");
                    } else {
                        this.print(this.getOverloadMethodName((Symbol.MethodSymbol)methSym));
                    }
                } else {
                    this.print(this.getTSMemberAccess(this.context.getActualName(methSym), this.removeLastChar('.')));
                }
            } else {
                this.print(inv.meth);
            }
        }
        if (applyVarargs) {
            this.print(".apply");
        } else if (inv.typeargs != null && !inv.typeargs.isEmpty()) {
            this.print("<");
            for (JCTree.JCExpression argument : inv.typeargs) {
                this.substituteAndPrintType(argument).print(",");
            }
            this.removeLastChar();
            this.print(">");
        } else if (methSym != null && !((List)((Symbol.MethodSymbol)methSym).getTypeParameters()).isEmpty() && !(target = (Symbol.ClassSymbol)((Symbol.MethodSymbol)methSym).getEnclosingElement()).getQualifiedName().toString().startsWith("def.")) {
            boolean inOverload;
            OverloadScanner.Overload overload = this.context.getOverload(target, (ExecutableElement)((Object)methSym));
            boolean bl2 = inOverload = overload != null && overload.methods.size() > 1;
            if (!inOverload || overload.isValid) {
                this.printAnyTypeArguments(((List)((Symbol.MethodSymbol)methSym).getTypeParameters()).size());
            }
        }
        this.print("(");
        if (applyVarargs) {
            String contextVar = "null";
            if (targetIsThisOrStaticImported) {
                contextVar = "this";
            } else if (inv.meth instanceof JCTree.JCFieldAccess && !targetIsThisOrStaticImported && !isStatic) {
                contextVar = "o";
            }
            this.print(contextVar + ", ");
            if (inv.args.size() > 1) {
                this.print("[");
            }
        }
        int n = argsLength = applyVarargs ? inv.args.size() - 1 : inv.args.size();
        if (this.getScope().innerClassNotStatic && "super".equals(methName) && (s = this.getParent(JCTree.JCClassDecl.class).extending.type.tsym).getEnclosingElement() instanceof Symbol.ClassSymbol && !s.isStatic()) {
            this.print(PARENT_CLASS_FIELD_NAME);
            if (argsLength > 0) {
                this.print(", ");
            }
        }
        if (this.getScope().enumWrapperClassScope && this.isAnonymousClass() && "super".equals(methName)) {
            this.print("_$ordinal, _$name");
            if (argsLength > 0) {
                this.print(", ");
            }
        }
        if ("super".equals(methName)) {
            JCTree.JCClassDecl p = this.getParent(JCTree.JCClassDecl.class);
            methSym = p == null ? null : Util.findMethodDeclarationInType(this.context.types, p.sym, "this", type);
        }
        for (int i = 0; i < argsLength; ++i) {
            JCTree.JCExpression arg = inv.args.get(i);
            if (inv.meth.type instanceof Type.MethodType) {
                Type paramType;
                List<Type> argTypes = ((Type.MethodType)inv.meth.type).argtypes;
                Type type2 = paramType = i < argTypes.size() ? (Type)argTypes.get(i) : (Type)argTypes.get(argTypes.size() - 1);
                if (i == argsLength - 1 && !applyVarargs && methSym != null && ((Symbol.MethodSymbol)methSym).isVarArgs() && arg instanceof JCTree.JCIdent && ((JCTree.JCIdent)arg).sym instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol var = (Symbol.VarSymbol)((JCTree.JCIdent)arg).sym;
                    if (var.owner instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)var.owner).isVarArgs() && ((List)((Symbol.MethodSymbol)var.owner).getParameters()).last() == var) {
                        this.print("...");
                    }
                }
                if (!this.substituteAssignedExpression(paramType, arg)) {
                    this.print(arg);
                }
            } else {
                this.print(arg);
            }
            if (i >= argsLength - 1) continue;
            this.print(", ");
        }
        if (applyVarargs) {
            if (inv.args.size() > 1) {
                this.print("].concat(<any[]>");
            }
            this.print(inv.args.last());
            if (inv.args.size() > 1) {
                this.print(")");
            }
            if (inv.meth instanceof JCTree.JCFieldAccess && !targetIsThisOrStaticImported && !isStatic) {
                this.print("))(").print(((JCTree.JCFieldAccess)inv.meth).selected);
            }
        }
        this.print(")");
    }

    private boolean isAnonymousMethod(String methName) {
        boolean anonymous = "$apply".equals(methName) || "$applyStatic".equals(methName) || this.context.deprecatedApply && "apply".equals(methName) || this.context.deprecatedApply && "applyStatic".equals(methName) || "$new".equals(methName);
        return anonymous;
    }

    private JCTree.JCImport getStaticGlobalImport(String methName) {
        if (this.compilationUnit == null) {
            return null;
        }
        for (JCTree.JCImport i : this.compilationUnit.getImports()) {
            if (!i.staticImport || !i.qualid.toString().endsWith("Globals." + methName)) continue;
            return i;
        }
        return null;
    }

    private String getStaticContainerFullName(JCTree.JCImport importDecl) {
        if (importDecl.getQualifiedIdentifier() instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)importDecl.getQualifiedIdentifier();
            String name = this.context.getRootRelativeJavaName(fa.selected.type.tsym);
            if ("Globals".equals(name)) {
                return null;
            }
            boolean globals = name.endsWith(".Globals");
            if (globals) {
                name = name.substring(0, name.length() - "Globals".length() - 1);
            }
            if (this.compilationUnit.packge.getQualifiedName().toString().startsWith(name)) {
                return null;
            }
            return name;
        }
        return null;
    }

    @Override
    public void visitIdent(JCTree.JCIdent ident) {
        String name = ident.toString();
        if (this.getScope().inlinedConstructorArgs != null && ident.sym instanceof Symbol.VarSymbol && this.getScope().inlinedConstructorArgs.contains(name)) {
            this.print("__args[" + this.getScope().inlinedConstructorArgs.indexOf(name) + "]");
            return;
        }
        if (!this.getAdapter().substitute(ExtendedElementFactory.INSTANCE.create(ident))) {
            Symbol.VarSymbol varSym;
            boolean lazyInitializedStatic = false;
            if (ident.sym instanceof Symbol.VarSymbol && !ident.sym.name.equals(this.context.names._this) && !ident.sym.name.equals(this.context.names._super) && (varSym = (Symbol.VarSymbol)ident.sym) != null) {
                if (varSym.owner instanceof Symbol.ClassSymbol) {
                    name = this.context.getFieldNameMapping(varSym) != null ? this.context.getFieldNameMapping(varSym) : this.getIdentifier(varSym);
                    if (!varSym.getModifiers().contains((Object)Modifier.STATIC)) {
                        this.printInnerClassAccess(varSym.name.toString(), ElementKind.FIELD);
                    } else {
                        String prefix;
                        if (this.isLazyInitialized(varSym)) {
                            lazyInitializedStatic = true;
                        }
                        if (!varSym.owner.getQualifiedName().toString().endsWith(".Globals")) {
                            if (!this.context.useModules && !varSym.owner.equals(this.getParent(JCTree.JCClassDecl.class).sym)) {
                                prefix = this.context.getRootRelativeName(null, varSym.owner);
                                if (!StringUtils.isEmpty((CharSequence)prefix)) {
                                    this.print(this.context.getRootRelativeName(null, varSym.owner));
                                    if (lazyInitializedStatic && varSym.owner.isEnum()) {
                                        this.print(ENUM_WRAPPER_CLASS_SUFFIX);
                                    }
                                    this.print(".");
                                }
                            } else if (!varSym.owner.getSimpleName().toString().equals("globals")) {
                                this.print(varSym.owner.getSimpleName().toString());
                                this.ensureModuleIsUsed(varSym.owner);
                                if (lazyInitializedStatic && varSym.owner.isEnum()) {
                                    this.print(ENUM_WRAPPER_CLASS_SUFFIX);
                                }
                                this.print(".");
                            }
                        } else if (!this.context.useModules) {
                            prefix = this.context.getRootRelativeName(null, varSym.owner);
                            if (!(prefix = prefix.substring(0, prefix.length() - "Globals".length())).equals("globals.") && !prefix.endsWith(".globals.")) {
                                this.print(prefix);
                            }
                        }
                    }
                } else if (varSym.owner instanceof Symbol.MethodSymbol && this.isAnonymousClass() && ((LinkedHashSet)this.getScope(1).finalVariables.get(this.getScope(1).anonymousClasses.indexOf(this.getParent(JCTree.JCClassDecl.class)))).contains(varSym)) {
                    this.print("this.");
                } else {
                    if (!this.context.useModules && varSym.owner instanceof Symbol.MethodSymbol && this.context.importedTopPackages.contains(name)) {
                        name = "__var_" + name;
                    }
                    if (JSweetConfig.JS_KEYWORDS.contains(name)) {
                        name = "__" + name;
                    }
                }
            }
            if (ident.sym instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)ident.sym;
                boolean prefixAdded = false;
                if (this.getScope().defaultMethodScope && Util.isImported(this.getContext().getDefaultMethodCompilationUnit(this.getParent(JCTree.JCMethodDecl.class)), clazz)) {
                    String rootRelativeName = this.getRootRelativeName((Symbol)clazz.getEnclosingElement());
                    if (!rootRelativeName.isEmpty()) {
                        this.print(rootRelativeName + ".");
                        Symbol.PackageSymbol identifierPackage = clazz.packge();
                        String pathToModulePackage = Util.getRelativePath(this.compilationUnit.packge, identifierPackage);
                        if (pathToModulePackage == null) {
                            pathToModulePackage = ".";
                        }
                        File moduleFile = new File(new File(pathToModulePackage), clazz.owner.getSimpleName().toString());
                        this.useModule(false, false, identifierPackage, ident, clazz.owner.getSimpleName().toString(), moduleFile.getPath().replace('\\', '/'), null);
                    }
                    prefixAdded = true;
                }
                if (!prefixAdded && clazz.getEnclosingElement() instanceof Symbol.ClassSymbol) {
                    if (this.context.useModules) {
                        this.print(((Symbol)clazz.getEnclosingElement()).getSimpleName() + ".");
                        prefixAdded = true;
                    } else if (!this.getCompilationUnit().getImports().stream().map(i -> i.qualid.type == null ? null : i.qualid.type.tsym).anyMatch(t -> t == clazz)) {
                        this.print(this.getClassName((Symbol)clazz.getEnclosingElement()) + ".");
                        prefixAdded = true;
                    }
                }
                if (!(prefixAdded || this.context.useModules || clazz.equals(this.getParent(JCTree.JCClassDecl.class).sym))) {
                    this.print(this.getRootRelativeName(clazz));
                } else if (this.context.hasClassNameMapping(ident.sym)) {
                    this.print(this.context.getClassNameMapping(ident.sym));
                } else {
                    this.print(name);
                }
            } else {
                if (this.doesMemberNameRequireQuotes(name)) {
                    if (this.getLastPrintedChar() == '.') {
                        this.removeLastChar();
                        this.print("['").print(name).print("']");
                    } else {
                        this.print("this['").print(name).print("']");
                    }
                } else {
                    this.print(name);
                }
                if (lazyInitializedStatic && !this.staticInitializedAssignment) {
                    this.print("_$LI$()");
                }
            }
        }
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply typeApply) {
        this.substituteAndPrintType(typeApply);
    }

    private int initAnonymousClass(JCTree.JCNewClass newClass) {
        int anonymousClassIndex = this.getScope().anonymousClasses.indexOf(newClass.def);
        if (anonymousClassIndex == -1) {
            anonymousClassIndex = this.getScope().anonymousClasses.size();
            this.getScope().anonymousClasses.add(newClass.def);
            this.getScope().anonymousClassesConstructors.add(newClass);
            final LinkedHashSet finalVars = new LinkedHashSet();
            this.getScope().finalVariables.add(finalVars);
            new TreeScanner(){

                @Override
                public void visitIdent(JCTree.JCIdent var) {
                    Symbol.VarSymbol varSymbol;
                    if (var.sym != null && var.sym instanceof Symbol.VarSymbol && (varSymbol = (Symbol.VarSymbol)var.sym).getEnclosingElement() instanceof Symbol.MethodSymbol && ((Symbol)varSymbol.getEnclosingElement()).getEnclosingElement() == Java2TypeScriptTranslator.this.getParent(JCTree.JCClassDecl.class).sym) {
                        finalVars.add((Symbol.VarSymbol)var.sym);
                    }
                }
            }.visitClassDef(newClass.def);
        }
        return anonymousClassIndex;
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass newClass) {
        Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)newClass.clazz.type.tsym;
        if (clazz.getSimpleName().toString().equals("Globals")) {
            this.report((JCTree)newClass, JSweetProblem.GLOBAL_CANNOT_BE_INSTANTIATED, new Object[0]);
            return;
        }
        if (this.getScope().localClasses.stream().map(c -> c.type).anyMatch(t -> t.equals(newClass.type))) {
            this.print("new ").print(this.getScope().name + ".").print(newClass.clazz.toString());
            this.print("(").printConstructorArgList(newClass, true).print(")");
            return;
        }
        boolean isInterface = this.context.isInterface(clazz);
        if (newClass.def != null || isInterface) {
            if (this.context.isAnonymousClass(newClass)) {
                int anonymousClassIndex = this.initAnonymousClass(newClass);
                this.print("new ").print(this.getScope().name + "." + this.getScope().name + ANONYMOUS_PREFIX + anonymousClassIndex);
                if (newClass.def.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                    this.printAnonymousClassTypeArgs(newClass);
                }
                this.print("(").printConstructorArgList(newClass, false).print(")");
                return;
            }
            if (isInterface || this.context.hasAnnotationType(newClass.clazz.type.tsym, "jsweet.lang.ObjectType")) {
                if (isInterface) {
                    this.print("<any>");
                }
                HashSet<String> interfaces = new HashSet<String>();
                this.context.grabSupportedInterfaceNames(interfaces, clazz);
                if (!interfaces.isEmpty()) {
                    this.print("Object.defineProperty(");
                }
                this.print("{").println().startIndent();
                boolean statementPrinted = false;
                boolean initializationBlockFound = false;
                if (newClass.def != null) {
                    for (JCTree m : newClass.def.getMembers()) {
                        if (m instanceof JCTree.JCBlock) {
                            initializationBlockFound = true;
                            ArrayList<Symbol.VarSymbol> initializedVars = new ArrayList<Symbol.VarSymbol>();
                            for (JCTree jCTree : ((JCTree.JCBlock)m).stats) {
                                JCTree.JCMethodInvocation invocation;
                                MethodInvocationElement invocationElement;
                                boolean currentStatementPrinted = false;
                                if (jCTree instanceof JCTree.JCExpressionStatement && ((JCTree.JCExpressionStatement)jCTree).expr instanceof JCTree.JCAssign) {
                                    JCTree.JCAssign assignment = (JCTree.JCAssign)((JCTree.JCExpressionStatement)jCTree).expr;
                                    Symbol.VarSymbol var = null;
                                    if (assignment.lhs instanceof JCTree.JCFieldAccess) {
                                        var = Util.findFieldDeclaration(clazz, ((JCTree.JCFieldAccess)assignment.lhs).name);
                                        this.printIndent().print(((Name)var.getSimpleName()).toString());
                                    } else {
                                        if (!(assignment.lhs instanceof JCTree.JCIdent)) continue;
                                        var = Util.findFieldDeclaration(clazz, ((JCTree.JCIdent)assignment.lhs).name);
                                        this.printIndent().print(assignment.lhs.toString());
                                    }
                                    initializedVars.add(var);
                                    this.print(": ").print(assignment.rhs).print(",").println();
                                    currentStatementPrinted = true;
                                    statementPrinted = true;
                                } else if (jCTree instanceof JCTree.JCExpressionStatement && ((JCTree.JCExpressionStatement)jCTree).expr instanceof JCTree.JCMethodInvocation && (invocationElement = (MethodInvocationElement)ExtendedElementFactory.INSTANCE.create(invocation = (JCTree.JCMethodInvocation)((JCTree.JCExpressionStatement)jCTree).expr)).getMethodName().equals("$set")) {
                                    if (((List)invocation.getArguments()).size() == 3) {
                                        if ("this".equals(((JCTree.JCExpression)((List)invocation.getArguments()).get(0)).toString())) {
                                            this.printIndent().print((JCTree)invocation.args.tail.head).print(": ").print((JCTree)invocation.args.tail.tail.head).print(",").println();
                                        }
                                        currentStatementPrinted = true;
                                        statementPrinted = true;
                                    } else {
                                        this.printIndent().print((JCTree)invocation.args.head).print(": ").print((JCTree)invocation.args.tail.head).print(",").println();
                                        currentStatementPrinted = true;
                                        statementPrinted = true;
                                    }
                                }
                                if (currentStatementPrinted) continue;
                                this.report(jCTree, JSweetProblem.INVALID_INITIALIZER_STATEMENT, new Object[0]);
                            }
                            for (Symbol symbol : clazz.getEnclosedElements()) {
                                if (!(symbol instanceof Symbol.VarSymbol) || initializedVars.contains(symbol) || this.context.hasAnnotationType(symbol, "jsweet.lang.Optional")) continue;
                                this.report(m, JSweetProblem.UNINITIALIZED_FIELD, symbol);
                            }
                        }
                        if (!(m instanceof JCTree.JCMethodDecl)) continue;
                        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)m;
                        if (method.sym.isConstructor()) continue;
                        this.printIndent().print(method.getName() + ": (");
                        for (JCTree.JCVariableDecl jCVariableDecl : method.getParameters()) {
                            this.print(jCVariableDecl.getName() + ", ");
                        }
                        if (!((List)method.getParameters()).isEmpty()) {
                            this.removeLastChars(2);
                        }
                        this.print(") => ");
                        this.print(method.body);
                        this.print(",").println();
                        statementPrinted = true;
                    }
                    if (statementPrinted) {
                        this.removeLastChars(2);
                    }
                }
                if (!statementPrinted && !initializationBlockFound) {
                    for (Symbol s : clazz.getEnclosedElements()) {
                        if (!(s instanceof Symbol.VarSymbol) || this.context.hasAnnotationType(s, "jsweet.lang.Optional")) continue;
                        this.report((JCTree)newClass, JSweetProblem.UNINITIALIZED_FIELD, s);
                    }
                }
                this.println().endIndent().printIndent().print("}");
                if (!interfaces.isEmpty()) {
                    this.print(", '__interfaces', { configurable: true, value: ");
                    this.print("[");
                    for (String i : interfaces) {
                        this.print("\"").print(i).print("\",");
                    }
                    this.removeLastChar();
                    this.print("]");
                    this.print(" })");
                }
            } else {
                this.print("((target:").print(newClass.clazz).print(") => {").println().startIndent();
                for (JCTree m : newClass.def.getMembers()) {
                    if (!(m instanceof JCTree.JCBlock)) continue;
                    for (JCTree jCTree : ((JCTree.JCBlock)m).stats) {
                        JCTree.JCMethodInvocation invocation;
                        MethodInvocationElement invocationElement;
                        boolean currentStatementPrinted = false;
                        if (jCTree instanceof JCTree.JCExpressionStatement && ((JCTree.JCExpressionStatement)jCTree).expr instanceof JCTree.JCAssign) {
                            JCTree.JCAssign assignment = (JCTree.JCAssign)((JCTree.JCExpressionStatement)jCTree).expr;
                            Symbol.VarSymbol var = null;
                            if (assignment.lhs instanceof JCTree.JCFieldAccess) {
                                var = Util.findFieldDeclaration(clazz, ((JCTree.JCFieldAccess)assignment.lhs).name);
                                this.printIndent().print("target['").print(((Name)var.getSimpleName()).toString()).print("']");
                            } else {
                                if (!(assignment.lhs instanceof JCTree.JCIdent)) continue;
                                this.printIndent().print("target['").print(assignment.lhs.toString()).print("']");
                            }
                            this.print(" = ").print(assignment.rhs).print(";").println();
                            currentStatementPrinted = true;
                        } else if (jCTree instanceof JCTree.JCExpressionStatement && ((JCTree.JCExpressionStatement)jCTree).expr instanceof JCTree.JCMethodInvocation && (invocationElement = (MethodInvocationElement)ExtendedElementFactory.INSTANCE.create(invocation = (JCTree.JCMethodInvocation)((JCTree.JCExpressionStatement)jCTree).expr)).getMethodName().equals("$set")) {
                            if (((List)invocation.getArguments()).size() == 3) {
                                if ("this".equals(((JCTree.JCExpression)((List)invocation.getArguments()).get(0)).toString())) {
                                    this.printIndent().print("target[").print((JCTree)invocation.args.tail.head).print("]").print(" = ").print((JCTree)invocation.args.tail.tail.head).print(";").println();
                                }
                                currentStatementPrinted = true;
                            } else {
                                this.printIndent().print("target[").print((JCTree)invocation.args.head).print("]").print(" = ").print((JCTree)invocation.args.tail.head).print(";").println();
                                currentStatementPrinted = true;
                            }
                        }
                        if (currentStatementPrinted) continue;
                        this.report(jCTree, JSweetProblem.INVALID_INITIALIZER_STATEMENT, new Object[0]);
                    }
                }
                this.printIndent().print("return target;").println();
                this.println().endIndent().printIndent().print("})(");
                this.print("new ").print(newClass.clazz).print("(").printArgList(null, newClass.args).print("))");
            }
        } else if (this.context.hasAnnotationType(newClass.clazz.type.tsym, "jsweet.lang.ObjectType")) {
            this.print("{}");
        } else {
            this.getAdapter().substituteNewClass(new NewClassElementSupport(newClass));
        }
    }

    public void printDefaultNewClass(JCTree.JCNewClass newClass) {
        String mappedType = this.context.getTypeMappingTarget(newClass.clazz.type.toString());
        if (this.typeChecker.checkType(newClass, null, newClass.clazz)) {
            boolean applyVarargs = true;
            Symbol s = newClass.constructor;
            if (!(s instanceof Symbol.MethodSymbol)) {
                this.print("null/*cannot resolve " + newClass.clazz + "*/");
                return;
            }
            Symbol.MethodSymbol methSym = (Symbol.MethodSymbol)newClass.constructor;
            if (newClass.args.size() == 0 || !Util.hasVarargs(methSym) || newClass.args.last().type.getKind() != TypeKind.ARRAY || !this.context.types.erasure(((Type.ArrayType)newClass.args.last().type).elemtype).equals(this.context.types.erasure(((Type.ArrayType)((Symbol.VarSymbol)((List)methSym.getParameters()).last()).type).elemtype))) {
                applyVarargs = false;
            }
            if (applyVarargs) {
                this.context.addGlobalsMapping("Function", "__Function");
                this.print("<any>new (__Function.prototype.bind.apply(");
                if (mappedType != null) {
                    this.print(Java2TypeScriptTranslator.mapConstructorType(mappedType));
                } else {
                    this.print(newClass.clazz);
                }
                this.print(", [null");
                for (int i = 0; i < newClass.args.length() - 1; ++i) {
                    this.print(", ").print(newClass.args.get(i));
                }
                this.print("].concat(<any[]>").print(newClass.args.last()).print(")))");
            } else if (newClass.clazz instanceof JCTree.JCTypeApply) {
                JCTree.JCTypeApply typeApply = (JCTree.JCTypeApply)newClass.clazz;
                mappedType = this.context.getTypeMappingTarget(typeApply.clazz.type.toString());
                this.print("new ");
                if (mappedType != null) {
                    this.print(Java2TypeScriptTranslator.mapConstructorType(mappedType));
                } else {
                    this.print(typeApply.clazz);
                }
                if (!typeApply.arguments.isEmpty()) {
                    this.print("<").printTypeArgList(typeApply.arguments).print(">");
                } else {
                    this.printAnyTypeArguments(((List)((Symbol.ClassSymbol)newClass.clazz.type.tsym).getTypeParameters()).length());
                }
                this.print("(").printConstructorArgList(newClass, false).print(")");
            } else {
                if (newClass.constructorType instanceof Type.ErrorType) {
                    this.print("null/*cannot resolve constructor type " + newClass.clazz + "*/");
                    return;
                }
                this.print("new ");
                if (mappedType != null) {
                    this.print(Java2TypeScriptTranslator.mapConstructorType(mappedType));
                } else {
                    this.print(newClass.clazz);
                }
                this.print("(").printConstructorArgList(newClass, false).print(")");
            }
        }
    }

    public void printAnyTypeArguments(int count) {
        this.print("<");
        for (int i = 0; i < count; ++i) {
            this.print("any, ");
        }
        if (count > 0) {
            this.removeLastChars(2);
        }
        this.print(">");
    }

    @Override
    public AbstractTreePrinter printConstructorArgList(JCTree.JCNewClass newClass, boolean localClass) {
        boolean printed = false;
        if (localClass || this.getScope().anonymousClasses.contains(newClass.def) && !newClass.def.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            this.print("this");
            if (!newClass.args.isEmpty()) {
                this.print(", ");
            }
            printed = true;
        } else if (newClass.clazz.type.tsym.getEnclosingElement() instanceof Symbol.ClassSymbol && !newClass.clazz.type.tsym.getModifiers().contains((Object)Modifier.STATIC)) {
            Symbol.ClassSymbol parentSymbol;
            this.print("this");
            JCTree.JCClassDecl parent = this.getParent(JCTree.JCClassDecl.class);
            Symbol.ClassSymbol classSymbol = parentSymbol = parent == null ? null : parent.sym;
            if (newClass.clazz.type.tsym.getEnclosingElement() != parentSymbol) {
                this.print(".__parent");
            }
            if (!newClass.args.isEmpty()) {
                this.print(", ");
            }
            printed = true;
        }
        Type.MethodType t = (Type.MethodType)newClass.constructorType;
        this.printArgList(t == null ? null : t.argtypes, newClass.args);
        int index = this.getScope().anonymousClasses.indexOf(newClass.def);
        if (index >= 0 && !((LinkedHashSet)this.getScope().finalVariables.get(index)).isEmpty()) {
            if (printed || !newClass.args.isEmpty()) {
                this.print(", ");
            }
            for (Symbol.VarSymbol v : (LinkedHashSet)this.getScope().finalVariables.get(index)) {
                this.print(((Name)v.getSimpleName()).toString());
                this.print(", ");
            }
            this.removeLastChars(2);
        }
        return this;
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral literal) {
        String s = literal.toString();
        switch (literal.typetag) {
            case FLOAT: {
                if (!s.endsWith("F")) break;
                s = s.substring(0, s.length() - 1);
                break;
            }
            case LONG: {
                if (!s.endsWith("L")) break;
                s = s.substring(0, s.length() - 1);
                break;
            }
        }
        this.print(s);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess arrayAccess) {
        if (!this.getAdapter().substituteArrayAccess(new ArrayAccessElementSupport(arrayAccess))) {
            this.print(arrayAccess.indexed).print("[").substituteAndPrintAssignedExpression(this.context.symtab.intType, arrayAccess.index).print("]");
        }
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop foreachLoop) {
        String indexVarName = "index" + Util.getId();
        boolean[] hasLength = new boolean[]{false};
        Symbol.TypeSymbol targetType = foreachLoop.expr.type.tsym;
        Util.scanMemberDeclarationsInType(targetType, this.getAdapter().getErasedTypes(), element -> {
            if (element instanceof Symbol.VarSymbol && "length".equals(element.getSimpleName().toString()) && Util.isNumber(((Symbol.VarSymbol)element).type)) {
                hasLength[0] = true;
                return false;
            }
            return true;
        });
        if (!this.getAdapter().substituteForEachLoop(new ForeachLoopElementSupport(foreachLoop), hasLength[0], indexVarName)) {
            boolean noVariable;
            boolean bl = noVariable = foreachLoop.expr instanceof JCTree.JCIdent || foreachLoop.expr instanceof JCTree.JCFieldAccess;
            if (noVariable) {
                this.print("for(let " + indexVarName + "=0; " + indexVarName + " < ").print(foreachLoop.expr).print(".length; " + indexVarName + "++) {").println().startIndent().printIndent();
                this.print("let " + foreachLoop.var.name.toString() + " = ").print(foreachLoop.expr).print("[" + indexVarName + "];").println();
            } else {
                String arrayVarName = "array" + Util.getId();
                this.print("{").println().startIndent().printIndent();
                this.print("let " + arrayVarName + " = ").print(foreachLoop.expr).print(";").println().printIndent();
                this.print("for(let " + indexVarName + "=0; " + indexVarName + " < " + arrayVarName + ".length; " + indexVarName + "++) {").println().startIndent().printIndent();
                this.print("let " + foreachLoop.var.name.toString() + " = " + arrayVarName + "[" + indexVarName + "];").println();
            }
            this.visitBeforeForEachBody(foreachLoop);
            this.printIndent().print(foreachLoop.body);
            this.endIndent().println().printIndent().print("}");
            if (!noVariable) {
                this.endIndent().println().printIndent().print("}");
            }
        }
    }

    protected void visitBeforeForEachBody(JCTree.JCEnhancedForLoop foreachLoop) {
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree type) {
        switch (type.typetag) {
            case FLOAT: 
            case LONG: 
            case BYTE: 
            case DOUBLE: 
            case INT: 
            case SHORT: {
                this.print("number");
                break;
            }
            default: {
                this.print(type.toString());
            }
        }
    }

    private boolean singlePrecisionFloats() {
        return !this.context.options.isDisableSinglePrecisionFloats() && this.context.options.getEcmaTargetVersion().higherThan(EcmaScriptComplianceLevel.ES3);
    }

    @Override
    public void visitBinary(JCTree.JCBinary binary) {
        if (!this.getAdapter().substituteBinaryOperator(new BinaryOperatorElementSupport(binary))) {
            String op = binary.operator.name.toString();
            boolean forceParens = false;
            boolean booleanOp = false;
            if (this.context.types.isSameType(this.context.symtab.booleanType, this.context.types.unboxedTypeOrType(binary.lhs.type))) {
                booleanOp = true;
                if ("^".equals(op)) {
                    forceParens = true;
                }
                if ("|".equals(op) || "&".equals(op)) {
                    this.print("((lhs, rhs) => lhs " + op + op + " rhs)(").print(binary.lhs).print(", ").print(binary.rhs).print(")");
                    return;
                }
            }
            boolean closeParen = false;
            boolean truncate = false;
            if (Util.isIntegral(binary.type) && binary.getKind() == Tree.Kind.DIVIDE) {
                if (binary.type.getKind() == TypeKind.LONG) {
                    this.print("(n => n<0?Math.ceil(n):Math.floor(n))(");
                    closeParen = true;
                } else {
                    this.print("(");
                    truncate = true;
                }
            }
            if (this.singlePrecisionFloats() && binary.type.getKind() == TypeKind.FLOAT) {
                this.print("(<any>Math).fround(");
                closeParen = true;
            }
            boolean charWrapping = Util.isArithmeticOrLogicalOperator(binary.getKind()) || Util.isComparisonOperator(binary.getKind());
            boolean actualCharWrapping = false;
            if (charWrapping && this.context.types.isSameType(this.context.symtab.charType, this.context.types.unboxedTypeOrType(binary.lhs.type)) && binary.rhs.type.tsym != this.context.symtab.stringType.tsym) {
                actualCharWrapping = true;
                if (binary.lhs instanceof JCTree.JCLiteral) {
                    this.printBinaryLeftOperand(binary);
                    this.print(".charCodeAt(0)");
                } else {
                    this.print("(c => c.charCodeAt==null?<any>c:c.charCodeAt(0))(").print(binary.lhs).print(")");
                }
            } else {
                if (forceParens) {
                    this.print("(");
                }
                this.printBinaryLeftOperand(binary);
                if (forceParens) {
                    this.print(")");
                }
            }
            if (booleanOp) {
                if ("|".equals(op)) {
                    op = "||";
                } else if ("&".equals(op)) {
                    op = "&&";
                } else if ("^".equals(op)) {
                    op = "!==";
                }
            }
            if (("==".equals(op) || "!=".equals(op)) && charWrapping && this.context.types.isSameType(this.context.symtab.charType, this.context.types.unboxedTypeOrType(binary.rhs.type)) && binary.lhs.type.tsym != this.context.symtab.stringType.tsym) {
                actualCharWrapping = true;
            }
            if (!actualCharWrapping && ("==".equals(op) || "!=".equals(op))) {
                switch (this.getComparisonMode()) {
                    case FORCE_STRICT: {
                        op = op + "=";
                        break;
                    }
                    case STRICT: {
                        if (Util.isNullLiteral(binary.lhs) || Util.isNullLiteral(binary.rhs)) break;
                        op = op + "=";
                        break;
                    }
                }
            }
            this.space().print(op).space();
            if (charWrapping && this.context.types.isSameType(this.context.symtab.charType, this.context.types.unboxedTypeOrType(binary.rhs.type)) && binary.lhs.type.tsym != this.context.symtab.stringType.tsym) {
                if (binary.rhs instanceof JCTree.JCLiteral) {
                    this.printBinaryRightOperand(binary);
                    this.print(".charCodeAt(0)");
                } else {
                    this.print("(c => c.charCodeAt==null?<any>c:c.charCodeAt(0))(");
                    this.printBinaryRightOperand(binary);
                    this.print(")");
                }
            } else {
                if (forceParens) {
                    this.print("(");
                }
                this.printBinaryRightOperand(binary);
                if (forceParens) {
                    this.print(")");
                }
            }
            if (closeParen) {
                this.print(")");
            }
            if (truncate) {
                this.print("|0)");
            }
        }
    }

    protected void printBinaryRightOperand(JCTree.JCBinary binary) {
        this.print(binary.rhs);
    }

    protected void printBinaryLeftOperand(JCTree.JCBinary binary) {
        this.print(binary.lhs);
    }

    @Override
    public void visitIf(JCTree.JCIf ifStatement) {
        this.print("if").print(ifStatement.cond).print(" ");
        this.print(ifStatement.thenpart);
        if (!(ifStatement.thenpart instanceof JCTree.JCBlock) && !statementsWithNoSemis.contains(ifStatement.thenpart.getClass())) {
            this.print(";");
        }
        if (ifStatement.elsepart != null) {
            this.print(" else ");
            this.print(ifStatement.elsepart);
            if (!(ifStatement.elsepart instanceof JCTree.JCBlock) && !statementsWithNoSemis.contains(ifStatement.elsepart.getClass())) {
                this.print(";");
            }
        }
    }

    @Override
    public void visitReturn(JCTree.JCReturn returnStatement) {
        this.print("return");
        if (returnStatement.expr != null) {
            JCTree parentFunction = this.getFirstParent(JCTree.JCMethodDecl.class, JCTree.JCLambda.class);
            if (returnStatement.expr.type == null) {
                this.report((JCTree)returnStatement, JSweetProblem.CANNOT_ACCESS_THIS, parentFunction == null ? returnStatement.toString() : parentFunction.toString());
                return;
            }
            this.print(" ");
            Type returnType = null;
            if (parentFunction != null && parentFunction instanceof JCTree.JCMethodDecl) {
                returnType = ((JCTree.JCMethodDecl)parentFunction).restype.type;
            }
            if (!this.substituteAssignedExpression(returnType, returnStatement.expr)) {
                this.print(returnStatement.expr);
            }
        }
    }

    private Symbol.VarSymbol getStaticInitializedField(JCTree expr) {
        if (expr instanceof JCTree.JCIdent) {
            return this.context.lazyInitializedStatics.contains(((JCTree.JCIdent)expr).sym) ? (Symbol.VarSymbol)((JCTree.JCIdent)expr).sym : null;
        }
        if (expr instanceof JCTree.JCFieldAccess) {
            return this.context.lazyInitializedStatics.contains(((JCTree.JCFieldAccess)expr).sym) ? (Symbol.VarSymbol)((JCTree.JCFieldAccess)expr).sym : null;
        }
        return null;
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp assignOp) {
        if (!this.getAdapter().substituteAssignmentWithOperator(new AssignmentWithOperatorElementSupport(assignOp))) {
            boolean castToIntegral;
            this.staticInitializedAssignment = this.getStaticInitializedField(assignOp.lhs) != null;
            boolean expand = this.staticInitializedAssignment;
            boolean expandChar = this.context.types.isSameType(this.context.symtab.charType, this.context.types.unboxedTypeOrType(assignOp.lhs.type));
            this.print(assignOp.lhs);
            this.staticInitializedAssignment = false;
            String op = assignOp.operator.name.toString();
            if (this.context.types.isSameType(this.context.symtab.booleanType, this.context.types.unboxedTypeOrType(assignOp.lhs.type))) {
                if ("|".equals(op)) {
                    this.print(" = ").print(assignOp.rhs).print(" || ").print(assignOp.lhs);
                    return;
                }
                if ("&".equals(op)) {
                    this.print(" = ").print(assignOp.rhs).print(" && ").print(assignOp.lhs);
                    return;
                }
            }
            boolean bl = castToIntegral = "/".equals(op) && Util.isIntegral(assignOp.lhs.type) && Util.isIntegral(assignOp.rhs.type);
            if (expandChar) {
                this.print(" = String.fromCharCode(").substituteAndPrintAssignedExpression(this.context.symtab.intType, assignOp.lhs).print(" " + op + " ").substituteAndPrintAssignedExpression(this.context.symtab.intType, assignOp.rhs).print(")");
                return;
            }
            if (expand || castToIntegral) {
                this.print(" = ");
                if (castToIntegral) {
                    this.print("(n => n<0?Math.ceil(n):Math.floor(n))(");
                }
                this.print(assignOp.lhs);
                this.print(" " + op + " ");
                if (this.context.types.isSameType(this.context.symtab.charType, this.context.types.unboxedTypeOrType(assignOp.rhs.type))) {
                    this.substituteAndPrintAssignedExpression(this.context.symtab.intType, assignOp.rhs);
                } else {
                    this.printAssignWithOperatorRightOperand(assignOp);
                }
                if (castToIntegral) {
                    this.print(")");
                }
                return;
            }
            this.print(" " + op + "= ");
            if (this.context.types.isSameType(this.context.symtab.charType, this.context.types.unboxedTypeOrType(assignOp.rhs.type))) {
                boolean isLeftOperandString = assignOp.lhs.type.tsym == this.context.symtab.stringType.tsym;
                Type.JCPrimitiveType rightPromotedType = isLeftOperandString ? this.context.symtab.charType : this.context.symtab.intType;
                this.substituteAndPrintAssignedExpression(rightPromotedType, assignOp.rhs);
            } else {
                this.printAssignWithOperatorRightOperand(assignOp);
            }
        }
    }

    protected void printAssignWithOperatorRightOperand(JCTree.JCAssignOp assignOp) {
        this.print(assignOp.rhs);
    }

    @Override
    public void visitConditional(JCTree.JCConditional conditional) {
        this.print(conditional.cond);
        this.print("?");
        if (!this.substituteAssignedExpression(this.rootConditionalAssignedTypes.isEmpty() ? null : this.rootConditionalAssignedTypes.peek(), conditional.truepart)) {
            this.print(conditional.truepart);
        }
        this.print(":");
        if (!this.substituteAssignedExpression(this.rootConditionalAssignedTypes.isEmpty() ? null : this.rootConditionalAssignedTypes.peek(), conditional.falsepart)) {
            this.print(conditional.falsepart);
        }
        if (!this.rootConditionalAssignedTypes.isEmpty()) {
            this.rootConditionalAssignedTypes.pop();
        }
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop forLoop) {
        this.print("for(").printArgList(null, forLoop.init).print("; ").print(forLoop.cond).print("; ").printArgList(null, forLoop.step).print(") ");
        this.print("{");
        this.visitBeforeForBody(forLoop);
        this.print(forLoop.body).print(";");
        this.print("}");
    }

    protected void visitBeforeForBody(JCTree.JCForLoop forLoop) {
    }

    @Override
    public void visitContinue(JCTree.JCContinue continueStatement) {
        this.print("continue");
        if (continueStatement.label != null) {
            this.print(" ").print(continueStatement.label.toString());
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak breakStatement) {
        this.print("break");
        if (breakStatement.label != null) {
            this.print(" ").print(breakStatement.label.toString());
        }
    }

    @Override
    public void visitLabelled(final JCTree.JCLabeledStatement labelledStatement) {
        JCTree parent = this.getParent(JCTree.JCMethodDecl.class);
        if (parent == null) {
            parent = this.getParent(JCTree.JCBlock.class);
            while (parent != null && this.getParent(JCTree.JCBlock.class, parent) != null) {
                parent = this.getParent(JCTree.JCBlock.class, parent);
            }
        }
        final boolean[] used = new boolean[]{false};
        new TreeScanner(){

            @Override
            public void visitBreak(JCTree.JCBreak b) {
                if (b.label != null && labelledStatement.label.equals(b.label)) {
                    used[0] = true;
                }
            }

            @Override
            public void visitContinue(JCTree.JCContinue c) {
                if (c.label != null && labelledStatement.label.equals(c.label)) {
                    used[0] = true;
                }
            }
        }.scan(parent);
        if (!used[0]) {
            this.print("/*");
        }
        this.print(labelledStatement.label.toString()).print(":");
        if (!used[0]) {
            this.print("*/");
        }
        this.print(" ");
        this.print(labelledStatement.body);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree arrayType) {
        this.print(arrayType.elemtype).print("[]");
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray newArray) {
        if (newArray.elemtype != null) {
            this.typeChecker.checkType(newArray, null, newArray.elemtype);
        }
        if (newArray.dims != null && !newArray.dims.isEmpty()) {
            if (newArray.dims.size() == 1) {
                if (newArray.dims.head instanceof JCTree.JCLiteral && (Integer)((JCTree.JCLiteral)newArray.dims.head).value <= 10) {
                    boolean hasElements = false;
                    this.print("[");
                    for (int i = 0; i < (Integer)((JCTree.JCLiteral)newArray.dims.head).value; ++i) {
                        this.print(Util.getTypeInitialValue(newArray.elemtype.type) + ", ");
                        hasElements = true;
                    }
                    if (hasElements) {
                        this.removeLastChars(2);
                    }
                    this.print("]");
                } else {
                    this.print("(s => { let a=[]; while(s-->0) a.push(" + Util.getTypeInitialValue(newArray.elemtype.type) + "); return a; })(").print((JCTree)newArray.dims.head).print(")");
                }
            } else {
                this.print("<any> (function(dims) { let allocate = function(dims) { if(dims.length==0) { return " + Util.getTypeInitialValue(newArray.elemtype.type) + "; } else { " + VAR_DECL_KEYWORD + " array = []; for(" + VAR_DECL_KEYWORD + " i = 0; i < dims[0]; i++) { array.push(allocate(dims.slice(1))); } return array; }}; return allocate(dims);})");
                this.print("([");
                this.printArgList(null, newArray.dims);
                this.print("])");
            }
        } else {
            this.print("[");
            if (newArray.elems != null && !newArray.elems.isEmpty()) {
                for (JCTree.JCExpression e : newArray.elems) {
                    if (!this.rootArrayAssignedTypes.isEmpty()) {
                        if (!this.substituteAssignedExpression(this.rootArrayAssignedTypes.peek(), e)) {
                            this.print(e);
                        }
                    } else {
                        this.print(e);
                    }
                    this.print(", ");
                }
                this.removeLastChars(2);
                if (!this.rootArrayAssignedTypes.isEmpty()) {
                    this.rootArrayAssignedTypes.pop();
                }
            }
            this.print("]");
        }
    }

    @Override
    public void visitUnary(JCTree.JCUnary unary) {
        if (!this.getAdapter().substituteUnaryOperator(new UnaryOperatorElementSupport(unary))) {
            if (!this.inRollback) {
                JCTree.JCStatement statement = null;
                Symbol.VarSymbol[] staticInitializedField = new Symbol.VarSymbol[]{null};
                switch (unary.getTag()) {
                    case POSTDEC: 
                    case POSTINC: 
                    case PREDEC: 
                    case PREINC: {
                        staticInitializedField[0] = this.getStaticInitializedField(unary.arg);
                        boolean bl = this.staticInitializedAssignment = staticInitializedField[0] != null;
                        if (!this.staticInitializedAssignment) break;
                        statement = this.getParent(JCTree.JCStatement.class);
                    }
                }
                if (statement != null) {
                    this.rollback(statement, tree -> {
                        this.print(this.context.getRootRelativeName(null, (Symbol)staticInitializedField[0].getEnclosingElement())).print(".").print(((Name)staticInitializedField[0].getSimpleName()).toString() + STATIC_INITIALIZATION_SUFFIX + "();").println().printIndent();
                        this.inRollback = true;
                        this.scan((JCTree)tree);
                    });
                }
            } else {
                this.inRollback = false;
            }
            switch (unary.getTag()) {
                case POS: {
                    this.print("+").print(unary.arg);
                    break;
                }
                case NEG: {
                    this.print("-").print(unary.arg);
                    break;
                }
                case POSTDEC: 
                case POSTINC: {
                    this.print(unary.arg);
                    this.print(unary.operator.name.toString());
                    break;
                }
                default: {
                    this.print(unary.operator.name.toString());
                    this.print(unary.arg);
                }
            }
        }
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch switchStatement) {
        this.print("switch(");
        this.print(switchStatement.selector);
        if (this.context.types.isSameType(this.context.symtab.charType, this.context.types.unboxedTypeOrType(switchStatement.selector.type))) {
            this.print(".charCodeAt(0)");
        }
        this.print(") {").println();
        for (JCTree.JCCase caseStatement : switchStatement.cases) {
            this.printIndent();
            this.print(caseStatement);
        }
        this.printIndent().print("}");
    }

    protected void printCaseStatementPattern(JCTree.JCExpression pattern) {
    }

    @Override
    public void visitCase(JCTree.JCCase caseStatement) {
        if (caseStatement.pat != null) {
            this.print("case ");
            if (!this.getAdapter().substituteCaseStatementPattern(new CaseElementSupport(caseStatement), ExtendedElementFactory.INSTANCE.create(caseStatement.pat))) {
                if (caseStatement.pat.type.isPrimitive() || this.context.types.isSameType(this.context.symtab.stringType, caseStatement.pat.type)) {
                    if (caseStatement.pat instanceof JCTree.JCIdent) {
                        Object value = ((Symbol.VarSymbol)((JCTree.JCIdent)caseStatement.pat).sym).getConstValue();
                        if (this.context.types.isSameType(this.context.symtab.stringType, caseStatement.pat.type)) {
                            this.print("\"" + value + "\" /* " + caseStatement.pat + " */");
                        } else {
                            this.print("" + value + " /* " + caseStatement.pat + " */");
                        }
                    } else if (this.context.types.isSameType(this.context.symtab.charType, caseStatement.pat.type)) {
                        JCTree.JCExpression caseExpression = caseStatement.pat;
                        if (caseExpression instanceof JCTree.JCTypeCast) {
                            caseExpression = ((JCTree.JCTypeCast)caseExpression).expr;
                        }
                        if (caseExpression instanceof JCTree.JCLiteral) {
                            this.print("" + ((JCTree.JCLiteral)caseExpression).value + " /* " + caseStatement.pat + " */");
                        } else {
                            this.print(caseExpression);
                        }
                    } else {
                        this.print(caseStatement.pat);
                    }
                } else {
                    this.print(this.getRootRelativeName(caseStatement.pat.type.tsym) + "." + caseStatement.pat);
                    this.ensureModuleIsUsed(caseStatement.pat.type.tsym);
                }
            }
        } else {
            this.print("default");
        }
        this.print(":");
        this.println().startIndent();
        for (JCTree.JCStatement statement : caseStatement.stats) {
            this.printIndent();
            this.print(statement);
            if (!statementsWithNoSemis.contains(statement.getClass())) {
                this.print(";");
            }
            this.println();
        }
        this.endIndent();
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast cast) {
        if (this.substituteAssignedExpression(cast.type, cast.expr)) {
            return;
        }
        if (Util.isIntegral(cast.type)) {
            if (cast.type.getKind() == TypeKind.LONG) {
                this.print("(n => n<0?Math.ceil(n):Math.floor(n))(");
            } else {
                this.print("(");
            }
        }
        if (!this.context.hasAnnotationType(cast.clazz.type.tsym, "jsweet.lang.Erased", "jsweet.lang.ObjectType", JSweetConfig.ANNOTATION_FUNCTIONAL_INTERFACE)) {
            if (cast.expr.type.getKind() == TypeKind.TYPEVAR) {
                this.print("<any>");
            } else {
                this.print("<");
                this.substituteAndPrintType(cast.clazz).print(">");
                if (cast.expr.type.tsym.isInterface() || cast.type.tsym.isInterface() || cast.clazz.type.getKind() == TypeKind.TYPEVAR) {
                    this.print("<any>");
                }
            }
        }
        this.print(cast.expr);
        if (Util.isIntegral(cast.type)) {
            if (cast.type.getKind() == TypeKind.LONG) {
                this.print(")");
            } else {
                this.print("|0)");
            }
        }
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop doWhileLoop) {
        this.print("do ");
        this.print("{");
        this.visitBeforeDoWhileBody(doWhileLoop);
        if (doWhileLoop.body instanceof JCTree.JCBlock) {
            this.print(doWhileLoop.body);
        } else {
            this.print(doWhileLoop.body).print(";");
        }
        this.print("}");
        this.print(" while(").print(doWhileLoop.cond).print(")");
    }

    protected void visitBeforeDoWhileBody(JCTree.JCDoWhileLoop doWhileLoop) {
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop whileLoop) {
        this.print("while(").print(whileLoop.cond).print(") ");
        this.print("{");
        this.visitBeforeWhileBody(whileLoop);
        this.print(whileLoop.body);
        this.print("}");
    }

    protected void visitBeforeWhileBody(JCTree.JCWhileLoop whileLoop) {
    }

    @Override
    public void visitAssign(JCTree.JCAssign assign) {
        if (!this.getAdapter().substituteAssignment(new AssignmentElementSupport(assign))) {
            this.staticInitializedAssignment = this.getStaticInitializedField(assign.lhs) != null;
            this.print(assign.lhs).print(this.isAnnotationScope ? ": " : " = ");
            if (!this.substituteAssignedExpression(assign.lhs.type, assign.rhs)) {
                this.print(assign.rhs);
            }
            this.staticInitializedAssignment = false;
        }
    }

    @Override
    public void visitTry(JCTree.JCTry tryStatement) {
        boolean resourced;
        boolean bl = resourced = tryStatement.resources != null && !tryStatement.resources.isEmpty();
        if (resourced) {
            for (JCTree resource : tryStatement.resources) {
                this.print(resource).println(";").printIndent();
            }
        } else if (tryStatement.catchers.isEmpty() && tryStatement.finalizer == null) {
            this.report((JCTree)tryStatement, JSweetProblem.TRY_WITHOUT_CATCH_OR_FINALLY, new Object[0]);
        }
        this.print("try ").print(tryStatement.body);
        if (tryStatement.catchers.size() > 1) {
            this.print(" catch(__e) {").startIndent();
            for (JCTree.JCCatch catcher : tryStatement.catchers) {
                this.println().printIndent().print("if");
                this.printInstanceOf("__e", null, catcher.param.type);
                this.print(" {").startIndent().println().printIndent();
                this.print(catcher.param).print(" = <");
                this.substituteAndPrintType(catcher.param.getType());
                this.print(">__e;").println();
                this.printBlockStatements(catcher.body.getStatements());
                this.endIndent().println().printIndent().print("}");
            }
            this.endIndent().println().printIndent().print("}");
        } else if (tryStatement.catchers.size() == 1) {
            this.print((JCTree)tryStatement.catchers.head);
        }
        if (resourced || tryStatement.finalizer != null) {
            this.print(" finally {");
            if (resourced) {
                this.startIndent();
                for (JCTree resource : tryStatement.resources.reverse()) {
                    if (!(resource instanceof JCTree.JCVariableDecl)) continue;
                    this.println().printIndent().print(((JCTree.JCVariableDecl)resource).name + ".close();");
                }
                this.endIndent();
            }
            if (tryStatement.finalizer != null) {
                this.startIndent();
                for (JCTree.JCStatement statement : tryStatement.finalizer.getStatements()) {
                    this.println().printIndent().print(statement).print(";");
                }
                this.endIndent();
            }
            this.println().printIndent().print("}");
        }
    }

    @Override
    public void visitCatch(JCTree.JCCatch catcher) {
        this.print(" catch(").print(catcher.param.name.toString()).print(") ");
        this.print(catcher.body);
    }

    @Override
    public void visitLambda(JCTree.JCLambda lamba) {
        MethodInvocationElement invocation;
        boolean regularFunction = false;
        if (this.getParent() instanceof JCTree.JCMethodInvocation && ((JCTree.JCMethodInvocation)this.getParent()).meth.toString().endsWith("function") && this.getParentOfParent() instanceof JCTree.JCMethodInvocation && ((JCTree.JCMethodInvocation)this.getParentOfParent()).meth.toString().endsWith("$noarrow") && "jsweet.util.Lang".equals((invocation = (MethodInvocationElement)ExtendedElementFactory.INSTANCE.create(this.getParent())).getMethod().getEnclosingElement().toString())) {
            regularFunction = true;
        }
        HashMap<String, Symbol.VarSymbol> varAccesses = new HashMap<String, Symbol.VarSymbol>();
        Util.fillAllVariableAccesses(varAccesses, lamba);
        ArrayList finalVars = new ArrayList(varAccesses.values());
        if (!varAccesses.isEmpty()) {
            int parentIndex;
            int i;
            HashMap<String, Symbol.VarSymbol> varDefs = new HashMap<String, Symbol.VarSymbol>();
            JCTree.JCStatement statement = null;
            for (i = parentIndex = this.getStack().size() - 2; i > 0 && ((JCTree)this.getStack().get(i)).getKind() != Tree.Kind.LAMBDA_EXPRESSION && ((JCTree)this.getStack().get(i)).getKind() != Tree.Kind.METHOD; --i) {
                if (statement != null || !(this.getStack().get(i) instanceof JCTree.JCStatement)) continue;
                statement = (JCTree.JCStatement)this.getStack().get(i);
            }
            if (i >= 0 && ((JCTree)this.getStack().get(i)).getKind() != Tree.Kind.LAMBDA_EXPRESSION && statement != null) {
                Util.fillAllVariablesInScope(varDefs, this.getStack(), lamba, (JCTree)this.getStack().get(i));
            }
            finalVars.retainAll(varDefs.values());
        }
        if (!finalVars.isEmpty()) {
            this.print("((");
            for (Symbol.VarSymbol var : finalVars) {
                this.print(var.name.toString()).print(",");
            }
            this.removeLastChar();
            this.print(") => {").println().startIndent().printIndent().print("return ");
        }
        this.getScope().skipTypeAnnotations = true;
        if (regularFunction) {
            this.print("function(").printArgList(null, lamba.params).print(") ");
        } else {
            this.print("(").printArgList(null, lamba.params).print(") => ");
        }
        this.getScope().skipTypeAnnotations = false;
        this.print(lamba.body);
        if (!finalVars.isEmpty()) {
            this.endIndent().println().printIndent().print("})(");
            for (Symbol.VarSymbol var : finalVars) {
                this.print(var.name.toString()).print(",");
            }
            this.removeLastChar();
            this.print(")");
        }
    }

    @Override
    public void visitReference(JCTree.JCMemberReference memberReference) {
        Symbol.MethodSymbol method;
        boolean exprIsInstance;
        String memberReferenceSimpleName = ((Name)memberReference.expr.type.tsym.getSimpleName()).toString();
        boolean printAsInstanceMethod = !memberReference.sym.isStatic() && !"<init>".equals(memberReference.name.toString()) && !"Globals".equals(memberReferenceSimpleName);
        boolean bl = exprIsInstance = memberReference.expr.toString().equals("this") || memberReference.expr.toString().equals("super") || memberReference.expr instanceof JCTree.JCIdent && ((JCTree.JCIdent)memberReference.expr).sym instanceof Symbol.VarSymbol || memberReference.expr instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)memberReference.expr).sym instanceof Symbol.VarSymbol;
        if (memberReference.sym instanceof Symbol.MethodSymbol) {
            method = (Symbol.MethodSymbol)memberReference.sym;
            if (this.getParent() instanceof JCTree.JCTypeCast) {
                this.print("(");
            }
            this.print("(");
            int argumentsPrinted = 0;
            if (printAsInstanceMethod && !exprIsInstance) {
                this.print("instance$").print(memberReferenceSimpleName);
                this.print(",");
                ++argumentsPrinted;
            }
            if (method.getParameters() != null) {
                for (Symbol.VarSymbol var : method.getParameters()) {
                    this.print(var.name.toString());
                    this.print(",");
                    ++argumentsPrinted;
                }
            }
            if (argumentsPrinted > 0) {
                this.removeLastChar();
            }
            this.print(")");
            this.print(" => { return ");
        }
        if ("Globals".equals(((Name)memberReference.expr.type.tsym.getSimpleName()).toString())) {
            this.print(memberReference.name.toString());
        } else if ("<init>".equals(memberReference.name.toString())) {
            if (this.context.types.isArray(memberReference.expr.type)) {
                this.print("new Array<");
                this.substituteAndPrintType(((JCTree.JCArrayTypeTree)memberReference.expr).elemtype);
                this.print(">");
            } else {
                this.print("new ").print(memberReference.expr);
            }
        } else {
            if (printAsInstanceMethod && !exprIsInstance) {
                this.print("instance$").print(memberReferenceSimpleName);
            } else {
                this.print(memberReference.expr);
            }
            this.print(".").print(memberReference.name.toString());
        }
        if (memberReference.sym instanceof Symbol.MethodSymbol) {
            method = (Symbol.MethodSymbol)memberReference.sym;
            this.print("(");
            if (method.getParameters() != null) {
                for (Symbol.VarSymbol var : method.getParameters()) {
                    this.print(var.name.toString());
                    this.print(",");
                }
                if (!((List)method.getParameters()).isEmpty()) {
                    this.removeLastChar();
                }
            }
            this.print(")");
            this.print(" }");
            if (this.getParent() instanceof JCTree.JCTypeCast) {
                this.print(")");
            }
        }
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter typeParameter) {
        this.print(typeParameter.name.toString());
        if (typeParameter.bounds != null && !typeParameter.bounds.isEmpty()) {
            this.print(" extends ");
            for (JCTree.JCExpression e : typeParameter.bounds) {
                this.substituteAndPrintType(e).print(" & ");
            }
            this.removeLastChars(3);
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized sync) {
        this.report((JCTree)sync, JSweetProblem.SYNCHRONIZATION, new Object[0]);
        if (sync.body != null) {
            this.print(sync.body);
        }
    }

    public void print(String exprStr, JCTree expr) {
        if (exprStr == null) {
            this.print(expr);
        } else {
            this.print(exprStr);
        }
    }

    private void printInstanceOf(String exprStr, JCTree expr, Type type) {
        this.printInstanceOf(exprStr, expr, type, false);
    }

    private void printInstanceOf(String exprStr, JCTree expr, Type type, boolean checkFirstArrayElement) {
        if (!(this.getParent() instanceof JCTree.JCParens)) {
            this.print("(");
        }
        if (checkFirstArrayElement || !this.getAdapter().substituteInstanceof(exprStr, ExtendedElementFactory.INSTANCE.create(expr), type)) {
            if (TYPE_MAPPING.containsKey(type.toString())) {
                this.print("typeof ");
                this.print(exprStr, expr);
                if (checkFirstArrayElement) {
                    this.print("[0]");
                }
                this.print(" === ").print("'" + TYPE_MAPPING.get(type.toString()).toLowerCase() + "'");
            } else if (type.tsym.isEnum()) {
                this.print("typeof ");
                this.print(exprStr, expr);
                if (checkFirstArrayElement) {
                    this.print("[0]");
                }
                this.print(" === 'number'");
            } else if (type.toString().startsWith("jsweet.util.function.") || type.toString().startsWith("java.util.function.") || Runnable.class.getName().equals(type.toString()) || this.context.hasAnnotationType(type.tsym, JSweetConfig.ANNOTATION_FUNCTIONAL_INTERFACE)) {
                this.print("typeof ");
                this.print(exprStr, expr);
                if (checkFirstArrayElement) {
                    this.print("[0]");
                }
                this.print(" === 'function'");
                int parameterCount = this.context.getFunctionalTypeParameterCount(type);
                if (parameterCount != -1) {
                    this.print(" && (<any>");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print(").length == " + this.context.getFunctionalTypeParameterCount(type));
                }
            } else {
                this.print(exprStr, expr);
                if (checkFirstArrayElement) {
                    this.print("[0]");
                }
                if (this.context.isInterface(type.tsym)) {
                    this.print(" != null && ");
                    this.print("(");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print("[\"__interfaces\"]").print(" != null && ");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print("[\"__interfaces\"].indexOf(\"").print(type.tsym.getQualifiedName().toString()).print("\") >= 0");
                    this.print(" || ");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print(".constructor != null && ");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print(".constructor[\"__interfaces\"]").print(" != null && ");
                    this.print(exprStr, expr);
                    if (checkFirstArrayElement) {
                        this.print("[0]");
                    }
                    this.print(".constructor[\"__interfaces\"].indexOf(\"").print(type.tsym.getQualifiedName().toString()).print("\") >= 0");
                    if (CharSequence.class.getName().equals(type.tsym.getQualifiedName().toString())) {
                        this.print(" || typeof ");
                        this.print(exprStr, expr);
                        if (checkFirstArrayElement) {
                            this.print("[0]");
                        }
                        this.print(" === \"string\"");
                    }
                    this.print(")");
                } else if (type.tsym instanceof Symbol.TypeVariableSymbol || Object.class.getName().equals(type.tsym.getQualifiedName().toString())) {
                    this.print(" != null");
                } else {
                    String qualifiedName = this.getQualifiedTypeName(type.tsym, false, false);
                    if (qualifiedName.startsWith("{")) {
                        qualifiedName = "Object";
                    }
                    this.print(" != null");
                    if (!"any".equals(qualifiedName)) {
                        this.print(" && ");
                        this.print(exprStr, expr);
                        if (checkFirstArrayElement) {
                            this.print("[0]");
                        }
                        if (qualifiedName.startsWith("def.")) {
                            this.print(" instanceof ").print(qualifiedName);
                        } else {
                            this.print(" instanceof <any>").print(qualifiedName);
                        }
                        if (type instanceof Type.ArrayType) {
                            Type.ArrayType t = (Type.ArrayType)type;
                            this.print(" && (");
                            this.print(exprStr, expr);
                            if (checkFirstArrayElement) {
                                this.print("[0]");
                            }
                            this.print(".length==0 || ");
                            this.print(exprStr, expr);
                            this.print("[0] == null ||");
                            if (t.elemtype instanceof Type.ArrayType) {
                                this.print(exprStr, expr);
                                this.print("[0] instanceof Array");
                            } else {
                                this.printInstanceOf(exprStr, expr, t.elemtype, true);
                            }
                            this.print(")");
                        }
                    }
                }
            }
        }
        if (!(this.getParent() instanceof JCTree.JCParens)) {
            this.print(")");
        }
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf instanceOf) {
        this.printInstanceOf(null, instanceOf.expr, instanceOf.clazz.type);
    }

    @Override
    public void visitThrow(JCTree.JCThrow throwStatement) {
        this.print("throw ").print(throwStatement.expr);
    }

    @Override
    public void visitAssert(JCTree.JCAssert assertion) {
        if (!this.context.options.isIgnoreAssertions()) {
            String assertCode = assertion.toString().replace("\"", "'");
            this.print("if(!(").print(assertion.cond).print(")) throw new Error(\"Assertion error line " + this.getCurrentLine() + ": " + assertCode + "\");");
        }
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation annotation) {
        if (!this.context.hasAnnotationType(annotation.type.tsym, "jsweet.lang.Decorator")) {
            return;
        }
        if (this.getScope().isInterfaceScope()) {
            return;
        }
        this.print("@").print(annotation.getAnnotationType());
        if (annotation.getArguments() != null && !((List)annotation.getArguments()).isEmpty()) {
            this.print("(");
            this.isAnnotationScope = true;
            this.print(" { ");
            for (JCTree.JCExpression e : annotation.getArguments()) {
                this.print(e);
                this.print(", ");
            }
            this.removeLastChars(2);
            this.print(" } ");
            this.isAnnotationScope = false;
            this.print(")");
        } else {
            JCTree[] globalDecoratorFunction;
            boolean parens = true;
            if (annotation.getAnnotationType() instanceof JCTree.JCIdent && (globalDecoratorFunction = this.context.lookupGlobalMethod(((JCTree.JCIdent)annotation.getAnnotationType()).sym.toString())) != null && !((List)((JCTree.JCMethodDecl)globalDecoratorFunction[1]).sym.getParameters()).isEmpty()) {
                parens = false;
            }
            if (parens) {
                this.print("()");
            }
        }
        this.println().printIndent();
    }

    @Override
    protected boolean substituteAssignedExpression(Type assignedType, JCTree.JCExpression expression) {
        if (assignedType == null) {
            return false;
        }
        if (this.getAdapter().substituteAssignedExpression(assignedType, ExtendedElementFactory.INSTANCE.create(expression))) {
            return true;
        }
        if (assignedType.isInterface() && expression.type.tsym.isEnum()) {
            String relTarget = this.getRootRelativeName(expression.type.tsym);
            this.print("((wrappers, value) => wrappers===undefined?value:wrappers[value])(").print(relTarget).print("[\"_$wrappers\"], ").print(expression).print(")");
            return true;
        }
        if (expression instanceof JCTree.JCConditional) {
            this.rootConditionalAssignedTypes.push(assignedType);
            return false;
        }
        if (expression instanceof JCTree.JCNewArray && assignedType instanceof Type.ArrayType) {
            this.rootArrayAssignedTypes.push(((Type.ArrayType)assignedType).elemtype);
            return false;
        }
        if (assignedType.getTag() == TypeTag.CHAR && expression.type.getTag() != TypeTag.CHAR) {
            this.print("String.fromCharCode(").print(expression).print(")");
            return true;
        }
        if (Util.isNumber(assignedType) && expression.type.getTag() == TypeTag.CHAR) {
            this.print("(").print(expression).print(").charCodeAt(0)");
            return true;
        }
        if (this.singlePrecisionFloats() && assignedType.getTag() == TypeTag.FLOAT && expression.type.getTag() == TypeTag.DOUBLE) {
            this.print("(<any>Math).fround(").print(expression).print(")");
            return true;
        }
        if (expression instanceof JCTree.JCLambda) {
            if (assignedType.tsym.isInterface() && !this.context.isFunctionalType(assignedType.tsym)) {
                JCTree.JCLambda lambda = (JCTree.JCLambda)expression;
                Symbol.MethodSymbol method = (Symbol.MethodSymbol)assignedType.tsym.getEnclosedElements().get(0);
                this.print("{ " + method.getSimpleName() + " : ").print(lambda).print(" }");
                return true;
            }
        } else if (expression instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)expression;
            if (newClass.def != null && this.context.isFunctionalType(assignedType.tsym)) {
                List<JCTree> defs = newClass.def.defs;
                boolean printed = false;
                for (JCTree def : defs) {
                    if (!(def instanceof JCTree.JCMethodDecl)) continue;
                    if (printed) {
                        // empty if block
                    }
                    JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)def;
                    if (method.sym.isConstructor()) continue;
                    this.getStack().push(method);
                    this.print("(").printArgList(null, method.getParameters()).print(") => ").print(method.body);
                    this.getStack().pop();
                    printed = true;
                }
                if (printed) {
                    return true;
                }
            } else {
                if (newClass.def == null && this.context.isFunctionalType(assignedType.tsym)) {
                    for (Symbol s : assignedType.tsym.getEnclosedElements()) {
                        if (!(s instanceof Symbol.MethodSymbol)) continue;
                        Symbol.MethodSymbol method = (Symbol.MethodSymbol)s;
                        this.print("(");
                        for (Symbol.VarSymbol p : method.getParameters()) {
                            this.print(((Name)p.getSimpleName()).toString()).print(", ");
                        }
                        if (!((List)method.getParameters()).isEmpty()) {
                            this.removeLastChars(2);
                        }
                        this.print(") => { return new ").print(newClass.clazz).print("(").printArgList(null, newClass.args);
                        this.print(").").print(((Name)method.getSimpleName()).toString()).print("(");
                        for (Symbol.VarSymbol p : method.getParameters()) {
                            this.print(((Name)p.getSimpleName()).toString()).print(", ");
                        }
                        if (!((List)method.getParameters()).isEmpty()) {
                            this.removeLastChars(2);
                        }
                        this.print("); }");
                        return true;
                    }
                }
                if (!newClass.type.tsym.getTypeParameters().isEmpty() && newClass.typeargs.isEmpty()) {
                    this.print("<any>(").print(expression).print(")");
                    return true;
                }
            }
        } else {
            Symbol.MethodSymbol m;
            Symbol s;
            if (!(expression instanceof JCTree.JCLambda) && !(expression instanceof JCTree.JCMemberReference) && this.context.isFunctionalType(assignedType.tsym)) {
                this.print("<any>(").print(expression).print(")");
                return true;
            }
            if (expression instanceof JCTree.JCMethodInvocation && (s = Util.getAccessedSymbol(((JCTree.JCMethodInvocation)expression).meth)) instanceof Symbol.MethodSymbol && (m = (Symbol.MethodSymbol)s) != null && m.getReturnType() instanceof Type.TypeVar && m.getReturnType().tsym.getEnclosingElement() == m) {
                this.print("<any>(").print(expression).print(")");
                return true;
            }
        }
        return false;
    }

    @Override
    public String getQualifiedTypeName(Symbol.TypeSymbol type, boolean globals, boolean ignoreLangTypes) {
        String qualifiedName = super.getQualifiedTypeName(type, globals, ignoreLangTypes);
        String typeName = type.getQualifiedName().toString();
        if (!ignoreLangTypes && this.context.getLangTypeMappings().containsKey(typeName)) {
            qualifiedName = this.context.getLangTypeMappings().get(typeName);
        } else if (this.context.isMappedType(typeName)) {
            qualifiedName = this.context.getTypeMappingTarget(typeName);
            if (qualifiedName.endsWith("<>")) {
                qualifiedName = qualifiedName.substring(0, qualifiedName.length() - 2);
            }
        } else {
            if (this.context.useModules) {
                String[] namePath = qualifiedName.split("\\.");
                int i = namePath.length - 1;
                Symbol s = type;
                qualifiedName = "";
                while (i >= 0 && !(s instanceof Symbol.PackageSymbol)) {
                    qualifiedName = namePath[i--] + ("".equals(qualifiedName) ? "" : "." + qualifiedName);
                    s = ((Symbol)s).getEnclosingElement();
                }
            }
            if (globals) {
                int dotIndex = qualifiedName.lastIndexOf(".");
                qualifiedName = dotIndex == -1 ? "" : qualifiedName.substring(0, dotIndex);
            }
        }
        if (type.isEnum()) {
            qualifiedName = qualifiedName + ENUM_WRAPPER_CLASS_SUFFIX;
        }
        return qualifiedName;
    }

    static {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("java.lang.String", "String");
        mapping.put("java.lang.Number", "Number");
        mapping.put("java.lang.Integer", "Number");
        mapping.put("java.lang.Float", "Number");
        mapping.put("java.lang.Double", "Number");
        mapping.put("java.lang.Short", "Number");
        mapping.put("java.lang.Character", "String");
        mapping.put("java.lang.Byte", "Number");
        mapping.put("java.lang.Boolean", "Boolean");
        mapping.put("java.lang.Long", "Number");
        mapping.put("int", "Number");
        mapping.put("float", "Number");
        mapping.put("double", "Number");
        mapping.put("short", "Number");
        mapping.put("char", "String");
        mapping.put("boolean", "Boolean");
        mapping.put("byte", "Number");
        mapping.put("long", "Number");
        TYPE_MAPPING = Collections.unmodifiableMap(mapping);
        mapping = new HashMap();
        mapping.put("string", "String");
        mapping.put("number", "Number");
        mapping.put("boolean", "Boolean");
        mapping.put("any", "Object");
        CONSTRUCTOR_TYPE_MAPPING = Collections.unmodifiableMap(mapping);
    }

    class UsedTypesScanner
    extends TreeScanner {
        private HashSet<String> names = new HashSet();

        UsedTypesScanner() {
        }

        private void checkType(Symbol symbol) {
            String name;
            if (symbol instanceof Symbol.ClassSymbol && !this.names.contains(name = symbol.getSimpleName().toString())) {
                this.names.add(name);
                ModuleImportDescriptor moduleImport = Java2TypeScriptTranslator.this.getModuleImportDescriptor(name, (Symbol.ClassSymbol)symbol);
                if (moduleImport != null) {
                    Java2TypeScriptTranslator.this.useModule(false, moduleImport.isDirect(), moduleImport.getTargetPackage(), null, moduleImport.getImportedName(), moduleImport.getPathToImportedClass(), (Symbol)((Object)moduleImport.getImportedClass()));
                }
            }
        }

        @Override
        public void scan(JCTree t) {
            if (t instanceof JCTree.JCImport) {
                return;
            }
            if (t != null && t.type != null && t.type.tsym instanceof Symbol.ClassSymbol && !(t instanceof JCTree.JCTypeApply) && t instanceof JCTree.JCIdent && t.toString().equals(((Name)t.type.tsym.getSimpleName()).toString())) {
                this.checkType(t.type.tsym);
            }
            super.scan(t);
        }
    }

    private class AsyncCallsFinder
    extends AbstractTreeScanner {
        protected boolean found;

        public AsyncCallsFinder(TranspilationHandler logHandler, JSweetContext context, JCTree.JCCompilationUnit compilationUnit) {
            super(logHandler, context, compilationUnit);
            this.found = false;
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation methodInvocation) {
            Symbol.MethodSymbol method;
            Symbol methodSymbol = Util.getAccessedSymbol(methodInvocation.meth);
            if (methodSymbol instanceof Symbol.MethodSymbol && this.isAwait(method = (Symbol.MethodSymbol)methodSymbol)) {
                this.found = true;
                throw new RollbackException(methodInvocation, null);
            }
            super.visitApply(methodInvocation);
        }

        private boolean isAwait(Symbol.MethodSymbol method) {
            return method.owner.getQualifiedName().toString().equals("jsweet.util.Lang") && method.name.toString().equals("await");
        }
    }

    public static class ClassScope {
        private String name;
        private JCTree.JCMethodDecl mainMethod;
        private boolean interfaceScope = false;
        private boolean enumScope = false;
        private boolean isComplexEnum = false;
        private boolean enumWrapperClassScope = false;
        private boolean removedSuperclass = false;
        private boolean declareClassScope;
        private boolean skipTypeAnnotations = false;
        private boolean defaultMethodScope = false;
        private boolean eraseVariableTypes = false;
        private boolean hasDeclaredConstructor = false;
        private boolean innerClass = false;
        private boolean innerClassNotStatic = false;
        private boolean hasInnerClass = false;
        private java.util.List<JCTree.JCClassDecl> anonymousClasses = new ArrayList<JCTree.JCClassDecl>();
        private java.util.List<JCTree.JCNewClass> anonymousClassesConstructors = new ArrayList<JCTree.JCNewClass>();
        private java.util.List<LinkedHashSet<Symbol.VarSymbol>> finalVariables = new ArrayList<LinkedHashSet<Symbol.VarSymbol>>();
        private boolean hasConstructorOverloadWithSuperClass;
        private java.util.List<JCTree.JCVariableDecl> fieldsWithInitializers = new ArrayList<JCTree.JCVariableDecl>();
        private java.util.List<String> inlinedConstructorArgs = null;
        private java.util.List<JCTree.JCClassDecl> localClasses = new ArrayList<JCTree.JCClassDecl>();
        private java.util.List<String> generatedMethodNames = new ArrayList<String>();
        private boolean isAnonymousClass = false;
        private boolean isInnerClass = false;
        private boolean isLocalClass = false;
        private boolean constructor = false;
        private boolean decoratorScope = false;

        public String getName() {
            return this.name;
        }

        protected JCTree.JCMethodDecl getMainMethod() {
            return this.mainMethod;
        }

        protected boolean isInterfaceScope() {
            return this.interfaceScope;
        }

        public boolean isEnumScope() {
            return this.enumScope;
        }

        public boolean isComplexEnum() {
            return this.isComplexEnum;
        }

        public boolean isEnumWrapperClassScope() {
            return this.enumWrapperClassScope;
        }

        public boolean isRemovedSuperclass() {
            return this.removedSuperclass;
        }

        public boolean isDeclareClassScope() {
            return this.declareClassScope;
        }

        public boolean isSkipTypeAnnotations() {
            return this.skipTypeAnnotations;
        }

        public boolean isDefaultMethodScope() {
            return this.defaultMethodScope;
        }

        public boolean isEraseVariableTypes() {
            return this.eraseVariableTypes;
        }

        public void setEraseVariableTypes(boolean eraseVariableTypes) {
            this.eraseVariableTypes = eraseVariableTypes;
        }

        public boolean isHasDeclaredConstructor() {
            return this.hasDeclaredConstructor;
        }

        public boolean getInnerClass() {
            return this.innerClass;
        }

        public boolean isInnerClassNotStatic() {
            return this.innerClassNotStatic;
        }

        public boolean isHasInnerClass() {
            return this.hasInnerClass;
        }

        public java.util.List<JCTree.JCClassDecl> getAnonymousClasses() {
            return this.anonymousClasses;
        }

        public java.util.List<JCTree.JCNewClass> getAnonymousClassesConstructors() {
            return this.anonymousClassesConstructors;
        }

        public java.util.List<LinkedHashSet<Symbol.VarSymbol>> getFinalVariables() {
            return this.finalVariables;
        }

        public boolean isHasConstructorOverloadWithSuperClass() {
            return this.hasConstructorOverloadWithSuperClass;
        }

        public java.util.List<JCTree.JCVariableDecl> getFieldsWithInitializers() {
            return this.fieldsWithInitializers;
        }

        public java.util.List<String> getInlinedConstructorArgs() {
            return this.inlinedConstructorArgs;
        }

        public java.util.List<JCTree.JCClassDecl> getLocalClasses() {
            return this.localClasses;
        }

        public java.util.List<String> getGeneratedMethodNames() {
            return this.generatedMethodNames;
        }

        public boolean isAnonymousClass() {
            return this.isAnonymousClass;
        }

        public boolean isInnerClass() {
            return this.isInnerClass;
        }

        public boolean isLocalClass() {
            return this.isLocalClass;
        }

        public boolean isConstructor() {
            return this.constructor;
        }

        public boolean isDecoratorScope() {
            return this.decoratorScope;
        }
    }

    public static enum ComparisonMode {
        FORCE_STRICT,
        STRICT,
        LOOSE;

    }
}

