/*
 * Decompiled with CFR 0.152.
 */
package org.jsweet.transpiler;

import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapConsumerFactory;
import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.debugging.sourcemap.SourceMapping;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.gson.Gson;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jsweet.JSweetConfig;
import org.jsweet.transpiler.EcmaScriptComplianceLevel;
import org.jsweet.transpiler.JSweetContext;
import org.jsweet.transpiler.JSweetFactory;
import org.jsweet.transpiler.JSweetOptions;
import org.jsweet.transpiler.JSweetProblem;
import org.jsweet.transpiler.Java2TypeScriptTranslator;
import org.jsweet.transpiler.ModuleKind;
import org.jsweet.transpiler.ModuleResolution;
import org.jsweet.transpiler.OverloadScanner;
import org.jsweet.transpiler.SourceFile;
import org.jsweet.transpiler.SourcePosition;
import org.jsweet.transpiler.StaticInitilializerAnalyzer;
import org.jsweet.transpiler.TranspilationHandler;
import org.jsweet.transpiler.TypeScript2JavaScriptTranspiler;
import org.jsweet.transpiler.TypeScript2JavaScriptWithTscTranspiler;
import org.jsweet.transpiler.TypeScript2JavaScriptWithTsserverTranspiler;
import org.jsweet.transpiler.candy.CandyProcessor;
import org.jsweet.transpiler.eval.EvalOptions;
import org.jsweet.transpiler.eval.JavaEval;
import org.jsweet.transpiler.eval.JavaScriptEval;
import org.jsweet.transpiler.extension.ExtensionManager;
import org.jsweet.transpiler.extension.PrinterAdapter;
import org.jsweet.transpiler.util.DirectedGraph;
import org.jsweet.transpiler.util.ErrorCountTranspilationHandler;
import org.jsweet.transpiler.util.EvaluationResult;
import org.jsweet.transpiler.util.Position;
import org.jsweet.transpiler.util.ProcessUtil;
import org.jsweet.transpiler.util.SourceMap;
import org.jsweet.transpiler.util.Util;

public class JSweetTranspiler
implements JSweetOptions {
    public static final String TSC_VERSION = "3.7";
    public static final String TMP_WORKING_DIR_NAME = ".jsweet";
    public static final String EXPORTED_VAR_BEGIN = "EXPORT ";
    public static final String EXPORTED_VAR_END = ";";
    public static Pattern EXPORTED_VAR_REGEXP;
    private static final Logger logger;
    public static final String TSCROOTFILE = ".tsc-rootfile.ts";
    private JSweetFactory factory;
    private PrinterAdapter adapter;
    private long transpilationStartTimestamp;
    private JSweetContext context;
    private Options options;
    private JavaFileManager fileManager;
    private JavaCompiler compiler;
    private Log log;
    private CandyProcessor candiesProcessor;
    private boolean generateSourceMaps = false;
    private File workingDir;
    private File tsOutputDir;
    private File jsOutputDir;
    private String classPath;
    private boolean generateTsFiles = true;
    private boolean generateJsFiles = true;
    private boolean tscWatchMode = false;
    private final LinkedList<File> tsDefDirs = new LinkedList();
    private ModuleKind moduleKind = ModuleKind.none;
    private ModuleResolution moduleResolution = ModuleResolution.classic;
    private EcmaScriptComplianceLevel ecmaTargetVersion = EcmaScriptComplianceLevel.ES3;
    private boolean bundle = false;
    private String encoding = null;
    private String outEncoding = "UTF-8";
    private boolean noRootDirectories = false;
    private boolean ignoreAssertions = true;
    private boolean ignoreJavaFileNameError = false;
    private boolean generateDeclarations = false;
    private File declarationsOutputDir;
    private boolean generateDefinitions = true;
    private ArrayList<File> jsLibFiles = new ArrayList();
    private File sourceRoot = null;
    private boolean ignoreTypeScriptErrors = false;
    private boolean ignoreJavaErrors = false;
    private boolean forceJavaRuntime = false;
    private boolean isUsingJavaRuntime = false;
    private File headerFile = null;
    private boolean debugMode = false;
    private boolean skipTypeScriptChecks = false;
    private boolean disableSingleFloatPrecision = false;
    private boolean ignoreCandiesTypeScriptDefinitions = false;
    private ArrayList<String> adapters = new ArrayList();
    private File configurationFile;
    private TypeScript2JavaScriptTranspiler ts2jsTranspiler = new TypeScript2JavaScriptWithTscTranspiler();
    private Map<String, Object> configuration;
    private File baseDirectory;
    private File extractedCandyJavascriptDir;

    public static EcmaScriptComplianceLevel getEcmaTargetVersion(String targetVersion) {
        try {
            EcmaScriptComplianceLevel ecmaScriptComplianceLevel = EcmaScriptComplianceLevel.valueOf(targetVersion);
            return ecmaScriptComplianceLevel;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid EcmaScript target version: " + targetVersion);
        }
    }

    public void setUsingJavaRuntime(boolean usingJavaRuntime) {
        this.forceJavaRuntime = true;
        this.isUsingJavaRuntime = usingJavaRuntime;
    }

    public String toString() {
        return "workingDir=" + this.workingDir + "\ntsOutputDir=" + this.tsOutputDir + "\njsOutputDir=" + this.jsOutputDir + "\nclassPath=" + this.classPath + "\ngenerateJsFiles=" + this.generateJsFiles + "\ntscWatchMode=" + this.tscWatchMode + "\ntsDefDirs=" + this.tsDefDirs + "\nmoduleKind=" + (Object)((Object)this.moduleKind) + "\necmaTargertVersion=" + this.ecmaTargetVersion + "\nbundle=" + this.bundle + "\nencoding=" + this.encoding + "\nnoRootDirectories=" + this.noRootDirectories + "\nignoreAssertions=" + this.ignoreAssertions + "\nignoreJavaFileNameError=" + this.ignoreJavaFileNameError + "\ngenerateDeclarations=" + this.generateDeclarations + "\ndeclarationsOutputDir=" + this.declarationsOutputDir + "\ngenerateDefinitions=" + this.generateDefinitions + "\njsLibFiles=" + this.jsLibFiles;
    }

    public JSweetTranspiler(JSweetFactory factory) {
        this(factory, new File(System.getProperty("java.io.tmpdir")), null, null, System.getProperty("java.class.path"));
    }

    public JSweetTranspiler(JSweetFactory factory, File tsOutputDir, File jsOutputDir, File extractedCandiesJavascriptDir, String classPath) {
        this(factory, null, tsOutputDir, jsOutputDir, extractedCandiesJavascriptDir, classPath);
    }

    private <T> T getMapValue(Map<String, Object> map, String key) {
        return (T)map.get(key);
    }

    private void applyConfiguration() {
        if (this.configuration.containsKey("options")) {
            Map options = (Map)this.configuration.get("options");
            for (String key : options.keySet()) {
                if (ArrayUtils.contains((Object[])JSweetOptions.options, (Object)key)) continue;
                logger.error((Object)("unsupported option: " + key));
            }
            if (options.containsKey("bundle")) {
                this.setBundle((Boolean)this.getMapValue(options, "bundle"));
            }
            if (options.containsKey("noRootDirectories")) {
                this.setNoRootDirectories((Boolean)this.getMapValue(options, "noRootDirectories"));
            }
            if (options.containsKey("sourceMap")) {
                this.setGenerateSourceMaps((Boolean)this.getMapValue(options, "sourceMap"));
            }
            if (options.containsKey("module")) {
                this.setModuleKind(ModuleKind.valueOf((String)this.getMapValue(options, "module")));
            }
            if (options.containsKey("encoding")) {
                this.setEncoding((String)this.getMapValue(options, "encoding"));
            }
            if (options.containsKey("enableAssertions")) {
                this.setIgnoreAssertions((Boolean)this.getMapValue(options, "enableAssertions") == false);
            }
            if (options.containsKey("declaration")) {
                this.setGenerateDeclarations((Boolean)this.getMapValue(options, "declaration"));
            }
            if (options.containsKey("tsOnly")) {
                this.setGenerateJsFiles((Boolean)this.getMapValue(options, "tsOnly") == false);
            }
            if (options.containsKey("ignoreDefinitions")) {
                this.setGenerateDefinitions((Boolean)this.getMapValue(options, "ignoreDefinitions") == false);
            }
            if (options.containsKey("header")) {
                this.setHeaderFile(new File((String)this.getMapValue(options, "header")));
            }
            if (options.containsKey("disableSinglePrecisionFloats")) {
                this.setDisableSinglePrecisionFloats((Boolean)this.getMapValue(options, "disableSinglePrecisionFloats"));
            }
            if (options.containsKey("targetVersion")) {
                this.setEcmaTargetVersion(JSweetTranspiler.getEcmaTargetVersion((String)this.getMapValue(options, "targetVersion")));
            }
            if (options.containsKey("tsout")) {
                this.setTsOutputDir(new File((String)this.getMapValue(options, "tsout")));
            }
            if (options.containsKey("dtsout")) {
                this.setDeclarationsOutputDir(new File((String)this.getMapValue(options, "dtsout")));
            }
            if (options.containsKey("jsout")) {
                this.setJsOutputDir(new File((String)this.getMapValue(options, "jsout")));
            }
            if (options.containsKey("candiesJsOut")) {
                this.setJsOutputDir(new File((String)this.getMapValue(options, "candiesJsOut")));
            }
            if (options.containsKey("moduleResolution")) {
                this.setModuleResolution((ModuleResolution)((Object)this.getMapValue(options, "moduleResolution")));
            }
            if (options.containsKey("extraSystemPath")) {
                ProcessUtil.addExtraPath("extraSystemPath");
            }
        }
    }

    private void readConfiguration() {
        File confFile;
        File file = confFile = this.configurationFile == null ? new File(this.baseDirectory, "jsweetconfig.json") : this.configurationFile;
        if (confFile.exists()) {
            try {
                Map fromJson;
                logger.info((Object)("configuration file found: " + confFile));
                this.configuration = fromJson = (Map)new Gson().fromJson(FileUtils.readFileToString((File)confFile), Map.class);
                logger.debug((Object)("configuration: " + this.configuration));
                this.applyConfiguration();
            }
            catch (Exception e) {
                logger.warn((Object)"error reading configuration file", (Throwable)e);
            }
        } else {
            logger.info((Object)("no configuration file found at " + confFile.getAbsolutePath()));
        }
    }

    public JSweetTranspiler(JSweetFactory factory, File workingDir, File tsOutputDir, File jsOutputDir, File extractedCandiesJavascriptDir, String classPath) {
        this(null, factory, workingDir, tsOutputDir, tsOutputDir, extractedCandiesJavascriptDir, classPath);
    }

    public JSweetTranspiler(File configurationFile, JSweetFactory factory, File workingDir, File tsOutputDir, File jsOutputDir, File extractedCandiesJavascriptDir, String classPath) {
        this(null, configurationFile, factory, workingDir, tsOutputDir, jsOutputDir, extractedCandiesJavascriptDir, classPath);
    }

    public JSweetTranspiler(File baseDirectory, File configurationFile, JSweetFactory factory, File workingDir, File tsOutputDir, File jsOutputDir, File extractedCandiesJavascriptDir, String classPath) {
        if (baseDirectory == null) {
            baseDirectory = new File(".");
        }
        this.baseDirectory = baseDirectory;
        this.baseDirectory.mkdirs();
        this.configurationFile = configurationFile;
        this.factory = factory;
        this.readConfiguration();
        if (tsOutputDir == null) {
            tsOutputDir = new File(baseDirectory, "target/ts");
        }
        this.workingDir = workingDir == null ? new File(baseDirectory, TMP_WORKING_DIR_NAME).getAbsoluteFile() : workingDir.getAbsoluteFile();
        this.extractedCandyJavascriptDir = extractedCandiesJavascriptDir;
        try {
            tsOutputDir.mkdirs();
            this.tsOutputDir = tsOutputDir.getCanonicalFile();
            if (jsOutputDir != null && this.generateJsFiles) {
                jsOutputDir.mkdirs();
                this.jsOutputDir = jsOutputDir.getCanonicalFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("cannot locate output dirs", e);
        }
        File extensionDirectory = new File(baseDirectory, "jsweet_extension");
        classPath = classPath == null ? System.getProperty("java.class.path") : classPath;
        this.classPath = classPath = extensionDirectory.getAbsolutePath() + File.pathSeparator + classPath;
        logger.info((Object)("creating transpiler version " + JSweetConfig.getVersionNumber() + " (build date: " + JSweetConfig.getBuildDate() + ")"));
        logger.info((Object)("current dir: " + new File(".").getAbsolutePath()));
        logger.info((Object)("base directory: " + this.baseDirectory.getAbsolutePath()));
        logger.info((Object)("working directory: " + this.workingDir.getAbsolutePath()));
        logger.info((Object)("tsOut: " + tsOutputDir + (tsOutputDir == null ? "" : " - " + tsOutputDir.getAbsolutePath())));
        logger.info((Object)("jsOut: " + jsOutputDir + (jsOutputDir == null ? "" : " - " + jsOutputDir.getAbsolutePath())));
        logger.info((Object)("candyJsOut: " + extractedCandiesJavascriptDir));
        logger.info((Object)("factory: " + factory));
        logger.debug((Object)("compile classpath: " + classPath));
        logger.debug((Object)("runtime classpath: " + System.getProperty("java.class.path")));
        logger.debug((Object)("extension directory: " + extensionDirectory.getAbsolutePath()));
        this.candiesProcessor = new CandyProcessor(this.workingDir, classPath, this.extractedCandyJavascriptDir);
        new ExtensionManager(extensionDirectory.getAbsolutePath()).checkAndCompileExtension(this.workingDir, classPath);
    }

    public File getWorkingDirectory() {
        return this.workingDir;
    }

    public void initNode(TranspilationHandler transpilationHandler) throws Exception {
        ProcessUtil.initNode();
        File initFile = new File(this.workingDir, ".node-init");
        boolean initialized = initFile.exists();
        if (!initialized) {
            ProcessUtil.runCommand(ProcessUtil.NODE_COMMAND, currentNodeVersion -> {
                logger.info((Object)("node version: " + currentNodeVersion));
                if (!ProcessUtil.isVersionHighEnough(currentNodeVersion, "4.4.0")) {
                    transpilationHandler.report(JSweetProblem.NODE_OBSOLETE_VERSION, null, JSweetProblem.NODE_OBSOLETE_VERSION.getMessage(currentNodeVersion, "4.4.0"));
                }
            }, () -> {
                transpilationHandler.report(JSweetProblem.NODE_CANNOT_START, null, JSweetProblem.NODE_CANNOT_START.getMessage(new Object[0]));
                throw new RuntimeException("cannot find node.js");
            }, "--version");
            initFile.mkdirs();
            initFile.createNewFile();
        }
        String v = "";
        File tscVersionFile = new File(ProcessUtil.NPM_DIR, "tsc-version");
        if (tscVersionFile.exists()) {
            v = FileUtils.readFileToString((File)tscVersionFile);
        }
        if (!ProcessUtil.isExecutableInstalledGloballyWithNpm("tsc") || !v.trim().startsWith(TSC_VERSION)) {
            if (ProcessUtil.isExecutableInstalledGloballyWithNpm("tsc")) {
                ProcessUtil.uninstallGlobalNodePackage("typescript");
            }
            ProcessUtil.installGlobalNodePackage("typescript", TSC_VERSION);
            FileUtils.writeStringToFile((File)tscVersionFile, (String)TSC_VERSION);
        }
    }

    public void setTsDefDirs(File ... tsDefDirs) {
        this.clearTsDefDirs();
        this.tsDefDirs.addAll(Arrays.asList(tsDefDirs));
    }

    public void addTsDefDir(File tsDefDir) {
        if (!this.tsDefDirs.contains(tsDefDir)) {
            this.tsDefDirs.add(tsDefDir);
        }
    }

    public void clearTsDefDirs() {
        this.tsDefDirs.clear();
    }

    private void initJavac(TranspilationHandler transpilationHandler) {
        this.context = this.factory.createContext(this);
        this.context.setUsingJavaRuntime(this.forceJavaRuntime ? this.isUsingJavaRuntime : (this.candiesProcessor == null ? false : this.candiesProcessor.isUsingJavaRuntime()));
        this.options = Options.instance(this.context);
        if (this.classPath != null) {
            this.options.put(Option.CLASSPATH, this.classPath);
            for (String s : this.classPath.split(File.pathSeparator)) {
                if (!s.contains(JSweetConfig.MAVEN_JAVA_OVERRIDE_ARTIFACT)) continue;
                this.context.strictMode = true;
                this.options.put(Option.BOOTCLASSPATH, s);
            }
        }
        if (this.encoding != null) {
            this.options.put(Option.ENCODING, this.encoding);
        }
        logger.debug((Object)("encoding: " + this.options.get(Option.ENCODING)));
        logger.debug((Object)("strict mode: " + this.context.strictMode));
        this.options.put(Option.XLINT, "path");
        JavacFileManager.preRegister(this.context);
        this.fileManager = this.context.get(JavaFileManager.class);
        this.compiler = JavaCompiler.instance(this.context);
        this.compiler.attrParseOnly = true;
        this.compiler.verbose = false;
        this.compiler.genEndPos = true;
        this.compiler.keepComments = true;
        this.log = Log.instance(this.context);
        this.log.dumpOnError = false;
        this.log.emitWarnings = false;
        this.log.setWriters(new PrintWriter(new StringWriter(){

            @Override
            public void write(String str) {
            }
        }));
        this.log.setDiagnosticFormatter(this.factory.createDiagnosticHandler(transpilationHandler, this.context));
    }

    private boolean areAllTranspiled(SourceFile ... sourceFiles) {
        for (SourceFile file : sourceFiles) {
            if (file.getJsFile() != null) continue;
            return false;
        }
        return true;
    }

    public EvaluationResult eval(TranspilationHandler transpilationHandler, SourceFile ... sourceFiles) throws Exception {
        return this.eval("JavaScript", transpilationHandler, sourceFiles);
    }

    public EvaluationResult eval(String engineName, TranspilationHandler transpilationHandler, SourceFile ... sourceFiles) throws Exception {
        java.util.List<File> jsFiles;
        logger.info((Object)("[" + engineName + " engine] eval files: " + Arrays.asList(sourceFiles)));
        EvalOptions options = new EvalOptions(this.isUsingModules(), this.workingDir);
        if ("Java".equals(engineName)) {
            JavaEval evaluator = new JavaEval(this, options);
            return evaluator.performEval(sourceFiles);
        }
        if (!this.areAllTranspiled(sourceFiles)) {
            ErrorCountTranspilationHandler errorHandler = new ErrorCountTranspilationHandler(transpilationHandler);
            this.transpile((TranspilationHandler)errorHandler, Collections.emptySet(), sourceFiles);
            if (errorHandler.getErrorCount() > 0) {
                throw new Exception("unable to evaluate: transpilation errors remain");
            }
        }
        if (this.context.useModules) {
            File f = null;
            if (!this.context.entryFiles.isEmpty()) {
                f = this.context.entryFiles.get(0);
                for (SourceFile sf : sourceFiles) {
                    if (!sf.getJavaFile().equals(f)) continue;
                    f = sf.getJsFile();
                }
            }
            if (f == null) {
                f = sourceFiles[sourceFiles.length - 1].getJsFile();
            }
            jsFiles = Arrays.asList(f);
        } else {
            jsFiles = Stream.of(sourceFiles).map(sourceFile -> sourceFile.getJsFile()).collect(Collectors.toList());
        }
        JavaScriptEval evaluator = new JavaScriptEval(options, JavaScriptEval.JavaScriptRuntime.NodeJs);
        return evaluator.performEval(jsFiles);
    }

    public List<JCTree.JCCompilationUnit> setupCompiler(java.util.List<File> files, ErrorCountTranspilationHandler transpilationHandler) throws IOException {
        this.initJavac(transpilationHandler);
        List<JavaFileObject> fileObjects = Util.toJavaFileObjects(this.fileManager, files);
        logger.info((Object)("ENTER phase: " + fileObjects));
        transpilationHandler.setDisabled(this.isIgnoreJavaErrors());
        List<JCTree.JCCompilationUnit> compilationUnits = this.compiler.enterTrees(this.compiler.parseFiles(fileObjects));
        this.context.compilationUnits = compilationUnits.toArray(new JCTree.JCCompilationUnit[compilationUnits.size()]);
        if (transpilationHandler.getErrorCount() > 0) {
            logger.warn((Object)"errors during parse tree");
            return null;
        }
        logger.info((Object)"ATTRIBUTE phase");
        Queue<Env<AttrContext>> todo = this.compiler.attribute(this.compiler.todo);
        logger.info((Object)"FLOW phase");
        todo = this.compiler.flow(todo);
        logger.info((Object)"REPORT DEFERRED phase");
        this.compiler.reportDeferredDiagnostics();
        transpilationHandler.setDisabled(false);
        if (transpilationHandler.getErrorCount() > 0) {
            return null;
        }
        if (!this.generateTsFiles) {
            return null;
        }
        this.context.useModules = this.isUsingModules();
        boolean bl = this.context.useRequireForModules = this.moduleKind != ModuleKind.es2015;
        if (this.context.useModules && this.bundle) {
            this.context.useModules = false;
            this.context.moduleBundleMode = true;
        }
        this.adapter = this.factory.createAdapter(this.context);
        return compilationUnits;
    }

    private String ts2js(ErrorCountTranspilationHandler handler, String tsCode, String targetFileName) throws IOException {
        SourceFile sf = new SourceFile(null);
        sf.setTsFile(File.createTempFile(targetFileName, ".ts", this.tsOutputDir));
        sf.setJsFile(File.createTempFile(targetFileName, ".js", this.jsOutputDir));
        try {
            sf.tsFile.getParentFile().mkdirs();
            sf.tsFile.createNewFile();
            Files.write(sf.tsFile.toPath(), Arrays.asList(tsCode), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.ts2js(handler, new SourceFile[]{sf});
        try {
            return new String(Files.readAllBytes(sf.jsFile.toPath()));
        }
        catch (IOException ex) {
            return null;
        }
    }

    public synchronized void transpile(TranspilationHandler transpilationHandler, SourceFile ... files) throws IOException {
        this.transpile(transpilationHandler, Collections.emptySet(), files);
    }

    public synchronized void transpile(TranspilationHandler transpilationHandler, Set<String> excludedSourcePaths, SourceFile ... files) throws IOException {
        this.transpilationStartTimestamp = System.currentTimeMillis();
        SourceFile.touch(files);
        try {
            this.initNode(transpilationHandler);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        this.candiesProcessor.processCandies(transpilationHandler);
        if (!this.isIgnoreCandiesTypeScriptDefinitions()) {
            this.addTsDefDir(this.candiesProcessor.getCandiesTsdefsDir());
        }
        ErrorCountTranspilationHandler errorHandler = new ErrorCountTranspilationHandler(transpilationHandler);
        Collection jsweetSources = Arrays.asList(files).stream().filter(source -> source.getJavaFile() != null).collect(Collectors.toList());
        if (this.isIgnoreJavaErrors()) {
            errorHandler.report(JSweetProblem.USER_WARNING, null, "Java compilation errors are ignored - make sure you validate your Java code another way in order to avoid subsequent transpilation errors");
        }
        long startJava2TsTimeNanos = System.nanoTime();
        this.java2ts(errorHandler, excludedSourcePaths, jsweetSources.toArray(new SourceFile[0]));
        long endJava2TsTimeNanos = System.nanoTime();
        long startTs2JsTimeNanos = System.nanoTime();
        if (errorHandler.getErrorCount() == 0 && this.generateTsFiles && this.generateJsFiles) {
            this.ts2js(errorHandler, files);
        }
        long endTs2JsTimeNanos = System.nanoTime();
        if (!this.generateJsFiles || !this.generateTsFiles) {
            transpilationHandler.onCompleted(this, !this.isTscWatchMode(), files);
        }
        logger.info((Object)("transpilation process finished in " + (System.currentTimeMillis() - this.transpilationStartTimestamp) + " ms \n> java2ts: " + (double)(endJava2TsTimeNanos - startJava2TsTimeNanos) / 1000000.0 + "ms\n> ts2js: " + (double)(endTs2JsTimeNanos - startTs2JsTimeNanos) / 1000000.0 + "ms\n"));
    }

    private void ts2js(ErrorCountTranspilationHandler transpilationHandler, SourceFile[] sourceFiles) throws IOException {
        LinkedHashSet<SourceFile> tsSourceFiles = new LinkedHashSet<SourceFile>();
        for (SourceFile sourceFile : sourceFiles) {
            if (sourceFile.getTsFile() == null) continue;
            tsSourceFiles.add(sourceFile);
        }
        logger.info((Object)("ts2js on " + this.ts2jsTranspiler + " sourceFiles=" + sourceFiles.length));
        this.ts2jsTranspiler.ts2js(transpilationHandler, tsSourceFiles, this.tsDefDirs, this, this.isIgnoreTypeScriptErrors(), this::onTsTranspilationCompleted);
    }

    public void setUseTsserver(boolean useTsserver) {
        this.ts2jsTranspiler = useTsserver ? TypeScript2JavaScriptWithTsserverTranspiler.INSTANCE : new TypeScript2JavaScriptWithTscTranspiler();
    }

    private void java2ts(ErrorCountTranspilationHandler transpilationHandler, Set<String> excludedSourcePaths, SourceFile[] files) throws IOException {
        List<JCTree.JCCompilationUnit> compilationUnits = this.setupCompiler(Arrays.asList(SourceFile.toFiles(files)), transpilationHandler);
        if (compilationUnits == null) {
            return;
        }
        if (this.candiesProcessor.hasDeprecatedCandy()) {
            this.context.deprecatedApply = true;
            logger.warn((Object)"\n\n\n*********************************************************************\n*********************************************************************\n YOUR CLASSPATH CONTAINS JSweet v1.x CANDIES \n This can lead to unexpected behaviors, please contribute to https://github.com/jsweet-candies \n to add your library's typings \n*********************************************************************\n*********************************************************************\n\n");
        }
        this.context.sourceFiles = files;
        this.context.excludedSourcePaths = excludedSourcePaths;
        this.factory.createBeforeTranslationScanner(transpilationHandler, this.context).process(compilationUnits);
        if (this.context.useModules) {
            StaticInitilializerAnalyzer analizer = new StaticInitilializerAnalyzer(this.context);
            analizer.process(compilationUnits);
            this.generateTsFiles(transpilationHandler, files, compilationUnits);
        } else if (this.bundle) {
            this.generateTsBundle(transpilationHandler, files, compilationUnits);
        } else {
            this.generateTsFiles(transpilationHandler, files, compilationUnits);
        }
        this.log.flush();
    }

    private void generateModuleDefs(JCTree.JCCompilationUnit moduleDefs) throws IOException {
        StringBuilder out = new StringBuilder();
        for (String line : FileUtils.readLines((File)new File(moduleDefs.getSourceFile().getName()))) {
            if (!line.startsWith("///")) continue;
            out.append(line.substring(3));
        }
        FileUtils.write((File)new File(this.tsOutputDir, "module_defs.d.ts"), (CharSequence)out, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTsFiles(ErrorCountTranspilationHandler transpilationHandler, SourceFile[] files, List<JCTree.JCCompilationUnit> compilationUnits) throws IOException {
        new OverloadScanner(transpilationHandler, this.context).process(compilationUnits);
        if (this.isVerbose()) {
            this.context.dumpOverloads(System.out);
        }
        this.adapter.onTranspilationStarted();
        String[] headerLines = this.getHeaderLines();
        for (int i = 0; i < compilationUnits.length(); ++i) {
            if (this.context.isExcludedSourcePath(files[i].toString())) continue;
            try {
                JCTree.JCCompilationUnit cu = compilationUnits.get(i);
                if (this.isModuleDefsFile(cu)) {
                    if (!this.context.useModules) continue;
                    this.generateModuleDefs(cu);
                    continue;
                }
                logger.info((Object)("scanning " + cu.sourcefile.getName() + "..."));
                Java2TypeScriptTranslator printer = this.factory.createTranslator(this.adapter, transpilationHandler, this.context, cu, this.generateSourceMaps);
                printer.print(cu);
                if (StringUtils.isWhitespace((CharSequence)printer.getResult())) continue;
                String[] s = cu.getSourceFile().getName().split(File.separator.equals("\\") ? "\\\\" : File.separator);
                String cuName = s[s.length - 1];
                s = cuName.split("\\.");
                cuName = s[0];
                String javaSourceFileRelativeFullName = cu.packge.getQualifiedName().toString().replace(".", File.separator) + File.separator + cuName + ".java";
                files[i].javaSourceDirRelativeFile = new File(javaSourceFileRelativeFullName);
                files[i].javaSourceDir = new File(cu.getSourceFile().getName().substring(0, cu.getSourceFile().getName().length() - javaSourceFileRelativeFullName.length()));
                String packageName = this.isNoRootDirectories() ? this.context.getRootRelativeJavaName(cu.packge) : cu.packge.getQualifiedName().toString();
                String outputFileRelativePathNoExt = packageName.replace(".", File.separator) + File.separator + cuName;
                String outputFileRelativePath = outputFileRelativePathNoExt + (cu.packge.fullname.toString().startsWith("def.") ? ".d.ts" : ".ts");
                logger.info((Object)("output file: " + outputFileRelativePath));
                File outputFile = new File(this.tsOutputDir, outputFileRelativePath);
                outputFile.getParentFile().mkdirs();
                String outputFilePath = outputFile.getPath();
                PrintWriter out = new PrintWriter(outputFilePath, this.outEncoding);
                String headers = this.context.getHeaders();
                int headersLineCount = StringUtils.countMatches((CharSequence)headers, (CharSequence)"\n");
                try {
                    for (String line : headerLines) {
                        out.println(line);
                    }
                    out.print(headers);
                    out.println(printer.getResult());
                    out.print(this.context.getGlobalsMappingString());
                    out.print(this.context.getFooterStatements());
                }
                finally {
                    out.close();
                }
                files[i].tsFile = outputFile;
                files[i].javaFileLastTranspiled = files[i].getJavaFile().lastModified();
                printer.sourceMap.shiftOutputPositions(headerLines.length + headersLineCount);
                files[i].setSourceMap(printer.sourceMap);
                if (this.generateSourceMaps && !this.generateJsFiles) {
                    this.generateTypeScriptSourceMapFile(files[i]);
                }
                logger.info((Object)("created " + outputFilePath));
                continue;
            }
            finally {
                this.context.clearHeaders();
                this.context.clearFooterStatements();
            }
        }
        this.adapter.onTranspilationFinished();
    }

    private void generateTypeScriptSourceMapFile(SourceFile sourceFile) throws IOException {
        if (sourceFile.getSourceMap() == null) {
            return;
        }
        SourceMapGenerator generator = SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3);
        String javaSourceFilePath = sourceFile.getTsFile().getAbsoluteFile().getCanonicalFile().getParentFile().toPath().relativize(sourceFile.getJavaFile().getAbsoluteFile().getCanonicalFile().toPath()).toString();
        for (SourceMap.Entry entry : sourceFile.getSourceMap().getSortedEntries(new Comparator<SourceMap.Entry>(){

            @Override
            public int compare(SourceMap.Entry e1, SourceMap.Entry e2) {
                return e1.getOutputPosition().compareTo(e2.getOutputPosition());
            }
        })) {
            generator.addMapping(javaSourceFilePath, null, new FilePosition(entry.getInputPosition().getLine(), entry.getInputPosition().getColumn()), new FilePosition(entry.getOutputPosition().getLine(), entry.getOutputPosition().getColumn()), new FilePosition(entry.getOutputPosition().getLine(), entry.getOutputPosition().getColumn() + 1));
        }
        File outputFile = new File(sourceFile.getTsFile().getPath() + ".map");
        try (FileWriter writer = new FileWriter(outputFile, false);){
            generator.appendTo((Appendable)writer, sourceFile.getTsFile().getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isModuleDefsFile(JCTree.JCCompilationUnit cu) {
        return cu.getSourceFile().getName().equals("module_defs.java") || cu.getSourceFile().getName().endsWith("/module_defs.java");
    }

    private void generateTsBundle(ErrorCountTranspilationHandler transpilationHandler, SourceFile[] files, List<JCTree.JCCompilationUnit> compilationUnits) throws IOException {
        if (this.context.useModules) {
            return;
        }
        StaticInitilializerAnalyzer analizer = new StaticInitilializerAnalyzer(this.context);
        analizer.process(compilationUnits);
        ArrayList sourcesInCycle = new ArrayList();
        java.util.List<JCTree.JCCompilationUnit> orderedCompilationUnits = analizer.globalStaticInitializersDependencies.topologicalSort(n -> sourcesInCycle.add(n));
        if (!sourcesInCycle.isEmpty()) {
            transpilationHandler.report(JSweetProblem.CYCLE_IN_STATIC_INITIALIZER_DEPENDENCIES, null, JSweetProblem.CYCLE_IN_STATIC_INITIALIZER_DEPENDENCIES.getMessage(sourcesInCycle.stream().map(n -> ((JCTree.JCCompilationUnit)n.element).sourcefile.getName()).collect(Collectors.toList())));
            DirectedGraph.dumpCycles(sourcesInCycle, u -> u.sourcefile.getName());
            return;
        }
        new OverloadScanner(transpilationHandler, this.context).process(orderedCompilationUnits);
        this.adapter.onTranspilationStarted();
        logger.debug((Object)("ordered compilation units: " + orderedCompilationUnits.stream().map(cu -> cu.sourcefile.getName()).collect(Collectors.toList())));
        logger.debug((Object)("count: " + compilationUnits.size() + " (initial), " + orderedCompilationUnits.size() + " (ordered)"));
        int[] permutation = new int[orderedCompilationUnits.size()];
        StringBuilder permutationString = new StringBuilder();
        for (int i = 0; i < orderedCompilationUnits.size(); ++i) {
            permutation[i] = compilationUnits.indexOf(orderedCompilationUnits.get(i));
            permutationString.append("" + i + "=" + permutation[i] + EXPORTED_VAR_END);
        }
        logger.debug((Object)("permutation: " + permutationString.toString()));
        this.createBundle(transpilationHandler, files, permutation, orderedCompilationUnits, false);
        if (this.isGenerateDefinitions()) {
            this.createBundle(transpilationHandler, files, permutation, orderedCompilationUnits, true);
        }
        this.adapter.onTranspilationFinished();
    }

    private void initSourceFileJavaPaths(SourceFile file, JCTree.JCCompilationUnit cu) {
        String[] s = cu.getSourceFile().getName().split(File.separator.equals("\\") ? "\\\\" : File.separator);
        String cuName = s[s.length - 1];
        s = cuName.split("\\.");
        cuName = s[0];
        String javaSourceFileRelativeFullName = cu.packge.getQualifiedName().toString().replace(".", File.separator) + File.separator + cuName + ".java";
        file.javaSourceDirRelativeFile = new File(javaSourceFileRelativeFullName);
        file.javaSourceDir = new File(cu.getSourceFile().getName().substring(0, cu.getSourceFile().getName().length() - javaSourceFileRelativeFullName.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBundle(ErrorCountTranspilationHandler transpilationHandler, SourceFile[] files, int[] permutation, java.util.List<JCTree.JCCompilationUnit> orderedCompilationUnits, boolean definitionBundle) throws FileNotFoundException, UnsupportedEncodingException {
        this.context.bundleMode = true;
        StringBuilder sb = new StringBuilder();
        int lineCount = 0;
        for (String line : this.getHeaderLines()) {
            sb.append(line).append("\n");
            ++lineCount;
        }
        ArrayList<SourceFile> bundledFiles = new ArrayList<SourceFile>();
        for (int i = 0; i < orderedCompilationUnits.size(); ++i) {
            JCTree.JCCompilationUnit cu = orderedCompilationUnits.get(i);
            if (this.isModuleDefsFile(cu) || (cu.packge.fullname.toString().startsWith("def.") ? !definitionBundle : definitionBundle)) continue;
            logger.info((Object)("scanning " + cu.sourcefile.getName() + "..."));
            Java2TypeScriptTranslator printer = this.factory.createTranslator(this.adapter, transpilationHandler, this.context, cu, this.generateSourceMaps);
            printer.print(cu);
            printer.sourceMap.shiftOutputPositions(lineCount);
            files[permutation[i]].setSourceMap(printer.sourceMap);
            bundledFiles.add(files[permutation[i]]);
            sb.append(printer.getOutput());
            lineCount += printer.getCurrentLine() - 1;
            this.initSourceFileJavaPaths(files[permutation[i]], cu);
        }
        this.context.bundleMode = false;
        File bundleDirectory = this.tsOutputDir;
        if (!bundleDirectory.exists()) {
            bundleDirectory.mkdirs();
        }
        String bundleName = "bundle" + (definitionBundle ? ".d.ts" : ".ts");
        File outputFile = new File(bundleDirectory, bundleName);
        logger.info((Object)("creating bundle file: " + outputFile));
        outputFile.getParentFile().mkdirs();
        String outputFilePath = outputFile.getPath();
        try (PrintWriter out = new PrintWriter(outputFilePath, this.outEncoding);){
            String headers = this.context.getHeaders();
            out.print(headers);
            lineCount = StringUtils.countMatches((CharSequence)headers, (CharSequence)"\n");
            for (SourceFile sourceFile : bundledFiles) {
                sourceFile.getSourceMap().shiftOutputPositions(lineCount);
            }
            out.println(sb.toString());
            if (!definitionBundle) {
                out.print(this.context.getGlobalsMappingString());
            }
            out.print(this.context.getFooterStatements());
            this.context.clearFooterStatements();
            if (definitionBundle && this.context.getExportedElements() != null) {
                for (Map.Entry entry : this.context.getExportedElements().entrySet()) {
                    out.println();
                    out.print("declare module \"" + (String)entry.getKey() + "\"");
                    boolean exported = false;
                    for (Symbol element : (java.util.List)entry.getValue()) {
                        if (!(element instanceof Symbol.PackageSymbol) || this.context.isRootPackage(element)) continue;
                        out.print(" {");
                        out.println();
                        out.print("    export = " + this.context.getExportedElementName(element) + EXPORTED_VAR_END);
                        out.println();
                        out.print("}");
                        exported = true;
                        break;
                    }
                    if (!exported) {
                        out.print(EXPORTED_VAR_END);
                    }
                    out.println();
                }
            }
        }
        for (int i = 0; i < orderedCompilationUnits.size(); ++i) {
            JCTree.JCCompilationUnit cu = orderedCompilationUnits.get(i);
            if (cu.packge.fullname.toString().startsWith("def.") ? !definitionBundle : definitionBundle) continue;
            files[permutation[i]].tsFile = outputFile;
            files[permutation[i]].javaFileLastTranspiled = files[permutation[i]].getJavaFile().lastModified();
        }
        logger.info((Object)("created " + outputFilePath));
    }

    public synchronized SourceFile[] getWatchedFiles() {
        return ((TypeScript2JavaScriptWithTscTranspiler)this.ts2jsTranspiler).getWatchedFiles().toArray(new SourceFile[0]);
    }

    public synchronized SourceFile getWatchedFile(File javaFile) {
        return ((TypeScript2JavaScriptWithTscTranspiler)this.ts2jsTranspiler).getWatchedFile(javaFile);
    }

    @Override
    public synchronized boolean isTscWatchMode() {
        return this.tscWatchMode;
    }

    public synchronized void setTscWatchMode(boolean tscWatchMode) {
        this.tscWatchMode = tscWatchMode;
        if (!tscWatchMode) {
            ((TypeScript2JavaScriptWithTscTranspiler)this.ts2jsTranspiler).stopWatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTsTranspilationCompleted(boolean fullPass, ErrorCountTranspilationHandler handler, Collection<SourceFile> files) {
        block27: {
            try {
                if (this.isGenerateDeclarations() && this.getDeclarationsOutputDir() != null) {
                    logger.info((Object)("moving d.ts files to " + this.getDeclarationsOutputDir()));
                    LinkedList<File> dtsFiles = new LinkedList<File>();
                    File rootDir = this.jsOutputDir == null ? this.tsOutputDir : this.jsOutputDir;
                    Util.addFiles(".d.ts", rootDir, dtsFiles);
                    for (File dtsFile : dtsFiles) {
                        String relativePath = Util.getRelativePath(rootDir.getAbsolutePath(), dtsFile.getAbsolutePath());
                        File targetFile = new File(this.getDeclarationsOutputDir(), relativePath);
                        logger.info((Object)("moving " + dtsFile + " to " + targetFile));
                        if (targetFile.exists()) {
                            FileUtils.deleteQuietly((File)targetFile);
                        }
                        try {
                            FileUtils.moveFile((File)dtsFile, (File)targetFile);
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (handler.getErrorCount() != 0) break block27;
                HashSet<File> handledFiles = new HashSet<File>();
                for (SourceFile sourceFile : files) {
                    File outputFile;
                    if (!sourceFile.getTsFile().getAbsolutePath().startsWith(this.tsOutputDir.getAbsolutePath())) {
                        throw new RuntimeException("ts directory isn't configured properly, please use setTsDir: " + sourceFile.getTsFile().getAbsolutePath() + " != " + this.tsOutputDir.getAbsolutePath());
                    }
                    String outputFileRelativePath = sourceFile.getTsFile().getAbsolutePath().substring(this.tsOutputDir.getAbsolutePath().length());
                    sourceFile.jsFile = outputFile = new File(this.jsOutputDir == null ? this.tsOutputDir : this.jsOutputDir, Util.removeExtension(outputFileRelativePath) + ".js");
                    if (outputFile.lastModified() <= sourceFile.jsFileLastTranspiled || handledFiles.contains(outputFile)) continue;
                    handledFiles.add(outputFile);
                    logger.info((Object)("js output file: " + outputFile));
                    File mapFile = new File(outputFile.getAbsolutePath() + ".map");
                    if (!mapFile.exists() || !this.generateSourceMaps) continue;
                    SourceMapGeneratorV3 generator = (SourceMapGeneratorV3)SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3);
                    Path javaSourcePath = sourceFile.javaSourceDir.getCanonicalFile().toPath();
                    String sourceRoot = this.getSourceRoot() != null ? this.getSourceRoot().toString() : sourceFile.getJsFile().getParentFile().getCanonicalFile().toPath().relativize(javaSourcePath) + "/";
                    generator.setSourceRoot(sourceRoot);
                    sourceFile.jsMapFile = mapFile;
                    logger.info((Object)("redirecting map file: " + mapFile));
                    String contents = FileUtils.readFileToString((File)mapFile);
                    SourceMapping mapping = SourceMapConsumerFactory.parse((String)contents);
                    int line = 1;
                    int columnIndex = 0;
                    for (String lineContent : FileUtils.readLines((File)outputFile, (Charset)null)) {
                        SourcePosition originPosition;
                        for (columnIndex = 0; columnIndex < lineContent.length() && (lineContent.charAt(columnIndex) == ' ' || lineContent.charAt(columnIndex) == '\t'); ++columnIndex) {
                        }
                        Mapping.OriginalMapping originalMapping = mapping.getMappingForLine(line, columnIndex + 1);
                        if (originalMapping != null && (originPosition = SourceFile.findOriginPosition(new SourcePosition(sourceFile.tsFile, null, new Position(originalMapping.getLineNumber(), originalMapping.getColumnPosition())), files)) != null) {
                            generator.addMapping(javaSourcePath.relativize(originPosition.getFile().getCanonicalFile().toPath()).toString(), null, new FilePosition(originPosition.getStartLine() - 1, 0), new FilePosition(line - 1, 0), new FilePosition(line - 1, lineContent.length() - 1));
                        }
                        ++line;
                    }
                    try {
                        FileWriter writer = new FileWriter(mapFile, false);
                        Throwable throwable = null;
                        try {
                            generator.appendTo((Appendable)writer, outputFile.getName());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (writer == null) continue;
                            if (throwable != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            writer.close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                handler.onCompleted(this, fullPass, files.toArray(new SourceFile[0]));
            }
        }
    }

    @Override
    @Deprecated
    public boolean isPreserveSourceLineNumbers() {
        return this.generateSourceMaps;
    }

    @Override
    public boolean isGenerateSourceMaps() {
        return this.generateSourceMaps;
    }

    @Deprecated
    public void setPreserveSourceLineNumbers(boolean preserveSourceLineNumbers) {
        this.generateSourceMaps = preserveSourceLineNumbers;
    }

    public void setGenerateSourceMaps(boolean generateSourceMaps) {
        this.generateSourceMaps = generateSourceMaps;
    }

    @Override
    public File getTsOutputDir() {
        return this.tsOutputDir;
    }

    public void setTsOutputDir(File tsOutputDir) {
        this.tsOutputDir = tsOutputDir;
    }

    @Override
    public File getJsOutputDir() {
        return this.jsOutputDir;
    }

    public void setJsOutputDir(File jsOutputDir) {
        this.jsOutputDir = jsOutputDir;
    }

    @Override
    public boolean isGenerateJsFiles() {
        return this.generateJsFiles;
    }

    public void setGenerateJsFiles(boolean generateJsFiles) {
        this.generateJsFiles = generateJsFiles;
    }

    public synchronized void resetTscWatchMode() {
        this.setTscWatchMode(false);
        this.setTscWatchMode(true);
    }

    public CandyProcessor getCandiesProcessor() {
        return this.candiesProcessor;
    }

    public void setEcmaTargetVersion(EcmaScriptComplianceLevel ecmaTargetVersion) {
        this.ecmaTargetVersion = ecmaTargetVersion;
    }

    @Override
    public EcmaScriptComplianceLevel getEcmaTargetVersion() {
        return this.ecmaTargetVersion;
    }

    @Override
    public ModuleKind getModuleKind() {
        return this.moduleKind;
    }

    public void setModuleKind(ModuleKind moduleKind) {
        this.moduleKind = moduleKind;
    }

    @Override
    public ModuleResolution getModuleResolution() {
        return this.moduleResolution;
    }

    public void setModuleResolution(ModuleResolution moduleResolution) {
        this.moduleResolution = moduleResolution;
    }

    public void setSkipTypeScriptChecks(boolean skipTypeScriptChecks) {
        this.skipTypeScriptChecks = skipTypeScriptChecks;
    }

    @Override
    public boolean isSkipTypeScriptChecks() {
        return this.skipTypeScriptChecks;
    }

    @Override
    public boolean isUsingModules() {
        return this.moduleKind != null && this.moduleKind != ModuleKind.none;
    }

    @Override
    public boolean isBundle() {
        return this.bundle;
    }

    public void setBundle(boolean bundle) {
        this.bundle = bundle;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getOutEncoding() {
        return this.outEncoding;
    }

    public void setOutEncoding(String encoding) {
        this.outEncoding = encoding;
    }

    @Override
    public boolean isNoRootDirectories() {
        return this.noRootDirectories;
    }

    public void setNoRootDirectories(boolean noRootDirectories) {
        this.noRootDirectories = noRootDirectories;
    }

    @Override
    public boolean isIgnoreAssertions() {
        return this.ignoreAssertions;
    }

    public void setIgnoreAssertions(boolean ignoreAssertions) {
        this.ignoreAssertions = ignoreAssertions;
    }

    @Override
    public boolean isIgnoreJavaFileNameError() {
        return this.ignoreJavaFileNameError;
    }

    public void setIgnoreJavaFileNameError(boolean ignoreJavaFileNameError) {
        this.ignoreJavaFileNameError = ignoreJavaFileNameError;
    }

    @Override
    public boolean isGenerateDeclarations() {
        return this.generateDeclarations;
    }

    public void setGenerateDeclarations(boolean generateDeclarations) {
        this.generateDeclarations = generateDeclarations;
    }

    @Override
    public File getDeclarationsOutputDir() {
        return this.declarationsOutputDir;
    }

    public void setDeclarationsOutputDir(File declarationsOutputDir) {
        this.declarationsOutputDir = declarationsOutputDir;
    }

    @Override
    public File getExtractedCandyJavascriptDir() {
        return this.extractedCandyJavascriptDir;
    }

    public void addJsLibFiles(File ... files) {
        this.jsLibFiles.addAll(Arrays.asList(files));
    }

    public void clearJsLibFiles() {
        this.jsLibFiles.clear();
    }

    public String transpile(ErrorCountTranspilationHandler handler, JCTree tree, String targetFileName) throws IOException {
        Java2TypeScriptTranslator translator = this.factory.createTranslator(this.adapter, handler, this.context, null, false);
        translator.enterScope();
        translator.scan(tree);
        translator.exitScope();
        String tsCode = translator.getResult();
        return this.ts2js(handler, tsCode, targetFileName);
    }

    @Override
    public boolean isGenerateDefinitions() {
        return this.generateDefinitions;
    }

    public void setGenerateDefinitions(boolean generateDefinitions) {
        this.generateDefinitions = generateDefinitions;
    }

    @Override
    public File getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(File sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isIgnoreTypeScriptErrors() {
        return this.ignoreTypeScriptErrors;
    }

    public void setIgnoreTypeScriptErrors(boolean ignoreTypeScriptErrors) {
        this.ignoreTypeScriptErrors = ignoreTypeScriptErrors;
    }

    @Override
    public File getHeaderFile() {
        return this.headerFile;
    }

    public void setHeaderFile(File headerFile) {
        this.headerFile = headerFile;
    }

    private String[] getHeaderLines() {
        Object[] headerLines = null;
        if (this.getHeaderFile() != null) {
            try {
                headerLines = FileUtils.readLines((File)this.getHeaderFile(), (String)this.getEncoding()).toArray(new String[0]);
            }
            catch (Exception e) {
                logger.error((Object)("cannot read header file: " + this.getHeaderFile() + " - using default header"));
            }
        }
        if (headerLines == null) {
            headerLines = new String[]{"/* Generated from Java with JSweet " + JSweetConfig.getVersionNumber() + " - http://www.jsweet.org */"};
        }
        if (this.context.options.isDebugMode()) {
            headerLines = (String[])ArrayUtils.add(headerLines, (Object)"declare function __debug_exec(className, functionName, argNames, target, args, generator);");
            headerLines = (String[])ArrayUtils.add((Object[])headerLines, (Object)"declare function __debug_result(expression);");
        }
        return headerLines;
    }

    @Override
    public boolean isGenerateTsFiles() {
        return this.generateTsFiles;
    }

    public void setGenerateTsFiles(boolean generateTsFiles) {
        this.generateTsFiles = generateTsFiles;
    }

    @Override
    public boolean isIgnoreJavaErrors() {
        return this.ignoreJavaErrors;
    }

    public void setIgnoreJavaErrors(boolean ignoreJavaErrors) {
        this.ignoreJavaErrors = ignoreJavaErrors;
    }

    public JSweetContext getContext() {
        return this.context;
    }

    public Options getOptions() {
        return this.options;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public boolean isVerbose() {
        return LogManager.getLogger((String)"org.jsweet").getLevel() == Level.ALL;
    }

    public void setVerbose(boolean verbose) {
        Level level = Level.WARN;
        if (verbose) {
            level = Level.ALL;
        }
        LogManager.getLogger((String)"org.jsweet").setLevel(level);
    }

    @Override
    public boolean isDisableSinglePrecisionFloats() {
        return this.disableSingleFloatPrecision;
    }

    public void setDisableSinglePrecisionFloats(boolean disableSinglePrecisionFloats) {
        this.disableSingleFloatPrecision = disableSinglePrecisionFloats;
    }

    @Override
    public java.util.List<String> getAdapters() {
        return this.adapters;
    }

    public void setAdapters(java.util.List<String> adapters) {
        this.adapters = new ArrayList<String>(adapters);
    }

    @Override
    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public boolean isIgnoreCandiesTypeScriptDefinitions() {
        return this.ignoreCandiesTypeScriptDefinitions;
    }

    public void setIgnoreCandiesTypeScriptDefinitions(boolean ignoreCandiesTypeScriptDefinitions) {
        this.ignoreCandiesTypeScriptDefinitions = ignoreCandiesTypeScriptDefinitions;
    }

    static {
        if (!SystemUtils.IS_JAVA_1_8) {
            throw new RuntimeException("JSweet is currently only supported for JDK8, please use JDK 8.\nPlease see this issue which asks for Java>8 support: https://github.com/cincheo/jsweet/issues/519");
        }
        JSweetConfig.initClassPath(null);
        EXPORTED_VAR_REGEXP = Pattern.compile("EXPORT (\\w*)=(.*);");
        logger = Logger.getLogger(JSweetTranspiler.class);
    }
}

