/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.management.CacheMXBean;
import javax.cache.management.CacheStatisticsMXBean;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.jsr107.ri.LockManager;
import org.jsr107.ri.RICacheManager;
import org.jsr107.ri.RICachedValue;
import org.jsr107.ri.RIEntry;
import org.jsr107.ri.RIInternalConverter;
import org.jsr107.ri.RIInternalMap;
import org.jsr107.ri.RIReferenceInternalConverter;
import org.jsr107.ri.RISerializingInternalConverter;
import org.jsr107.ri.RISimpleInternalMap;
import org.jsr107.ri.event.RICacheEntryEvent;
import org.jsr107.ri.event.RICacheEntryListenerRegistration;
import org.jsr107.ri.event.RICacheEventDispatcher;
import org.jsr107.ri.management.MBeanServerRegistrationUtility;
import org.jsr107.ri.management.RICacheMXBean;
import org.jsr107.ri.management.RICacheStatisticsMXBean;
import org.jsr107.ri.processor.EntryProcessorEntry;
import org.jsr107.ri.processor.MutableEntryOperation;
import org.jsr107.ri.processor.RIEntryProcessorResult;

public final class RICache<K, V>
implements Cache<K, V> {
    private final String cacheName;
    private final RICacheManager cacheManager;
    private final MutableConfiguration<K, V> configuration;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private final RIInternalConverter<K> keyConverter;
    private final RIInternalConverter<V> valueConverter;
    private final RIInternalMap<Object, RICachedValue> entries;
    private final ExpiryPolicy expiryPolicy;
    private final CopyOnWriteArrayList<RICacheEntryListenerRegistration<K, V>> listenerRegistrations;
    private volatile boolean isClosed;
    private final RICacheMXBean cacheMXBean;
    private final RICacheStatisticsMXBean statistics;
    private final LockManager<K> lockManager = new LockManager();
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private ArrayList<CacheEntryListenerConfiguration<K, V>> dynamicListenerConfigurations;

    RICache(RICacheManager cacheManager, String cacheName, ClassLoader classLoader, Configuration<K, V> configuration) {
        this.cacheManager = cacheManager;
        this.cacheName = cacheName;
        if (configuration instanceof CompleteConfiguration) {
            this.configuration = new MutableConfiguration((CompleteConfiguration)((MutableConfiguration)configuration));
        } else {
            MutableConfiguration mutableConfiguration = new MutableConfiguration();
            mutableConfiguration.setStoreByValue(configuration.isStoreByValue());
            mutableConfiguration.setTypes(configuration.getKeyType(), configuration.getValueType());
            this.configuration = new MutableConfiguration((CompleteConfiguration)mutableConfiguration);
        }
        if (this.configuration.getCacheLoaderFactory() != null) {
            this.cacheLoader = (CacheLoader)this.configuration.getCacheLoaderFactory().create();
        }
        if (this.configuration.getCacheWriterFactory() != null) {
            this.cacheWriter = (CacheWriter)this.configuration.getCacheWriterFactory().create();
        }
        this.keyConverter = this.configuration.isStoreByValue() ? new RISerializingInternalConverter(classLoader) : new RIReferenceInternalConverter();
        this.valueConverter = this.configuration.isStoreByValue() ? new RISerializingInternalConverter(classLoader) : new RIReferenceInternalConverter();
        this.expiryPolicy = (ExpiryPolicy)this.configuration.getExpiryPolicyFactory().create();
        this.entries = new RISimpleInternalMap<Object, RICachedValue>();
        this.listenerRegistrations = new CopyOnWriteArrayList();
        for (CacheEntryListenerConfiguration listenerConfiguration : this.configuration.getCacheEntryListenerConfigurations()) {
            this.createAndAddListener(listenerConfiguration);
        }
        this.cacheMXBean = new RICacheMXBean(this);
        this.statistics = new RICacheStatisticsMXBean(this);
        this.isClosed = false;
        if (this.configuration.isManagementEnabled()) {
            this.setManagementEnabled(true);
        }
        if (this.configuration.isStatisticsEnabled()) {
            this.setStatisticsEnabled(true);
        }
    }

    private void createAndAddListener(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
        RICacheEntryListenerRegistration<K, V> registration = new RICacheEntryListenerRegistration<K, V>(listenerConfiguration);
        this.listenerRegistrations.add(registration);
    }

    private void removeListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        for (RICacheEntryListenerRegistration<K, V> listenerRegistration : this.listenerRegistrations) {
            if (!cacheEntryListenerConfiguration.equals(listenerRegistration.getConfiguration())) continue;
            this.listenerRegistrations.remove(listenerRegistration);
            this.configuration.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        }
    }

    protected void submit(Runnable task) {
        this.executorService.submit(task);
    }

    protected Duration getDefaultDuration() {
        return Duration.ETERNAL;
    }

    public String getName() {
        return this.cacheName;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.cacheManager.releaseCache(this.cacheName);
            this.setStatisticsEnabled(false);
            this.setManagementEnabled(false);
            if (this.cacheLoader instanceof Closeable) {
                try {
                    ((Closeable)this.cacheLoader).close();
                }
                catch (IOException e) {
                    Logger.getLogger(this.getName()).log(Level.WARNING, "Problem closing CacheLoader " + this.cacheLoader.getClass(), e);
                }
            }
            if (this.cacheWriter instanceof Closeable) {
                try {
                    ((Closeable)this.cacheWriter).close();
                }
                catch (IOException e) {
                    Logger.getLogger(this.getName()).log(Level.WARNING, "Problem closing CacheWriter " + this.cacheWriter.getClass(), e);
                }
            }
            if (this.expiryPolicy instanceof Closeable) {
                try {
                    ((Closeable)this.expiryPolicy).close();
                }
                catch (IOException e) {
                    Logger.getLogger(this.getName()).log(Level.WARNING, "Problem closing ExpiryPolicy " + this.cacheLoader.getClass(), e);
                }
            }
            for (RICacheEntryListenerRegistration<K, V> registration : this.listenerRegistrations) {
                if (!(registration.getCacheEntryListener() instanceof Closeable)) continue;
                try {
                    ((Closeable)((Object)registration)).close();
                }
                catch (IOException e) {
                    Logger.getLogger(this.getName()).log(Level.WARNING, "Problem closing listener " + this.cacheLoader.getClass(), e);
                }
            }
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
            this.entries.clear();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.configuration)) {
            return (C)((Configuration)clazz.cast(this.configuration));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    public V get(K key) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
        Object value = this.getValue(key, dispatcher);
        dispatcher.dispatch(this.listenerRegistrations);
        return value;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.ensureOpen();
        if (keys.contains(null)) {
            throw new NullPointerException("key");
        }
        HashMap map = new HashMap(keys.size());
        RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
        for (K key : keys) {
            Object value = this.getValue(key, dispatcher);
            if (value == null) continue;
            map.put(key, value);
        }
        dispatcher.dispatch(this.listenerRegistrations);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        long now = System.currentTimeMillis();
        this.lockManager.lock(key);
        try {
            Object internalKey = this.keyConverter.toInternal(key);
            RICachedValue cachedValue = this.entries.get(internalKey);
            boolean bl = cachedValue != null && !cachedValue.isExpiredAt(now);
            return bl;
        }
        finally {
            this.lockManager.unLock(key);
        }
    }

    public void loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final CompletionListener completionListener) {
        this.ensureOpen();
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (this.cacheLoader == null) {
            if (completionListener != null) {
                completionListener.onCompletion();
            }
        } else {
            for (K key : keys) {
                if (key != null) continue;
                throw new NullPointerException("keys contains a null");
            }
            this.submit(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        try {
                            Map loaded;
                            ArrayList keysToLoad = new ArrayList();
                            for (Object key : keys) {
                                if (!replaceExistingValues && RICache.this.containsKey(key)) continue;
                                keysToLoad.add(key);
                            }
                            try {
                                loaded = RICache.this.cacheLoader.loadAll(keysToLoad);
                            }
                            catch (Exception e) {
                                if (!(e instanceof CacheLoaderException)) {
                                    throw new CacheLoaderException("Exception in CacheLoader", (Throwable)e);
                                }
                                throw e;
                            }
                            for (Object key : keysToLoad) {
                                if (loaded.get(key) != null) continue;
                                loaded.remove(key);
                            }
                            RICache.this.putAll(loaded, replaceExistingValues, false);
                            if (completionListener != null) {
                                completionListener.onCompletion();
                            }
                        }
                        catch (Exception e) {
                            if (completionListener == null) break block8;
                            completionListener.onException(e);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        int putCount = 0;
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        if (value == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        this.checkTypesAgainstConfiguredTypes(key, value);
        this.lockManager.lock(key);
        try {
            boolean isOldEntryExpired;
            RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
            long now = System.currentTimeMillis();
            Object internalKey = this.keyConverter.toInternal(key);
            Object internalValue = this.valueConverter.toInternal(value);
            RICachedValue cachedValue = this.entries.get(internalKey);
            boolean bl = isOldEntryExpired = cachedValue != null && cachedValue.isExpiredAt(now);
            if (isOldEntryExpired) {
                V expiredValue = this.valueConverter.fromInternal(cachedValue.get());
                this.processExpiries(key, dispatcher, expiredValue);
            }
            if (cachedValue == null || isOldEntryExpired) {
                Duration duration;
                RIEntry<K, V> entry = new RIEntry<K, V>(key, value);
                try {
                    duration = this.expiryPolicy.getExpiryForCreation();
                }
                catch (Throwable t) {
                    duration = this.getDefaultDuration();
                }
                long expiryTime = duration.getAdjustedTime(now);
                cachedValue = new RICachedValue(internalValue, now, expiryTime);
                this.writeCacheEntry(entry);
                if (cachedValue.isExpiredAt(now)) {
                    this.processExpiries(key, dispatcher, this.valueConverter.fromInternal(cachedValue.get()));
                } else {
                    this.entries.put(internalKey, cachedValue);
                    ++putCount;
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new RICacheEntryEvent<K, V>(this, key, value, EventType.CREATED));
                }
            } else {
                V oldValue = this.valueConverter.fromInternal(cachedValue.get());
                RIEntry<K, V> entry = new RIEntry<K, V>(key, value, oldValue);
                this.writeCacheEntry(entry);
                try {
                    Duration duration = this.expiryPolicy.getExpiryForUpdate();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                cachedValue.setInternalValue(internalValue, now);
                ++putCount;
                dispatcher.addEvent(CacheEntryUpdatedListener.class, new RICacheEntryEvent<K, V>(this, key, value, oldValue, EventType.UPDATED));
            }
            dispatcher.dispatch(this.listenerRegistrations);
        }
        finally {
            this.lockManager.unLock(key);
        }
        if (this.statisticsEnabled() && putCount > 0) {
            this.statistics.increaseCachePuts(putCount);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
    }

    private void checkTypesAgainstConfiguredTypes(K key, V value) throws ClassCastException {
        Class keyType = this.configuration.getKeyType();
        Class valueType = this.configuration.getValueType();
        if (Object.class != keyType && !keyType.isAssignableFrom(key.getClass())) {
            throw new ClassCastException("Key " + key + "is not assignable to " + keyType);
        }
        if (Object.class != valueType && !valueType.isAssignableFrom(value.getClass())) {
            throw new ClassCastException("Value " + value + "is not assignable to " + valueType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndPut(K key, V value) {
        V result;
        this.ensureOpen();
        if (value == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        long now = System.currentTimeMillis();
        int putCount = 0;
        this.lockManager.lock(key);
        try {
            boolean isExpired;
            RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
            Object internalKey = this.keyConverter.toInternal(key);
            Object internalValue = this.valueConverter.toInternal(value);
            RICachedValue cachedValue = this.entries.get(internalKey);
            boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
            if (cachedValue == null || isExpired) {
                Duration duration;
                result = null;
                RIEntry<K, V> entry = new RIEntry<K, V>(key, value);
                this.writeCacheEntry(entry);
                if (isExpired) {
                    V expiredValue = this.valueConverter.fromInternal(cachedValue.get());
                    this.processExpiries(key, dispatcher, expiredValue);
                }
                try {
                    duration = this.expiryPolicy.getExpiryForCreation();
                }
                catch (Throwable t) {
                    duration = this.getDefaultDuration();
                }
                long expiryTime = duration.getAdjustedTime(now);
                cachedValue = new RICachedValue(internalValue, now, expiryTime);
                if (cachedValue.isExpiredAt(now)) {
                    this.processExpiries(key, dispatcher, value);
                } else {
                    this.entries.put(internalKey, cachedValue);
                    ++putCount;
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new RICacheEntryEvent<K, V>(this, key, value, EventType.CREATED));
                }
            } else {
                V oldValue = this.valueConverter.fromInternal(cachedValue.getInternalValue(now));
                RIEntry<K, V> entry = new RIEntry<K, V>(key, value, oldValue);
                this.writeCacheEntry(entry);
                try {
                    Duration duration = this.expiryPolicy.getExpiryForUpdate();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                cachedValue.setInternalValue(internalValue, now);
                ++putCount;
                result = oldValue;
                dispatcher.addEvent(CacheEntryUpdatedListener.class, new RICacheEntryEvent<K, V>(this, key, value, oldValue, EventType.UPDATED));
            }
            dispatcher.dispatch(this.listenerRegistrations);
        }
        finally {
            this.lockManager.unLock(key);
        }
        if (this.statisticsEnabled()) {
            if (result == null) {
                this.statistics.increaseCacheMisses(1L);
            } else {
                this.statistics.increaseCacheHits(1L);
            }
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (putCount > 0) {
                this.statistics.increaseCachePuts(putCount);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            }
        }
        return result;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, true);
    }

    public void putAll(Map<? extends K, ? extends V> map, boolean replaceExistingValues) {
        this.putAll(map, replaceExistingValues, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> map, boolean replaceExistingValues, boolean useWriteThrough) {
        this.ensureOpen();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        long now = System.currentTimeMillis();
        int putCount = 0;
        if (map.containsKey(null)) {
            throw new NullPointerException("key");
        }
        CacheWriterException exception = null;
        RICacheEventDispatcher<Map.Entry<K, V>, V> dispatcher = new RICacheEventDispatcher<Map.Entry<K, V>, V>();
        try {
            boolean isWriteThrough = this.configuration.isWriteThrough() && this.cacheWriter != null && useWriteThrough;
            ArrayList<RIEntry<K, V>> entriesToWrite = new ArrayList<RIEntry<K, V>>();
            HashSet<K> keysToPut = new HashSet<K>();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                if (value == null) {
                    throw new NullPointerException("key " + key + " has a null value");
                }
                this.lockManager.lock(key);
                keysToPut.add(key);
                if (!isWriteThrough) continue;
                entriesToWrite.add(new RIEntry<K, V>(key, value));
            }
            if (isWriteThrough) {
                block23: {
                    try {
                        this.cacheWriter.writeAll(entriesToWrite);
                    }
                    catch (Exception e) {
                        if (e instanceof CacheWriterException) break block23;
                        exception = new CacheWriterException("Exception during write", (Throwable)e);
                    }
                }
                for (Cache.Entry entry : entriesToWrite) {
                    keysToPut.remove(entry.getKey());
                }
            }
            for (Map.Entry<K, V> entry : keysToPut) {
                boolean isExpired;
                V value = map.get(entry);
                Object internalKey = this.keyConverter.toInternal(entry);
                Object internalValue = this.valueConverter.toInternal(value);
                RICachedValue cachedValue = this.entries.get(internalKey);
                boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
                if (cachedValue == null || isExpired) {
                    Duration duration;
                    if (isExpired) {
                        V expiredValue = this.valueConverter.fromInternal(cachedValue.get());
                        this.processExpiries(entry, dispatcher, expiredValue);
                    }
                    try {
                        duration = this.expiryPolicy.getExpiryForCreation();
                    }
                    catch (Throwable t) {
                        duration = this.getDefaultDuration();
                    }
                    long expiryTime = duration.getAdjustedTime(now);
                    cachedValue = new RICachedValue(internalValue, now, expiryTime);
                    if (cachedValue.isExpiredAt(now)) {
                        this.processExpiries(entry, dispatcher, value);
                        continue;
                    }
                    this.entries.put(internalKey, cachedValue);
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new RICacheEntryEvent<Map.Entry<K, V>, V>(this, entry, value, EventType.CREATED));
                    if (!useWriteThrough) continue;
                    ++putCount;
                    continue;
                }
                if (!replaceExistingValues) continue;
                V oldValue = this.valueConverter.fromInternal(cachedValue.get());
                try {
                    Duration duration = this.expiryPolicy.getExpiryForUpdate();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                cachedValue.setInternalValue(internalValue, now);
                if (useWriteThrough) {
                    ++putCount;
                }
                dispatcher.addEvent(CacheEntryUpdatedListener.class, new RICacheEntryEvent<Map.Entry<K, V>, V>(this, entry, value, oldValue, EventType.UPDATED));
            }
        }
        finally {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                this.lockManager.unLock(key);
            }
        }
        dispatcher.dispatch(this.listenerRegistrations);
        if (this.statisticsEnabled() && putCount > 0) {
            this.statistics.increaseCachePuts(putCount);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfAbsent(K key, V value) {
        boolean result;
        this.ensureOpen();
        if (value == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        this.checkTypesAgainstConfiguredTypes(key, value);
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        long now = System.currentTimeMillis();
        this.lockManager.lock(key);
        try {
            boolean isExpired;
            RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
            Object internalKey = this.keyConverter.toInternal(key);
            Object internalValue = this.valueConverter.toInternal(value);
            RICachedValue cachedValue = this.entries.get(internalKey);
            boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
            if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                Duration duration;
                RIEntry<K, V> entry = new RIEntry<K, V>(key, value);
                this.writeCacheEntry(entry);
                if (isExpired) {
                    V expiredValue = this.valueConverter.fromInternal(cachedValue.get());
                    this.processExpiries(key, dispatcher, expiredValue);
                }
                try {
                    duration = this.expiryPolicy.getExpiryForCreation();
                }
                catch (Throwable t) {
                    duration = this.getDefaultDuration();
                }
                long expiryTime = duration.getAdjustedTime(now);
                cachedValue = new RICachedValue(internalValue, now, expiryTime);
                if (cachedValue.isExpiredAt(now)) {
                    this.processExpiries(key, dispatcher, value);
                    result = false;
                } else {
                    this.entries.put(internalKey, cachedValue);
                    result = true;
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new RICacheEntryEvent<K, V>(this, key, value, EventType.CREATED));
                }
            } else {
                result = false;
            }
            dispatcher.dispatch(this.listenerRegistrations);
        }
        finally {
            this.lockManager.unLock(key);
        }
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    private void processExpiries(K key, RICacheEventDispatcher<K, V> dispatcher, V expiredValue) {
        this.entries.remove(key);
        dispatcher.addEvent(CacheEntryExpiredListener.class, new RICacheEntryEvent<K, V>(this, key, expiredValue, EventType.EXPIRED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        boolean result;
        this.ensureOpen();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        long now = System.currentTimeMillis();
        this.lockManager.lock(key);
        try {
            this.deleteCacheEntry(key);
            Object internalKey = this.keyConverter.toInternal(key);
            RICachedValue cachedValue = this.entries.get(internalKey);
            if (cachedValue == null) {
                boolean bl = false;
                return bl;
            }
            if (cachedValue.isExpiredAt(now)) {
                result = false;
            } else {
                this.entries.remove(internalKey);
                V value = this.valueConverter.fromInternal(cachedValue.get());
                RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
                dispatcher.addEvent(CacheEntryRemovedListener.class, new RICacheEntryEvent<K, V>(this, key, value, EventType.REMOVED));
                dispatcher.dispatch(this.listenerRegistrations);
                result = true;
            }
        }
        finally {
            this.lockManager.unLock(key);
        }
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(1L);
            this.statistics.addRemoveTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V oldValue) {
        boolean result;
        long start;
        long hitCount;
        block13: {
            this.ensureOpen();
            if (oldValue == null) {
                throw new NullPointerException("null oldValue specified for key " + key);
            }
            long now = System.currentTimeMillis();
            hitCount = 0L;
            start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            this.lockManager.lock(key);
            try {
                Object oldInternalValue;
                Object internalKey = this.keyConverter.toInternal(key);
                RICachedValue cachedValue = this.entries.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = false;
                    break block13;
                }
                ++hitCount;
                Object internalValue = cachedValue.get();
                if (internalValue.equals(oldInternalValue = this.valueConverter.toInternal(oldValue))) {
                    this.deleteCacheEntry(key);
                    this.entries.remove(internalKey);
                    RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
                    dispatcher.addEvent(CacheEntryRemovedListener.class, new RICacheEntryEvent<K, V>(this, key, oldValue, EventType.REMOVED));
                    dispatcher.dispatch(this.listenerRegistrations);
                    result = true;
                    break block13;
                }
                try {
                    Duration duration = this.expiryPolicy.getExpiryForAccess();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                result = false;
            }
            finally {
                this.lockManager.unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            if (result) {
                this.statistics.increaseCacheRemovals(1L);
                this.statistics.addRemoveTimeNano(System.nanoTime() - start);
            }
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (hitCount == 1L) {
                this.statistics.increaseCacheHits(hitCount);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndRemove(K key) {
        Object result;
        this.ensureOpen();
        long now = System.currentTimeMillis();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        this.lockManager.lock(key);
        try {
            this.deleteCacheEntry(key);
            Object internalKey = this.keyConverter.toInternal(key);
            RICachedValue cachedValue = this.entries.get(internalKey);
            if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                result = null;
            } else {
                this.entries.remove(internalKey);
                result = this.valueConverter.fromInternal(cachedValue.getInternalValue(now));
                RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
                dispatcher.addEvent(CacheEntryRemovedListener.class, new RICacheEntryEvent<K, Object>(this, key, result, EventType.REMOVED));
                dispatcher.dispatch(this.listenerRegistrations);
            }
        }
        finally {
            this.lockManager.unLock(key);
        }
        if (this.statisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (result != null) {
                this.statistics.increaseCacheHits(1L);
                this.statistics.increaseCacheRemovals(1L);
                this.statistics.addRemoveTimeNano(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V oldValue, V newValue) {
        boolean result;
        long hitCount;
        long start;
        block17: {
            this.ensureOpen();
            if (newValue == null) {
                throw new NullPointerException("null newValue specified for key " + key);
            }
            if (oldValue == null) {
                throw new NullPointerException("null oldValue specified for key " + key);
            }
            long now = System.currentTimeMillis();
            start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            hitCount = 0L;
            this.lockManager.lock(key);
            try {
                Object internalKey = this.keyConverter.toInternal(key);
                RICachedValue cachedValue = this.entries.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = false;
                    break block17;
                }
                ++hitCount;
                Object oldInternalValue = this.valueConverter.toInternal(oldValue);
                if (cachedValue.get().equals(oldInternalValue)) {
                    RIEntry<K, V> entry = new RIEntry<K, V>(key, newValue, oldValue);
                    this.writeCacheEntry(entry);
                    try {
                        Duration duration = this.expiryPolicy.getExpiryForUpdate();
                        if (duration != null) {
                            long expiryTime = duration.getAdjustedTime(now);
                            cachedValue.setExpiryTime(expiryTime);
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    Object newInternalValue = this.valueConverter.toInternal(newValue);
                    cachedValue.setInternalValue(newInternalValue, now);
                    RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
                    dispatcher.addEvent(CacheEntryUpdatedListener.class, new RICacheEntryEvent<K, V>(this, key, newValue, oldValue, EventType.UPDATED));
                    dispatcher.dispatch(this.listenerRegistrations);
                    result = true;
                    break block17;
                }
                try {
                    RIEntry<K, V> entry = new RIEntry<K, V>(key, oldValue);
                    Duration duration = this.expiryPolicy.getExpiryForAccess();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                result = false;
            }
            finally {
                this.lockManager.unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            if (result) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            }
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (hitCount == 1L) {
                this.statistics.increaseCacheHits(hitCount);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(K key, V value) {
        boolean result;
        long start;
        block11: {
            this.ensureOpen();
            if (value == null) {
                throw new NullPointerException("null value specified for key " + key);
            }
            long now = System.currentTimeMillis();
            start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            this.lockManager.lock(key);
            try {
                Object internalKey = this.keyConverter.toInternal(key);
                RICachedValue cachedValue = this.entries.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = false;
                    break block11;
                }
                V oldValue = this.valueConverter.fromInternal(cachedValue.get());
                RIEntry<K, V> entry = new RIEntry<K, V>(key, value, oldValue);
                this.writeCacheEntry(entry);
                try {
                    Duration duration = this.expiryPolicy.getExpiryForUpdate();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                Object internalValue = this.valueConverter.toInternal(value);
                cachedValue.setInternalValue(internalValue, now);
                RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
                dispatcher.addEvent(CacheEntryUpdatedListener.class, new RICacheEntryEvent<K, V>(this, key, value, oldValue, EventType.UPDATED));
                dispatcher.dispatch(this.listenerRegistrations);
                result = true;
            }
            finally {
                this.lockManager.unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (result) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.increaseCacheHits(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndReplace(K key, V value) {
        V result;
        long start;
        block11: {
            this.ensureOpen();
            if (value == null) {
                throw new NullPointerException("null value specified for key " + key);
            }
            long now = System.currentTimeMillis();
            start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            this.lockManager.lock(key);
            try {
                Object internalKey = this.keyConverter.toInternal(key);
                RICachedValue cachedValue = this.entries.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = null;
                    break block11;
                }
                V oldValue = this.valueConverter.fromInternal(cachedValue.getInternalValue(now));
                RIEntry<K, V> entry = new RIEntry<K, V>(key, value, oldValue);
                this.writeCacheEntry(entry);
                try {
                    Duration duration = this.expiryPolicy.getExpiryForUpdate();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                Object internalValue = this.valueConverter.toInternal(value);
                cachedValue.setInternalValue(internalValue, now);
                RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
                dispatcher.addEvent(CacheEntryUpdatedListener.class, new RICacheEntryEvent<K, V>(this, key, value, oldValue, EventType.UPDATED));
                dispatcher.dispatch(this.listenerRegistrations);
                result = oldValue;
            }
            finally {
                this.lockManager.unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (result != null) {
                this.statistics.increaseCacheHits(1L);
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        long now = System.currentTimeMillis();
        CacheWriterException exception = null;
        HashSet<K> lockedKeys = new HashSet<K>();
        HashSet<K> cacheWriterKeys = new HashSet<K>();
        cacheWriterKeys.addAll(keys);
        RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
        try {
            V value;
            RICachedValue cachedValue;
            Object internalKey;
            boolean isWriteThrough = this.configuration.isWriteThrough() && this.cacheWriter != null;
            HashSet<K> deletedKeys = new HashSet<K>();
            for (Object key : keys) {
                this.lockManager.lock(key);
                lockedKeys.add(key);
            }
            if (isWriteThrough) {
                block15: {
                    try {
                        this.cacheWriter.deleteAll(cacheWriterKeys);
                    }
                    catch (Exception e) {
                        if (e instanceof CacheWriterException) break block15;
                        exception = new CacheWriterException("Exception during write", (Throwable)e);
                    }
                }
                for (Object key : lockedKeys) {
                    if (cacheWriterKeys.contains(key) || !this.entries.containsKey(internalKey = this.keyConverter.toInternal(key))) continue;
                    cachedValue = this.entries.remove(internalKey);
                    deletedKeys.add(key);
                    value = this.valueConverter.fromInternal(cachedValue.get());
                    if (cachedValue.isExpiredAt(now)) {
                        this.processExpiries(key, dispatcher, value);
                        continue;
                    }
                    dispatcher.addEvent(CacheEntryRemovedListener.class, new RICacheEntryEvent<K, V>(this, key, value, EventType.REMOVED));
                }
            }
            if (!isWriteThrough) {
                for (Object key : lockedKeys) {
                    internalKey = this.keyConverter.toInternal(key);
                    if (!this.entries.containsKey(internalKey)) continue;
                    cachedValue = this.entries.remove(internalKey);
                    deletedKeys.add(key);
                    value = this.valueConverter.fromInternal(cachedValue.get());
                    if (cachedValue.isExpiredAt(now)) {
                        this.processExpiries(key, dispatcher, value);
                        continue;
                    }
                    dispatcher.addEvent(CacheEntryRemovedListener.class, new RICacheEntryEvent<K, V>(this, key, value, EventType.REMOVED));
                }
            }
            if (this.statisticsEnabled()) {
                this.statistics.increaseCacheRemovals(deletedKeys.size());
            }
        }
        finally {
            for (Object key : lockedKeys) {
                this.lockManager.unLock(key);
            }
        }
        dispatcher.dispatch(this.listenerRegistrations);
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        this.ensureOpen();
        int size = 0;
        long now = System.currentTimeMillis();
        CacheWriterException exception = null;
        HashSet<K> lockedKeys = new HashSet<K>();
        RICacheEventDispatcher<Object, V> dispatcher = new RICacheEventDispatcher<Object, V>();
        try {
            Object internalKey;
            HashSet<K> keysToDelete;
            block12: {
                boolean isWriteThrough = this.configuration.isWriteThrough() && this.cacheWriter != null;
                keysToDelete = new HashSet<K>();
                for (Map.Entry entry : this.entries) {
                    internalKey = entry.getKey();
                    K key = this.keyConverter.fromInternal(internalKey);
                    this.lockManager.lock(key);
                    lockedKeys.add(key);
                    if (!isWriteThrough) continue;
                    keysToDelete.add(key);
                }
                if (isWriteThrough && keysToDelete.size() > 0) {
                    try {
                        this.cacheWriter.deleteAll(keysToDelete);
                    }
                    catch (Exception e) {
                        if (e instanceof CacheWriterException) break block12;
                        exception = new CacheWriterException("Exception during write", (Throwable)e);
                    }
                }
            }
            for (Object object : lockedKeys) {
                if (keysToDelete.contains(object)) continue;
                internalKey = this.keyConverter.toInternal(object);
                RICachedValue cachedValue = this.entries.remove(internalKey);
                V value = this.valueConverter.fromInternal(cachedValue.get());
                if (cachedValue.isExpiredAt(now)) {
                    this.processExpiries(object, dispatcher, value);
                    continue;
                }
                dispatcher.addEvent(CacheEntryRemovedListener.class, new RICacheEntryEvent<Object, V>(this, object, value, EventType.REMOVED));
                ++size;
            }
        }
        finally {
            for (Object key : lockedKeys) {
                this.lockManager.unLock(key);
            }
        }
        dispatcher.dispatch(this.listenerRegistrations);
        if (this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(size);
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.ensureOpen();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object internalKey = entry.getKey();
            K key = this.keyConverter.fromInternal(internalKey);
            this.lockManager.lock(key);
            try {
                iterator.remove();
            }
            finally {
                this.lockManager.unLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        Object result = null;
        this.lockManager.lock(key);
        try {
            boolean isExpired;
            long now = System.currentTimeMillis();
            RICacheEventDispatcher<K, V> dispatcher = new RICacheEventDispatcher<K, V>();
            Object internalKey = this.keyConverter.toInternal(key);
            RICachedValue cachedValue = this.entries.get(internalKey);
            boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
            if (isExpired) {
                V expiredValue = this.valueConverter.fromInternal(cachedValue.get());
                this.processExpiries(key, dispatcher, expiredValue);
            }
            if (this.statisticsEnabled()) {
                if (cachedValue == null || isExpired) {
                    this.statistics.increaseCacheMisses(1L);
                } else {
                    this.statistics.increaseCacheHits(1L);
                }
            }
            if (this.statisticsEnabled()) {
                this.statistics.addGetTimeNano(System.nanoTime() - start);
            }
            start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            EntryProcessorEntry<K, V> entry = new EntryProcessorEntry<K, V>(this.valueConverter, key, cachedValue, now, dispatcher, this.configuration.isReadThrough() ? this.cacheLoader : null);
            try {
                result = entryProcessor.process(entry, arguments);
            }
            catch (CacheException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EntryProcessorException((Throwable)e);
            }
            switch (entry.getOperation()) {
                case NONE: {
                    break;
                }
                case ACCESS: {
                    try {
                        Duration duration = this.expiryPolicy.getExpiryForAccess();
                        if (duration == null) break;
                        long expiryTime1 = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime1);
                    }
                    catch (Throwable t) {}
                    break;
                }
                case CREATE: 
                case LOAD: {
                    Duration duration;
                    RIEntry<K, V> e = new RIEntry<K, V>(key, entry.getValue());
                    if (entry.getOperation() == MutableEntryOperation.CREATE) {
                        this.writeCacheEntry(e);
                    }
                    try {
                        duration = this.expiryPolicy.getExpiryForCreation();
                    }
                    catch (Throwable t) {
                        duration = this.getDefaultDuration();
                    }
                    long expiryTime = duration.getAdjustedTime(now);
                    cachedValue = new RICachedValue(this.valueConverter.toInternal(entry.getValue()), now, expiryTime);
                    if (cachedValue.isExpiredAt(now)) {
                        V previousValue = this.valueConverter.fromInternal(cachedValue.get());
                        this.processExpiries(key, dispatcher, previousValue);
                        break;
                    }
                    this.entries.put(internalKey, cachedValue);
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new RICacheEntryEvent<K, V>(this, key, entry.getValue(), EventType.CREATED));
                    if (!this.statisticsEnabled() || entry.getOperation() != MutableEntryOperation.CREATE) break;
                    this.statistics.increaseCachePuts(1L);
                    this.statistics.addPutTimeNano(System.nanoTime() - start);
                    break;
                }
                case UPDATE: {
                    V oldValue = this.valueConverter.fromInternal(cachedValue.get());
                    RIEntry<K, V> e = new RIEntry<K, V>(key, entry.getValue(), oldValue);
                    this.writeCacheEntry(e);
                    try {
                        Duration duration = this.expiryPolicy.getExpiryForUpdate();
                        if (duration != null) {
                            long expiryTime = duration.getAdjustedTime(now);
                            cachedValue.setExpiryTime(expiryTime);
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    cachedValue.setInternalValue(this.valueConverter.toInternal(entry.getValue()), now);
                    dispatcher.addEvent(CacheEntryUpdatedListener.class, new RICacheEntryEvent<K, V>(this, key, entry.getValue(), oldValue, EventType.UPDATED));
                    if (!this.statisticsEnabled()) break;
                    this.statistics.increaseCachePuts(1L);
                    this.statistics.addPutTimeNano(System.nanoTime() - start);
                    break;
                }
                case REMOVE: {
                    this.deleteCacheEntry(key);
                    Object oldValue = cachedValue == null ? null : (Object)this.valueConverter.fromInternal(cachedValue.get());
                    this.entries.remove(internalKey);
                    dispatcher.addEvent(CacheEntryRemovedListener.class, new RICacheEntryEvent<K, Object>(this, key, oldValue, EventType.REMOVED));
                    if (!this.statisticsEnabled()) break;
                    this.statistics.increaseCacheRemovals(1L);
                    this.statistics.addRemoveTimeNano(System.nanoTime() - start);
                    break;
                }
            }
            dispatcher.dispatch(this.listenerRegistrations);
        }
        finally {
            this.lockManager.unLock(key);
        }
        return (T)result;
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        if (keys == null) {
            throw new NullPointerException();
        }
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        HashMap<K, RIEntryProcessorResult<T>> map = new HashMap<K, RIEntryProcessorResult<T>>();
        for (K key : keys) {
            RIEntryProcessorResult<T> result = null;
            try {
                T t = this.invoke(key, entryProcessor, arguments);
                result = t == null ? null : new RIEntryProcessorResult<T>(t);
            }
            catch (Exception e) {
                result = new RIEntryProcessorResult<T>(e);
            }
            if (result == null) continue;
            map.put(key, result);
        }
        return map;
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        long now = System.currentTimeMillis();
        return new RIEntryIterator(this.entries.iterator(), now);
    }

    public CacheMXBean getCacheMXBean() {
        return this.cacheMXBean;
    }

    public CacheStatisticsMXBean getCacheStatisticsMXBean() {
        return this.statistics;
    }

    public void setStatisticsEnabled(boolean enabled) {
        if (enabled) {
            MBeanServerRegistrationUtility.registerCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Statistics);
        } else {
            MBeanServerRegistrationUtility.unregisterCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Statistics);
        }
        this.configuration.setStatisticsEnabled(enabled);
    }

    public void setManagementEnabled(boolean enabled) {
        if (enabled) {
            MBeanServerRegistrationUtility.registerCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Configuration);
        } else {
            MBeanServerRegistrationUtility.unregisterCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Configuration);
        }
        this.configuration.setManagementEnabled(enabled);
    }

    private void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + cls + " is not " + "supported by this implementation");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.configuration.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        this.createAndAddListener(cacheEntryListenerConfiguration);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.removeListener(cacheEntryListenerConfiguration);
    }

    private boolean statisticsEnabled() {
        return this.getConfiguration(CompleteConfiguration.class).isStatisticsEnabled();
    }

    private void writeCacheEntry(RIEntry<K, V> entry) {
        if (this.configuration.isWriteThrough()) {
            try {
                this.cacheWriter.write(entry);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter", (Throwable)e);
                }
                throw e;
            }
        }
    }

    private void deleteCacheEntry(K key) {
        if (this.configuration.isWriteThrough()) {
            try {
                this.cacheWriter.delete(key);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter", (Throwable)e);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getValue(K key, RICacheEventDispatcher<K, V> dispatcher) {
        Object value;
        block21: {
            long now = System.currentTimeMillis();
            long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            Object internalKey = this.keyConverter.toInternal(key);
            RICachedValue cachedValue = null;
            value = null;
            this.lockManager.lock(key);
            try {
                boolean isExpired;
                cachedValue = this.entries.get(internalKey);
                boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
                if (cachedValue == null || isExpired) {
                    Duration duration;
                    V expiredValue;
                    V v = expiredValue = isExpired ? (V)this.valueConverter.fromInternal(cachedValue.get()) : null;
                    if (isExpired) {
                        this.processExpiries(key, dispatcher, expiredValue);
                    }
                    if (this.statisticsEnabled()) {
                        this.statistics.increaseCacheMisses(1L);
                    }
                    if (this.configuration.isReadThrough() && this.cacheLoader != null) {
                        try {
                            value = this.cacheLoader.load(key);
                        }
                        catch (Exception e) {
                            if (!(e instanceof CacheLoaderException)) {
                                throw new CacheLoaderException("Exception in CacheLoader", (Throwable)e);
                            }
                            throw e;
                        }
                    }
                    if (value == null) {
                        V e = null;
                        return e;
                    }
                    try {
                        duration = this.expiryPolicy.getExpiryForCreation();
                    }
                    catch (Throwable t) {
                        duration = this.getDefaultDuration();
                    }
                    long expiryTime = duration.getAdjustedTime(now);
                    Object internalValue = this.valueConverter.toInternal(value);
                    cachedValue = new RICachedValue(internalValue, now, expiryTime);
                    if (cachedValue.isExpiredAt(now)) {
                        V v2 = null;
                        return v2;
                    }
                    this.entries.put(internalKey, cachedValue);
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new RICacheEntryEvent<K, Object>(this, key, value, EventType.CREATED));
                    break block21;
                }
                value = this.valueConverter.fromInternal(cachedValue.getInternalValue(now));
                RIEntry<K, Object> entry = new RIEntry<K, Object>(key, value);
                try {
                    Duration duration = this.expiryPolicy.getExpiryForAccess();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (this.statisticsEnabled()) {
                    this.statistics.increaseCacheHits(1L);
                }
            }
            finally {
                this.lockManager.unLock(key);
                if (this.statisticsEnabled()) {
                    this.statistics.addGetTimeNano(System.nanoTime() - start);
                }
            }
        }
        return (V)value;
    }

    public long getSize() {
        return this.entries.size();
    }

    private final class RIEntryIterator
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<Map.Entry<Object, RICachedValue>> iterator;
        private RIEntry<K, V> nextEntry;
        private RIEntry<K, V> lastEntry;
        private long now;

        private RIEntryIterator(Iterator<Map.Entry<Object, RICachedValue>> iterator, long now) {
            this.iterator = iterator;
            this.nextEntry = null;
            this.lastEntry = null;
            this.now = now;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetch() {
            long start;
            long l = start = RICache.this.statisticsEnabled() ? System.nanoTime() : 0L;
            while (this.nextEntry == null && this.iterator.hasNext()) {
                Map.Entry<Object, RICachedValue> entry = this.iterator.next();
                RICachedValue cachedValue = entry.getValue();
                Object key = RICache.this.keyConverter.fromInternal(entry.getKey());
                RICache.this.lockManager.lock(key);
                try {
                    if (cachedValue.isExpiredAt(this.now)) continue;
                    Object value = RICache.this.valueConverter.fromInternal(cachedValue.getInternalValue(this.now));
                    this.nextEntry = new RIEntry(key, value);
                    try {
                        Duration duration = RICache.this.expiryPolicy.getExpiryForAccess();
                        if (duration == null) continue;
                        long expiryTime = duration.getAdjustedTime(this.now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                finally {
                    RICache.this.lockManager.unLock(key);
                    if (!RICache.this.statisticsEnabled() || this.nextEntry == null) continue;
                    RICache.this.statistics.increaseCacheHits(1L);
                    RICache.this.statistics.addGetTimeNano(System.nanoTime() - start);
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry == null) {
                this.fetch();
            }
            return this.nextEntry != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (this.hasNext()) {
                this.lastEntry = this.nextEntry;
                this.nextEntry = null;
                return this.lastEntry;
            }
            throw new NoSuchElementException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            int cacheRemovals = 0;
            if (this.lastEntry == null) {
                throw new IllegalStateException("Must progress to the next entry to remove");
            }
            long start = RICache.this.statisticsEnabled() ? System.nanoTime() : 0L;
            RICache.this.lockManager.lock(this.lastEntry.getKey());
            try {
                RICache.this.deleteCacheEntry(this.lastEntry.getKey());
                this.iterator.remove();
                ++cacheRemovals;
                RICacheEventDispatcher dispatcher = new RICacheEventDispatcher();
                dispatcher.addEvent(CacheEntryRemovedListener.class, new RICacheEntryEvent(RICache.this, this.lastEntry.getKey(), this.lastEntry.getValue(), EventType.REMOVED));
                dispatcher.dispatch(RICache.this.listenerRegistrations);
            }
            finally {
                RICache.this.lockManager.unLock(this.lastEntry.getKey());
                this.lastEntry = null;
                if (RICache.this.statisticsEnabled() && cacheRemovals > 0) {
                    RICache.this.statistics.increaseCacheRemovals(cacheRemovals);
                    RICache.this.statistics.addRemoveTimeNano(System.nanoTime() - start);
                }
            }
        }
    }
}

