/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations;

import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.GeneratedCacheKey;
import org.jsr107.ri.annotations.AbstractKeyedCacheInterceptor;
import org.jsr107.ri.annotations.CacheContextSource;
import org.jsr107.ri.annotations.CacheRemoveEntryMethodDetails;
import org.jsr107.ri.annotations.ClassFilter;
import org.jsr107.ri.annotations.InterceptorType;
import org.jsr107.ri.annotations.InternalCacheKeyInvocationContext;

public abstract class AbstractCacheRemoveEntryInterceptor<I>
extends AbstractKeyedCacheInterceptor<I, CacheRemoveEntryMethodDetails> {
    public final Object cacheRemoveEntry(CacheContextSource<I> cacheContextSource, I invocation) throws Throwable {
        Object result;
        InternalCacheKeyInvocationContext<Annotation> cacheKeyInvocationContext = cacheContextSource.getCacheKeyInvocationContext(invocation);
        CacheRemoveEntryMethodDetails methodDetails = (CacheRemoveEntryMethodDetails)this.getStaticCacheKeyInvocationContext(cacheKeyInvocationContext, InterceptorType.CACHE_REMOVE_ENTRY);
        CacheRemove cacheRemoveAnnotation = (CacheRemove)methodDetails.getCacheAnnotation();
        boolean afterInvocation = cacheRemoveAnnotation.afterInvocation();
        if (!afterInvocation) {
            this.cacheRemove(cacheKeyInvocationContext, methodDetails);
        }
        try {
            result = this.proceed(invocation);
        }
        catch (Throwable t) {
            Class[] noEvictFor;
            Class[] evictFor;
            boolean cache;
            if (afterInvocation && (cache = ClassFilter.isIncluded(t, evictFor = cacheRemoveAnnotation.evictFor(), noEvictFor = cacheRemoveAnnotation.noEvictFor(), false))) {
                this.cacheRemove(cacheKeyInvocationContext, methodDetails);
            }
            throw t;
        }
        if (afterInvocation) {
            this.cacheRemove(cacheKeyInvocationContext, methodDetails);
        }
        return result;
    }

    private void cacheRemove(InternalCacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext, CacheRemoveEntryMethodDetails methodDetails) {
        CacheResolver cacheResolver = methodDetails.getCacheResolver();
        Cache cache = cacheResolver.resolveCache(cacheKeyInvocationContext);
        CacheKeyGenerator cacheKeyGenerator = methodDetails.getCacheKeyGenerator();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        cache.remove((Object)cacheKey);
    }
}

