/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.scanner.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jsondoc.core.annotation.ApiQueryParam;
import org.jsondoc.core.pojo.ApiParamDoc;
import org.jsondoc.core.util.JSONDocType;
import org.jsondoc.core.util.JSONDocTypeBuilder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class SpringQueryParamBuilder {
    public static Set<ApiParamDoc> buildQueryParams(Method method) {
        String[] splitParam;
        RequestMapping requestMapping;
        LinkedHashSet<ApiParamDoc> apiParamDocs = new LinkedHashSet<ApiParamDoc>();
        Class<?> controller = method.getDeclaringClass();
        if (controller.isAnnotationPresent(RequestMapping.class) && (requestMapping = controller.getAnnotation(RequestMapping.class)).params().length > 0) {
            for (String param : requestMapping.params()) {
                splitParam = param.split("=");
                if (splitParam.length > 1) {
                    apiParamDocs.add(new ApiParamDoc(splitParam[0], "", JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), String.class, null), "true", new String[]{splitParam[1]}, null, null));
                    continue;
                }
                apiParamDocs.add(new ApiParamDoc(param, "", JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), String.class, null), "true", new String[0], null, null));
            }
        }
        if (method.isAnnotationPresent(RequestMapping.class) && (requestMapping = method.getAnnotation(RequestMapping.class)).params().length > 0) {
            for (String param : requestMapping.params()) {
                splitParam = param.split("=");
                if (splitParam.length > 1) {
                    apiParamDocs.add(new ApiParamDoc(splitParam[0], "", JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), String.class, null), "true", new String[]{splitParam[1]}, null, null));
                    continue;
                }
                apiParamDocs.add(new ApiParamDoc(param, "", JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), String.class, null), "true", new String[0], null, null));
            }
        }
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parametersAnnotations.length; ++i) {
            RequestParam requestParam = null;
            ModelAttribute modelAttribute = null;
            ApiQueryParam apiQueryParam = null;
            ApiParamDoc apiParamDoc = null;
            for (Annotation annotation : parametersAnnotations[i]) {
                if (annotation instanceof RequestParam) {
                    requestParam = (RequestParam)annotation;
                }
                if (annotation instanceof ModelAttribute) {
                    modelAttribute = (ModelAttribute)annotation;
                }
                if (annotation instanceof ApiQueryParam) {
                    apiQueryParam = (ApiQueryParam)annotation;
                }
                if (requestParam != null) {
                    apiParamDoc = new ApiParamDoc(requestParam.value(), "", JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), method.getParameterTypes()[i], (Type)method.getGenericParameterTypes()[i]), String.valueOf(requestParam.required()), new String[]{}, null, requestParam.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n") ? "" : requestParam.defaultValue());
                    SpringQueryParamBuilder.mergeApiQueryParamDoc(apiQueryParam, apiParamDoc);
                }
                if (modelAttribute == null) continue;
                apiParamDoc = new ApiParamDoc(modelAttribute.value(), "", JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), method.getParameterTypes()[i], (Type)method.getGenericParameterTypes()[i]), "false", new String[0], null, null);
                SpringQueryParamBuilder.mergeApiQueryParamDoc(apiQueryParam, apiParamDoc);
            }
            if (apiParamDoc == null) continue;
            apiParamDocs.add(apiParamDoc);
        }
        return apiParamDocs;
    }

    private static void mergeApiQueryParamDoc(ApiQueryParam apiQueryParam, ApiParamDoc apiParamDoc) {
        if (apiQueryParam != null) {
            if (apiParamDoc.getName().trim().isEmpty()) {
                apiParamDoc.setName(apiQueryParam.name());
            }
            apiParamDoc.setDescription(apiQueryParam.description());
            apiParamDoc.setAllowedvalues(apiQueryParam.allowedvalues());
            apiParamDoc.setFormat(apiQueryParam.format());
        }
    }
}

