/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.springmvc.scanner.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.TreeSet;
import org.jsondoc.core.pojo.ApiObjectDoc;
import org.jsondoc.core.pojo.ApiObjectFieldDoc;
import org.jsondoc.core.scanner.DefaultJSONDocScanner;
import org.jsondoc.core.util.JSONDocHibernateValidatorProcessor;
import org.jsondoc.core.util.JSONDocType;
import org.jsondoc.core.util.JSONDocTypeBuilder;

public class SpringObjectBuilder {
    public static ApiObjectDoc buildObject(Class<?> clazz) {
        ApiObjectDoc apiObjectDoc = new ApiObjectDoc();
        apiObjectDoc.setName(clazz.getSimpleName());
        TreeSet<ApiObjectFieldDoc> fieldDocs = new TreeSet<ApiObjectFieldDoc>();
        for (Field field : clazz.getDeclaredFields()) {
            ApiObjectFieldDoc fieldDoc = new ApiObjectFieldDoc();
            fieldDoc.setName(field.getName());
            fieldDoc.setOrder(Integer.MAX_VALUE);
            fieldDoc.setRequired("undefined".toUpperCase());
            fieldDoc.setJsondocType(JSONDocTypeBuilder.build((JSONDocType)new JSONDocType(), field.getType(), (Type)field.getGenericType()));
            JSONDocHibernateValidatorProcessor.processHibernateValidatorAnnotations((Field)field, (ApiObjectFieldDoc)fieldDoc);
            fieldDocs.add(fieldDoc);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            ApiObjectDoc parentObjectDoc = SpringObjectBuilder.buildObject(superclass);
            fieldDocs.addAll(parentObjectDoc.getFields());
        }
        if (clazz.isEnum()) {
            apiObjectDoc.setAllowedvalues(DefaultJSONDocScanner.enumConstantsToStringArray((Object[])clazz.getEnumConstants()));
        }
        apiObjectDoc.setFields(fieldDocs);
        if (Modifier.isAbstract(clazz.getModifiers())) {
            apiObjectDoc.setShow(false);
        }
        return apiObjectDoc;
    }
}

