/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.scanner.builder;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jsondoc.core.annotation.ApiError;
import org.jsondoc.core.annotation.ApiErrors;
import org.jsondoc.core.pojo.ApiErrorDoc;

public class JSONDocApiErrorDocBuilder {
    public static List<ApiErrorDoc> build(Method method) {
        ArrayList<ApiErrorDoc> apiMethodDocs = new ArrayList<ApiErrorDoc>();
        ApiErrors methodAnnotation = method.getAnnotation(ApiErrors.class);
        ApiErrors typeAnnotation = method.getDeclaringClass().getAnnotation(ApiErrors.class);
        if (methodAnnotation != null) {
            for (final ApiError apiError : methodAnnotation.apierrors()) {
                apiMethodDocs.add(new ApiErrorDoc(apiError.code(), apiError.description()));
            }
        }
        if (typeAnnotation != null) {
            for (final ApiError apiError : typeAnnotation.apierrors()) {
                boolean isAlreadyDefined = FluentIterable.from(apiMethodDocs).anyMatch((Predicate)new Predicate<ApiErrorDoc>(){

                    public boolean apply(ApiErrorDoc apiErrorDoc) {
                        return apiError.code().equals(apiErrorDoc.getCode());
                    }
                });
                if (isAlreadyDefined) continue;
                apiMethodDocs.add(new ApiErrorDoc(apiError.code(), apiError.description()));
            }
        }
        return apiMethodDocs;
    }
}

