/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Map;
import org.jsondoc.core.annotation.ApiObject;
import org.jsondoc.core.util.JSONDocDefaultType;
import org.jsondoc.core.util.JSONDocType;

public class JSONDocTypeBuilder {
    private static final String WILDCARD = "wildcard";
    private static final String UNDEFINED = "undefined";
    private static final String ARRAY = "array";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONDocType build(JSONDocType jsondocType, Class<?> clazz, Type type) {
        if (clazz.isAssignableFrom(JSONDocDefaultType.class)) {
            jsondocType.addItemToType(UNDEFINED);
            return jsondocType;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            jsondocType.addItemToType(JSONDocTypeBuilder.getCustomClassName(clazz));
            if (!(type instanceof ParameterizedType)) return jsondocType;
            Type mapKeyType = ((ParameterizedType)type).getActualTypeArguments()[0];
            Type mapValueType = ((ParameterizedType)type).getActualTypeArguments()[1];
            jsondocType.setMapKey(new JSONDocType());
            jsondocType.setMapValue(new JSONDocType());
            if (mapKeyType instanceof Class) {
                jsondocType.setMapKey(new JSONDocType(((Class)mapKeyType).getSimpleName().toLowerCase()));
            } else if (mapKeyType instanceof WildcardType) {
                jsondocType.setMapKey(new JSONDocType(WILDCARD));
            } else {
                jsondocType.setMapKey(JSONDocTypeBuilder.build(jsondocType.getMapKey(), (Class)((ParameterizedType)mapKeyType).getRawType(), mapKeyType));
            }
            if (mapValueType instanceof Class) {
                jsondocType.setMapValue(new JSONDocType(((Class)mapValueType).getSimpleName().toLowerCase()));
                return jsondocType;
            } else if (mapValueType instanceof WildcardType) {
                jsondocType.setMapValue(new JSONDocType(WILDCARD));
                return jsondocType;
            } else {
                jsondocType.setMapValue(JSONDocTypeBuilder.build(jsondocType.getMapValue(), (Class)((ParameterizedType)mapValueType).getRawType(), mapValueType));
            }
            return jsondocType;
        } else if (Collection.class.isAssignableFrom(clazz)) {
            if (type instanceof ParameterizedType) {
                Type parametrizedType = ((ParameterizedType)type).getActualTypeArguments()[0];
                jsondocType.addItemToType(JSONDocTypeBuilder.getCustomClassName(clazz));
                if (parametrizedType instanceof Class) {
                    jsondocType.addItemToType(((Class)parametrizedType).getSimpleName().toLowerCase());
                    return jsondocType;
                } else {
                    if (!(parametrizedType instanceof WildcardType)) return JSONDocTypeBuilder.build(jsondocType, (Class)((ParameterizedType)parametrizedType).getRawType(), parametrizedType);
                    jsondocType.addItemToType(WILDCARD);
                }
                return jsondocType;
            } else {
                if (type instanceof GenericArrayType) {
                    return JSONDocTypeBuilder.build(jsondocType, clazz, ((GenericArrayType)type).getGenericComponentType());
                }
                jsondocType.addItemToType(JSONDocTypeBuilder.getCustomClassName(clazz));
            }
            return jsondocType;
        } else {
            if (clazz.isArray()) {
                jsondocType.addItemToType(ARRAY);
                Class<?> componentType = clazz.getComponentType();
                return JSONDocTypeBuilder.build(jsondocType, componentType, type);
            }
            jsondocType.addItemToType(JSONDocTypeBuilder.getCustomClassName(clazz));
            if (!(type instanceof ParameterizedType)) return jsondocType;
            Type parametrizedType = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (parametrizedType instanceof Class) {
                jsondocType.addItemToType(((Class)parametrizedType).getSimpleName().toLowerCase());
                return jsondocType;
            } else {
                if (!(parametrizedType instanceof WildcardType)) return JSONDocTypeBuilder.build(jsondocType, (Class)((ParameterizedType)parametrizedType).getRawType(), parametrizedType);
                jsondocType.addItemToType(WILDCARD);
            }
        }
        return jsondocType;
    }

    private static String getCustomClassName(Class<?> clazz) {
        if (clazz.isAnnotationPresent(ApiObject.class)) {
            ApiObject annotation = clazz.getAnnotation(ApiObject.class);
            if (annotation.name().isEmpty()) {
                return clazz.getSimpleName().toLowerCase();
            }
            return annotation.name();
        }
        return clazz.getSimpleName().toLowerCase();
    }
}

