/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsondoc.core.annotation.ApiObjectField;

public class JSONDocTemplateBuilder {
    private static Map<Class<?>, Class<?>> primitives = new HashMap();

    public static Map<String, Object> build(Map<String, Object> jsondocTemplate, Class<?> clazz) {
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Character.TYPE, String.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Void.TYPE, Void.class);
        try {
            List<Field> fields = JSONDocTemplateBuilder.getAllDeclaredFields(clazz);
            for (Field field : fields) {
                Object value = JSONDocTemplateBuilder.getValue(field.getType(), field.getGenericType(), field.getName());
                jsondocTemplate.put(field.getName(), value);
            }
            return jsondocTemplate;
        }
        catch (Exception e) {
            return new HashMap<String, Object>();
        }
    }

    private static Object getValue(Class<?> fieldClass, Type fieldGenericType, String fieldName) {
        if (fieldClass.isPrimitive()) {
            return JSONDocTemplateBuilder.getValue(JSONDocTemplateBuilder.wrap(fieldClass), null, fieldName);
        }
        if (Map.class.isAssignableFrom(fieldClass)) {
            return new HashMap();
        }
        if (Number.class.isAssignableFrom(fieldClass)) {
            return new Integer(0);
        }
        if (String.class.isAssignableFrom(fieldClass) || fieldClass.isEnum()) {
            return new String("");
        }
        if (Boolean.class.isAssignableFrom(fieldClass)) {
            return new Boolean("true");
        }
        if (fieldClass.isArray() || Collection.class.isAssignableFrom(fieldClass)) {
            return new ArrayList();
        }
        HashMap<String, Object> template = new HashMap<String, Object>();
        return JSONDocTemplateBuilder.build(template, fieldClass);
    }

    private static List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : Arrays.asList(clazz.getDeclaredFields())) {
            if (!field.isAnnotationPresent(ApiObjectField.class)) continue;
            fields.add(field);
        }
        if (clazz.getSuperclass() != null) {
            fields.addAll(JSONDocTemplateBuilder.getAllDeclaredFields(clazz.getSuperclass()));
        }
        return fields;
    }

    private static <T> Class<T> wrap(Class<T> clazz) {
        return clazz.isPrimitive() ? primitives.get(clazz) : clazz;
    }
}

