/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.scanner;

import com.google.common.base.Predicate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiAuthBasic;
import org.jsondoc.core.annotation.ApiAuthNone;
import org.jsondoc.core.annotation.ApiFlow;
import org.jsondoc.core.annotation.ApiFlowSet;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiObject;
import org.jsondoc.core.annotation.ApiParams;
import org.jsondoc.core.annotation.ApiPathParam;
import org.jsondoc.core.annotation.ApiQueryParam;
import org.jsondoc.core.pojo.ApiAuthDoc;
import org.jsondoc.core.pojo.ApiBodyObjectDoc;
import org.jsondoc.core.pojo.ApiDoc;
import org.jsondoc.core.pojo.ApiErrorDoc;
import org.jsondoc.core.pojo.ApiFlowDoc;
import org.jsondoc.core.pojo.ApiHeaderDoc;
import org.jsondoc.core.pojo.ApiMethodDoc;
import org.jsondoc.core.pojo.ApiObjectDoc;
import org.jsondoc.core.pojo.ApiObjectFieldDoc;
import org.jsondoc.core.pojo.ApiParamDoc;
import org.jsondoc.core.pojo.ApiParamType;
import org.jsondoc.core.pojo.ApiResponseObjectDoc;
import org.jsondoc.core.pojo.ApiVerb;
import org.jsondoc.core.pojo.ApiVersionDoc;
import org.jsondoc.core.pojo.JSONDoc;
import org.jsondoc.core.scanner.JSONDocScanner;
import org.jsondoc.core.util.JSONDocType;
import org.jsondoc.core.util.JSONDocTypeBuilder;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJSONDocScanner
implements JSONDocScanner {
    protected Reflections reflections = null;
    protected static Logger log = LoggerFactory.getLogger(JSONDocScanner.class);
    protected List<ApiMethodDoc> allApiMethodDocs = new ArrayList<ApiMethodDoc>();

    public abstract ApiDoc mergeApiDoc(Class<?> var1, ApiDoc var2);

    public abstract ApiMethodDoc mergeApiMethodDoc(Method var1, Class<?> var2, ApiMethodDoc var3);

    public abstract ApiParamDoc mergeApiPathParamDoc(Method var1, int var2, ApiParamDoc var3);

    public abstract ApiParamDoc mergeApiQueryParamDoc(Method var1, int var2, ApiParamDoc var3);

    @Override
    public JSONDoc getJSONDoc(String version, String basePath, List<String> packages) {
        HashSet urls = new HashSet();
        FilterBuilder filter = new FilterBuilder();
        log.debug("Found " + packages.size() + " package(s) to scan...");
        for (String pkg : packages) {
            log.debug("Adding package to JSONDoc recursive scan: " + pkg);
            urls.addAll(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0]));
            filter.includePackage(new String[]{pkg});
        }
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)filter).setUrls(urls));
        JSONDoc jsondocDoc = new JSONDoc(version, basePath);
        jsondocDoc.setApis(this.getApiDocsMap(this.reflections.getTypesAnnotatedWith(Api.class, true)));
        jsondocDoc.setObjects(this.getApiObjectsMap(this.reflections.getTypesAnnotatedWith(ApiObject.class, true)));
        jsondocDoc.setFlows(this.getApiFlowDocsMap(this.reflections.getTypesAnnotatedWith(ApiFlowSet.class, true), this.allApiMethodDocs));
        return jsondocDoc;
    }

    @Override
    public Set<ApiDoc> getApiDocs(Set<Class<?>> classes) {
        TreeSet<ApiDoc> apiDocs = new TreeSet<ApiDoc>();
        for (Class<?> controller : classes) {
            ApiDoc apiDoc = this.getApiDoc(controller);
            apiDocs.add(apiDoc);
        }
        return apiDocs;
    }

    private ApiDoc getApiDoc(Class<?> controller) {
        log.debug("Getting JSONDoc for class: " + controller.getName());
        ApiDoc apiDoc = ApiDoc.buildFromAnnotation(controller.getAnnotation(Api.class));
        apiDoc.setSupportedversions(ApiVersionDoc.build(controller));
        apiDoc.setAuth(this.getApiAuthDocForController(controller));
        apiDoc.setMethods(this.getApiMethodDocs(controller));
        apiDoc = this.mergeApiDoc(controller, apiDoc);
        return apiDoc;
    }

    private Set<ApiMethodDoc> getApiMethodDocs(Class<?> controller) {
        Method[] methods;
        TreeSet<ApiMethodDoc> apiMethodDocs = new TreeSet<ApiMethodDoc>();
        for (Method method : methods = controller.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ApiMethod.class)) continue;
            ApiMethodDoc apiMethodDoc = this.getApiMethodDoc(method, controller);
            apiMethodDocs.add(apiMethodDoc);
        }
        this.allApiMethodDocs.addAll(apiMethodDocs);
        return apiMethodDocs;
    }

    private ApiMethodDoc getApiMethodDoc(Method method, Class<?> controller) {
        ApiMethodDoc apiMethodDoc = ApiMethodDoc.buildFromAnnotation(method.getAnnotation(ApiMethod.class));
        apiMethodDoc.setHeaders(ApiHeaderDoc.build(method));
        apiMethodDoc.setPathparameters(this.getApiPathParamDocs(method));
        apiMethodDoc.setQueryparameters(this.getApiQueryParamDocs(method));
        apiMethodDoc.setBodyobject(ApiBodyObjectDoc.build(method));
        apiMethodDoc.setResponse(ApiResponseObjectDoc.build(method));
        apiMethodDoc.setApierrors(ApiErrorDoc.build(method));
        apiMethodDoc.setSupportedversions(ApiVersionDoc.build(method));
        apiMethodDoc.setAuth(this.getApiAuthDocForMethod(method, method.getDeclaringClass()));
        apiMethodDoc = this.mergeApiMethodDoc(method, controller, apiMethodDoc);
        apiMethodDoc = this.validateApiMethodDoc(apiMethodDoc);
        return apiMethodDoc;
    }

    @Override
    public Set<ApiFlowDoc> getApiFlowDocs(Set<Class<?>> classes, List<ApiMethodDoc> apiMethodDocs) {
        TreeSet<ApiFlowDoc> apiFlowDocs = new TreeSet<ApiFlowDoc>();
        for (Class<?> clazz : classes) {
            Method[] methods;
            log.debug("Getting JSONDoc for class: " + clazz.getName());
            for (Method method : methods = clazz.getMethods()) {
                if (!method.isAnnotationPresent(ApiFlow.class)) continue;
                ApiFlowDoc apiFlowDoc = this.getApiFlowDoc(method, apiMethodDocs);
                apiFlowDocs.add(apiFlowDoc);
            }
        }
        return apiFlowDocs;
    }

    private ApiFlowDoc getApiFlowDoc(Method method, List<ApiMethodDoc> apiMethodDocs) {
        ApiFlowDoc apiFlowDoc = ApiFlowDoc.buildFromAnnotation(method.getAnnotation(ApiFlow.class), apiMethodDocs);
        return apiFlowDoc;
    }

    private ApiMethodDoc validateApiMethodDoc(ApiMethodDoc apiMethodDoc) {
        String ERROR_MISSING_METHOD_PATH = "Missing documentation data: path";
        String ERROR_MISSING_PATH_PARAM_NAME = "Missing documentation data: path parameter name";
        String ERROR_MISSING_QUERY_PARAM_NAME = "Missing documentation data: query parameter name";
        String WARN_MISSING_METHOD_PRODUCES = "Missing documentation data: produces";
        String WARN_MISSING_METHOD_CONSUMES = "Missing documentation data: consumes";
        String HINT_MISSING_PATH_PARAM_DESCRIPTION = "Add description to ApiPathParam";
        String HINT_MISSING_QUERY_PARAM_DESCRIPTION = "Add description to ApiQueryParam";
        String HINT_MISSING_METHOD_DESCRIPTION = "Add description to ApiMethod";
        String HINT_MISSING_METHOD_RESPONSE_OBJECT = "Add annotation ApiResponseObject to document the returned object";
        if (apiMethodDoc.getPath().trim().isEmpty()) {
            apiMethodDoc.setPath("Missing documentation data: path");
            apiMethodDoc.addJsondocerror("Missing documentation data: path");
        }
        for (ApiParamDoc apiParamDoc : apiMethodDoc.getPathparameters()) {
            if (apiParamDoc.getName().trim().isEmpty()) {
                apiMethodDoc.addJsondocerror("Missing documentation data: path parameter name");
            }
            if (!apiParamDoc.getDescription().trim().isEmpty()) continue;
            apiMethodDoc.addJsondochint("Add description to ApiPathParam");
        }
        for (ApiParamDoc apiParamDoc : apiMethodDoc.getQueryparameters()) {
            if (apiParamDoc.getName().trim().isEmpty()) {
                apiMethodDoc.addJsondocerror("Missing documentation data: query parameter name");
            }
            if (!apiParamDoc.getDescription().trim().isEmpty()) continue;
            apiMethodDoc.addJsondochint("Add description to ApiQueryParam");
        }
        if (apiMethodDoc.getProduces().isEmpty()) {
            apiMethodDoc.addJsondocwarning("Missing documentation data: produces");
        }
        if ((apiMethodDoc.getVerb().equals((Object)ApiVerb.POST) || apiMethodDoc.getVerb().equals((Object)ApiVerb.PUT)) && apiMethodDoc.getConsumes().isEmpty()) {
            apiMethodDoc.addJsondocwarning("Missing documentation data: consumes");
        }
        if (apiMethodDoc.getDescription().trim().isEmpty()) {
            apiMethodDoc.addJsondochint("Add description to ApiMethod");
        }
        if (apiMethodDoc.getResponse() == null) {
            apiMethodDoc.addJsondochint("Add annotation ApiResponseObject to document the returned object");
        }
        return apiMethodDoc;
    }

    public Set<ApiParamDoc> getApiPathParamDocs(Method method) {
        ApiParamDoc apiParamDoc;
        LinkedHashSet<ApiParamDoc> docs = new LinkedHashSet<ApiParamDoc>();
        if (method.isAnnotationPresent(ApiParams.class)) {
            for (ApiPathParam apiParam : method.getAnnotation(ApiParams.class).pathparams()) {
                apiParamDoc = ApiParamDoc.buildFromAnnotation(apiParam, JSONDocTypeBuilder.build(new JSONDocType(), apiParam.clazz(), apiParam.clazz()), ApiParamType.PATH);
                docs.add(apiParamDoc);
            }
        }
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parametersAnnotations.length; ++i) {
            for (int j = 0; j < parametersAnnotations[i].length; ++j) {
                if (!(parametersAnnotations[i][j] instanceof ApiPathParam)) continue;
                ApiPathParam annotation = (ApiPathParam)parametersAnnotations[i][j];
                apiParamDoc = ApiParamDoc.buildFromAnnotation(annotation, JSONDocTypeBuilder.build(new JSONDocType(), method.getParameterTypes()[i], method.getGenericParameterTypes()[i]), ApiParamType.PATH);
                apiParamDoc = this.mergeApiPathParamDoc(method, i, apiParamDoc);
                docs.add(apiParamDoc);
            }
        }
        return docs;
    }

    public Set<ApiParamDoc> getApiQueryParamDocs(Method method) {
        ApiParamDoc apiParamDoc;
        LinkedHashSet<ApiParamDoc> docs = new LinkedHashSet<ApiParamDoc>();
        if (method.isAnnotationPresent(ApiParams.class)) {
            for (ApiQueryParam apiParam : method.getAnnotation(ApiParams.class).queryparams()) {
                apiParamDoc = ApiParamDoc.buildFromAnnotation(apiParam, JSONDocTypeBuilder.build(new JSONDocType(), apiParam.clazz(), apiParam.clazz()), ApiParamType.QUERY);
                docs.add(apiParamDoc);
            }
        }
        Annotation[][] parametersAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parametersAnnotations.length; ++i) {
            for (int j = 0; j < parametersAnnotations[i].length; ++j) {
                if (!(parametersAnnotations[i][j] instanceof ApiQueryParam)) continue;
                ApiQueryParam annotation = (ApiQueryParam)parametersAnnotations[i][j];
                apiParamDoc = ApiParamDoc.buildFromAnnotation(annotation, JSONDocTypeBuilder.build(new JSONDocType(), method.getParameterTypes()[i], method.getGenericParameterTypes()[i]), ApiParamType.QUERY);
                apiParamDoc = this.mergeApiQueryParamDoc(method, i, apiParamDoc);
                docs.add(apiParamDoc);
            }
        }
        return docs;
    }

    @Override
    public Set<ApiObjectDoc> getApiObjectDocs(Set<Class<?>> classes) {
        TreeSet<ApiObjectDoc> apiObjectDocs = new TreeSet<ApiObjectDoc>();
        for (Class<?> clazz : classes) {
            log.debug("Getting JSONDoc for class: " + clazz.getName());
            ApiObject annotation = clazz.getAnnotation(ApiObject.class);
            ApiObjectDoc apiObjectDoc = ApiObjectDoc.buildFromAnnotation(annotation, clazz);
            apiObjectDoc.setSupportedversions(ApiVersionDoc.build(clazz));
            apiObjectDoc = this.validateApiObjectDoc(apiObjectDoc);
            if (!annotation.show()) continue;
            apiObjectDocs.add(apiObjectDoc);
        }
        return apiObjectDocs;
    }

    private ApiObjectDoc validateApiObjectDoc(ApiObjectDoc apiObjectDoc) {
        String HINT_MISSING_API_OBJECT_FIELD_DESCRIPTION = "Add description to field: %s";
        for (ApiObjectFieldDoc apiObjectFieldDoc : apiObjectDoc.getFields()) {
            if (!apiObjectFieldDoc.getDescription().trim().isEmpty()) continue;
            apiObjectDoc.addJsondochint(String.format("Add description to field: %s", apiObjectFieldDoc.getName()));
        }
        return apiObjectDoc;
    }

    public Map<String, Set<ApiDoc>> getApiDocsMap(Set<Class<?>> classes) {
        TreeMap<String, Set<ApiDoc>> apiDocsMap = new TreeMap<String, Set<ApiDoc>>();
        Set<ApiDoc> apiDocSet = this.getApiDocs(classes);
        for (ApiDoc apiDoc : apiDocSet) {
            if (apiDocsMap.containsKey(apiDoc.getGroup())) {
                ((Set)apiDocsMap.get(apiDoc.getGroup())).add(apiDoc);
                continue;
            }
            TreeSet<ApiDoc> groupedPojoDocs = new TreeSet<ApiDoc>();
            groupedPojoDocs.add(apiDoc);
            apiDocsMap.put(apiDoc.getGroup(), groupedPojoDocs);
        }
        return apiDocsMap;
    }

    public Map<String, Set<ApiObjectDoc>> getApiObjectsMap(Set<Class<?>> classes) {
        TreeMap<String, Set<ApiObjectDoc>> objectsMap = new TreeMap<String, Set<ApiObjectDoc>>();
        Set<ApiObjectDoc> apiObjectDocSet = this.getApiObjectDocs(classes);
        for (ApiObjectDoc apiObjectDoc : apiObjectDocSet) {
            if (objectsMap.containsKey(apiObjectDoc.getGroup())) {
                ((Set)objectsMap.get(apiObjectDoc.getGroup())).add(apiObjectDoc);
                continue;
            }
            TreeSet<ApiObjectDoc> groupedPojoDocs = new TreeSet<ApiObjectDoc>();
            groupedPojoDocs.add(apiObjectDoc);
            objectsMap.put(apiObjectDoc.getGroup(), groupedPojoDocs);
        }
        return objectsMap;
    }

    public Map<String, Set<ApiFlowDoc>> getApiFlowDocsMap(Set<Class<?>> classes, List<ApiMethodDoc> apiMethodDocs) {
        TreeMap<String, Set<ApiFlowDoc>> apiFlowDocsMap = new TreeMap<String, Set<ApiFlowDoc>>();
        Set<ApiFlowDoc> apiFlowDocSet = this.getApiFlowDocs(classes, apiMethodDocs);
        for (ApiFlowDoc apiFlowDoc : apiFlowDocSet) {
            if (apiFlowDocsMap.containsKey(apiFlowDoc.getGroup())) {
                ((Set)apiFlowDocsMap.get(apiFlowDoc.getGroup())).add(apiFlowDoc);
                continue;
            }
            TreeSet<ApiFlowDoc> groupedFlowDocs = new TreeSet<ApiFlowDoc>();
            groupedFlowDocs.add(apiFlowDoc);
            apiFlowDocsMap.put(apiFlowDoc.getGroup(), groupedFlowDocs);
        }
        return apiFlowDocsMap;
    }

    protected ApiAuthDoc getApiAuthDocForController(Class<?> clazz) {
        if (clazz.isAnnotationPresent(ApiAuthNone.class)) {
            return ApiAuthDoc.buildFromApiAuthNoneAnnotation(clazz.getAnnotation(ApiAuthNone.class));
        }
        if (clazz.isAnnotationPresent(ApiAuthBasic.class)) {
            return ApiAuthDoc.buildFromApiAuthBasicAnnotation(clazz.getAnnotation(ApiAuthBasic.class));
        }
        return null;
    }

    protected ApiAuthDoc getApiAuthDocForMethod(Method method, Class<?> clazz) {
        if (method.isAnnotationPresent(ApiAuthNone.class)) {
            return ApiAuthDoc.buildFromApiAuthNoneAnnotation(method.getAnnotation(ApiAuthNone.class));
        }
        if (method.isAnnotationPresent(ApiAuthBasic.class)) {
            return ApiAuthDoc.buildFromApiAuthBasicAnnotation(method.getAnnotation(ApiAuthBasic.class));
        }
        return this.getApiAuthDocForController(clazz);
    }

    public static String[] enumConstantsToStringArray(Object[] enumConstants) {
        String[] sarr = new String[enumConstants.length];
        for (int i = 0; i < enumConstants.length; ++i) {
            sarr[i] = String.valueOf(enumConstants[i]);
        }
        return sarr;
    }
}

