/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.pojo;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jsondoc.core.annotation.ApiVersion;

public class ApiVersionDoc {
    private String since;
    private String until;

    public static ApiVersionDoc build(Class<?> clazz) {
        if (clazz.isAnnotationPresent(ApiVersion.class)) {
            return ApiVersionDoc.buildFromAnnotation(clazz.getAnnotation(ApiVersion.class));
        }
        return null;
    }

    public static ApiVersionDoc build(Method method) {
        if (method.isAnnotationPresent(ApiVersion.class)) {
            return ApiVersionDoc.buildFromAnnotation(method.getAnnotation(ApiVersion.class));
        }
        return null;
    }

    public static ApiVersionDoc build(Field field) {
        if (field.isAnnotationPresent(ApiVersion.class)) {
            return ApiVersionDoc.buildFromAnnotation(field.getAnnotation(ApiVersion.class));
        }
        return null;
    }

    private static ApiVersionDoc buildFromAnnotation(ApiVersion annotation) {
        ApiVersionDoc apiVersionDoc = new ApiVersionDoc();
        apiVersionDoc.setSince(annotation.since());
        apiVersionDoc.setUntil(annotation.until());
        return apiVersionDoc;
    }

    public String getSince() {
        return this.since;
    }

    public void setSince(String since) {
        this.since = since;
    }

    public String getUntil() {
        return this.until;
    }

    public void setUntil(String until) {
        this.until = until;
    }
}

