/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.pojo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.pojo.AbstractDoc;
import org.jsondoc.core.pojo.ApiAuthDoc;
import org.jsondoc.core.pojo.ApiBodyObjectDoc;
import org.jsondoc.core.pojo.ApiErrorDoc;
import org.jsondoc.core.pojo.ApiHeaderDoc;
import org.jsondoc.core.pojo.ApiParamDoc;
import org.jsondoc.core.pojo.ApiResponseObjectDoc;
import org.jsondoc.core.pojo.ApiVerb;
import org.jsondoc.core.pojo.ApiVersionDoc;

public class ApiMethodDoc
extends AbstractDoc
implements Comparable<ApiMethodDoc> {
    public String jsondocId = UUID.randomUUID().toString();
    private String id;
    private String path;
    private String description;
    private ApiVerb verb;
    private Set<String> produces;
    private Set<String> consumes;
    private Set<ApiHeaderDoc> headers = new LinkedHashSet<ApiHeaderDoc>();
    private Set<ApiParamDoc> pathparameters = new LinkedHashSet<ApiParamDoc>();
    private Set<ApiParamDoc> queryparameters = new LinkedHashSet<ApiParamDoc>();
    private ApiBodyObjectDoc bodyobject;
    private ApiResponseObjectDoc response;
    private List<ApiErrorDoc> apierrors = new ArrayList<ApiErrorDoc>();
    private ApiVersionDoc supportedversions;
    private ApiAuthDoc auth;
    private String responsestatuscode;

    public static ApiMethodDoc buildFromAnnotation(ApiMethod annotation) {
        ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
        apiMethodDoc.setId(annotation.id());
        apiMethodDoc.setPath(annotation.path());
        apiMethodDoc.setDescription(annotation.description());
        apiMethodDoc.setVerb(annotation.verb());
        apiMethodDoc.setConsumes(new LinkedHashSet<String>(Arrays.asList(annotation.consumes())));
        apiMethodDoc.setProduces(new LinkedHashSet<String>(Arrays.asList(annotation.produces())));
        apiMethodDoc.setResponsestatuscode(annotation.responsestatuscode());
        return apiMethodDoc;
    }

    public ApiMethodDoc() {
        this.produces = new LinkedHashSet<String>();
        this.consumes = new LinkedHashSet<String>();
    }

    public Set<ApiHeaderDoc> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Set<ApiHeaderDoc> headers) {
        this.headers = headers;
    }

    public Set<String> getProduces() {
        return this.produces;
    }

    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    public Set<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    public ApiVerb getVerb() {
        return this.verb;
    }

    public void setVerb(ApiVerb verb) {
        this.verb = verb;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<ApiParamDoc> getPathparameters() {
        return this.pathparameters;
    }

    public void setPathparameters(Set<ApiParamDoc> pathparameters) {
        this.pathparameters = pathparameters;
    }

    public Set<ApiParamDoc> getQueryparameters() {
        return this.queryparameters;
    }

    public void setQueryparameters(Set<ApiParamDoc> queryparameters) {
        this.queryparameters = queryparameters;
    }

    public ApiResponseObjectDoc getResponse() {
        return this.response;
    }

    public void setResponse(ApiResponseObjectDoc response) {
        this.response = response;
    }

    public ApiBodyObjectDoc getBodyobject() {
        return this.bodyobject;
    }

    public void setBodyobject(ApiBodyObjectDoc bodyobject) {
        this.bodyobject = bodyobject;
    }

    public List<ApiErrorDoc> getApierrors() {
        return this.apierrors;
    }

    public void setApierrors(List<ApiErrorDoc> apierrors) {
        this.apierrors = apierrors;
    }

    public ApiVersionDoc getSupportedversions() {
        return this.supportedversions;
    }

    public void setSupportedversions(ApiVersionDoc supportedversions) {
        this.supportedversions = supportedversions;
    }

    public ApiAuthDoc getAuth() {
        return this.auth;
    }

    public void setAuth(ApiAuthDoc auth) {
        this.auth = auth;
    }

    public String getResponsestatuscode() {
        return this.responsestatuscode;
    }

    public void setResponsestatuscode(String responsestatuscode) {
        this.responsestatuscode = responsestatuscode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int compareTo(ApiMethodDoc o) {
        int i = this.path.compareTo(o.getPath());
        if (i != 0) {
            return i;
        }
        i = this.verb.compareTo(o.getVerb());
        if (i != 0) {
            return i;
        }
        return i;
    }
}

