/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.pojo;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import org.jsondoc.core.annotation.ApiHeader;
import org.jsondoc.core.annotation.ApiHeaders;

public class ApiHeaderDoc {
    public String jsondocId = UUID.randomUUID().toString();
    private String name;
    private String description;
    private String[] allowedvalues;

    public ApiHeaderDoc(String name, String description, String[] allowedvalues) {
        this.name = name;
        this.description = description;
        this.allowedvalues = allowedvalues;
    }

    public static Set<ApiHeaderDoc> build(Method method) {
        LinkedHashSet<ApiHeaderDoc> docs = new LinkedHashSet<ApiHeaderDoc>();
        if (method.isAnnotationPresent(ApiHeaders.class)) {
            ApiHeaders annotation = method.getAnnotation(ApiHeaders.class);
            for (ApiHeader apiHeader : annotation.headers()) {
                docs.add(new ApiHeaderDoc(apiHeader.name(), apiHeader.description(), apiHeader.allowedvalues()));
            }
        }
        return docs;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getAllowedvalues() {
        return this.allowedvalues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiHeaderDoc other = (ApiHeaderDoc)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

