/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.pojo;

import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.pojo.ApiAuthDoc;
import org.jsondoc.core.pojo.ApiMethodDoc;
import org.jsondoc.core.pojo.ApiVersionDoc;

public class ApiDoc
implements Comparable<ApiDoc> {
    public String jsondocId = UUID.randomUUID().toString();
    private String name;
    private String description;
    private Set<ApiMethodDoc> methods = new TreeSet<ApiMethodDoc>();
    private ApiVersionDoc supportedversions;
    private ApiAuthDoc auth;
    private String group;

    public static ApiDoc buildFromAnnotation(Api api) {
        ApiDoc apiDoc = new ApiDoc();
        apiDoc.setDescription(api.description());
        apiDoc.setName(api.name());
        apiDoc.setGroup(api.group());
        return apiDoc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<ApiMethodDoc> getMethods() {
        return this.methods;
    }

    public void setMethods(Set<ApiMethodDoc> methods) {
        this.methods = methods;
    }

    public void addMethod(ApiMethodDoc apiMethod) {
        this.methods.add(apiMethod);
    }

    @Override
    public int compareTo(ApiDoc o) {
        return this.name.compareTo(o.getName());
    }

    public ApiVersionDoc getSupportedversions() {
        return this.supportedversions;
    }

    public void setSupportedversions(ApiVersionDoc supportedversions) {
        this.supportedversions = supportedversions;
    }

    public ApiAuthDoc getAuth() {
        return this.auth;
    }

    public void setAuth(ApiAuthDoc auth) {
        this.auth = auth;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

