/*
 * Decompiled with CFR 0.152.
 */
package muster.codec.json;

import muster.Ast;
import muster.InputCursor$;
import muster.codec.json.JsonInputCursor;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class JsonInputCursor$class {
    public static Option readArrayOpt(JsonInputCursor $this) {
        return new Some((Object)new JsonInputCursor.JsonArrayNode($this));
    }

    public static Option readObjectOpt(JsonInputCursor $this) {
        return new Some((Object)new JsonInputCursor.JsonObjectNode($this));
    }

    public static Option readStringOpt(JsonInputCursor $this) {
        $this.skipWhiteSpace();
        char end = $this.iterator().current();
        boolean shouldContinue = $this.iterator().hasNext();
        boolean seenEnd = false;
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        while (shouldContinue) {
            char c = BoxesRunTime.unboxToChar((Object)$this.iterator().next());
            switch (c) {
                default: {
                    sb.append(c);
                    shouldContinue = $this.iterator().hasNext();
                    Object object = BoxedUnit.UNIT;
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    throw $this.failParse(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected control char at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.iterator().pos())})));
                }
                case '\\': {
                    Object object;
                    if ($this.iterator().hasNext()) {
                        char c2 = BoxesRunTime.unboxToChar((Object)$this.iterator().next());
                        switch (c2) {
                            default: {
                                Object object2 = BoxedUnit.UNIT;
                                break;
                            }
                            case 'x': {
                                char[] chars = new char[]{BoxesRunTime.unboxToChar((Object)$this.iterator().next()), BoxesRunTime.unboxToChar((Object)$this.iterator().next())};
                                int codePoint = Integer.parseInt(new String(chars), 16);
                                Object object2 = sb.appendCodePoint(codePoint);
                                break;
                            }
                            case 'u': {
                                char[] chars = new char[]{BoxesRunTime.unboxToChar((Object)$this.iterator().next()), BoxesRunTime.unboxToChar((Object)$this.iterator().next()), BoxesRunTime.unboxToChar((Object)$this.iterator().next()), BoxesRunTime.unboxToChar((Object)$this.iterator().next())};
                                int codePoint = Integer.parseInt(new String(chars), 16);
                                Object object2 = sb.appendCodePoint(codePoint);
                                break;
                            }
                            case '\"': {
                                Object object2 = sb.append('\"');
                                break;
                            }
                            case '\'': {
                                Object object2 = sb.append('\'');
                                break;
                            }
                            case '/': {
                                Object object2 = sb.append('/');
                                break;
                            }
                            case '\\': {
                                Object object2 = sb.append('\\');
                                break;
                            }
                            case 'b': {
                                Object object2 = sb.append('\b');
                                break;
                            }
                            case 'f': {
                                Object object2 = sb.append('\f');
                                break;
                            }
                            case 'r': {
                                Object object2 = sb.append('\r');
                                break;
                            }
                            case 'n': {
                                Object object2 = sb.append('\n');
                                break;
                            }
                            case 't': {
                                Object object2 = sb.append('\t');
                            }
                        }
                        shouldContinue = $this.iterator().hasNext();
                        object = BoxedUnit.UNIT;
                        break;
                    }
                    throw $this.failParse("Tried to move past the end of the input");
                }
                case '\"': 
                case '\'': {
                    Object object;
                    if (end == $this.iterator().current()) {
                        Object object3 = $this.iterator().hasNext() ? $this.iterator().next() : BoxedUnit.UNIT;
                        shouldContinue = false;
                        seenEnd = true;
                        object = BoxedUnit.UNIT;
                        break;
                    }
                    object = sb.append($this.iterator().current());
                }
            }
        }
        if (seenEnd) {
            return new Some((Object)new Ast.TextNode(sb.toString()));
        }
        throw $this.failParse(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input ended too early while trying to find a closing quote for a string at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.iterator().pos())})));
    }

    public static Option readBooleanOpt(JsonInputCursor $this) {
        block4: {
            Ast.TrueNode$ trueNode$;
            block3: {
                block2: {
                    $this.skipWhiteSpace();
                    if ($this.iterator().current() != 't' || $this.iterator().peek() != 'r' || $this.iterator().charAt($this.iterator().pos() + 2) != 'u' || $this.iterator().charAt($this.iterator().pos() + 3) != 'e') break block2;
                    $this.iterator().next();
                    $this.iterator().next();
                    $this.iterator().next();
                    trueNode$ = Ast.TrueNode$.MODULE$;
                    break block3;
                }
                if ($this.iterator().current() != 'f' || $this.iterator().peek() != 'a' || $this.iterator().charAt($this.iterator().pos() + 2) != 'l' || $this.iterator().charAt($this.iterator().pos() + 3) != 's' || $this.iterator().charAt($this.iterator().pos() + 4) != 'e') break block4;
                $this.iterator().next();
                $this.iterator().next();
                $this.iterator().next();
                $this.iterator().next();
                trueNode$ = Ast.FalseNode$.MODULE$;
            }
            Ast.TrueNode$ node = trueNode$;
            Object object = $this.iterator().hasNext() && $this.iterator().current() == 'e' ? $this.iterator().next() : BoxedUnit.UNIT;
            return new Some((Object)node);
        }
        throw $this.failParse(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected char '", "' at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)$this.iterator().current()), BoxesRunTime.boxToInteger((int)$this.iterator().pos())})));
    }

    public static Option readNumberOpt(JsonInputCursor $this) {
        $this.skipWhiteSpace();
        StringBuilder sb = new StringBuilder();
        while ($this.iterator().hasNext() && InputCursor$.MODULE$.isNumberChar($this.iterator().current())) {
            sb.append($this.iterator().current());
            $this.iterator().next();
        }
        return new Some((Object)new Ast.NumberNode(sb.toString()));
    }

    public static void skipWhiteSpace(JsonInputCursor $this) {
        while ($this.iterator().hasNext() && InputCursor$.MODULE$.isWhitespace($this.iterator().current())) {
            $this.iterator().next();
        }
    }

    public static boolean hasNextNode(JsonInputCursor $this) {
        return $this.iterator().hasNext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Ast.AstNode nextNode(JsonInputCursor $this) {
        while ($this.iterator().hasNext()) {
            char c = $this.iterator().current();
            switch (c) {
                default: {
                    throw $this.failParse(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected char '", "' at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)$this.iterator().current()), BoxesRunTime.boxToInteger((int)$this.iterator().pos())})));
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'E': 
                case 'e': {
                    Ast.NumberNode numberNode = $this.readNumber();
                    return numberNode;
                }
                case 'N': {
                    throw $this.failParse(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected char '", "' at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)$this.iterator().current()), BoxesRunTime.boxToInteger((int)$this.iterator().pos())})));
                }
                case 'f': 
                case 't': {
                    Ast.NumberNode numberNode = $this.readBoolean();
                    return numberNode;
                }
                case 'n': {
                    if ($this.size() < $this.iterator().pos() + 3 || $this.iterator().peek() != 'u' || $this.iterator().charAt($this.iterator().pos() + 2) != 'l' || $this.iterator().charAt($this.iterator().pos() + 3) != 'l') throw $this.failParse(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected char '", "' at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)$this.iterator().current()), BoxesRunTime.boxToInteger((int)$this.iterator().pos())})));
                    Ast.NumberNode numberNode = Ast.NullNode$.MODULE$;
                    return numberNode;
                }
                case '\'': {
                    throw $this.failParse(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected char '", "' at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)$this.iterator().current()), BoxesRunTime.boxToInteger((int)$this.iterator().pos())})));
                }
                case '\"': {
                    Ast.NumberNode numberNode = $this.readString();
                    return numberNode;
                }
                case '[': {
                    Ast.NumberNode numberNode = $this.readArray();
                    return numberNode;
                }
                case '{': {
                    Ast.NumberNode numberNode = $this.readObject();
                    return numberNode;
                }
                case ':': 
                case ']': 
                case '}': {
                    throw $this.failParse(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected char '", "' at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)$this.iterator().current()), BoxesRunTime.boxToInteger((int)$this.iterator().pos())})));
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
            }
            $this.skipWhiteSpace();
        }
        throw $this.failParse("Tried to move past the end of the input");
    }

    public static void $init$(JsonInputCursor $this) {
    }
}

