/*
 * Decompiled with CFR 0.152.
 */
package muster.codec.json;

import com.fasterxml.jackson.databind.JsonNode;
import muster.Ast;
import muster.MappingException;
import muster.codec.json.JackonInputCursor;
import muster.codec.json.JacksonInputCursor;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;

public abstract class JacksonInputCursor$class {
    public static Option readArrayOpt(JacksonInputCursor $this) {
        JsonNode node;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    node = $this.node();
                    if (!node.isNull() && !node.isMissingNode()) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (!node.isArray()) break block4;
                none$ = new Some((Object)new JackonInputCursor.JacksonArrayNode(node));
            }
            return none$;
        }
        throw new MappingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected an array but found a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getClass().getSimpleName()})));
    }

    public static Option readObjectOpt(JacksonInputCursor $this) {
        JsonNode node;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    node = $this.node();
                    if (!node.isNull() && !node.isMissingNode()) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (!node.isObject()) break block4;
                none$ = new Some((Object)new JackonInputCursor.JacksonObjectNode(node));
            }
            return none$;
        }
        throw new MappingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected an object but found a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getClass().getSimpleName()})));
    }

    public static Option readStringOpt(JacksonInputCursor $this) {
        JsonNode node;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    node = $this.node();
                    if (!node.isNull() && !node.isMissingNode()) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (!node.isTextual()) break block4;
                none$ = new Some((Object)new Ast.TextNode(node.asText()));
            }
            return none$;
        }
        throw new MappingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected an array but found a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getClass().getSimpleName()})));
    }

    public static Option readBooleanOpt(JacksonInputCursor $this) {
        JsonNode node;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    node = $this.node();
                    if (!node.isNull() && !node.isMissingNode()) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (!node.isBoolean()) break block4;
                none$ = new Some(node.asBoolean() ? Ast.TrueNode$.MODULE$ : Ast.FalseNode$.MODULE$);
            }
            return none$;
        }
        throw new MappingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a boolean but found a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getClass().getSimpleName()})));
    }

    public static Option readNumberOpt(JacksonInputCursor $this) {
        JsonNode node;
        block5: {
            None$ none$;
            block3: {
                block4: {
                    block2: {
                        node = $this.node();
                        if (!node.isNull() && !node.isMissingNode()) break block2;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                    if (!node.isNumber()) break block4;
                    none$ = new Some((Object)new Ast.NumberNode(node.asText()));
                    break block3;
                }
                if (!node.isTextual()) break block5;
                none$ = new Some((Object)new Ast.NumberNode(node.asText()));
            }
            return none$;
        }
        throw new MappingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a number but found a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.getClass().getSimpleName()})));
    }

    public static Ast.AstNode nextNode(JacksonInputCursor $this) {
        block9: {
            Object object;
            block3: {
                JsonNode node;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        node = $this.node();
                                        if (!node.isNull()) break block2;
                                        object = Ast.NullNode$.MODULE$;
                                        break block3;
                                    }
                                    if (!node.isMissingNode()) break block4;
                                    object = Ast.UndefinedNode$.MODULE$;
                                    break block3;
                                }
                                if (!node.isArray()) break block5;
                                object = new JackonInputCursor.JacksonArrayNode(node);
                                break block3;
                            }
                            if (!node.isObject()) break block6;
                            object = new JackonInputCursor.JacksonObjectNode(node);
                            break block3;
                        }
                        if (!node.isTextual()) break block7;
                        object = new Ast.TextNode(node.asText());
                        break block3;
                    }
                    if (!node.isNumber()) break block8;
                    object = new Ast.NumberNode(node.asText());
                    break block3;
                }
                if (!node.isBoolean()) break block9;
                object = node.asBoolean() ? Ast.TrueNode$.MODULE$ : Ast.FalseNode$.MODULE$;
            }
            return object;
        }
        throw new MappingException("Unable to determine the type of this json");
    }

    public static void $init$(JacksonInputCursor $this) {
    }
}

