/*
 * Decompiled with CFR 0.152.
 */
package org.json4s.native;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.json4s.AsJsonInput;
import org.json4s.AsJsonInput$;
import org.json4s.FileInput;
import org.json4s.JArray;
import org.json4s.JBool$;
import org.json4s.JDecimal;
import org.json4s.JDouble;
import org.json4s.JField$;
import org.json4s.JInt;
import org.json4s.JLong;
import org.json4s.JNothing$;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.JsonInput;
import org.json4s.ParserUtil;
import org.json4s.ReaderInput;
import org.json4s.StreamInput;
import org.json4s.StringInput;
import org.json4s.native.JsonParser;
import org.json4s.native.JsonParser$CloseArr$;
import org.json4s.native.JsonParser$CloseObj$;
import org.json4s.native.JsonParser$End$;
import org.json4s.native.JsonParser$NullVal$;
import org.json4s.native.JsonParser$OpenArr$;
import org.json4s.native.JsonParser$OpenObj$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public final class JsonParser$ {
    public static final JsonParser$ MODULE$ = new JsonParser$();
    private static final Function3<JsonParser.Parser, Object, Object, JValue> astParser = (Function3 & Serializable)(p, useBigDecimal, useBigIntForLong) -> JsonParser$.$anonfun$astParser$1(p, BoxesRunTime.unboxToBoolean((Object)useBigDecimal), BoxesRunTime.unboxToBoolean((Object)useBigIntForLong));
    public static final char org$json4s$native$JsonParser$$EOF = (char)-1;

    public <A> JValue parse(A in, boolean useBigDecimalForDouble, AsJsonInput<A> evidence$1) {
        return this.parse(in, useBigDecimalForDouble, true, evidence$1);
    }

    public <A> JValue parse(A in, boolean useBigDecimalForDouble, boolean useBigIntForLong, AsJsonInput<A> evidence$2) {
        JValue jValue;
        JsonInput jsonInput = AsJsonInput$.MODULE$.asJsonInput(in, evidence$2);
        if (jsonInput instanceof StringInput) {
            StringInput stringInput = (StringInput)jsonInput;
            String s = stringInput.string();
            jValue = this.parseFromString(s, useBigDecimalForDouble, useBigIntForLong);
        } else if (jsonInput instanceof ReaderInput) {
            ReaderInput readerInput = (ReaderInput)jsonInput;
            Reader rdr = readerInput.reader();
            jValue = this.parseFromReader(rdr, true, useBigDecimalForDouble, useBigIntForLong);
        } else if (jsonInput instanceof StreamInput) {
            StreamInput streamInput = (StreamInput)jsonInput;
            InputStream stream = streamInput.stream();
            jValue = this.parseFromReader(new InputStreamReader(stream, "UTF-8"), true, useBigDecimalForDouble, useBigIntForLong);
        } else if (jsonInput instanceof FileInput) {
            FileInput fileInput = (FileInput)jsonInput;
            File file = fileInput.file();
            jValue = this.parseFromReader(new FileReader(file), true, useBigDecimalForDouble, useBigIntForLong);
        } else {
            throw new MatchError((Object)jsonInput);
        }
        return jValue;
    }

    public JValue parse(String s) throws ParserUtil.ParseException {
        return this.parse(s, false, true, AsJsonInput$.MODULE$.stringAsJsonInput());
    }

    public JValue parse(String s, boolean useBigDecimalForDouble) throws ParserUtil.ParseException {
        return this.parse(s, useBigDecimalForDouble, true, AsJsonInput$.MODULE$.stringAsJsonInput());
    }

    private JValue parseFromString(String s, boolean useBigDecimalForDouble, boolean useBigIntForLong) {
        return this.parse(new ParserUtil.Buffer((Reader)new StringReader(s), false), useBigDecimalForDouble, useBigIntForLong);
    }

    public JValue parse(Reader s, boolean closeAutomatically, boolean useBigDecimalForDouble, boolean useBigIntForLong) throws ParserUtil.ParseException {
        return this.parseFromReader(s, closeAutomatically, useBigDecimalForDouble, useBigIntForLong);
    }

    private JValue parseFromReader(Reader s, boolean closeAutomatically, boolean useBigDecimalForDouble, boolean useBigIntForLong) {
        return this.parse(new ParserUtil.Buffer(s, closeAutomatically), useBigDecimalForDouble, useBigIntForLong);
    }

    public Option<JValue> parseOpt(String s) {
        return this.parseOpt(s, false);
    }

    public Option<JValue> parseOpt(String s, boolean useBigDecimalForDouble) {
        None$ none$;
        try {
            none$ = this.parse(s, useBigDecimalForDouble).toOption();
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<JValue> parseOpt(Reader s, boolean closeAutomatically, boolean useBigDecimalForDouble) {
        None$ none$;
        try {
            none$ = this.parse(s, closeAutomatically, useBigDecimalForDouble, AsJsonInput$.MODULE$.readerAsJsonInput()).toOption();
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p) {
        return this.parse(s, p, false);
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p, boolean useBigDecimalForDouble) {
        return this.parse(new StringReader(s), p, useBigDecimalForDouble);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p) {
        return this.parse(s, p, false);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p, boolean useBigDecimalForDouble) {
        return this.parse(s, p, useBigDecimalForDouble, true);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p, boolean useBigDecimalForDouble, boolean useBigIntForLong) {
        return (A)p.apply((Object)new JsonParser.Parser(new ParserUtil.Buffer(s, false), useBigDecimalForDouble, useBigIntForLong));
    }

    private JValue parse(ParserUtil.Buffer buf, boolean useBigDecimal, boolean useBigInt) {
        JValue jValue;
        try {
            try {
                jValue = (JValue)astParser.apply((Object)new JsonParser.Parser(buf, useBigDecimal, useBigInt), (Object)BoxesRunTime.boxToBoolean((boolean)useBigDecimal), (Object)BoxesRunTime.boxToBoolean((boolean)useBigInt));
            }
            catch (ParserUtil.ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParserUtil.ParseException("parsing failed", e);
            }
        }
        finally {
            buf.release();
        }
        return jValue;
    }

    public boolean parse$default$2() {
        return true;
    }

    public boolean parse$default$3() {
        return false;
    }

    public boolean parse$default$4() {
        return true;
    }

    public boolean parseOpt$default$2() {
        return true;
    }

    public boolean parseOpt$default$3() {
        return false;
    }

    private static final JValue reverse$1(JValue v2) {
        JValue jValue;
        JValue jValue2 = v2;
        if (jValue2 instanceof JObject) {
            JObject jObject = (JObject)jValue2;
            List l = jObject.obj();
            jValue = new JObject(l.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String n = (String)tuple2._1();
                JValue v = (JValue)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)n, (Object)JsonParser$.reverse$1(v));
                return tuple22;
            }).reverse());
        } else if (jValue2 instanceof JArray) {
            JArray jArray = (JArray)jValue2;
            List l = jArray.arr();
            jValue = new JArray(l.map((Function1 & Serializable)v -> JsonParser$.reverse$1(v)).reverse());
        } else {
            jValue = jValue2;
        }
        return jValue;
    }

    private static final JValue toJValue$1(Object x, JsonParser.Parser p$1) {
        JValue jValue;
        Object object = x;
        if (!(object instanceof JValue)) {
            Throwable throwable;
            Option option;
            if (object instanceof Throwable && !(option = NonFatal$.MODULE$.unapply(throwable = (Throwable)object)).isEmpty()) {
                throw p$1.fail(new StringBuilder(17).append("unexpected field ").append(x).toString());
            }
            throw new MatchError(object);
        }
        JValue jValue2 = jValue = (JValue)object;
        return jValue2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void closeBlock$1(Object v, JsonParser.Parser p$1, JsonParser.ValStack vals$1, ObjectRef root$1) {
        Object a;
        Object o;
        boolean bl = false;
        Some some = null;
        Option<Object> option = vals$1.peekOption();
        if (option instanceof Some) {
            Tuple2 tuple2;
            Object name;
            bl = true;
            some = (Some)option;
            Object object = some.value();
            if (object instanceof Tuple2 && (name = (tuple2 = (Tuple2)object)._1()) instanceof String) {
                String string = (String)name;
                vals$1.pop(Tuple2.class);
                JObject obj = vals$1.peek(JObject.class);
                Tuple2 tuple22 = new Tuple2((Object)string, (Object)JsonParser$.toJValue$1(v, p$1));
                vals$1.replace(new JObject(obj.obj().$colon$colon((Object)tuple22)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (o = some.value()) instanceof JObject) {
            JObject jObject = (JObject)o;
            Tuple2 tuple2 = vals$1.peek(Tuple2.class);
            vals$1.replace(new JObject(jObject.obj().$colon$colon((Object)tuple2)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl && (a = some.value()) instanceof JArray) {
            JArray jArray = (JArray)a;
            JValue jValue = JsonParser$.toJValue$1(v, p$1);
            vals$1.replace(new JArray(jArray.arr().$colon$colon((Object)jValue)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl) {
            Object x = some.value();
            throw p$1.fail(new StringBuilder(40).append("expected field, array or object but got ").append(x).toString());
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        root$1.elem = new Some((Object)JsonParser$.reverse$1(JsonParser$.toJValue$1(v, p$1)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void newValue$1(JValue v, JsonParser.ValStack vals$1, JsonParser.Parser p$1) {
        Tuple2 tuple2;
        Object name;
        Object object = vals$1.peekAny();
        if (object instanceof Tuple2 && (name = (tuple2 = (Tuple2)object)._1()) instanceof String) {
            String string = (String)name;
            vals$1.pop(Tuple2.class);
            JObject obj = vals$1.peek(JObject.class);
            Tuple2 tuple22 = new Tuple2((Object)string, (Object)v);
            vals$1.replace(new JObject(obj.obj().$colon$colon((Object)tuple22)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof JArray) {
            JArray jArray = (JArray)object;
            JValue jValue = v;
            vals$1.replace(new JArray(jArray.arr().$colon$colon((Object)jValue)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw p$1.fail("expected field or array");
        }
    }

    private static final void go$1(ObjectRef token$1, JsonParser.Parser p$1, JsonParser.ValStack vals$1, ObjectRef root$1) {
        token$1.elem = p$1.nextToken();
        JsonParser.Token token = (JsonParser.Token)token$1.elem;
        if (JsonParser$OpenObj$.MODULE$.equals(token)) {
            vals$1.push(new JObject((List)package$.MODULE$.Nil()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (token instanceof JsonParser.FieldStart) {
            JsonParser.FieldStart fieldStart = (JsonParser.FieldStart)token;
            String name = fieldStart.name();
            vals$1.push(JField$.MODULE$.apply(name, null));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (token instanceof JsonParser.StringVal) {
            JsonParser.StringVal stringVal = (JsonParser.StringVal)token;
            String x = stringVal.value();
            JsonParser$.newValue$1((JValue)new JString(x), vals$1, p$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (token instanceof JsonParser.IntVal) {
            JsonParser.IntVal intVal = (JsonParser.IntVal)token;
            BigInt x = intVal.value();
            JsonParser$.newValue$1((JValue)new JInt(x), vals$1, p$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (token instanceof JsonParser.LongVal) {
            JsonParser.LongVal longVal = (JsonParser.LongVal)token;
            long x = longVal.value();
            JsonParser$.newValue$1((JValue)new JLong(x), vals$1, p$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (token instanceof JsonParser.DoubleVal) {
            JsonParser.DoubleVal doubleVal = (JsonParser.DoubleVal)token;
            double x = doubleVal.value();
            JsonParser$.newValue$1((JValue)new JDouble(x), vals$1, p$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (token instanceof JsonParser.BigDecimalVal) {
            JsonParser.BigDecimalVal bigDecimalVal = (JsonParser.BigDecimalVal)token;
            BigDecimal x = bigDecimalVal.value();
            JsonParser$.newValue$1((JValue)new JDecimal(x), vals$1, p$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (token instanceof JsonParser.BoolVal) {
            JsonParser.BoolVal boolVal = (JsonParser.BoolVal)token;
            boolean x = boolVal.value();
            JsonParser$.newValue$1((JValue)JBool$.MODULE$.apply(x), vals$1, p$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsonParser$NullVal$.MODULE$.equals(token)) {
            JsonParser$.newValue$1((JValue)JNull$.MODULE$, vals$1, p$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsonParser$CloseObj$.MODULE$.equals(token)) {
            JsonParser$.closeBlock$1(vals$1.popAny(), p$1, vals$1, root$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsonParser$OpenArr$.MODULE$.equals(token)) {
            vals$1.push(new JArray((List)package$.MODULE$.Nil()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsonParser$CloseArr$.MODULE$.equals(token)) {
            JsonParser$.closeBlock$1(vals$1.pop(JArray.class), p$1, vals$1, root$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsonParser$End$.MODULE$.equals(token)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)token);
        }
    }

    public static final /* synthetic */ JValue $anonfun$astParser$1(JsonParser.Parser p, boolean useBigDecimal, boolean useBigIntForLong) {
        JsonParser.ValStack vals = new JsonParser.ValStack(p);
        ObjectRef token = ObjectRef.create(null);
        ObjectRef root = ObjectRef.create((Object)None$.MODULE$);
        JsonParser$.go$1(token, p, vals, root);
        while (true) {
            JsonParser.Token token2 = (JsonParser.Token)token.elem;
            JsonParser$End$ jsonParser$End$ = JsonParser$End$.MODULE$;
            if (!(token2 == null ? jsonParser$End$ != null : !token2.equals(jsonParser$End$))) break;
            JsonParser$.go$1(token, p, vals, root);
        }
        return (JValue)((Option)root.elem).getOrElse((Function0 & Serializable)() -> JNothing$.MODULE$);
    }

    private JsonParser$() {
    }
}

