/*
 * Decompiled with CFR 0.152.
 */
package org.json4s.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.Serializable;
import org.json4s.JArray;
import org.json4s.JBool;
import org.json4s.JDecimal;
import org.json4s.JDouble;
import org.json4s.JInt;
import org.json4s.JLong;
import org.json4s.JNothing$;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JSet;
import org.json4s.JString;
import org.json4s.JValue;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005u2A\u0001B\u0003\u0001\u0019!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C!)q\u0007\u0001C!q\t\u0001\"JV1mk\u0016\u001cVM]5bY&TXM\u001d\u0006\u0003\r\u001d\tqA[1dWN|gN\u0003\u0002\t\u0013\u00051!n]8oiMT\u0011AC\u0001\u0004_J<7\u0001A\n\u0003\u00015\u00012A\u0004\f\u0019\u001b\u0005y!B\u0001\t\u0012\u0003!!\u0017\r^1cS:$'B\u0001\u0004\u0013\u0015\t\u0019B#A\u0005gCN$XM\u001d=nY*\tQ#A\u0002d_6L!aF\b\u0003\u001d)\u001bxN\\*fe&\fG.\u001b>feB\u0011\u0011DG\u0007\u0002\u000f%\u00111d\u0002\u0002\u0007\u0015Z\u000bG.^3\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005)\u0011!C:fe&\fG.\u001b>f)\u0011\u0011\u0003F\u000b\u001a\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006S\t\u0001\r\u0001G\u0001\u0006m\u0006dW/\u001a\u0005\u0006W\t\u0001\r\u0001L\u0001\u0005UN|g\u000e\u0005\u0002.a5\taF\u0003\u00020#\u0005!1m\u001c:f\u0013\t\tdFA\u0007Kg>tw)\u001a8fe\u0006$xN\u001d\u0005\u0006g\t\u0001\r\u0001N\u0001\taJ|g/\u001b3feB\u0011a\"N\u0005\u0003m=\u0011!cU3sS\u0006d\u0017N_3s!J|g/\u001b3fe\u00069\u0011n]#naRLHCA\u001d=!\t\u0019#(\u0003\u0002<I\t9!i\\8mK\u0006t\u0007\"B\u0015\u0004\u0001\u0004A\u0002")
public class JValueSerializer
extends JsonSerializer<JValue> {
    public void serialize(JValue value, JsonGenerator json, SerializerProvider provider) {
        if (value == null) {
            json.writeNull();
        } else {
            JValue jValue = value;
            if (jValue instanceof JInt) {
                JInt jInt = (JInt)jValue;
                BigInt v = jInt.num();
                json.writeNumber(v.bigInteger());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JLong) {
                JLong jLong = (JLong)jValue;
                long v = jLong.num();
                json.writeNumber(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JDouble) {
                JDouble jDouble = (JDouble)jValue;
                double v = jDouble.num();
                json.writeNumber(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JDecimal) {
                JDecimal jDecimal = (JDecimal)jValue;
                BigDecimal v = jDecimal.num();
                json.writeNumber(v.bigDecimal());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JString) {
                JString jString = (JString)jValue;
                String v = jString.s();
                json.writeString(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JBool) {
                JBool jBool = (JBool)jValue;
                boolean v = jBool.value();
                json.writeBoolean(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JArray) {
                JArray jArray = (JArray)jValue;
                List elements = jArray.arr();
                json.writeStartArray();
                elements.foreach((Function1 & Serializable)x -> {
                    this.serialize(x, json, provider);
                    return BoxedUnit.UNIT;
                });
                json.writeEndArray();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JSet) {
                JSet jSet = (JSet)jValue;
                Set elements = jSet.set();
                json.writeStartArray();
                elements.foreach((Function1 & Serializable)x -> {
                    this.serialize(x, json, provider);
                    return BoxedUnit.UNIT;
                });
                json.writeEndArray();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JObject) {
                JObject jObject = (JObject)jValue;
                List fields = jObject.obj();
                json.writeStartObject();
                fields.foreach((Function1 & Serializable)x0$1 -> {
                    JValueSerializer.$anonfun$serialize$3(this, json, provider, x0$1);
                    return BoxedUnit.UNIT;
                });
                json.writeEndObject();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (JNull$.MODULE$.equals(jValue)) {
                json.writeNull();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (JNothing$.MODULE$.equals(jValue)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)jValue);
            }
        }
    }

    public boolean isEmpty(JValue value) {
        JValue jValue = value;
        JNothing$ jNothing$ = JNothing$.MODULE$;
        return !(jValue != null ? !jValue.equals(jNothing$) : jNothing$ != null);
    }

    public static final /* synthetic */ void $anonfun$serialize$3(JValueSerializer $this, JsonGenerator json$1, SerializerProvider provider$1, Tuple2 x0$1) {
        JValue jValue;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && JNothing$.MODULE$.equals(jValue = (JValue)tuple2._2())) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (tuple2 != null) {
            String n = (String)tuple2._1();
            JValue v = (JValue)tuple2._2();
            json$1.writeFieldName(n);
            $this.serialize(v, json$1, provider$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)tuple2);
        }
    }
}

