/*
 * Decompiled with CFR 0.152.
 */
package org.json4s;

import java.io.Writer;
import org.json4s.ArrayStreamingJsonWriter;
import org.json4s.JsonWriter;
import org.json4s.ObjectStreamingJsonWriter;
import org.json4s.ParserUtil$;
import org.json4s.StreamingJsonWriter;

public final class FieldStreamingJsonWriter<T extends Writer>
extends StreamingJsonWriter<T> {
    private final String name;
    private final boolean isFirst;
    private final Writer nodes;
    private final int level;
    private final ObjectStreamingJsonWriter<T> parent;
    private final boolean pretty;
    private final int spaces;
    private final boolean alwaysEscapeUnicode;

    public FieldStreamingJsonWriter(String name, boolean isFirst, T nodes, int level, ObjectStreamingJsonWriter<T> parent, boolean pretty, int spaces, boolean alwaysEscapeUnicode) {
        this.name = name;
        this.isFirst = isFirst;
        this.nodes = nodes;
        this.level = level;
        this.parent = parent;
        this.pretty = pretty;
        this.spaces = spaces;
        this.alwaysEscapeUnicode = alwaysEscapeUnicode;
    }

    @Override
    public T nodes() {
        return (T)this.nodes;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public boolean pretty() {
        return this.pretty;
    }

    @Override
    public int spaces() {
        return this.spaces;
    }

    @Override
    public boolean alwaysEscapeUnicode() {
        return this.alwaysEscapeUnicode;
    }

    @Override
    public T result() {
        return this.nodes();
    }

    @Override
    public JsonWriter<T> startArray() {
        this.writeName(true);
        return new ArrayStreamingJsonWriter<T>(this.nodes(), this.level() + 1, this.parent, this.pretty(), this.spaces(), this.alwaysEscapeUnicode());
    }

    @Override
    public JsonWriter<T> startObject() {
        this.writeName(true);
        return new ObjectStreamingJsonWriter<T>(this.nodes(), this.level() + 1, this.parent, this.pretty(), this.spaces(), this.alwaysEscapeUnicode());
    }

    private void writeName(boolean hasPretty) {
        if (!this.isFirst) {
            ((Writer)this.nodes()).write(",");
            this.writePretty(this.writePretty$default$1());
        }
        ((Writer)this.nodes()).append("\"");
        ParserUtil$.MODULE$.quote(this.name, this.nodes(), this.alwaysEscapeUnicode());
        ((Writer)this.nodes()).append("\":");
    }

    @Override
    public JsonWriter<T> addNode(String node) {
        this.writeName(false);
        ((Writer)this.nodes()).append(node);
        return this.parent;
    }

    @Override
    public JsonWriter<T> addAndQuoteNode(String node) {
        this.writeName(false);
        ((Writer)this.nodes()).append("\"");
        ParserUtil$.MODULE$.quote(node, this.nodes(), this.alwaysEscapeUnicode());
        ((Writer)this.nodes()).append("\"");
        return this.parent;
    }
}

