/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.classpath.ClassPath;
import com.google.classpath.ClassPathFactory;
import com.google.classpath.RegExpResourceFilter;
import com.google.classpath.ResourceFilter;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SmartUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartUtils.class);
    @Inject
    private ObjectMapper mapper;
    @Inject
    @Named(value="YamlMapper")
    private ObjectMapper yamlMapper;

    public <T> String getItRight() throws IOException {
        String jsonAsString = this.mapper.toString();
        return jsonAsString;
    }

    public <T> String getJsonDocumentAsString(String fileName) throws IOException {
        String jsonAsString = Resources.toString((URL)this.getClass().getClassLoader().getResource(fileName), (Charset)StandardCharsets.UTF_8);
        return jsonAsString;
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding == null ? StandardCharsets.UTF_8 : encoding);
    }

    public static String readJsonAsString(String scenarioFile) {
        try {
            scenarioFile = SmartUtils.replaceHome(scenarioFile);
            if (SmartUtils.isValidAbsolutePath(scenarioFile)) {
                return SmartUtils.readFile(scenarioFile, StandardCharsets.UTF_8);
            }
            return Resources.toString((URL)Resources.getResource((String)scenarioFile), (Charset)Charset.defaultCharset());
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while parsing the 'Test Scenario' file:{}. Check if it is present n in correct format" + scenarioFile);
            throw new RuntimeException("Exception occurred while reading the 'Test Scenario' file - " + scenarioFile);
        }
    }

    public static String readYamlAsString(String yamlFile) {
        return SmartUtils.readJsonAsString(yamlFile);
    }

    public Map<String, Object> readJsonStringAsMap(String json) throws IOException {
        HashMap<String, Object> map = new HashMap();
        map = (Map)this.mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return map;
    }

    public static List<String> getAllEndPointFiles(String packageName) {
        if (SmartUtils.isValidAbsolutePath(packageName)) {
            return SmartUtils.retrieveScenariosByAbsPath(packageName);
        }
        ClassPathFactory factory = new ClassPathFactory();
        ClassPath jvmClassPath = factory.createFromJVM();
        String[] allSimulationFiles = jvmClassPath.findResources(packageName, (ResourceFilter)new RegExpResourceFilter(".*", ".*\\.json$"));
        if (null == allSimulationFiles || allSimulationFiles.length == 0) {
            LOGGER.error("Test folder is empty or not correctly setup.");
            throw new RuntimeException("NothingFoundHereException: Check the (" + packageName + ") integration test repo folder(empty?). ");
        }
        return Arrays.asList(allSimulationFiles);
    }

    public static List<String> retrieveScenariosByAbsPath(String packageName) {
        packageName = SmartUtils.replaceHome(packageName);
        try {
            return Files.walk(Paths.get(packageName, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(aPath -> aPath.toString()).collect(Collectors.toList());
        }
        catch (IOException exx) {
            LOGGER.error("Exception during reading absolute suite folder - " + exx);
            throw new RuntimeException("Exception during reading absolute suite folder - " + exx);
        }
    }

    public <T> T scenarioFileToJava(String scenarioFile, Class<T> clazz) throws IOException {
        if (scenarioFile.endsWith(".yml") || scenarioFile.endsWith(".yaml")) {
            return (T)this.yamlMapper.readValue(SmartUtils.readYamlAsString(scenarioFile), clazz);
        }
        return (T)this.mapper.readValue(SmartUtils.readJsonAsString(scenarioFile), clazz);
    }

    public static boolean isValidAbsolutePath(String path) {
        Path actualPath = Paths.get(path = SmartUtils.replaceHome(path), new String[0]).toAbsolutePath();
        File file = actualPath.toFile();
        return file.isAbsolute() && file.exists();
    }

    public static String replaceHome(String path) {
        path = path.replaceFirst("^~", System.getProperty("user.home"));
        return path;
    }

    public List<ScenarioSpec> getScenarioSpecListByPackage(String packageName) {
        List<String> allEndPointFiles = SmartUtils.getAllEndPointFiles(packageName);
        List<ScenarioSpec> scenarioSpecList = allEndPointFiles.stream().map(testResource -> {
            try {
                return this.scenarioFileToJava((String)testResource, (Class)ScenarioSpec.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while deserializing to Spec. Details: " + e);
            }
        }).collect(Collectors.toList());
        return scenarioSpecList;
    }

    public void checkDuplicateScenarios(String testPackageName) {
        HashSet oops = new HashSet();
        this.getScenarioSpecListByPackage(testPackageName).stream().forEach(scenarioSpec -> {
            if (!oops.add(scenarioSpec.getScenarioName())) {
                throw new RuntimeException("Oops! Can not run with multiple Scenarios with same name. Found duplicate: " + scenarioSpec.getScenarioName());
            }
        });
    }

    public static String prettyPrintJson(String jsonString) {
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        try {
            JsonNode jsonNode = (JsonNode)objectMapper.readValue(jsonString, JsonNode.class);
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        }
        catch (IOException e) {
            LOGGER.error("Non-JSON content was encountered. So pretty print did not format it and returned the raw text");
            return jsonString;
        }
    }

    public static String prettyPrintJson(JsonNode jsonNode) {
        String indented = jsonNode.toString();
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        }
        catch (IOException e) {
            return indented;
        }
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public static String resolveToken(String stringWithToken, Map<String, String> paramMap) {
        StrSubstitutor sub = new StrSubstitutor(paramMap);
        return sub.replace(stringWithToken);
    }

    public static String getEnvPropertyValue(String envPropertyKey) {
        String propertyValue = System.getProperty(envPropertyKey);
        if (propertyValue != null) {
            return propertyValue;
        }
        return System.getenv(envPropertyKey);
    }
}

