/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.utils;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jsmart.zerocode.core.utils.ApiType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTypeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiTypeUtils.class);
    public static final String JAVA_API_PROTOCOL_MAPPINGS = "java.api.protocol.mappings";
    @Inject(optional=true)
    @Named(value="java.api.protocol.mappings")
    private String javaApiProtoMappings;

    public ApiTypeUtils() {
    }

    public ApiTypeUtils(String javaApiProtoMappings) {
        this.javaApiProtoMappings = javaApiProtoMappings;
    }

    public static ApiType apiType(String serviceName, String methodName) {
        ApiType apiType = StringUtils.isEmpty((String)serviceName) || StringUtils.isEmpty((String)methodName) ? ApiType.NONE : (serviceName.contains("://") && !serviceName.startsWith("http") ? ApiType.JAVA_CALL : (serviceName != null && serviceName.contains("/") ? ApiType.REST_CALL : (serviceName != null && serviceName.contains("kafka") ? ApiType.KAFKA_CALL : ApiType.JAVA_CALL)));
        return apiType;
    }

    public String getQualifiedJavaApi(String url) {
        if (!url.contains("://")) {
            return url;
        }
        return this.findMapping(this.javaApiProtoMappings, url);
    }

    private String findMapping(String javaApiProtoMappings, String url) {
        LOGGER.info("Locating protocol service mapping for - '{}'", (Object)url);
        if (StringUtils.isEmpty((String)javaApiProtoMappings)) {
            LOGGER.error("Protocol mapping was null or empty. Please create the mappings first and then rerun");
            throw new RuntimeException("\nProtocol mapping was null or empty.");
        }
        List<String> mappingList = Arrays.asList(javaApiProtoMappings.split(","));
        String foundMapping = mappingList.stream().filter(thisMapping -> thisMapping.startsWith(url)).findFirst().orElseThrow(() -> new RuntimeException("\nurl '" + url + "' Not found"));
        String qualifiedClazz = foundMapping.split("\\|")[1];
        LOGGER.info("Found protocol mapping for - '{} -> {}'", (Object)url, (Object)qualifiedClazz);
        return qualifiedClazz;
    }
}

