/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.runner;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jsmart.zerocode.core.di.main.ApplicationMainModule;
import org.jsmart.zerocode.core.di.module.RuntimeHttpClientModule;
import org.jsmart.zerocode.core.di.module.RuntimeKafkaClientModule;
import org.jsmart.zerocode.core.domain.HostProperties;
import org.jsmart.zerocode.core.domain.JsonTestCase;
import org.jsmart.zerocode.core.domain.Scenario;
import org.jsmart.zerocode.core.domain.ScenarioSpec;
import org.jsmart.zerocode.core.domain.TargetEnv;
import org.jsmart.zerocode.core.domain.UseHttpClient;
import org.jsmart.zerocode.core.domain.UseKafkaClient;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeExecReportBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeIoWriteBuilder;
import org.jsmart.zerocode.core.engine.listener.ZeroCodeTestReportListener;
import org.jsmart.zerocode.core.httpclient.BasicHttpClient;
import org.jsmart.zerocode.core.httpclient.ssl.SslTrustHttpClient;
import org.jsmart.zerocode.core.kafka.client.BasicKafkaClient;
import org.jsmart.zerocode.core.kafka.client.ZerocodeCustomKafkaClient;
import org.jsmart.zerocode.core.logbuilder.ZerocodeCorrelationshipLogger;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunner;
import org.jsmart.zerocode.core.runner.ZeroCodeMultiStepsScenarioRunnerImpl;
import org.jsmart.zerocode.core.utils.RunnerUtils;
import org.jsmart.zerocode.core.utils.SmartUtils;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeUnitRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeUnitRunner.class);
    private ZeroCodeMultiStepsScenarioRunner zeroCodeMultiStepsScenarioRunner;
    private final Class<?> testClass;
    private Injector injector;
    private SmartUtils smartUtils;
    private HostProperties hostProperties;
    private String host;
    private String context;
    private int port;
    private List<String> smartTestCaseNames = new ArrayList<String>();
    private String currentTestCase;
    private ZerocodeCorrelationshipLogger corrLogger;
    protected boolean testRunCompleted;
    protected boolean passed;
    private ZeroCodeMultiStepsScenarioRunner multiStepsRunner;

    public ZeroCodeUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.testClass = klass;
        this.smartUtils = this.getInjectedSmartUtilsClass();
        this.smartTestCaseNames = this.getSmartChildrenList();
        this.hostProperties = this.testClass.getAnnotation(HostProperties.class);
        if (this.hostProperties != null) {
            this.host = this.hostProperties.host();
            this.port = this.hostProperties.port();
            this.context = this.hostProperties.context();
        }
        this.multiStepsRunner = this.createZeroCodeMultiStepRunner();
    }

    public void run(RunNotifier notifier) {
        RunListener reportListener = this.createReportListener();
        LOGGER.info("System property zerocode.junit=" + System.getProperty("zerocode.junit"));
        if (!"gen-smart-charts-csv-reports".equals(System.getProperty("zerocode.junit"))) {
            notifier.addListener(reportListener);
        }
        super.run(notifier);
        this.handleNoRunListenerReport(reportListener);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        JsonTestCase jsonTestCaseAnno = method.getMethod().getAnnotation(JsonTestCase.class);
        if (jsonTestCaseAnno == null) {
            jsonTestCaseAnno = this.evalScenarioToJsonTestCase(method.getMethod().getAnnotation(Scenario.class));
        }
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
        } else if (jsonTestCaseAnno != null) {
            this.runLeafJsonTest(notifier, description, jsonTestCaseAnno);
        } else {
            this.runLeafJUnitTest(this.methodBlock(method), description, notifier);
        }
    }

    public List<String> getSmartTestCaseNames() {
        return this.smartTestCaseNames;
    }

    public String getCurrentTestCase() {
        return this.currentTestCase;
    }

    private ZeroCodeMultiStepsScenarioRunner getInjectedMultiStepsRunner() {
        this.zeroCodeMultiStepsScenarioRunner = (ZeroCodeMultiStepsScenarioRunner)this.getMainModuleInjector().getInstance(ZeroCodeMultiStepsScenarioRunner.class);
        return this.zeroCodeMultiStepsScenarioRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector getMainModuleInjector() {
        ZeroCodeUnitRunner zeroCodeUnitRunner = this;
        synchronized (zeroCodeUnitRunner) {
            TargetEnv envAnnotation = this.testClass.getAnnotation(TargetEnv.class);
            String serverEnv = envAnnotation != null ? envAnnotation.value() : "config_hosts.properties";
            serverEnv = RunnerUtils.getEnvSpecificConfigFile(serverEnv, this.testClass);
            Class<? extends BasicHttpClient> runtimeHttpClient = this.createCustomHttpClientOrDefault();
            Class<? extends BasicKafkaClient> runtimeKafkaClient = this.createCustomKafkaClientOrDefault();
            this.injector = Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new ApplicationMainModule(serverEnv)}).with(new Module[]{new RuntimeHttpClientModule(runtimeHttpClient), new RuntimeKafkaClientModule(runtimeKafkaClient)})});
            return this.injector;
        }
    }

    public Class<? extends BasicKafkaClient> createCustomKafkaClientOrDefault() {
        UseKafkaClient kafkaClientAnnotated = this.getUseKafkaClient();
        return kafkaClientAnnotated != null ? kafkaClientAnnotated.value() : ZerocodeCustomKafkaClient.class;
    }

    public Class<? extends BasicHttpClient> createCustomHttpClientOrDefault() {
        UseHttpClient httpClientAnnotated = this.getUseHttpClient();
        return httpClientAnnotated != null ? httpClientAnnotated.value() : SslTrustHttpClient.class;
    }

    public UseHttpClient getUseHttpClient() {
        return this.testClass.getAnnotation(UseHttpClient.class);
    }

    public UseKafkaClient getUseKafkaClient() {
        return this.testClass.getAnnotation(UseKafkaClient.class);
    }

    protected RunListener createReportListener() {
        return (RunListener)this.getMainModuleInjector().getInstance(ZeroCodeTestReportListener.class);
    }

    protected SmartUtils getInjectedSmartUtilsClass() {
        return (SmartUtils)this.getMainModuleInjector().getInstance(SmartUtils.class);
    }

    protected ZeroCodeReportGenerator getInjectedReportGenerator() {
        return (ZeroCodeReportGenerator)this.getMainModuleInjector().getInstance(ZeroCodeReportGenerator.class);
    }

    private void runLeafJsonTest(RunNotifier notifier, Description description, JsonTestCase jsonTestCaseAnno) {
        if (jsonTestCaseAnno != null) {
            this.currentTestCase = jsonTestCaseAnno.value();
        }
        notifier.fireTestStarted(description);
        LOGGER.debug("### Running currentTestCase : " + this.currentTestCase);
        ScenarioSpec child = null;
        try {
            child = this.smartUtils.scenarioFileToJava(this.currentTestCase, ScenarioSpec.class);
            LOGGER.debug("### Found currentTestCase : -" + child);
            this.passed = this.multiStepsRunner.runScenario(child, notifier, description);
        }
        catch (Exception ioEx) {
            ioEx.printStackTrace();
            notifier.fireTestFailure(new Failure(description, (Throwable)ioEx));
        }
        this.testRunCompleted = true;
        if (this.passed) {
            LOGGER.info(String.format("\n**FINISHED executing all Steps for [%s] **.\nSteps were:%s", child.getScenarioName(), child.getSteps().stream().map(step -> step.getName() == null ? step.getId() : step.getName()).collect(Collectors.toList())));
        }
        notifier.fireTestFinished(description);
    }

    private List<String> getSmartChildrenList() {
        List children = this.getChildren();
        children.forEach(frameworkMethod -> {
            JsonTestCase jsonTestCaseAnno = (JsonTestCase)frameworkMethod.getAnnotation(JsonTestCase.class);
            if (jsonTestCaseAnno == null) {
                jsonTestCaseAnno = this.evalScenarioToJsonTestCase((Scenario)frameworkMethod.getAnnotation(Scenario.class));
            }
            if (jsonTestCaseAnno != null) {
                this.smartTestCaseNames.add(jsonTestCaseAnno.value());
            } else {
                this.smartTestCaseNames.add(frameworkMethod.getName());
            }
        });
        return this.smartTestCaseNames;
    }

    private ZeroCodeMultiStepsScenarioRunner createZeroCodeMultiStepRunner() {
        ZeroCodeMultiStepsScenarioRunner multiStepsRunner = this.getInjectedMultiStepsRunner();
        if (this.hostProperties != null) {
            ((ZeroCodeMultiStepsScenarioRunnerImpl)multiStepsRunner).overrideHost(this.host);
            ((ZeroCodeMultiStepsScenarioRunnerImpl)multiStepsRunner).overridePort(this.port);
            ((ZeroCodeMultiStepsScenarioRunnerImpl)multiStepsRunner).overrideApplicationContext(this.context);
        }
        return multiStepsRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runLeafJUnitTest(Statement statement, Description description, RunNotifier notifier) {
        LOGGER.info("Running a pure JUnit test...");
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        eachNotifier.fireTestStarted();
        String logPrefixRelationshipId = this.prepareRequestReport(description);
        try {
            statement.evaluate();
            this.passed = true;
            LOGGER.info("JUnit test passed = {} ", (Object)this.passed);
        }
        catch (AssumptionViolatedException e) {
            this.passed = false;
            LOGGER.warn("JUnit test failed due to : {},  passed = {}", (Object)e, (Object)this.passed);
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            this.passed = false;
            LOGGER.warn("JUnit test failed due to : {},  passed = {}", (Object)e, (Object)this.passed);
            eachNotifier.addFailure(e);
        }
        finally {
            LOGGER.info("JUnit test run completed. See the results in the console or log.  passed = {}", (Object)this.passed);
            this.prepareResponseReport(logPrefixRelationshipId);
            this.buildReportAndPrintToFile(description);
            eachNotifier.fireTestFinished();
        }
    }

    private void buildReportAndPrintToFile(Description description) {
        ZeroCodeExecReportBuilder reportResultBuilder = ZeroCodeExecReportBuilder.newInstance().loop(0).scenarioName(description.getClassName());
        reportResultBuilder.step(this.corrLogger.buildReportSingleStep());
        ZeroCodeIoWriteBuilder reportBuilder = ZeroCodeIoWriteBuilder.newInstance().timeStamp(LocalDateTime.now());
        reportBuilder.result(reportResultBuilder.build());
        reportBuilder.printToFile(description.getClassName() + this.corrLogger.getCorrelationId() + ".json");
    }

    private void prepareResponseReport(String logPrefixRelationshipId) {
        LocalDateTime timeNow = LocalDateTime.now();
        LOGGER.info("JUnit *responseTimeStamp:{}, \nJUnit Response:{}", (Object)timeNow, (Object)logPrefixRelationshipId);
        this.corrLogger.aResponseBuilder().relationshipId(logPrefixRelationshipId).responseTimeStamp(timeNow);
        this.corrLogger.stepOutcome(this.passed);
        this.corrLogger.buildResponseDelay();
    }

    private String prepareRequestReport(Description description) {
        this.corrLogger = ZerocodeCorrelationshipLogger.newInstance(LOGGER);
        this.corrLogger.stepLoop(0);
        String logPrefixRelationshipId = this.corrLogger.createRelationshipId();
        LocalDateTime timeNow = LocalDateTime.now();
        this.corrLogger.aRequestBuilder().stepLoop(0).relationshipId(logPrefixRelationshipId).requestTimeStamp(timeNow).step(description.getMethodName());
        LOGGER.info("JUnit *requestTimeStamp:{}, \nJUnit Request:{}", (Object)timeNow, (Object)logPrefixRelationshipId);
        return logPrefixRelationshipId;
    }

    protected void handleNoRunListenerReport(RunListener reportListener) {
        RunnerUtils.handleTestCompleted(reportListener, LOGGER);
    }

    private JsonTestCase evalScenarioToJsonTestCase(final Scenario scenario) {
        JsonTestCase jsonTestCase = new JsonTestCase(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return JsonTestCase.class;
            }

            @Override
            public String value() {
                return scenario != null ? scenario.value() : null;
            }
        };
        return jsonTestCase.value() == null ? null : jsonTestCase;
    }
}

