/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.report;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.markuputils.CodeLanguage;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jsmart.zerocode.core.domain.builders.ExtentReportsFactory;
import org.jsmart.zerocode.core.domain.builders.HighChartColumnHtmlBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeChartKeyValueArrayBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeChartKeyValueBuilder;
import org.jsmart.zerocode.core.domain.builders.ZeroCodeCsvReportBuilder;
import org.jsmart.zerocode.core.domain.reports.ZeroCodeExecResult;
import org.jsmart.zerocode.core.domain.reports.ZeroCodeReport;
import org.jsmart.zerocode.core.domain.reports.ZeroCodeReportStep;
import org.jsmart.zerocode.core.domain.reports.chart.HighChartColumnHtml;
import org.jsmart.zerocode.core.domain.reports.csv.ZeroCodeCsvReport;
import org.jsmart.zerocode.core.report.HighChartColumnHtmlWriter;
import org.jsmart.zerocode.core.report.ZeroCodeReportGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCodeReportGeneratorImpl
implements ZeroCodeReportGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroCodeReportGeneratorImpl.class);
    private static String spikeChartFileName;
    @Inject(optional=true)
    @Named(value="report.spike.chart.enabled")
    private boolean spikeChartReportEnabled;
    @Inject(optional=true)
    @Named(value="interactive.html.report.disabled")
    private boolean interactiveHtmlReportDisabled;
    private final ObjectMapper mapper;
    private List<ZeroCodeReport> treeReports;
    private List<ZeroCodeCsvReport> zeroCodeCsvFlattenedRows;
    private List<ZeroCodeCsvReport> csvRows = new ArrayList<ZeroCodeCsvReport>();

    @Inject
    public ZeroCodeReportGeneratorImpl(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    List<ZeroCodeReportStep> getUniqueSteps(List<ZeroCodeReportStep> steps) {
        LinkedHashMap result = new LinkedHashMap();
        steps.forEach(step -> result.merge(step.getCorrelationId(), step, (s1, s2) -> "PASSED".equals(s1.getResult()) ? s1 : s2));
        return new ArrayList<ZeroCodeReportStep>(result.values());
    }

    @Override
    public void generateExtentReport() {
        if (this.interactiveHtmlReportDisabled) {
            return;
        }
        ExtentReports extentReports = ExtentReportsFactory.createReportTheme("target/zerocode-junit-interactive-fuzzy-search.html");
        this.linkToSpikeChartIfEnabled();
        this.treeReports.forEach(thisReport -> thisReport.getResults().forEach(thisScenario -> {
            ExtentTest test = extentReports.createTest(thisScenario.getScenarioName());
            test.assignCategory(new String[]{"Regression"});
            test.assignCategory(new String[]{this.optionalCategory(thisScenario.getScenarioName())});
            test.assignAuthor(new String[]{this.optionalAuthor(thisScenario.getScenarioName())});
            List<ZeroCodeReportStep> thisScenarioUniqueSteps = this.getUniqueSteps(thisScenario.getSteps());
            thisScenarioUniqueSteps.forEach(thisStep -> {
                test.getModel().setStartTime(ZeroCodeReportGeneratorImpl.utilDateOf(thisStep.getRequestTimeStamp()));
                test.getModel().setEndTime(ZeroCodeReportGeneratorImpl.utilDateOf(thisStep.getResponseTimeStamp()));
                Status testStatus = thisStep.getResult().equals("PASSED") ? Status.PASS : Status.FAIL;
                ExtentTest step = test.createNode(thisStep.getName(), "TEST-STEP-CORRELATION-ID: " + thisStep.getCorrelationId());
                if (testStatus.equals((Object)Status.PASS)) {
                    step.pass(thisStep.getResult());
                } else {
                    step.info(MarkupHelper.createCodeBlock((String)(thisStep.getOperation() + "\t" + thisStep.getUrl())));
                    step.info(MarkupHelper.createCodeBlock((String)thisStep.getRequest(), (CodeLanguage)CodeLanguage.JSON));
                    step.info(MarkupHelper.createCodeBlock((String)thisStep.getResponse(), (CodeLanguage)CodeLanguage.JSON));
                    step.fail(MarkupHelper.createCodeBlock((String)("Reason:\n" + thisStep.getAssertions())));
                }
                extentReports.flush();
            });
        }));
    }

    public void linkToSpikeChartIfEnabled() {
        if (this.spikeChartReportEnabled || spikeChartFileName != null) {
            String reportName = ExtentReportsFactory.getReportName();
            String linkCodeToTargetSpikeChartHtml = String.format("<code>&nbsp;&nbsp;<a href='%s' style=\"color: #006; background: #ff6;\"> %s </a></code>", spikeChartFileName, "Spike Chart(Click here)");
            ExtentReportsFactory.reportName(reportName + linkCodeToTargetSpikeChartHtml);
        }
    }

    protected String optionalAuthor(String scenarioName) {
        String authorName = this.deriveName(scenarioName, "@@");
        authorName = "Anonymous".equals(authorName) ? this.deriveName(scenarioName, "@") : authorName;
        return authorName;
    }

    protected String optionalCategory(String scenarioName) {
        return this.deriveName(scenarioName, "#");
    }

    private String deriveName(String scenarioName, String marker) {
        String authorName = StringUtils.substringBetween((String)scenarioName, (String)marker, (String)marker);
        if (authorName == null) {
            authorName = StringUtils.substringBetween((String)scenarioName, (String)marker, (String)",");
        }
        if (authorName == null) {
            authorName = StringUtils.substringBetween((String)scenarioName, (String)marker, (String)" ");
        }
        if (authorName == null) {
            authorName = scenarioName.substring(scenarioName.lastIndexOf(marker) + marker.length());
        }
        if (scenarioName.lastIndexOf(marker) == -1 || StringUtils.isEmpty((String)authorName)) {
            authorName = "Anonymous";
        }
        return authorName;
    }

    protected String onlyScenarioName(String scenarioName) {
        int index = scenarioName.indexOf("@@");
        if (index == -1) {
            return scenarioName;
        }
        return scenarioName.substring(0, index - 1);
    }

    @Override
    public void generateCsvReport() {
        this.treeReports = this.readZeroCodeReportsByPath("target/zerocode-test-reports/");
        this.zeroCodeCsvFlattenedRows = this.buildCsvRows();
        this.generateCsvReport(this.zeroCodeCsvFlattenedRows);
    }

    @Override
    public void generateHighChartReport() {
        LOGGER.info("####spikeChartReportEnabled: " + this.spikeChartReportEnabled);
        if (this.spikeChartReportEnabled) {
            HighChartColumnHtml highChartColumnHtml = this.convertCsvRowsToHighChartData(this.zeroCodeCsvFlattenedRows);
            this.generateHighChartReport(highChartColumnHtml);
        }
    }

    private HighChartColumnHtml convertCsvRowsToHighChartData(List<ZeroCodeCsvReport> zeroCodeCsvReportRows) {
        HighChartColumnHtmlBuilder highChartColumnHtmlBuilder = HighChartColumnHtmlBuilder.newInstance().chartSeriesName("Test Results").chartTitleTop("Request Vs Response Delay Chart").textYaxis("Response Delay in Milli Sec").chartTitleTopInABox("Spike Chart ( Milli Seconds )");
        ZeroCodeChartKeyValueArrayBuilder dataArrayBuilder = ZeroCodeChartKeyValueArrayBuilder.newInstance();
        zeroCodeCsvReportRows.forEach(thisRow -> dataArrayBuilder.kv(ZeroCodeChartKeyValueBuilder.newInstance().key(thisRow.getScenarioName() + "->" + thisRow.getStepName()).value(thisRow.getResponseDelayMilliSec()).result(thisRow.getResult()).build()));
        highChartColumnHtmlBuilder.testResult(dataArrayBuilder.build());
        return highChartColumnHtmlBuilder.build();
    }

    public void generateHighChartReport(HighChartColumnHtml highChartColumnHtml) {
        HighChartColumnHtmlWriter highChartColumnHtmlWriter = new HighChartColumnHtmlWriter();
        spikeChartFileName = this.createTimeStampedFileName();
        highChartColumnHtmlWriter.generateHighChart(highChartColumnHtml, spikeChartFileName);
    }

    public void generateCsvReport(List<ZeroCodeCsvReport> zeroCodeCsvReportRows) {
        CsvSchema schema = CsvSchema.builder().setUseHeader(true).addColumn("scenarioName").addColumn("scenarioLoop", CsvSchema.ColumnType.NUMBER).addColumn("stepName").addColumn("stepLoop", CsvSchema.ColumnType.NUMBER).addColumn("correlationId").addColumn("requestTimeStamp").addColumn("responseDelayMilliSec", CsvSchema.ColumnType.NUMBER).addColumn("responseTimeStamp").addColumn("result").addColumn("method").build();
        CsvMapper csvMapper = new CsvMapper();
        csvMapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
        ObjectWriter writer = csvMapper.writer((FormatSchema)schema.withLineSeparator("\n"));
        try {
            writer.writeValue(new File("target/zerocode-junit-granular-report.csv"), zeroCodeCsvReportRows);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Exception while Writing full CSV report. Details: " + e);
        }
    }

    public List<ZeroCodeCsvReport> buildCsvRows() {
        ZeroCodeCsvReportBuilder csvFileBuilder = ZeroCodeCsvReportBuilder.newInstance();
        this.treeReports.forEach(thisReport -> thisReport.getResults().forEach(thisResult -> {
            csvFileBuilder.scenarioLoop(thisResult.getLoop());
            csvFileBuilder.scenarioName(thisResult.getScenarioName());
            thisResult.getSteps().forEach(thisStep -> {
                csvFileBuilder.stepLoop(thisStep.getLoop());
                csvFileBuilder.stepName(thisStep.getName());
                csvFileBuilder.correlationId(thisStep.getCorrelationId());
                csvFileBuilder.result(thisStep.getResult());
                csvFileBuilder.method(thisStep.getOperation());
                csvFileBuilder.requestTimeStamp(thisStep.getRequestTimeStamp().toString());
                csvFileBuilder.responseTimeStamp(thisStep.getResponseTimeStamp().toString());
                csvFileBuilder.responseDelayMilliSec(thisStep.getResponseDelay());
                this.csvRows.add(csvFileBuilder.build());
            });
        }));
        return this.csvRows;
    }

    public List<ZeroCodeReport> readZeroCodeReportsByPath(String reportsFolder) {
        this.validateReportsFolderAndTheFilesExists(reportsFolder);
        List<String> allEndPointFiles = ZeroCodeReportGeneratorImpl.getAllEndPointFilesFrom(reportsFolder);
        List<ZeroCodeReport> scenarioReports = allEndPointFiles.stream().map(reportJsonFile -> {
            try {
                return (ZeroCodeReport)this.mapper.readValue(new File((String)reportJsonFile), ZeroCodeReport.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Exception while deserializing to ZeroCodeReport. Details: " + e);
            }
        }).collect(Collectors.toList());
        for (ZeroCodeReport zeroCodeReport : scenarioReports) {
            for (ZeroCodeExecResult zeroCodeExecResult : zeroCodeReport.getResults()) {
                zeroCodeExecResult.setSteps(this.getUniqueSteps(zeroCodeExecResult.getSteps()));
            }
        }
        return scenarioReports;
    }

    public static List<String> getAllEndPointFilesFrom(String folderName) {
        File[] files = new File(folderName).listFiles((dir, name) -> name.endsWith(".json"));
        if (files == null || files.length == 0) {
            LOGGER.error("\n\t\t\t************\nNow files were found in folder:{}, hence could not proceed. \n(If this was intentional, then you can safely ignore this error) \n\t\t\t************** \n\n", (Object)folderName);
            return Collections.emptyList();
        }
        return Optional.ofNullable(Arrays.asList(files)).orElse(Collections.emptyList()).stream().map(thisFile -> thisFile.getAbsolutePath()).collect(Collectors.toList());
    }

    protected void validateReportsFolderAndTheFilesExists(String reportsFolder) {
        try {
            File[] files = new File(reportsFolder).listFiles((dir, fileName) -> fileName.endsWith(".json"));
            Optional.ofNullable(files).orElseThrow(() -> new RuntimeException("Somehow the '" + reportsFolder + "' has got no files."));
        }
        catch (Exception e) {
            String message = "\n----------------------------------------------------------------------------------------\nSomehow the '" + reportsFolder + "' is not present or has no report JSON files. \nPossible reasons- \n   1) No tests were activated or made to run via ZeroCode runner. -or- \n   2) You have simply used @RunWith(...) and ignored all tests -or- \n   3) Permission issue to create/write folder/files \n   4) Please fix it by adding/activating at least one test case or fix the file permission issue\n   5) If you are not concerned about reports, you can safely ignore this\n----------------------------------------------------------------------------------------\n";
            throw new RuntimeException(message + e);
        }
    }

    private static Date utilDateOf(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    private String createTimeStampedFileName() {
        return "zerocode_results_chart" + LocalDateTime.now().toString().replace(":", "-") + ".html";
    }
}

