/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.kafka.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jsmart.zerocode.core.di.provider.GsonSerDeProvider;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;
import org.jsmart.zerocode.core.kafka.common.KafkaCommonUtils;
import org.jsmart.zerocode.core.kafka.helper.ProducerRecordBuilder;
import org.jsmart.zerocode.core.kafka.send.message.ProducerJsonRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaProducerHelper.class);
    private static final Gson gson = new GsonSerDeProvider().get();
    private static final ObjectMapper objectMapper = new ObjectMapperProvider().get();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Producer<Long, String> createProducer(String bootStrapServers, String producerPropertyFile) {
        try (InputStream propsIs = Resources.getResource((String)producerPropertyFile).openStream();){
            Properties properties = new Properties();
            properties.load(propsIs);
            properties.put("bootstrap.servers", bootStrapServers);
            KafkaCommonUtils.resolveValuePlaceHolders(properties);
            KafkaProducer kafkaProducer = new KafkaProducer(properties);
            return kafkaProducer;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while reading kafka producer properties - " + e);
        }
    }

    public static void validateProduceRecord(List producerRecords) {
        if (producerRecords == null || producerRecords.size() == 0) {
            throw new RuntimeException("--------> No record was found or invalid record format was found <--------");
        }
    }

    public static ProducerRecord prepareRecordToSend(String topicName, ProducerRecord recordToSend) {
        return new ProducerRecord(topicName, recordToSend.partition(), recordToSend.timestamp(), recordToSend.key(), recordToSend.value(), (Iterable)recordToSend.headers());
    }

    public static ProducerRecord<Object, Object> prepareJsonRecordToSend(String topicName, ProducerJsonRecord recordToSend, String recordType, String requestJson) {
        return ProducerRecordBuilder.from(topicName, recordToSend.getKey(), "PROTO".equalsIgnoreCase(recordType) ? KafkaProducerHelper.buildProtoMessage(recordToSend.getValue().toString(), requestJson) : recordToSend.getValue().toString()).withHeaders(recordToSend.getHeaders()).build();
    }

    private static Object buildProtoMessage(String message, String requestJson) {
        String protobufMessageClassName = KafkaProducerHelper.protoClassType(requestJson, "$.protoClassType");
        Message.Builder builder = KafkaProducerHelper.createBuilder(protobufMessageClassName);
        try {
            JsonFormat.parser().merge(message, builder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
        return builder.build().toByteArray();
    }

    private static Message.Builder createBuilder(String messageClass) {
        try {
            Class<?> msgClass = Class.forName(messageClass);
            Method method = msgClass.getMethod("newBuilder", null);
            return (Message.Builder)method.invoke(null, null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String readRecordType(String requestJson, String jsonPath) {
        try {
            return (String)JsonPath.read((String)requestJson, (String)jsonPath, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException pEx) {
            LOGGER.warn("Could not find path '" + jsonPath + "' in the request. returned default type 'RAW'.");
            return "RAW";
        }
    }

    public static String protoClassType(String requestJson, String classTypeJsonPath) {
        try {
            return (String)JsonPath.read((String)requestJson, (String)classTypeJsonPath, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException pEx) {
            LOGGER.error("Could not find path '" + classTypeJsonPath + "' in the request. returned default type 'RAW'.");
            String errMsg = "Missing 'protoClassType' for 'recordType:PROTO'. Please provide 'protoClassType' and rerun ";
            throw new RuntimeException(errMsg);
        }
    }
}

