/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.kafka.delivery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.apache.kafka.clients.producer.RecordMetadata;

public class DeliveryDetails {
    private final String status;
    private final String message;
    @SerializedName(value="size")
    private final Integer recordCount;
    private final RecordMetadata recordMetadata;

    @JsonCreator
    public DeliveryDetails(String status, String message, Integer recordCount, RecordMetadata recordMetadata) {
        this.status = status;
        this.message = message;
        this.recordCount = recordCount;
        this.recordMetadata = recordMetadata;
    }

    public DeliveryDetails(String status, String message) {
        this(status, message, null, null);
    }

    public DeliveryDetails(String status, RecordMetadata recordMetadata) {
        this(status, null, null, recordMetadata);
    }

    public DeliveryDetails(String status, Integer recordCount) {
        this(status, null, recordCount, null);
    }

    public DeliveryDetails(String status) {
        this(status, null, null, null);
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getRecordCount() {
        return this.recordCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryDetails that = (DeliveryDetails)o;
        return Objects.equals(this.status, that.status) && Objects.equals(this.message, that.message) && Objects.equals(this.recordCount, that.recordCount) && Objects.equals(this.recordMetadata, that.recordMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.message, this.recordCount, this.recordMetadata);
    }

    public String toString() {
        return "DeliveryDetails{status='" + this.status + '\'' + ", message='" + this.message + '\'' + ", recordCount=" + this.recordCount + ", recordMetadata=" + this.recordMetadata + '}';
    }
}

