/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.httpclient.utils;

import java.util.Map;
import org.apache.http.client.methods.RequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderUtils.class);

    public static void processFrameworkDefault(Map<String, Object> headers, RequestBuilder requestBuilder) {
        if (headers != null) {
            Map<String, Object> headersMap = headers;
            for (String key : headersMap.keySet()) {
                if ("Content-Type".equalsIgnoreCase(key) && "multipart/form-data".equals(headersMap.get(key))) continue;
                HeaderUtils.removeDuplicateHeaders(requestBuilder, key);
                requestBuilder.addHeader(key, (String)headersMap.get(key));
                LOGGER.info("Overridden the header key:{}, with value:{}", (Object)key, headersMap.get(key));
            }
        }
    }

    public static void removeDuplicateHeaders(RequestBuilder requestBuilder, String key) {
        if (requestBuilder.getFirstHeader(key) != null) {
            requestBuilder.removeHeaders(key);
        }
    }
}

