/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.httpclient.ssl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.jsmart.zerocode.core.httpclient.BasicHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslTrustCorporateProxyHttpClient
extends BasicHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslTrustCorporateProxyHttpClient.class);
    @Inject
    @Named(value="corporate.proxy.host")
    private String proxyHost;
    @Inject
    @Named(value="corporate.proxy.port")
    private int proxyPort;
    @Inject
    @Named(value="corporate.proxy.username")
    private String proxyUserName;
    @Inject
    @Named(value="corporate.proxy.password")
    private String proxyPassword;

    @Override
    public CloseableHttpClient createHttpClient() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        LOGGER.info("###Used SSL Enabled Http Client with Corporate Proxy, for both Http and Https connections");
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        CredentialsProvider credsProvider = this.createProxyCredentialsProvider(this.proxyHost, this.proxyPort, this.proxyUserName, this.proxyPassword);
        HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
        return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setDefaultCookieStore((CookieStore)cookieStore).setDefaultCredentialsProvider(credsProvider).setProxy(proxy).build();
    }

    private CredentialsProvider createProxyCredentialsProvider(String proxyHost, int proxyPort, String proxyUserName, String proxyPassword) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUserName, proxyPassword));
        return credsProvider;
    }
}

