/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.engine.assertion;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import org.jsmart.zerocode.core.engine.assertion.FieldAssertionMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JsonAsserter {
    public static final Logger logger = LoggerFactory.getLogger(JsonAsserter.class);

    public String getPath();

    public Object getExpected();

    public FieldAssertionMatcher actualEqualsToExpected(Object var1);

    default public FieldAssertionMatcher assertWithJson(String jsonSource) {
        Object result = null;
        try {
            result = JsonPath.read((String)jsonSource, (String)this.getPath(), (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException pEx) {
            logger.warn("Path: {} was not found in the response. Hence this value was treated as null.", (Object)this.getPath());
        }
        return this.actualEqualsToExpected(result);
    }

    default public FieldAssertionMatcher defaultAssertionMessage(Object actualResult, boolean areEqual) {
        return areEqual ? FieldAssertionMatcher.aMatchingMessage() : FieldAssertionMatcher.aNotMatchingMessage(this.getPath(), this.getExpected(), actualResult);
    }
}

