/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.domain.builders;

import com.aventstack.extentreports.ExtentReporter;
import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.reporter.ExtentHtmlReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtentReportsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtentReportsFactory.class);
    private static ExtentHtmlReporter extentHtmlReporter;
    private static ExtentReports extentReports;
    private static Map<Object, String> systemProperties;

    public static ExtentReports createReportTheme(String reportFileName) {
        ExtentHtmlReporter extentHtmlReporter = ExtentReportsFactory.createExtentHtmlReporter(reportFileName);
        extentReports = new ExtentReports();
        ExtentReportsFactory.attachSystemInfo();
        extentReports.attachReporter(new ExtentReporter[]{extentHtmlReporter});
        extentReports.setReportUsesManualConfiguration(true);
        return extentReports;
    }

    public static void attachSystemInfo() {
        systemProperties = ExtentReportsFactory.getSystemProperties();
        String osName = systemProperties.get("os.name");
        String osArchitecture = systemProperties.get("os.arch");
        String javaVersion = systemProperties.get("java.version");
        String javaVendor = systemProperties.get("java.vendor");
        LOGGER.info("System Info: OS:{}, Architecture:{}, Java:{}, Vendor:{}", new Object[]{osName, osArchitecture, javaVersion, javaVendor});
        LOGGER.debug("Where were the tests fired? Ans: OS:{}, Architecture:{}, Java:{}, Vendor:{}", new Object[]{osName, osArchitecture, javaVersion, javaVendor});
        extentReports.setSystemInfo("OS : ", osName);
        extentReports.setSystemInfo("OS Architecture : ", osArchitecture);
        extentReports.setSystemInfo("Java Version : ", javaVersion);
        extentReports.setSystemInfo("Java Vendor : ", javaVendor);
    }

    public static ExtentHtmlReporter createExtentHtmlReporter(String reportFileName) {
        extentHtmlReporter = new ExtentHtmlReporter(reportFileName);
        extentHtmlReporter.config().setDocumentTitle("Zerocode Test Report");
        extentHtmlReporter.config().setReportName("Zerocode Interactive Report");
        return extentHtmlReporter;
    }

    public static Map<Object, String> getSystemProperties() {
        HashMap<Object, String> map = new HashMap<Object, String>();
        try {
            Properties properties = System.getProperties();
            Set<Object> sysPropertiesKeys = properties.keySet();
            for (Object key : sysPropertiesKeys) {
                map.put(key, properties.getProperty((String)key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Extent reporting error. You can safely ignore this. But to fix this see:" + e);
        }
        return map;
    }

    public static void reportName(String reportName) {
        extentHtmlReporter.config().setReportName(reportName);
    }

    public static String getReportName() {
        return extentHtmlReporter.config().getReportName();
    }

    static {
        systemProperties = new HashMap<Object, String>();
    }
}

