/*
 * Decompiled with CFR 0.152.
 */
package org.jsmart.zerocode.core.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.jsmart.zerocode.core.di.provider.ObjectMapperProvider;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MockStep {
    private final String name;
    private final String operation;
    private final String url;
    private final JsonNode request;
    private final JsonNode response;
    private final JsonNode assertions;
    private String body;
    private String headers;
    private Map<String, Object> headersMap;

    public String getName() {
        return this.name;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getUrl() {
        return this.url;
    }

    public JsonNode getRequest() {
        return this.request;
    }

    public JsonNode getResponse() {
        return this.response;
    }

    public JsonNode getAssertions() {
        return this.assertions;
    }

    public String getBody() {
        JsonNode bodyNode = this.request.get("body");
        return bodyNode != null ? this.request.get("body").toString() : null;
    }

    public String getHeaders() {
        return this.request.get("headers").toString();
    }

    public Map<String, Object> getHeadersMap() {
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        HashMap headersMap = new HashMap();
        try {
            JsonNode headersNode = this.request.get("headers");
            if (null != headersNode) {
                headersMap = (HashMap)objectMapper.readValue(headersNode.toString(), HashMap.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return headersMap;
    }

    @JsonCreator
    public MockStep(@JsonProperty(value="name") String name, @JsonProperty(value="operation") String operation, @JsonProperty(value="url") String url, @JsonProperty(value="request") JsonNode request, @JsonProperty(value="response") JsonNode response, @JsonProperty(value="assertions") JsonNode assertions) {
        this.name = name;
        this.operation = operation;
        this.request = request;
        this.url = url;
        this.response = response;
        this.assertions = assertions;
    }

    public String toString() {
        return "Step{, name='" + this.name + '\'' + ", operation='" + this.operation + '\'' + ", url='" + this.url + '\'' + ", request=" + this.request + ", response=" + this.response + ", assertions=" + this.assertions + '}';
    }
}

