/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.IParameter;
import org.jrubyparser.ast.IScope;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalAsgnNode
extends AssignableNode
implements ILocalVariable {
    private String name;
    private int location;

    public LocalAsgnNode(SourcePosition position, String name, int location, Node valueNode) {
        super(position, valueNode);
        this.name = name;
        this.location = location;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LOCALASGNNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitLocalAsgnNode(this);
    }

    @Override
    public String getLexicalName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public IScope getDefinedScope() {
        IScope scope = this.getClosestIScope();
        for (int i = 0; i < this.getDepth(); ++i) {
            scope = ((Node)((Object)scope)).getClosestIScope();
        }
        return scope;
    }

    @Override
    public List<ILocalVariable> getOccurrences() {
        return this.getDefinedScope().getVariableReferencesNamed(this.getName());
    }

    @Override
    public ILocalVariable getDeclaration() {
        List<ILocalVariable> list = this.getOccurrences();
        if (list.size() > 0) {
            ILocalVariable variable = list.get(0);
            if (variable instanceof IParameter) {
                return variable;
            }
            if (variable instanceof LocalAsgnNode) {
                return variable;
            }
        }
        return this;
    }

    @Override
    public SourcePosition getNamePosition() {
        return this.getPosition().fromBeginning(this.getName().length());
    }

    @Override
    public SourcePosition getLexicalNamePosition() {
        return this.getNamePosition();
    }
}

