/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.IGlobalVariable;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class GlobalVarNode
extends Node
implements IGlobalVariable {
    private String name;

    public GlobalVarNode(SourcePosition position, String name) {
        super(position);
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        this.name = name;
    }

    public NodeType getNodeType() {
        return NodeType.GLOBALVARNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitGlobalVarNode(this);
    }

    public String getLexicalName() {
        return "$" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    public SourcePosition getNamePosition() {
        return this.getPosition().fromEnd(this.getName().length());
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getPosition();
    }
}

