/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class AttrAssignNode
extends Node
implements INameNode,
IArgumentNode {
    protected Node receiver;
    private String name;
    private Node arg;
    private boolean hasParens;

    public AttrAssignNode(SourcePosition position, Node receiver, String name, Node arg) {
        super(position);
        assert (receiver != null) : "receiverNode is not null";
        this.receiver = this.adopt(receiver);
        this.name = name;
        this.arg = this.adopt(arg);
    }

    public NodeType getNodeType() {
        return NodeType.ATTRASSIGNNODE;
    }

    public Object accept(NodeVisitor visitor) {
        return visitor.visitAttrAssignNode(this);
    }

    public String getLexicalName() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    @Deprecated
    public Node getReceiverNode() {
        return this.getReceiver();
    }

    public Node getReceiver() {
        return this.receiver;
    }

    @Deprecated
    public Node getArgsNode() {
        return this.getArgs();
    }

    public Node getArgs() {
        return this.arg;
    }

    @Deprecated
    public Node setArgsNode(Node argsNode) {
        this.setArgs(argsNode);
        return this;
    }

    public void setArgs(Node argsNode) {
        this.arg = this.adopt(argsNode);
    }

    public boolean hasParens() {
        return this.hasParens;
    }

    public void setHasParens(boolean hasParens) {
        this.hasParens = hasParens;
    }

    public SourcePosition getNamePosition() {
        return this.getPosition().fromBeginning(this.getName().length());
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getNamePosition();
    }
}

