/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.util;

import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ArgsCatNode;
import org.jrubyparser.ast.ArgsPushNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.MultipleAsgn19Node;
import org.jrubyparser.ast.Node;
import org.jrubyparser.util.NodePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticAnalyzerHelper {
    private static ListNode EMPTY = new ListNode(new SourcePosition());
    private static short PRE = 0;
    private static short SPLAT = 1;
    private static short POST = (short)2;

    public static List<NodePair> calculateStaticAssignments(MultipleAsgn19Node masgn, Node values) {
        ArrayList<NodePair> assignments;
        block14: {
            block16: {
                int postSize;
                int leftOver;
                int handled;
                ListNode rhsPre;
                block17: {
                    int i;
                    int rhsPreSize;
                    block15: {
                        assignments = new ArrayList<NodePair>();
                        Node[] rhs = StaticAnalyzerHelper.flattenRHSValues(values);
                        rhsPre = (ListNode)rhs[PRE];
                        rhsPreSize = rhsPre.size();
                        handled = 0;
                        if (masgn.getPreCount() > 0) {
                            for (int i2 = 0; i2 < masgn.getPreCount(); ++i2) {
                                assignments.add(new NodePair(masgn.getPre().get(i2), i2 < rhsPreSize ? rhsPre.get(i2) : null));
                                ++handled;
                            }
                        }
                        if (masgn.getRest() == null) break block14;
                        ListNode rhsPost = (ListNode)rhs[POST];
                        int rhsPostSize = rhsPost.size();
                        if (rhs[SPLAT] == null) break block15;
                        if (rhsPostSize == masgn.getPostCount()) {
                            if (handled == rhsPreSize) {
                                assignments.add(new NodePair(masgn.getRest(), rhs[SPLAT]));
                            }
                            for (int i3 = 0; i3 < rhsPostSize; ++i3) {
                                assignments.add(new NodePair(masgn.getPost().get(i3), rhsPost.get(i3)));
                            }
                        } else if (rhsPostSize <= masgn.getPostCount()) {
                            assignments.add(new NodePair(masgn.getRest(), null));
                            int pivot = masgn.getPostCount() - rhsPostSize;
                            for (int i4 = 0; i4 < masgn.getPostCount(); ++i4) {
                                assignments.add(new NodePair(masgn.getPost().get(i4), i4 >= pivot ? rhsPost.get(i4 - pivot) : null));
                            }
                        } else {
                            assignments.add(new NodePair(masgn.getRest(), null));
                            int pivot = rhsPostSize - masgn.getPostCount();
                            for (int i5 = 0; i5 < masgn.getPostCount(); ++i5) {
                                assignments.add(new NodePair(masgn.getPost().get(i5), rhsPost.get(i5 + pivot)));
                            }
                        }
                        break block14;
                    }
                    if (handled > rhsPreSize) break block16;
                    leftOver = rhsPreSize - handled;
                    if (masgn.getRest() == null) break block14;
                    postSize = masgn.getPostCount();
                    if (leftOver <= postSize) break block17;
                    ListNode list = new ListNode(rhsPre.get(handled).getPosition());
                    for (i = 0; i < leftOver - postSize; ++i) {
                        list.add(rhsPre.get(handled + i));
                    }
                    handled += leftOver - postSize;
                    assignments.add(new NodePair(masgn.getRest(), list));
                    for (i = 0; i < postSize; ++i) {
                        assignments.add(new NodePair(masgn.getPost().get(i), rhsPre.get(handled + i)));
                    }
                    break block14;
                }
                if (leftOver != postSize) break block14;
                SourcePosition pos = handled == 0 ? (postSize == 0 ? masgn.getPosition().makeEmptyPositionAfterThis() : rhsPre.get(0).getPosition().makeEmptyPositionBeforeThis()) : rhsPre.get(handled - 1).getPosition();
                assignments.add(new NodePair(masgn.getRest(), new ListNode(pos)));
                for (int i = 0; i < postSize; ++i) {
                    assignments.add(new NodePair(masgn.getPost().get(i), rhsPre.get(handled + i)));
                }
                break block14;
            }
            assignments.add(new NodePair(masgn.getRest(), null));
            int postSize = masgn.getPostCount();
            for (int i = 0; i < postSize; ++i) {
                assignments.add(new NodePair(masgn.getPost().get(i), null));
            }
        }
        return assignments;
    }

    public static Node[] flattenRHSValues(Node rhs) {
        Node[] values = new Node[3];
        if (rhs instanceof ArgsPushNode) {
            ArgsPushNode push = (ArgsPushNode)rhs;
            if (push.getFirstNode() instanceof ArgsCatNode) {
                ArgsCatNode cat = (ArgsCatNode)push.getFirstNode();
                values[0] = StaticAnalyzerHelper.asList(cat.getFirst());
                values[1] = cat.getSecond();
                values[2] = StaticAnalyzerHelper.asList(push.getSecondNode());
            } else {
                values[1] = push.getFirstNode();
                values[2] = StaticAnalyzerHelper.asList(push.getSecondNode());
            }
        } else if (rhs instanceof ArgsCatNode) {
            ArgsCatNode cat = (ArgsCatNode)rhs;
            values[0] = StaticAnalyzerHelper.asList(cat.getFirst());
            values[1] = cat.getSecond();
        } else {
            values[0] = StaticAnalyzerHelper.asList(rhs);
        }
        if (values[0] == null) {
            values[0] = EMPTY;
        }
        if (values[2] == null) {
            values[2] = EMPTY;
        }
        return values;
    }

    private static ListNode asList(Node node) {
        if (node == null) {
            return new ListNode(SourcePosition.INVALID_POSITION);
        }
        return !(node instanceof ListNode) ? new ListNode(node.getPosition(), node) : (ListNode)node;
    }
}

